/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments for transforming HDFS Ranger service policies to Azure Data Lake Storage (ADLS) policies. <p> Note that it's relevant only if any of the Ranger services to be replicated contain HDFS Ranger service type and replication will be done from on-prem to ADLS.")
public class ApiRangerReplicationHdfsToAdlsArgs {
    @SerializedName(value="adlsStorageAccount")
    private String adlsStorageAccount = null;
    @SerializedName(value="adlsStorageAccountContainer")
    private String adlsStorageAccountContainer = null;

    public ApiRangerReplicationHdfsToAdlsArgs adlsStorageAccount(String adlsStorageAccount) {
        this.adlsStorageAccount = adlsStorageAccount;
        return this;
    }

    @Schema(description="ADLS storage account name for Ranger HDFS policies which need to be transformed to ADLS policy.")
    public String getAdlsStorageAccount() {
        return this.adlsStorageAccount;
    }

    public void setAdlsStorageAccount(String adlsStorageAccount) {
        this.adlsStorageAccount = adlsStorageAccount;
    }

    public ApiRangerReplicationHdfsToAdlsArgs adlsStorageAccountContainer(String adlsStorageAccountContainer) {
        this.adlsStorageAccountContainer = adlsStorageAccountContainer;
        return this;
    }

    @Schema(description="ADLS storage account container name for Ranger HDFS policies which need to be transformed to ADLS policy.")
    public String getAdlsStorageAccountContainer() {
        return this.adlsStorageAccountContainer;
    }

    public void setAdlsStorageAccountContainer(String adlsStorageAccountContainer) {
        this.adlsStorageAccountContainer = adlsStorageAccountContainer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRangerReplicationHdfsToAdlsArgs apiRangerReplicationHdfsToAdlsArgs = (ApiRangerReplicationHdfsToAdlsArgs)o;
        return Objects.equals(this.adlsStorageAccount, apiRangerReplicationHdfsToAdlsArgs.adlsStorageAccount) && Objects.equals(this.adlsStorageAccountContainer, apiRangerReplicationHdfsToAdlsArgs.adlsStorageAccountContainer);
    }

    public int hashCode() {
        return Objects.hash(this.adlsStorageAccount, this.adlsStorageAccountContainer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRangerReplicationHdfsToAdlsArgs {\n");
        sb.append("    adlsStorageAccount: ").append(this.toIndentedString(this.adlsStorageAccount)).append("\n");
        sb.append("    adlsStorageAccountContainer: ").append(this.toIndentedString(this.adlsStorageAccountContainer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

