/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIPaginator;
import org.apache.myfaces.tobago.internal.component.AbstractUIPaginatorRow;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.renderkit.renderer.PaginatorRenderer;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class PaginatorRowRenderer<T extends AbstractUIPaginatorRow>
extends PaginatorRenderer<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T paginator) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUISheet sheet = ((AbstractUIPaginator)paginator).getPageable();
        boolean visible = ((AbstractUIPaginator)paginator).isAlwaysVisible() || sheet.needMoreThanOnePage();
        writer.startElement(HtmlElements.TOBAGO_PAGINATOR_ROW);
        String clientId = paginator.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(visible ? null : BootstrapClass.D_NONE, BootstrapClass.PAGINATION, paginator.getCustomClass());
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(BootstrapClass.PAGE_ITEM);
        writer.writeAttribute(HtmlAttributes.TITLE, ResourceUtils.getString(facesContext, "sheet.setRow"), true);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(BootstrapClass.PAGE_LINK, BootstrapClass.TEXT_NOWRAP);
        if (sheet.getRowCount() != 0) {
            boolean unknown;
            Locale locale = facesContext.getViewRoot().getLocale();
            int first = sheet.getFirst() + 1;
            int last1 = sheet.hasRowCount() ? sheet.getLastRowIndexOfCurrentPage() : -1;
            boolean bl = unknown = !sheet.hasRowCount();
            String key = unknown ? (first == last1 ? "sheet.rowX" : "sheet.rowXtoY") : (first == last1 ? "sheet.rowXofZ" : "sheet.rowXtoYofZ");
            String inputMarker = "{#}";
            Object[] args = new Object[]{"{#}", last1 == -1 ? "?" : Integer.valueOf(last1), unknown ? "" : Integer.valueOf(sheet.getRowCount())};
            MessageFormat detail = new MessageFormat(ResourceUtils.getString(facesContext, key), locale);
            String formatted = detail.format(args);
            int pos = formatted.indexOf("{#}");
            if (pos >= 0) {
                writer.writeText(formatted.substring(0, pos));
                writer.startElement(HtmlElements.SPAN);
                writer.writeText(Integer.toString(first));
                writer.endElement(HtmlElements.SPAN);
                writer.startElement(HtmlElements.INPUT);
                writer.writeIdAttribute(((AbstractUIPaginator)paginator).getFieldId(facesContext));
                writer.writeNameAttribute(clientId);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.TEXT);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.VALUE, first);
                int maxLength = Integer.toString(sheet.getRowCount()).length();
                if (!unknown) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, maxLength);
                }
                writer.writeAttribute(HtmlAttributes.PATTERN, StringUtils.positiveNumberRegexp(maxLength), true);
                writer.endElement(HtmlElements.INPUT);
                writer.writeText(formatted.substring(pos + "{#}".length()));
            } else {
                writer.writeText(formatted);
            }
        }
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.SPAN);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_PAGINATOR_ROW);
    }
}

