/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.tobago.exception.TobagoConfigurationException;

public class ContentSecurityPolicy {
    private Mode mode;
    private Map<String, String> directiveMap;
    private boolean unmodifiable = false;

    private void checkLocked() throws IllegalStateException {
        if (this.unmodifiable) {
            throw new TobagoConfigurationException("The configuration must not be changed after initialization!");
        }
    }

    public void lock() {
        this.unmodifiable = true;
        this.directiveMap = Collections.unmodifiableMap(this.directiveMap);
    }

    public ContentSecurityPolicy(String mode) {
        this.mode = Mode.parse(mode);
        this.directiveMap = new HashMap<String, String>();
    }

    public void merge(ContentSecurityPolicy other) {
        this.checkLocked();
        for (Map.Entry<String, String> entry : other.directiveMap.entrySet()) {
            this.addDirective(entry.getKey(), entry.getValue());
        }
        this.mode = other.mode;
    }

    public void addDirective(String name, String text) {
        String old = this.directiveMap.get(name);
        if (old != null) {
            this.directiveMap.put(name, old + " " + text);
        } else {
            this.directiveMap.put(name, text);
        }
    }

    public Map<String, String> getDirectiveMap() {
        return this.directiveMap;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String toString() {
        return "ContentSecurityPolicy{mode=" + String.valueOf((Object)this.mode) + ", directiveMap=" + String.valueOf(this.directiveMap) + "}";
    }

    public static enum Mode {
        ON("on"),
        OFF("off"),
        REPORT_ONLY("report-only");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Mode parse(String string) {
            if (Mode.ON.value.equals(string)) {
                return ON;
            }
            if (Mode.OFF.value.equals(string)) {
                return OFF;
            }
            if (Mode.REPORT_ONLY.value.equals(string)) {
                return REPORT_ONLY;
            }
            throw new IllegalArgumentException("Found: " + string);
        }
    }
}

