/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.context;

import java.io.Serializable;

public class AccessibilityProfile {
    private final ColorContrast _colorContrast;
    private final FontSize _fontSize;
    private final int _hashCode;
    private static final AccessibilityProfile _sDefaultInstance = AccessibilityProfile.getInstance(ColorContrast.STANDARD, FontSize.MEDIUM);

    public static AccessibilityProfile getInstance(ColorContrast colorContrast, FontSize fontSize) {
        return new SerializableAccessibilityProfile(colorContrast, fontSize);
    }

    public static AccessibilityProfile getDefaultInstance() {
        return _sDefaultInstance;
    }

    public ColorContrast getColorContrast() {
        return this._colorContrast;
    }

    public FontSize getFontSize() {
        return this._fontSize;
    }

    public final boolean isHighContrast() {
        return this._colorContrast == ColorContrast.HIGH;
    }

    public final boolean isLargeFonts() {
        return this._fontSize == FontSize.LARGE;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AccessibilityProfile) {
            AccessibilityProfile otherProfile = (AccessibilityProfile)o;
            return this._hashCode == otherProfile._hashCode && this._colorContrast.equals((Object)otherProfile._colorContrast) && this._fontSize.equals((Object)otherProfile._fontSize);
        }
        return false;
    }

    private AccessibilityProfile(ColorContrast colorContrast, FontSize fontSize) {
        this._colorContrast = colorContrast == null ? ColorContrast.STANDARD : colorContrast;
        this._fontSize = fontSize == null ? FontSize.MEDIUM : fontSize;
        this._hashCode = this._colorContrast.hashCode() * 37 + this._fontSize.hashCode();
    }

    private AccessibilityProfile() {
        this(ColorContrast.STANDARD, FontSize.MEDIUM);
    }

    private static final class SerializableAccessibilityProfile
    extends AccessibilityProfile
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SerializableAccessibilityProfile(ColorContrast colorContrast, FontSize fontSize) {
            super(colorContrast, fontSize);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontSize {
        LARGE,
        MEDIUM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorContrast {
        HIGH,
        STANDARD;

    }
}

