/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.facelets;

import com.sun.facelets.FaceletViewHandler;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.context.RequestContext;

public class TrinidadFaceletViewHandler
extends FaceletViewHandler {
    public static final String FACELETS_VIEW_MAPPINGS = "org.apache.myfaces.trinidad.FACELETS_VIEW_MAPPINGS";
    private final ViewHandler _parent;
    private volatile Set<String> _extensionMappings;
    private volatile Set<String> _prefixMappings;
    private volatile boolean _mappingsInitialized = false;

    public TrinidadFaceletViewHandler(ViewHandler parent) {
        super(parent);
        this._parent = parent;
    }

    protected void buildView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        super.buildView(context, viewToRender);
        ChangeManager cm = RequestContext.getCurrentInstance().getChangeManager();
        cm.applyComponentChangesForCurrentView(FacesContext.getCurrentInstance());
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        this._initMappings(context);
        if (this._handledByFacelets(viewId)) {
            return super.restoreView(context, viewId);
        }
        return this._parent.restoreView(context, viewId);
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException {
        if (!viewToRender.isRendered()) {
            return;
        }
        this._initMappings(context);
        if (this._handledByFacelets(viewToRender.getViewId())) {
            super.renderView(context, viewToRender);
        } else {
            this._parent.renderView(context, viewToRender);
        }
    }

    public void writeState(FacesContext context) throws IOException {
        this._initMappings(context);
        if (this._handledByFacelets(context.getViewRoot().getViewId())) {
            super.writeState(context);
        } else {
            this._parent.writeState(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initMappings(FacesContext context) {
        if (this._mappingsInitialized) {
            return;
        }
        TrinidadFaceletViewHandler trinidadFaceletViewHandler = this;
        synchronized (trinidadFaceletViewHandler) {
            if (!this._mappingsInitialized) {
                ExternalContext external = context.getExternalContext();
                String viewMappings = external.getInitParameter(FACELETS_VIEW_MAPPINGS);
                if (viewMappings != null && viewMappings.length() > 0) {
                    String[] mappingsArray = viewMappings.split(";");
                    HashSet<String> extensionMappings = new HashSet<String>(mappingsArray.length);
                    HashSet<String> prefixMappings = new HashSet<String>(mappingsArray.length);
                    for (int i = 0; i < mappingsArray.length; ++i) {
                        String mapping = mappingsArray[i].trim();
                        int mappingLength = mapping.length();
                        if (mappingLength <= 1) continue;
                        if (mapping.charAt(0) == '*') {
                            extensionMappings.add(mapping.substring(1));
                            continue;
                        }
                        if (mapping.charAt(mappingLength - 1) != '*') continue;
                        prefixMappings.add(mapping.substring(0, mappingLength - 1));
                    }
                    if (extensionMappings.size() > 0) {
                        this._extensionMappings = new HashSet<String>(extensionMappings);
                    }
                    if (prefixMappings.size() > 0) {
                        this._prefixMappings = new HashSet<String>(prefixMappings);
                    }
                }
                this._mappingsInitialized = true;
            }
        }
    }

    private boolean _handledByFacelets(String viewId) {
        if (this._extensionMappings == null && this._prefixMappings == null) {
            return true;
        }
        RequestContext afc = RequestContext.getCurrentInstance();
        if (afc != null) {
            viewId = afc.getPageResolver().getPhysicalURI(viewId);
        }
        if (this._extensionMappings != null) {
            for (String extension : this._extensionMappings) {
                if (!viewId.endsWith(extension)) continue;
                return true;
            }
        }
        if (this._prefixMappings != null) {
            for (String prefix : this._prefixMappings) {
                if (!viewId.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }
}

