/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreImage;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRendererUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class ImageRenderer
extends XhtmlRenderer {
    private PropertyKey _imageMapTypeKey;
    private PropertyKey _longDescURLKey;
    private PropertyKey _sourceKey;

    public ImageRenderer() {
        super(CoreImage.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._imageMapTypeKey = type.findKey("imageMapType");
        this._longDescURLKey = type.findKey("longDescURL");
        this._sourceKey = type.findKey("source");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent comp, FacesBean bean) throws IOException {
        if (this.canSkipRendering(context, arc, comp)) {
            return;
        }
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("img", comp);
        this.renderId(context, arc, comp, rw);
        this.renderAllAttributes(context, arc, bean);
        rw.endElement("img");
    }

    protected void renderAllAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        super.renderAllAttributes(context, arc, bean);
        this.renderEncodedResourceURI(context, "src", this.getSource(bean));
        this.renderEncodedActionURI(context, "longdesc", this.getLongDescURL(bean));
        this._renderImageMap(bean, rw);
    }

    protected void renderShortDescAttribute(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        String shortDesc = this.getShortDesc(bean);
        if (shortDesc != null) {
            OutputUtils.renderAltAndTooltipForImage(context, arc, shortDesc);
        }
    }

    protected String getImageMapType(FacesBean bean) {
        return ImageRenderer.toString((Object)bean.getProperty(this._imageMapTypeKey));
    }

    protected String getLongDescURL(FacesBean bean) {
        return ImageRenderer.toActionUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._longDescURLKey));
    }

    protected String getSource(FacesBean bean) {
        return ImageRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._sourceKey));
    }

    protected void renderId(FacesContext context, RenderingContext arc, UIComponent comp, ResponseWriter writer) throws IOException {
        super.renderId(context, comp);
        if (this.shouldRenderId(context, comp) && CoreRendererUtils.supportsNameIdentification(arc)) {
            String clientId = this.getClientId(context, comp);
            writer.writeAttribute("name", (Object)clientId, null);
        }
    }

    private void _renderImageMap(FacesBean bean, ResponseWriter writer) throws IOException {
        String mType = this.getImageMapType(bean);
        if ("server".equals(mType)) {
            writer.writeAttribute("ismap", (Object)Boolean.TRUE, "imageMapType");
        }
    }
}

