/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectBooleanRadio;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectBooleanRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class SimpleSelectBooleanRadioRenderer
extends SimpleSelectBooleanRenderer {
    private PropertyKey _groupKey;

    public SimpleSelectBooleanRadioRenderer() {
        this(CoreSelectBooleanRadio.TYPE);
    }

    public SimpleSelectBooleanRadioRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._groupKey = type.findKey("group");
    }

    public Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        Object newValue;
        this.detectAutoSubmit(context, component, clientId);
        String group = this.getGroup(this.getFacesBean(component));
        if (group != null && clientId.equals(newValue = context.getExternalContext().getRequestParameterMap().get(group))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Object getValueAttr(RenderingContext arc) {
        return arc.getCurrentClientId();
    }

    protected Object getType() {
        return "radio";
    }

    protected String getIconAltTextName(boolean selected) {
        return selected ? "af_selectBooleanRadio.READONLY_CHECKED_TIP" : "af_selectBooleanRadio.READONLY_NOT_CHECKED_TIP";
    }

    protected String getIconName(boolean selected, boolean disabled) {
        String iconName = disabled ? (selected ? "af|selectBooleanRadio::disabled-selected-icon" : "af|selectBooleanRadio::disabled-unselected-icon") : (selected ? "af|selectBooleanRadio::read-only-selected-icon" : "af|selectBooleanRadio::read-only-unselected-icon");
        return iconName;
    }

    protected void renderNameAttribute(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        String group = this.getGroup(bean);
        if (group != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("name", (Object)group, null);
        }
    }

    protected boolean shouldRenderName(FacesContext context, UIComponent component) {
        return false;
    }

    protected boolean isRadio() {
        return true;
    }

    protected String getCompositeId(String clientId) {
        return clientId + "__xc_" + "r";
    }

    protected void renderSpanEventHandlers(FacesContext context, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        if (!SimpleSelectBooleanRadioRenderer.isPDA((RenderingContext)RenderingContext.getCurrentInstance()) && this.isAutoSubmit(bean)) {
            rw.writeAttribute("onclick", (Object)this.getAutoSubmitScript(bean), null);
        }
        rw.writeAttribute("ondblclick", (Object)this.getOndblclick(bean), "ondblclick");
        rw.writeAttribute("onkeydown", (Object)this.getOnkeydown(bean), "onkeydown");
        rw.writeAttribute("onkeyup", (Object)this.getOnkeyup(bean), "onkeyup");
        rw.writeAttribute("onkeypress", (Object)this.getOnkeypress(bean), "onkeypress");
        rw.writeAttribute("onmousedown", (Object)this.getOnmousedown(bean), "onmousedown");
        rw.writeAttribute("onmousemove", (Object)this.getOnmousemove(bean), "onmousemove");
        rw.writeAttribute("onmouseout", (Object)this.getOnmouseout(bean), "onmouseout");
        rw.writeAttribute("onmouseover", (Object)this.getOnmouseover(bean), "onmouseover");
        rw.writeAttribute("onmouseup", (Object)this.getOnmouseup(bean), "onmouseup");
    }

    protected void renderInputEventHandlers(FacesContext context, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String onClick = this.getOnclick(bean);
        if (SimpleSelectBooleanRadioRenderer.isPDA((RenderingContext)RenderingContext.getCurrentInstance()) && this.isAutoSubmit(bean)) {
            String auto = this.getAutoSubmitScript(bean);
            onClick = onClick == null ? auto : XhtmlUtils.getChainedJS(onClick, auto, true);
        }
        writer.writeAttribute("onclick", (Object)onClick, "onclick");
        writer.writeAttribute("onblur", (Object)this.getOnblur(bean), "onblur");
        writer.writeAttribute("onfocus", (Object)this.getOnfocus(bean), "onfocus");
        writer.writeAttribute("onchange", (Object)this.getOnchange(bean), "onchange");
    }

    protected String getGroup(FacesBean bean) {
        return SimpleSelectBooleanRadioRenderer.toString((Object)bean.getProperty(this._groupKey));
    }

    protected String getContentStyleClass(FacesBean bean) {
        return "af|selectBooleanRadio::content";
    }

    protected String getRootStyleClass(FacesBean bean) {
        return "af|selectBooleanRadio";
    }
}

