/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageProvider;
import org.apache.myfaces.trinidadinternal.image.ImageProviderResponse;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.style.CoreStyle;
import org.apache.myfaces.trinidadinternal.ui.AttributeKey;
import org.apache.myfaces.trinidadinternal.ui.NodeRole;
import org.apache.myfaces.trinidadinternal.ui.NodeUtils;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.beans.MarlinBean;
import org.apache.myfaces.trinidadinternal.ui.laf.base.BaseLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.IconURIBoundValue;
import org.apache.myfaces.trinidadinternal.ui.laf.base.LafIconProvider;
import org.apache.myfaces.trinidadinternal.ui.laf.base.NodeRoleUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.FlippedIconRequest;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlFormattedText;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafConstants;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;
import org.apache.myfaces.trinidadinternal.ui.partial.PartialPageRendererUtils;
import org.apache.myfaces.trinidadinternal.util.FormattedTextParser;

@Deprecated
public class XhtmlLafRenderer
extends BaseLafRenderer
implements XhtmlLafConstants {
    public static final String TRANSPARENT_GIF = "t.gif";
    static final String __TRANSPARENT_URL_KEY = "_t.gif";
    static final String __DEFER_SCRIPTS_KEY = "_defer";
    private static final Object _DOES_NOT_EXIST = new Object();
    private static final Object _SCRIPT_SPACER_COUNT = new Object();
    private static final Object _STYLE_CLASS_KEY = new Object();
    private static final Object _INLINE_STYLE_KEY = new Object();
    private static final Object _NAV_BLOCK_END_ANCHOR_NAME_KEY = new Object();
    private static final Object _SELECTED_CHILD_INDEX_KEY = new Object();
    private static final String _ACCESSIBILITY_SCRIPT_TYPE = "text/javascript";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(XhtmlLafRenderer.class);

    public void render(UIXRenderingContext context, UINode node) throws IOException {
        if (this.isSupportedNode(context, node)) {
            super.render(context, node);
        } else if (_LOG.isWarning()) {
            _LOG.warning("UNSUPPORTED_UINODE", (Object)node.getLocalName());
        }
    }

    public boolean isSupportedNode(UIXRenderingContext context, UINode node) {
        return true;
    }

    public static boolean structureSatisfiesRole(UIXRenderingContext context, UINode node, NodeRole expectedRole) {
        if (node != null) {
            NodeRole role = NodeRoleUtils.getStructuralRole(context, node);
            return role != null && role.satisfiesRole(expectedRole);
        }
        return false;
    }

    public static boolean supportsPartialRendering(UIXRenderingContext context) {
        return PartialPageRendererUtils.supportsPartialRendering(context);
    }

    public static boolean supportsAdvancedButtons(UIXRenderingContext context) {
        return XhtmlLafRenderer.getBooleanAgentCapability(context, TrinidadAgent.CAP_ADVANCED_BUTTONS);
    }

    public static boolean supportsVAlign(UIXRenderingContext context) {
        return XhtmlLafRenderer.getBooleanAgentCapability(context, TrinidadAgent.CAP_VALIGN);
    }

    public static boolean supportsWrappingDisabled(UIXRenderingContext context) {
        return XhtmlLafRenderer.getBooleanAgentCapability(context, TrinidadAgent.CAP_NOWRAP);
    }

    public static boolean supportsAltRendersTooltipOnImage(UIXRenderingContext context) {
        return XhtmlLafRenderer.getBooleanAgentCapability(context, TrinidadAgent.CAP_ALT_RENDERS_TOOLTIP_ON_IMAGE);
    }

    public static boolean renderStyleElements(UIXRenderingContext context) {
        return !XhtmlLafRenderer.supportsStyleAttributes(context) && XhtmlLafRenderer.supportsTextPresentation(context);
    }

    protected void prerender(UIXRenderingContext context, UINode node) throws IOException {
        super.prerender(context, node);
        if (this.doRenderStyleAttrs(context, node)) {
            Object styleClass = this._getLocalStyleClass(context, node);
            if (XhtmlLafRenderer.renderStyleElements(context)) {
                this.startRenderingStyleElements(context, null, styleClass);
            }
            XhtmlLafUtils.pushStyleAttrs(context, styleClass != null ? styleClass.toString() : null, null);
        }
    }

    protected void postrender(UIXRenderingContext context, UINode node) throws IOException {
        if (this.doRenderStyleAttrs(context, node)) {
            if (XhtmlLafRenderer.renderStyleElements(context)) {
                XhtmlLafUtils.endRenderingStyleElements(context);
            }
            XhtmlLafUtils.popStyleAttrs(context);
        }
        super.postrender(context, node);
    }

    protected void renderShortDesc(UIXRenderingContext context, UINode node) throws IOException {
        this.renderAttribute(context, node, "title", SHORT_DESC_ATTR);
    }

    protected void renderAttributesExceptID(UIXRenderingContext context, UINode node) throws IOException {
        this.renderShortDesc(context, node);
        if (XhtmlLafRenderer.supportsStyleAttributes(context) && this.doRenderStyleAttrs(context, node)) {
            this.renderStyleAttrs(context, node);
        }
        if (XhtmlLafRenderer.supportsIntrinsicEvents(context)) {
            this.renderEventHandlers(context, node);
        }
    }

    protected void renderAttributes(UIXRenderingContext context, UINode node) throws IOException {
        this.renderID(context, node);
        this.renderAttributesExceptID(context, node);
    }

    protected final void renderNameAndID(UIXRenderingContext context, UINode node) throws IOException {
        Object id = this.getID(context, node);
        if (id != null) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderID(context, id, false);
            if (XhtmlLafRenderer.supportsNameIdentification(context)) {
                writer.writeAttribute("name", id, null);
            }
        }
    }

    public static void renderScriptOnce(UIXRenderingContext context, String script, Object key) throws IOException {
        if (XhtmlLafRenderer.supportsScripting(context) && !XhtmlLafRenderer.isPreviouslyRendered(context, key)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", null);
            XhtmlLafRenderer.renderScriptDeferAttribute(context);
            XhtmlLafRenderer.renderScriptTypeAttribute(context);
            writer.writeText((Object)script, null);
            writer.endElement("script");
        }
    }

    public static boolean isPreviouslyRendered(UIXRenderingContext context, Object key) {
        if (context.getProperty("http://myfaces.apache.org/uix/ui", key) == null) {
            context.setProperty("http://myfaces.apache.org/uix/ui", key, key);
            return false;
        }
        return true;
    }

    protected final Object getIDOrName(UIXRenderingContext context, UINode node) {
        Object id = node.getAttributeValue(context, ID_ATTR);
        if (id == null) {
            id = this.getTransformedName(context, node);
        }
        return id;
    }

    protected final Object getCachedIDOrName(UIXRenderingContext context, UINode node) {
        Object result = context.getLocalProperty(0, ID_ATTR, _DOES_NOT_EXIST);
        if (result == _DOES_NOT_EXIST) {
            result = node.getAttributeValue(context, ID_ATTR);
            if (result == null) {
                result = this.getTransformedName(context, node);
            }
            context.setLocalProperty(ID_ATTR, result);
        }
        return result;
    }

    protected Object getText(UIXRenderingContext context, UINode node) {
        Object o = node.getAttributeValue(context, TEXT_ATTR);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    protected Object getStyleClass(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, STYLE_CLASS_ATTR);
    }

    protected Object getInlineStyle(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, INLINE_STYLE_ATTR);
    }

    protected boolean doRenderStyleAttrs(UIXRenderingContext context, UINode node) {
        return true;
    }

    public static void renderStyleAndClass(UIXRenderingContext context, String inlineStyle, Object styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (styleClass != null) {
            if (XhtmlLafRenderer.supportsClassAttribute(context)) {
                XhtmlLafRenderer._renderStyleClassAttributeImpl(context, styleClass);
            } else {
                CoreStyle inlineStyleClass = XhtmlLafUtils.getClassStyle(context, styleClass);
                XhtmlLafRenderer.renderInlineStyleAttribute(context, (Object)inlineStyleClass);
                if (inlineStyle != null) {
                    writer.writeAttribute("style", (Object)";", null);
                    writer.writeAttribute("style", (Object)inlineStyle, null);
                }
                return;
            }
        }
        writer.writeAttribute("style", (Object)inlineStyle, null);
    }

    protected void renderStyleAttrs(UIXRenderingContext context, UINode node, String defaultStyleClass) throws IOException {
        Object styleClass = this.getStyleClass(context, node);
        if (defaultStyleClass != null) {
            if (styleClass != null) {
                XhtmlLafRenderer.renderStyleClassAttributes(context, new Object[]{styleClass, defaultStyleClass});
            } else {
                XhtmlLafRenderer.renderStyleClassAttribute(context, defaultStyleClass);
            }
        } else if (styleClass != null) {
            XhtmlLafRenderer.renderStyleClassAttribute(context, styleClass);
        }
        Object inlineStyle = this.getInlineStyle(context, node);
        XhtmlLafRenderer.renderInlineStyleAttribute(context, inlineStyle);
    }

    protected void renderStyleAttrs(UIXRenderingContext context, UINode node) throws IOException {
        this.renderStyleAttrs(context, node, null);
    }

    protected final void renderInlineStyleAttribute(UIXRenderingContext context, UINode node) throws IOException {
        XhtmlLafRenderer.renderInlineStyleAttribute(context, this.getInlineStyle(context, node));
    }

    public static void renderInlineStyleAttribute(UIXRenderingContext context, Object inlineStyle) throws IOException {
        if (inlineStyle != null) {
            if (XhtmlLafRenderer.supportsStyleAttributes(context)) {
                ResponseWriter writer = context.getResponseWriter();
                writer.writeAttribute("style", inlineStyle, null);
            }
            context.setLocalProperty(_INLINE_STYLE_KEY, inlineStyle);
        } else {
            context.setLocalProperty(_INLINE_STYLE_KEY, _DOES_NOT_EXIST);
        }
    }

    public static void renderStyleClassAttributes(UIXRenderingContext context, String styleClass1, String styleClass2, String inlineStyleString) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (styleClass1 == null) {
            XhtmlLafRenderer.renderStyleClassAttribute(context, styleClass2);
            writer.writeAttribute("style", (Object)inlineStyleString, null);
            return;
        }
        if (styleClass2 == null) {
            XhtmlLafRenderer.renderStyleClassAttribute(context, styleClass1);
            writer.writeAttribute("style", (Object)inlineStyleString, null);
            return;
        }
        boolean inlineStyleClass1 = true;
        boolean inlineStyleClass2 = true;
        if (XhtmlLafRenderer.supportsClassAttribute(context)) {
            if (XhtmlLafRenderer.supportsMultipleCssSelectors(context)) {
                inlineStyleClass1 = false;
                inlineStyleClass2 = false;
                StringBuffer classes = new StringBuffer(styleClass1.length() + styleClass2.length() + 1);
                Object shortStyleClass1 = XhtmlLafUtils.getShortStyleClass(context, styleClass1);
                Object shortStyleClass2 = XhtmlLafUtils.getShortStyleClass(context, styleClass2);
                classes.append(shortStyleClass1);
                classes.append(' ');
                classes.append(shortStyleClass2);
                writer.writeAttribute("class", (Object)classes.toString(), null);
            } else {
                inlineStyleClass1 = false;
                XhtmlLafRenderer.renderStyleClassAttribute(context, styleClass1);
            }
        }
        int inlineLength = 0;
        if (inlineStyleString != null) {
            inlineLength = inlineStyleString.length();
        }
        if (inlineStyleClass1) {
            inlineLength += styleClass1.length();
        }
        if (inlineStyleClass2) {
            inlineLength += styleClass2.length();
        }
        StringBuffer inline = new StringBuffer(inlineLength);
        if (inlineStyleClass1) {
            inline.append(XhtmlLafUtils.getClassStyle(context, styleClass1).toInlineString()).append(';');
        }
        if (inlineStyleClass2) {
            inline.append(XhtmlLafUtils.getClassStyle(context, styleClass2).toInlineString()).append(';');
        }
        if (inlineStyleString != null) {
            inline.append(inlineStyleString);
        }
        if (inline.length() > 0) {
            writer.writeAttribute("style", (Object)inline.toString(), null);
        }
    }

    public static void renderStyleClassAttributes(UIXRenderingContext context, Object[] styleClasses) throws IOException {
        XhtmlLafRenderer.renderStyleClassAttributes(context, styleClasses, null);
    }

    public static void renderStyleClassAttributes(UIXRenderingContext context, Object[] styleClasses, String inlineStyleString) throws IOException {
        ResponseWriter writer;
        int j = 0;
        if (XhtmlLafRenderer.supportsClassAttribute(context)) {
            if (XhtmlLafRenderer.supportsMultipleCssSelectors(context)) {
                j = styleClasses.length;
                StringBuffer classes = new StringBuffer(20);
                for (int i = 0; i < styleClasses.length; ++i) {
                    Object shortStyleClass = XhtmlLafUtils.getShortStyleClass(context, styleClasses[i]);
                    Object styleClass = null;
                    if (shortStyleClass != null) {
                        styleClass = shortStyleClass;
                    }
                    if (styleClass == null) continue;
                    if (i == 0) {
                        classes.append(styleClass);
                        continue;
                    }
                    classes.append(' ');
                    classes.append(styleClass);
                }
                writer = context.getResponseWriter();
                writer.writeAttribute("class", (Object)classes.toString(), null);
            } else {
                XhtmlLafRenderer.renderStyleClassAttribute(context, styleClasses[0]);
                j = 1;
            }
        }
        StringBuffer inline = new StringBuffer();
        while (j < styleClasses.length) {
            Object styleClass = styleClasses[j];
            CoreStyle inlineStyle = XhtmlLafUtils.getClassStyle(context, styleClass);
            if (inlineStyle != null) {
                inline.append(inlineStyle.toInlineString());
            }
            ++j;
        }
        if (inlineStyleString != null) {
            inline.append(inlineStyleString);
        }
        writer = context.getResponseWriter();
        if (inline.length() > 0) {
            writer.writeAttribute("style", (Object)inline.toString(), null);
        }
    }

    public static void renderStyleClassAttribute(UIXRenderingContext context, Object styleClass) throws IOException {
        if (XhtmlLafRenderer.supportsClassAttribute(context)) {
            Object shortStyleClass = XhtmlLafUtils.getShortStyleClass(context, styleClass);
            if (shortStyleClass != null) {
                styleClass = shortStyleClass;
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("class", styleClass, null);
        } else {
            XhtmlLafRenderer.renderInlineStyleAttribute(context, (Object)XhtmlLafUtils.getClassStyle(context, styleClass));
        }
    }

    private static void _renderStyleClassAttributeImpl(UIXRenderingContext context, Object styleClass) throws IOException {
        Object shortStyleClass = XhtmlLafUtils.getShortStyleClass(context, styleClass);
        if (shortStyleClass != null) {
            styleClass = shortStyleClass;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.writeAttribute("class", styleClass, null);
    }

    public static void renderShortStyleClassAttribute(UIXRenderingContext context, Object shortStyleClass) throws IOException {
        if (XhtmlLafRenderer.supportsClassAttribute(context)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("class", shortStyleClass, null);
        } else {
            XhtmlLafRenderer.renderInlineStyleAttribute(context, (Object)XhtmlLafUtils.getClassStyle(context, shortStyleClass));
        }
    }

    public static void renderOnePixelLine(UIXRenderingContext context) throws IOException {
        String style = "p_OraOnePixelLine";
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        XhtmlLafRenderer.renderStyleClassAttribute(context, "p_OraOnePixelLine");
        writer.endElement("div");
    }

    public static void renderScriptDeferAttribute(UIXRenderingContext context) throws IOException {
        if (XhtmlLafRenderer.getRenderingProperty(context, __DEFER_SCRIPTS_KEY) != null) {
            context.getResponseWriter().writeAttribute("defer", (Object)Boolean.TRUE, null);
        }
    }

    public static void renderScriptTypeAttribute(UIXRenderingContext context) throws IOException {
        if (XhtmlLafRenderer.isScreenReaderMode(context)) {
            context.getResponseWriter().writeAttribute("type", (Object)_ACCESSIBILITY_SCRIPT_TYPE, null);
        }
    }

    protected final void startRenderingStyleElements(UIXRenderingContext context, UINode node) throws IOException {
        this.startRenderingStyleElements(context, null, this.getStyleClass(context, node));
    }

    protected final void startRenderingStyleElements(UIXRenderingContext context, CoreStyle inlineStyle, Object className) throws IOException {
        XhtmlLafUtils.startRenderingStyleElements(context, inlineStyle, XhtmlLafUtils.getClassStyle(context, className));
    }

    protected void renderEventHandlers(UIXRenderingContext context, UINode node) throws IOException {
        if (!this.isDisabled(context, node)) {
            this.renderAttribute(context, "onclick", this.getOnClick(context, node));
            this.renderAttribute(context, "ondblclick", this.getOnDoubleClick(context, node));
        }
        this.renderAttribute(context, "onmousedown", this.getOnMouseDown(context, node));
        this.renderAttribute(context, "onmouseup", this.getOnMouseUp(context, node));
        this.renderAttribute(context, "onmouseover", this.getOnMouseOver(context, node));
        this.renderAttribute(context, "onmousemove", this.getOnMouseMove(context, node));
        this.renderAttribute(context, "onmouseout", this.getOnMouseOut(context, node));
        this.renderAttribute(context, "onkeypress", this.getOnKeyPress(context, node));
        this.renderAttribute(context, "onkeydown", this.getOnKeyDown(context, node));
        this.renderAttribute(context, "onkeyup", this.getOnKeyUp(context, node));
    }

    protected Object getOnClick(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ON_CLICK_ATTR);
    }

    protected Object getOnDoubleClick(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ON_DOUBLE_CLICK_ATTR);
    }

    protected Object getOnKeyDown(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ON_KEY_DOWN_ATTR);
    }

    protected Object getOnKeyPress(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ON_KEY_PRESS_ATTR);
    }

    protected Object getOnKeyUp(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ON_KEY_UP_ATTR);
    }

    protected Object getOnMouseDown(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ON_MOUSE_DOWN_ATTR);
    }

    protected Object getOnMouseUp(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ON_MOUSE_UP_ATTR);
    }

    protected Object getOnMouseOver(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ON_MOUSE_OVER_ATTR);
    }

    protected Object getOnMouseMove(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ON_MOUSE_MOVE_ATTR);
    }

    protected Object getOnMouseOut(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, ON_MOUSE_OUT_ATTR);
    }

    protected void renderSpacer(UIXRenderingContext context, Object width, Object height, Object id) throws IOException {
        String widthString = XhtmlLafRenderer._toString(width);
        String heightString = XhtmlLafRenderer._toString(height);
        this.renderTransparent(context, widthString, heightString, true, id);
    }

    protected void renderSpacer(UIXRenderingContext context, Object width, Object height) throws IOException {
        this.renderSpacer(context, width, height, null);
    }

    protected void renderSpacer(UIXRenderingContext context, Integer width, Integer height) throws IOException {
        int widthInt = width != null ? width : -1;
        int heightInt = height != null ? height : -1;
        this.renderSpacer(context, widthInt, heightInt);
    }

    protected void renderSpacer(UIXRenderingContext context, int width, int height) throws IOException {
        String widthString = width >= 0 ? IntegerUtils.getString((int)width) : null;
        String heightString = height >= 0 ? IntegerUtils.getString((int)height) : null;
        this.renderTransparent(context, widthString, heightString, false);
    }

    protected void renderHorizontalSpacer(UIXRenderingContext context, String width) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("b", null);
        writer.writeAttribute("style", (Object)("margin-left:" + width + "px"), null);
        writer.endElement("b");
    }

    protected void renderVerticalSpacer(UIXRenderingContext context, Object height) throws IOException {
        if (height != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", null);
            writer.writeAttribute("style", (Object)("margin-top:" + height + "px"), null);
            writer.endElement("div");
        }
    }

    protected void renderTransparent(UIXRenderingContext context, String width, String height, boolean needsQuoting) throws IOException {
        this.renderTransparent(context, width, height, needsQuoting, null);
    }

    protected void renderTransparent(UIXRenderingContext context, String width, String height, boolean needsQuoting, Object id) throws IOException {
        int count;
        Counter counter = (Counter)XhtmlLafRenderer.getRenderingProperty(context, _SCRIPT_SPACER_COUNT);
        if (counter == null) {
            counter = new Counter();
            XhtmlLafRenderer.setRenderingProperty(context, _SCRIPT_SPACER_COUNT, counter);
        }
        boolean useScript = (count = counter.count++) < 800 && TrinidadAgent.SCRIPTING_SPEED_CAP_FAST == XhtmlLafRenderer.getAgentCapability(context, TrinidadAgent.CAP_SCRIPTING_SPEED) && null == XhtmlLafRenderer.getAgentCapability(context, TrinidadAgent.CAP_IS_JDEV_VE);
        this._renderTransparent(context, width, height, needsQuoting, id, useScript);
    }

    private void _renderTransparent(UIXRenderingContext context, String width, String height, boolean needsQuoting, Object id, boolean useScript) throws IOException {
        PartialPageContext pContext = context.getPartialPageContext();
        if (!useScript || pContext != null) {
            this.renderIcon(context, (Object)TRANSPARENT_GIF, (Object)width, (Object)height, id);
        } else {
            ResponseWriter writer = context.getResponseWriter();
            Boolean isTransparentURLSet = (Boolean)XhtmlLafRenderer.getRenderingProperty(context, __TRANSPARENT_URL_KEY);
            if (isTransparentURLSet == null) {
                XhtmlLafRenderer.setRenderingProperty(context, __TRANSPARENT_URL_KEY, Boolean.TRUE);
                String transparentURL = XhtmlLafRenderer.getBaseImageURI(context) + TRANSPARENT_GIF;
                XhtmlLafUtils.addLib(context, "t()");
                writer.startElement("script", null);
                XhtmlLafRenderer.renderScriptTypeAttribute(context);
                if (id != null) {
                    this.renderID(context, id, false);
                }
                writer.write("var _tURL=\"" + transparentURL + "\";");
                writer.write("var _axm");
                if (!XhtmlLafRenderer.isInaccessibleMode(context)) {
                    writer.write("=1");
                }
                writer.write(";");
            } else {
                writer.startElement("script", null);
                XhtmlLafRenderer.renderScriptTypeAttribute(context);
                if (id != null) {
                    this.renderID(context, id, false);
                }
            }
            writer.write("t(");
            if (width != null || height != null) {
                String widthParam = "void 0";
                if (width != null) {
                    widthParam = width;
                    if (needsQuoting) {
                        writer.write("'");
                    }
                }
                writer.write(widthParam);
                if (needsQuoting && width != null) {
                    writer.write("'");
                }
                if (height != null) {
                    writer.write(",");
                    if (needsQuoting) {
                        writer.write("'");
                    }
                    writer.write(height);
                    if (needsQuoting) {
                        writer.write("'");
                    }
                }
            }
            writer.write(")");
            writer.endElement("script");
        }
    }

    protected void renderIcon(UIXRenderingContext context, Object iconURL, Object width, Object height) throws IOException {
        this.renderIcon(context, iconURL, width, height, null);
    }

    protected void renderIcon(UIXRenderingContext context, Object iconURL, Object width, Object height, Object id) throws IOException {
        this.renderIcon(context, iconURL, width, height, id, null);
    }

    protected final void renderIcon(UIXRenderingContext context, Object iconURL, Object width, Object height, Object id, Object altText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", null);
        if (id != null) {
            this.renderID(context, id, false);
        }
        XhtmlLafRenderer.writeAbsoluteImageURI(context, "src", iconURL.toString());
        if (altText != null) {
            writer.writeAttribute("alt", altText, null);
        } else if (!XhtmlLafRenderer.isInaccessibleMode(context)) {
            writer.writeAttribute("alt", (Object)"", null);
        }
        if (width != null) {
            writer.writeAttribute("width", width, null);
        }
        if (height != null) {
            writer.writeAttribute("height", height, null);
        }
        writer.endElement("img");
    }

    protected void renderIcon(UIXRenderingContext context, Object iconURL, int width, int height) throws IOException {
        this.renderIcon(context, iconURL, width != -1 ? XhtmlLafRenderer.getInteger(width) : null, height != -1 ? XhtmlLafRenderer.getInteger(height) : null);
    }

    protected void renderIcon(UIXRenderingContext context, String iconAbsoluteURI, String altTextKey, Object destination, Object anchor, Object onClick, Object imgAlign, Object targetFrame, boolean isBlock) throws IOException {
        if (iconAbsoluteURI != null) {
            ResponseWriter writer = context.getResponseWriter();
            if ((destination != null || onClick != null || anchor != null) && XhtmlLafRenderer.supportsNavigation(context)) {
                writer.startElement("a", null);
                this.renderEncodedActionURI(context, "href", destination);
                writer.writeAttribute("onclick", onClick, null);
                writer.writeAttribute("target", targetFrame, null);
                if (anchor != null) {
                    writer.writeAttribute("name", anchor, null);
                }
            }
            writer.startElement("img", null);
            Object altText = null;
            if (altTextKey != null) {
                altText = XhtmlLafRenderer.getTranslatedValue(context, altTextKey);
            }
            XhtmlLafRenderer.renderAltAndTooltipForImage(context, altText == null ? "" : altText);
            writer.writeAttribute("align", imgAlign, null);
            this.renderEncodedResourceURI(context, "src", iconAbsoluteURI);
            writer.writeAttribute("border", (Object)"0", null);
            if (isBlock) {
                XhtmlLafRenderer.renderStyleClassAttribute(context, "p_OraDisplayBlock");
            }
            writer.endElement("img");
            if ((destination != null || onClick != null || anchor != null) && XhtmlLafRenderer.supportsNavigation(context)) {
                writer.endElement("a");
            }
        }
    }

    protected void renderIcon(UIXRenderingContext context, Object iconURL, Object width, Object height, boolean isBlock) throws IOException {
        String fulluri = XhtmlLafRenderer.getBaseImageURI(context) + iconURL.toString();
        this.renderIcon(context, fulluri, null, null, null, null, null, null, isBlock);
    }

    protected void renderStretchedImage(UIXRenderingContext context, String imageURL, int height) throws IOException {
        this.renderIcon(context, (Object)imageURL, "100%", XhtmlLafRenderer.getInteger(height));
    }

    public static void writeAbsoluteImageURI(UIXRenderingContext context, String attribute, String uri) throws IOException {
        if (uri == null || uri.length() == 0) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String encodedUri = XhtmlLafRenderer.getBaseImageURI(context) + uri;
        FacesContext facesContext = context.getFacesContext();
        if (facesContext != null) {
            encodedUri = facesContext.getExternalContext().encodeResourceURL(encodedUri);
        }
        writer.writeURIAttribute(attribute, (Object)encodedUri, null);
    }

    protected static void renderHAlign(UIXRenderingContext context, Object hAlign) throws IOException {
        if (hAlign != null) {
            boolean rtl = XhtmlLafRenderer.isRightToLeft(context);
            if ("start".equals(hAlign)) {
                hAlign = rtl ? "right" : "left";
            } else if ("end".equals(hAlign)) {
                hAlign = rtl ? "left" : "right";
            }
            context.getResponseWriter().writeAttribute("align", hAlign, null);
        }
    }

    protected void renderHAlign(UIXRenderingContext context, UINode node) throws IOException {
        XhtmlLafRenderer.renderHAlign(context, node.getAttributeValue(context, H_ALIGN_ATTR));
    }

    protected void renderAccessKeyText(UIXRenderingContext context, Object textValue, int keyIndex, String accessKeyClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (textValue != null) {
            if (keyIndex != -1 && XhtmlLafRenderer.supportsAccessKeys(context)) {
                int charsLeft;
                String textString = textValue.toString();
                char[] textChars = textString.toCharArray();
                writer.writeText(textChars, 0, keyIndex);
                if (accessKeyClass != null && accessKeyClass.length() > 0) {
                    writer.startElement("span", null);
                    XhtmlRenderer.renderStyleClass((FacesContext)context.getFacesContext(), (RenderingContext)RenderingContext.getCurrentInstance(), (String)accessKeyClass);
                    writer.writeText(textChars, keyIndex, 1);
                    writer.endElement("span");
                    ++keyIndex;
                }
                if ((charsLeft = textChars.length - keyIndex) > 0) {
                    writer.writeText(textChars, keyIndex, charsLeft);
                }
            } else {
                writer.writeText(textValue, null);
            }
        }
    }

    protected void renderAccessKeyText(UIXRenderingContext context, UINode node, Object textValue, String accesskeyClass) throws IOException {
        String textString = textValue != null ? textValue.toString() : null;
        this.renderAccessKeyText(context, textString, XhtmlLafRenderer.getAccessKeyIndex(context, node, textString), accesskeyClass);
    }

    protected int getResolvedSelectedIndexFromCache(UIXRenderingContext context, UINode node) {
        int resolvedSelectedIndexFromCache = 0;
        Integer cachedIndex = (Integer)context.getLocalProperty(0, _SELECTED_CHILD_INDEX_KEY, null);
        if (cachedIndex != null) {
            resolvedSelectedIndexFromCache = cachedIndex;
        } else {
            resolvedSelectedIndexFromCache = this.getResolvedSelectedIndex(context, node);
            context.setLocalProperty(_SELECTED_CHILD_INDEX_KEY, resolvedSelectedIndexFromCache);
        }
        return resolvedSelectedIndexFromCache;
    }

    public int getResolvedSelectedIndex(UIXRenderingContext context, UINode node) {
        Integer selected;
        int selectedIndex = -1;
        int currChildIndex = -1;
        while ((currChildIndex = this.getNextRenderedChildIndex(context, node, currChildIndex)) != -1) {
            UINode currChildNode = node.getIndexedChild(context, currChildIndex);
            if (!Boolean.TRUE.equals(currChildNode.getAttributeValue(context, UIConstants.SELECTED_ATTR))) continue;
            selectedIndex = currChildIndex;
            break;
        }
        if (selectedIndex == -1 && (selected = (Integer)node.getAttributeValue(context, UIConstants.SELECTED_INDEX_ATTR)) != null) {
            selectedIndex = selected;
        }
        return selectedIndex;
    }

    protected static int getAccessKeyIndex(UIXRenderingContext context, UINode node, Object textValue) {
        String textString;
        char accessChar;
        int keyIndex = -1;
        if (textValue != null && (accessChar = XhtmlLafUtils.getCharacterAttr(context, node, ACCESS_KEY_ATTR)) != '\uffff' && (keyIndex = (textString = textValue.toString()).indexOf(accessChar)) == -1) {
            char oppositeChar = Character.toLowerCase(accessChar);
            if (oppositeChar == accessChar) {
                oppositeChar = Character.toUpperCase(accessChar);
            }
            if (oppositeChar != accessChar) {
                keyIndex = textString.indexOf(oppositeChar);
            }
        }
        return keyIndex;
    }

    protected static void renderLayoutTableAttributes(UIXRenderingContext context, Object cellspacing, Object tableWidth) throws IOException {
        XhtmlLafRenderer.renderLayoutTableAttributes(context, "0", cellspacing, tableWidth);
    }

    protected static void renderLayoutTableAttributes(UIXRenderingContext context, Object cellpadding, Object cellspacing, Object tableWidth) throws IOException {
        XhtmlLafRenderer.renderLayoutTableAttributes(context, cellpadding, cellspacing, "0", tableWidth);
    }

    protected static void renderLayoutTableAttributes(UIXRenderingContext context, Object cellpadding, Object cellspacing, Object border, Object tableWidth) throws IOException {
        XhtmlLafRenderer.renderLayoutTableAttributes(context, cellpadding, cellspacing, border, tableWidth, "");
    }

    protected static void renderLayoutTableAttributes(UIXRenderingContext context, Object cellpadding, Object cellspacing, Object border, Object tableWidth, Object summary) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.writeAttribute("cellpadding", cellpadding, null);
        writer.writeAttribute("cellspacing", cellspacing, null);
        writer.writeAttribute("border", border, null);
        writer.writeAttribute("width", tableWidth, null);
        if (!XhtmlLafRenderer.isInaccessibleMode(context)) {
            writer.writeAttribute("summary", summary, null);
        }
    }

    protected static void renderLayoutTableHeader(UIXRenderingContext context, Object cellspacing, Object tableWidth) throws IOException {
        context.getResponseWriter().startElement("table", null);
        XhtmlLafRenderer.renderLayoutTableAttributes(context, cellspacing, tableWidth);
    }

    public static void renderAltAndTooltipForImage(UIXRenderingContext context, Object textValue) throws IOException {
        if (textValue == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean wroteTitle = false;
        if (!XhtmlLafRenderer.supportsAltRendersTooltipOnImage(context) && !"".equals(textValue)) {
            writer.writeAttribute("title", textValue, null);
            wroteTitle = true;
        }
        if (!wroteTitle || !XhtmlLafRenderer.isInaccessibleMode(context)) {
            writer.writeAttribute("alt", textValue, null);
        }
    }

    protected boolean isTextFormatted(Object textValue) {
        if (textValue == null) {
            return false;
        }
        String string = textValue.toString();
        return string.startsWith("<html>");
    }

    protected final void renderPossiblyFormattedText(UIXRenderingContext context, Object textValue) throws IOException {
        if (textValue != null) {
            if (this.isTextFormatted(textValue)) {
                this.renderFormattedText(context, textValue);
            } else {
                context.getResponseWriter().writeText(textValue, null);
            }
        }
    }

    protected final void renderFormattedText(UIXRenderingContext context, Object textValue) throws IOException {
        if (textValue != null) {
            String text = textValue.toString();
            this.getFormattedTextParser(context).writeFormattedText(context.getFacesContext(), text);
        }
    }

    protected final void renderRelatedLinksBlockStart(UIXRenderingContext context, String blockTitleKey) throws IOException {
        if (XhtmlLafRenderer.isScreenReaderMode(context)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("map", null);
            String blockTitleText = XhtmlLafRenderer.getTranslatedString(context, blockTitleKey);
            writer.writeAttribute("title", (Object)blockTitleText, null);
            String navBlockEndAnchorName = XhtmlLafUtils.generateUniqueID(context);
            context.setLocalProperty(_NAV_BLOCK_END_ANCHOR_NAME_KEY, navBlockEndAnchorName);
            String pattern = XhtmlLafRenderer.getTranslatedString(context, "SKIP_CURRENT_NAVIGATION_BLOCK");
            String skipLinkAltText = this.formatString(context, pattern, new String[]{blockTitleText});
            XhtmlLafRenderer._renderSkipNavigationLink(context, navBlockEndAnchorName, skipLinkAltText);
        }
    }

    protected final void renderRelatedLinksBlockEnd(UIXRenderingContext context) throws IOException {
        if (XhtmlLafRenderer.isScreenReaderMode(context)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.endElement("map");
            String navBlockEndAnchorName = (String)context.getLocalProperty(0, _NAV_BLOCK_END_ANCHOR_NAME_KEY, null);
            MarlinBean navBlockEndAnchor = new MarlinBean("link");
            navBlockEndAnchor.setAttributeValue(UIConstants.NAME_ATTR, navBlockEndAnchorName);
            navBlockEndAnchor.render(context);
        }
    }

    protected FormattedTextParser getFormattedTextParser(UIXRenderingContext context) {
        return XhtmlFormattedText.getFormattedTextParser();
    }

    protected final void renderStyledText(UIXRenderingContext context, UINode node) throws IOException {
        this.renderStyledText(context, node, false, true);
    }

    protected void renderStyledText(UIXRenderingContext context, UINode node, boolean renderAccessKeys, boolean renderID) throws IOException {
        Object textValue = this.getText(context, node);
        if (textValue != null) {
            ResponseWriter writer = context.getResponseWriter();
            Object styleClass = this.getStyleClass(context, node);
            Object inlineStyle = this.getInlineStyle(context, node);
            boolean hasElementStyle = false;
            UIComponent component = NodeUtils.getUIComponent(context, node);
            writer.startElement("span", component);
            if (renderID) {
                this.renderID(context, node);
            }
            if (styleClass != null || inlineStyle != null) {
                if (XhtmlLafRenderer.supportsStyleAttributes(context)) {
                    if (styleClass != null) {
                        XhtmlLafRenderer.renderStyleClassAttribute(context, styleClass);
                    }
                    if (inlineStyle != null) {
                        XhtmlLafRenderer.renderInlineStyleAttribute(context, inlineStyle);
                    }
                } else if (XhtmlLafRenderer.supportsTextPresentation(context)) {
                    hasElementStyle = true;
                    this.startRenderingStyleElements(context, null, styleClass);
                }
            }
            if (renderAccessKeys && XhtmlLafRenderer.supportsAccessKeys(context)) {
                this.renderAccessKeyText(context, node, textValue, "AFAccessKeyStyle");
            } else {
                writer.writeText(textValue, null);
            }
            if (hasElementStyle) {
                XhtmlLafUtils.endRenderingStyleElements(context);
            }
            writer.endElement("span");
        }
    }

    protected void addOnSubmitConverterValidators(UIXRenderingContext context, UINode node, String requiredMessageKey) throws IOException {
        Object disabled = node.getAttributeValue(context, DISABLED_ATTR);
        if (!Boolean.TRUE.equals(disabled)) {
            boolean requiredField = Boolean.TRUE.equals(node.getAttributeValue(context, REQUIRED_ATTR));
            Converter converter = (Converter)node.getAttributeValue(context, UIConstants.CONVERTER_ATTR);
            Iterator validators = (Iterator)node.getAttributeValue(context, UIConstants.VALIDATORS_ATTR);
            if (requiredField || converter != null || validators != null && validators.hasNext()) {
                Object nodeName = this.getNodeName(context, node);
                UIComponent component = NodeUtils.getUIComponent(context, node);
                if (component == null) {
                    _LOG.warning("NULL_COMPONENT_FOR_NODE", (Object)node.getLocalName());
                }
                boolean unvalidated = Boolean.TRUE.equals(node.getAttributeValue(context, UIConstants.UNVALIDATED_ATTR));
                FormRenderer.addOnSubmitConverterValidators(component, converter, validators, nodeName.toString(), unvalidated, requiredField, requiredMessageKey);
            }
        }
    }

    protected void addOnSubmitRequiredValidator(UIXRenderingContext context, UINode node, String requiredMessageKey) throws IOException {
        Object nodeName = this.getNodeName(context, node);
        XhtmlLafUtils.addOnSubmitRequiredValidator(context, node, requiredMessageKey, nodeName);
    }

    private static String _toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o.getClass() == Integer.class) {
            return IntegerUtils.getString((int)((Integer)o));
        }
        return o.toString();
    }

    public static String getFlippedIconURI(UIXRenderingContext context, String source) {
        ImageProviderResponse response = XhtmlLafRenderer.getFlippedIcon(context, source);
        if (response != null) {
            return LafIconProvider.getCacheImageURI(context) + response.getImageURI();
        }
        return null;
    }

    protected Object getFlippableURI(UIXRenderingContext context, UINode node, AttributeKey attrKey) {
        String flippeduri;
        Object uri = node.getAttributeValue(context, attrKey);
        if (XhtmlLafRenderer.isRightToLeft(context) && Boolean.TRUE.equals(node.getAttributeValue(context, AUTOFLIP_ATTR)) && uri != null && (flippeduri = XhtmlLafRenderer.getFlippedIconURI(context, uri.toString())) != null) {
            uri = flippeduri;
        }
        return uri;
    }

    public static ImageProviderResponse getFlippedIcon(UIXRenderingContext context, String sourceURI) {
        FlippedIconRequest request;
        ImageProvider provider = (ImageProvider)context.getProperty("http://myfaces.apache.org/uix/image", ImageConstants.IMAGE_PROVIDER_PROPERTY);
        if (provider == null) {
            return null;
        }
        ImageContext imageContext = context.getImageContext();
        ImageProviderResponse response = provider.getImage(imageContext, request = new FlippedIconRequest(context, sourceURI));
        if (response == null && _LOG.isWarning()) {
            _LOG.warning("CANNOT_FLIP_ICON", (Object)sourceURI);
        }
        return response;
    }

    private Object _getLocalStyleClass(UIXRenderingContext context, UINode node) {
        Object prop = context.getLocalProperty(0, _STYLE_CLASS_KEY, null);
        if (prop == _DOES_NOT_EXIST) {
            return null;
        }
        return prop == null ? this.getStyleClass(context, node) : prop;
    }

    private static void _renderSkipNavigationLink(UIXRenderingContext context, String skipNavigationAnchor, String altText) throws IOException {
        MarlinBean skipLink = new MarlinBean("image");
        skipLink.setAttributeValue(UIConstants.DESTINATION_ATTR, "#" + skipNavigationAnchor);
        skipLink.setAttributeValue(UIConstants.SHORT_DESC_ATTR, altText);
        skipLink.setAttributeValue(UIConstants.SOURCE_ATTR, new IconURIBoundValue(TRANSPARENT_GIF));
        skipLink.setStyleClass("p_OraHiddenLabel");
        skipLink.render(context);
    }

    private static final class Counter {
        public int count = 0;

        private Counter() {
        }
    }
}

