/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.cache.DeltaFIFO;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.util.Strings;
import java.util.Collections;
import java.util.List;

public class Caches {
    public static final String NAMESPACE_INDEX = "namespace";

    public static <ApiType extends KubernetesObject> String deletionHandlingMetaNamespaceKeyFunc(ApiType object) {
        if (object instanceof DeltaFIFO.DeletedFinalStateUnknown) {
            DeltaFIFO.DeletedFinalStateUnknown deleteObj = (DeltaFIFO.DeletedFinalStateUnknown)object;
            return deleteObj.getKey();
        }
        return Caches.metaNamespaceKeyFunc(object);
    }

    public static String metaNamespaceKeyFunc(KubernetesObject obj) {
        V1ObjectMeta metadata = obj.getMetadata();
        if (!Strings.isNullOrEmpty(metadata.getNamespace())) {
            return metadata.getNamespace() + "/" + metadata.getName();
        }
        return metadata.getName();
    }

    public static List<String> metaNamespaceIndexFunc(KubernetesObject obj) {
        V1ObjectMeta metadata = obj.getMetadata();
        if (metadata == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(metadata.getNamespace());
    }
}

