# PIP-357: Correct the conf name in load balance module.

# Background knowledge

We use `loadBalancerBandwithInResourceWeight` and `loadBalancerBandwithOutResourceWeight` to calculate the broker's load in the load balance module. However, the correct conf name should be `loadBalancerBandwidthInResourceWeight` and `loadBalancerBandwidthOutResourceWeight`. This PIP is to correct the conf name in the load balance module.

# Motivation

The current conf name is incorrect.


# Detailed Design

- deprecated `loadBalancerBandwithInResourceWeight` and `loadBalancerBandwithOutResourceWeight` in the load balance module.
- add `loadBalancerBandwidthInResourceWeight` and `loadBalancerBandwidthOutResourceWeight` in the load balance module.

In case of users upgrading to this version don't notice the change, we will still support the old conf name in following way:
- If a configuration is not the default configuration, use that configuration.
- If both the new and the old are configured different from the default value, use the new one.

# Backward & Forward Compatibility

Backward compatible, users can upgrade to this version without doing any changes and the old conf name will still work.
If user want to use the new conf name, they can change the conf name in the configuration file.
Just remember that if both the new and the old are configured different from the default value, the new one will be used.

# General Notes

# Links

<!--
Updated afterwards
-->
* Mailing List discussion thread: https://lists.apache.org/thread/31wfq2hhprn4zknp4jv21lzf5809q6lf
* Mailing List voting thread: https://lists.apache.org/thread/0pggcploqw43mo134cwmk7b3p7t13848
