//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v3.5.1
// source: PulsarApi.proto

package proto

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CompressionType int32

const (
	CompressionType_NONE   CompressionType = 0
	CompressionType_LZ4    CompressionType = 1
	CompressionType_ZLIB   CompressionType = 2
	CompressionType_ZSTD   CompressionType = 3
	CompressionType_SNAPPY CompressionType = 4
)

// Enum value maps for CompressionType.
var (
	CompressionType_name = map[int32]string{
		0: "NONE",
		1: "LZ4",
		2: "ZLIB",
		3: "ZSTD",
		4: "SNAPPY",
	}
	CompressionType_value = map[string]int32{
		"NONE":   0,
		"LZ4":    1,
		"ZLIB":   2,
		"ZSTD":   3,
		"SNAPPY": 4,
	}
)

func (x CompressionType) Enum() *CompressionType {
	p := new(CompressionType)
	*p = x
	return p
}

func (x CompressionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompressionType) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[0].Descriptor()
}

func (CompressionType) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[0]
}

func (x CompressionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CompressionType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CompressionType(num)
	return nil
}

// Deprecated: Use CompressionType.Descriptor instead.
func (CompressionType) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{0}
}

type ProducerAccessMode int32

const (
	ProducerAccessMode_Shared               ProducerAccessMode = 0 // By default multiple producers can publish on a topic
	ProducerAccessMode_Exclusive            ProducerAccessMode = 1 // Require exclusive access for producer. Fail immediately if there's already a producer connected.
	ProducerAccessMode_WaitForExclusive     ProducerAccessMode = 2 // Producer creation is pending until it can acquire exclusive access
	ProducerAccessMode_ExclusiveWithFencing ProducerAccessMode = 3 // Require exclusive access for producer. Fence out old producer.
)

// Enum value maps for ProducerAccessMode.
var (
	ProducerAccessMode_name = map[int32]string{
		0: "Shared",
		1: "Exclusive",
		2: "WaitForExclusive",
		3: "ExclusiveWithFencing",
	}
	ProducerAccessMode_value = map[string]int32{
		"Shared":               0,
		"Exclusive":            1,
		"WaitForExclusive":     2,
		"ExclusiveWithFencing": 3,
	}
)

func (x ProducerAccessMode) Enum() *ProducerAccessMode {
	p := new(ProducerAccessMode)
	*p = x
	return p
}

func (x ProducerAccessMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProducerAccessMode) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[1].Descriptor()
}

func (ProducerAccessMode) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[1]
}

func (x ProducerAccessMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ProducerAccessMode) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ProducerAccessMode(num)
	return nil
}

// Deprecated: Use ProducerAccessMode.Descriptor instead.
func (ProducerAccessMode) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{1}
}

type ServerError int32

const (
	ServerError_UnknownError        ServerError = 0
	ServerError_MetadataError       ServerError = 1 // Error with ZK/metadata
	ServerError_PersistenceError    ServerError = 2 // Error writing reading from BK
	ServerError_AuthenticationError ServerError = 3 // Non valid authentication
	ServerError_AuthorizationError  ServerError = 4 // Not authorized to use resource
	ServerError_ConsumerBusy        ServerError = 5 // Unable to subscribe/unsubscribe because
	// other consumers are connected
	ServerError_ServiceNotReady                       ServerError = 6  // Any error that requires client retry operation with a fresh lookup
	ServerError_ProducerBlockedQuotaExceededError     ServerError = 7  // Unable to create producer because backlog quota exceeded
	ServerError_ProducerBlockedQuotaExceededException ServerError = 8  // Exception while creating producer because quota exceeded
	ServerError_ChecksumError                         ServerError = 9  // Error while verifying message checksum
	ServerError_UnsupportedVersionError               ServerError = 10 // Error when an older client/version doesn't support a required feature
	ServerError_TopicNotFound                         ServerError = 11 // Topic not found
	ServerError_SubscriptionNotFound                  ServerError = 12 // Subscription not found
	ServerError_ConsumerNotFound                      ServerError = 13 // Consumer not found
	ServerError_TooManyRequests                       ServerError = 14 // Error with too many simultaneously request
	ServerError_TopicTerminatedError                  ServerError = 15 // The topic has been terminated
	ServerError_ProducerBusy                          ServerError = 16 // Producer with same name is already connected
	ServerError_InvalidTopicName                      ServerError = 17 // The topic name is not valid
	ServerError_IncompatibleSchema                    ServerError = 18 // Specified schema was incompatible with topic schema
	ServerError_ConsumerAssignError                   ServerError = 19 // Dispatcher assign consumer error
	ServerError_TransactionCoordinatorNotFound        ServerError = 20 // Transaction coordinator not found error
	ServerError_InvalidTxnStatus                      ServerError = 21 // Invalid txn status error
	ServerError_NotAllowedError                       ServerError = 22 // Not allowed error
	ServerError_TransactionConflict                   ServerError = 23 // Ack with transaction conflict
	ServerError_TransactionNotFound                   ServerError = 24 // Transaction not found
	ServerError_ProducerFenced                        ServerError = 25 // When a producer asks and fail to get exclusive producer access,
)

// Enum value maps for ServerError.
var (
	ServerError_name = map[int32]string{
		0:  "UnknownError",
		1:  "MetadataError",
		2:  "PersistenceError",
		3:  "AuthenticationError",
		4:  "AuthorizationError",
		5:  "ConsumerBusy",
		6:  "ServiceNotReady",
		7:  "ProducerBlockedQuotaExceededError",
		8:  "ProducerBlockedQuotaExceededException",
		9:  "ChecksumError",
		10: "UnsupportedVersionError",
		11: "TopicNotFound",
		12: "SubscriptionNotFound",
		13: "ConsumerNotFound",
		14: "TooManyRequests",
		15: "TopicTerminatedError",
		16: "ProducerBusy",
		17: "InvalidTopicName",
		18: "IncompatibleSchema",
		19: "ConsumerAssignError",
		20: "TransactionCoordinatorNotFound",
		21: "InvalidTxnStatus",
		22: "NotAllowedError",
		23: "TransactionConflict",
		24: "TransactionNotFound",
		25: "ProducerFenced",
	}
	ServerError_value = map[string]int32{
		"UnknownError":                          0,
		"MetadataError":                         1,
		"PersistenceError":                      2,
		"AuthenticationError":                   3,
		"AuthorizationError":                    4,
		"ConsumerBusy":                          5,
		"ServiceNotReady":                       6,
		"ProducerBlockedQuotaExceededError":     7,
		"ProducerBlockedQuotaExceededException": 8,
		"ChecksumError":                         9,
		"UnsupportedVersionError":               10,
		"TopicNotFound":                         11,
		"SubscriptionNotFound":                  12,
		"ConsumerNotFound":                      13,
		"TooManyRequests":                       14,
		"TopicTerminatedError":                  15,
		"ProducerBusy":                          16,
		"InvalidTopicName":                      17,
		"IncompatibleSchema":                    18,
		"ConsumerAssignError":                   19,
		"TransactionCoordinatorNotFound":        20,
		"InvalidTxnStatus":                      21,
		"NotAllowedError":                       22,
		"TransactionConflict":                   23,
		"TransactionNotFound":                   24,
		"ProducerFenced":                        25,
	}
)

func (x ServerError) Enum() *ServerError {
	p := new(ServerError)
	*p = x
	return p
}

func (x ServerError) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServerError) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[2].Descriptor()
}

func (ServerError) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[2]
}

func (x ServerError) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ServerError) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ServerError(num)
	return nil
}

// Deprecated: Use ServerError.Descriptor instead.
func (ServerError) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{2}
}

type AuthMethod int32

const (
	AuthMethod_AuthMethodNone   AuthMethod = 0
	AuthMethod_AuthMethodYcaV1  AuthMethod = 1
	AuthMethod_AuthMethodAthens AuthMethod = 2
)

// Enum value maps for AuthMethod.
var (
	AuthMethod_name = map[int32]string{
		0: "AuthMethodNone",
		1: "AuthMethodYcaV1",
		2: "AuthMethodAthens",
	}
	AuthMethod_value = map[string]int32{
		"AuthMethodNone":   0,
		"AuthMethodYcaV1":  1,
		"AuthMethodAthens": 2,
	}
)

func (x AuthMethod) Enum() *AuthMethod {
	p := new(AuthMethod)
	*p = x
	return p
}

func (x AuthMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[3].Descriptor()
}

func (AuthMethod) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[3]
}

func (x AuthMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *AuthMethod) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = AuthMethod(num)
	return nil
}

// Deprecated: Use AuthMethod.Descriptor instead.
func (AuthMethod) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{3}
}

// Each protocol version identify new features that are
// incrementally added to the protocol
type ProtocolVersion int32

const (
	ProtocolVersion_v0  ProtocolVersion = 0  // Initial versioning
	ProtocolVersion_v1  ProtocolVersion = 1  // Added application keep-alive
	ProtocolVersion_v2  ProtocolVersion = 2  // Added RedeliverUnacknowledgedMessages Command
	ProtocolVersion_v3  ProtocolVersion = 3  // Added compression with LZ4 and ZLib
	ProtocolVersion_v4  ProtocolVersion = 4  // Added batch message support
	ProtocolVersion_v5  ProtocolVersion = 5  // Added disconnect client w/o closing connection
	ProtocolVersion_v6  ProtocolVersion = 6  // Added checksum computation for metadata + payload
	ProtocolVersion_v7  ProtocolVersion = 7  // Added CommandLookupTopic - Binary Lookup
	ProtocolVersion_v8  ProtocolVersion = 8  // Added CommandConsumerStats - Client fetches broker side consumer stats
	ProtocolVersion_v9  ProtocolVersion = 9  // Added end of topic notification
	ProtocolVersion_v10 ProtocolVersion = 10 // Added proxy to broker
	ProtocolVersion_v11 ProtocolVersion = 11 // C++ consumers before this version are not correctly handling the checksum field
	ProtocolVersion_v12 ProtocolVersion = 12 // Added get topic's last messageId from broker
	// Added CommandActiveConsumerChange
	// Added CommandGetTopicsOfNamespace
	ProtocolVersion_v13 ProtocolVersion = 13 // Schema-registry : added avro schema format for json
	ProtocolVersion_v14 ProtocolVersion = 14 // Add CommandAuthChallenge and CommandAuthResponse for mutual auth
	// Added Key_Shared subscription
	ProtocolVersion_v15 ProtocolVersion = 15 // Add CommandGetOrCreateSchema and CommandGetOrCreateSchemaResponse
	ProtocolVersion_v16 ProtocolVersion = 16 // Add support for broker entry metadata
	ProtocolVersion_v17 ProtocolVersion = 17 // Added support ack receipt
	ProtocolVersion_v18 ProtocolVersion = 18 // Add client support for broker entry metadata
	ProtocolVersion_v19 ProtocolVersion = 19 // Add CommandTcClientConnectRequest and CommandTcClientConnectResponse
	ProtocolVersion_v20 ProtocolVersion = 20 // Add client support for topic migration redirection CommandTopicMigrated
)

// Enum value maps for ProtocolVersion.
var (
	ProtocolVersion_name = map[int32]string{
		0:  "v0",
		1:  "v1",
		2:  "v2",
		3:  "v3",
		4:  "v4",
		5:  "v5",
		6:  "v6",
		7:  "v7",
		8:  "v8",
		9:  "v9",
		10: "v10",
		11: "v11",
		12: "v12",
		13: "v13",
		14: "v14",
		15: "v15",
		16: "v16",
		17: "v17",
		18: "v18",
		19: "v19",
		20: "v20",
	}
	ProtocolVersion_value = map[string]int32{
		"v0":  0,
		"v1":  1,
		"v2":  2,
		"v3":  3,
		"v4":  4,
		"v5":  5,
		"v6":  6,
		"v7":  7,
		"v8":  8,
		"v9":  9,
		"v10": 10,
		"v11": 11,
		"v12": 12,
		"v13": 13,
		"v14": 14,
		"v15": 15,
		"v16": 16,
		"v17": 17,
		"v18": 18,
		"v19": 19,
		"v20": 20,
	}
)

func (x ProtocolVersion) Enum() *ProtocolVersion {
	p := new(ProtocolVersion)
	*p = x
	return p
}

func (x ProtocolVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProtocolVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[4].Descriptor()
}

func (ProtocolVersion) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[4]
}

func (x ProtocolVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ProtocolVersion) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ProtocolVersion(num)
	return nil
}

// Deprecated: Use ProtocolVersion.Descriptor instead.
func (ProtocolVersion) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{4}
}

type KeySharedMode int32

const (
	KeySharedMode_AUTO_SPLIT KeySharedMode = 0
	KeySharedMode_STICKY     KeySharedMode = 1
)

// Enum value maps for KeySharedMode.
var (
	KeySharedMode_name = map[int32]string{
		0: "AUTO_SPLIT",
		1: "STICKY",
	}
	KeySharedMode_value = map[string]int32{
		"AUTO_SPLIT": 0,
		"STICKY":     1,
	}
)

func (x KeySharedMode) Enum() *KeySharedMode {
	p := new(KeySharedMode)
	*p = x
	return p
}

func (x KeySharedMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeySharedMode) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[5].Descriptor()
}

func (KeySharedMode) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[5]
}

func (x KeySharedMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *KeySharedMode) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = KeySharedMode(num)
	return nil
}

// Deprecated: Use KeySharedMode.Descriptor instead.
func (KeySharedMode) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{5}
}

type TxnAction int32

const (
	TxnAction_COMMIT TxnAction = 0
	TxnAction_ABORT  TxnAction = 1
)

// Enum value maps for TxnAction.
var (
	TxnAction_name = map[int32]string{
		0: "COMMIT",
		1: "ABORT",
	}
	TxnAction_value = map[string]int32{
		"COMMIT": 0,
		"ABORT":  1,
	}
)

func (x TxnAction) Enum() *TxnAction {
	p := new(TxnAction)
	*p = x
	return p
}

func (x TxnAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TxnAction) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[6].Descriptor()
}

func (TxnAction) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[6]
}

func (x TxnAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *TxnAction) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = TxnAction(num)
	return nil
}

// Deprecated: Use TxnAction.Descriptor instead.
func (TxnAction) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{6}
}

type Schema_Type int32

const (
	Schema_None           Schema_Type = 0
	Schema_String         Schema_Type = 1
	Schema_Json           Schema_Type = 2
	Schema_Protobuf       Schema_Type = 3
	Schema_Avro           Schema_Type = 4
	Schema_Bool           Schema_Type = 5
	Schema_Int8           Schema_Type = 6
	Schema_Int16          Schema_Type = 7
	Schema_Int32          Schema_Type = 8
	Schema_Int64          Schema_Type = 9
	Schema_Float          Schema_Type = 10
	Schema_Double         Schema_Type = 11
	Schema_Date           Schema_Type = 12
	Schema_Time           Schema_Type = 13
	Schema_Timestamp      Schema_Type = 14
	Schema_KeyValue       Schema_Type = 15
	Schema_Instant        Schema_Type = 16
	Schema_LocalDate      Schema_Type = 17
	Schema_LocalTime      Schema_Type = 18
	Schema_LocalDateTime  Schema_Type = 19
	Schema_ProtobufNative Schema_Type = 20
)

// Enum value maps for Schema_Type.
var (
	Schema_Type_name = map[int32]string{
		0:  "None",
		1:  "String",
		2:  "Json",
		3:  "Protobuf",
		4:  "Avro",
		5:  "Bool",
		6:  "Int8",
		7:  "Int16",
		8:  "Int32",
		9:  "Int64",
		10: "Float",
		11: "Double",
		12: "Date",
		13: "Time",
		14: "Timestamp",
		15: "KeyValue",
		16: "Instant",
		17: "LocalDate",
		18: "LocalTime",
		19: "LocalDateTime",
		20: "ProtobufNative",
	}
	Schema_Type_value = map[string]int32{
		"None":           0,
		"String":         1,
		"Json":           2,
		"Protobuf":       3,
		"Avro":           4,
		"Bool":           5,
		"Int8":           6,
		"Int16":          7,
		"Int32":          8,
		"Int64":          9,
		"Float":          10,
		"Double":         11,
		"Date":           12,
		"Time":           13,
		"Timestamp":      14,
		"KeyValue":       15,
		"Instant":        16,
		"LocalDate":      17,
		"LocalTime":      18,
		"LocalDateTime":  19,
		"ProtobufNative": 20,
	}
)

func (x Schema_Type) Enum() *Schema_Type {
	p := new(Schema_Type)
	*p = x
	return p
}

func (x Schema_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Schema_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[7].Descriptor()
}

func (Schema_Type) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[7]
}

func (x Schema_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Schema_Type) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Schema_Type(num)
	return nil
}

// Deprecated: Use Schema_Type.Descriptor instead.
func (Schema_Type) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{0, 0}
}

type CommandSubscribe_SubType int32

const (
	CommandSubscribe_Exclusive  CommandSubscribe_SubType = 0
	CommandSubscribe_Shared     CommandSubscribe_SubType = 1
	CommandSubscribe_Failover   CommandSubscribe_SubType = 2
	CommandSubscribe_Key_Shared CommandSubscribe_SubType = 3
)

// Enum value maps for CommandSubscribe_SubType.
var (
	CommandSubscribe_SubType_name = map[int32]string{
		0: "Exclusive",
		1: "Shared",
		2: "Failover",
		3: "Key_Shared",
	}
	CommandSubscribe_SubType_value = map[string]int32{
		"Exclusive":  0,
		"Shared":     1,
		"Failover":   2,
		"Key_Shared": 3,
	}
)

func (x CommandSubscribe_SubType) Enum() *CommandSubscribe_SubType {
	p := new(CommandSubscribe_SubType)
	*p = x
	return p
}

func (x CommandSubscribe_SubType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommandSubscribe_SubType) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[8].Descriptor()
}

func (CommandSubscribe_SubType) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[8]
}

func (x CommandSubscribe_SubType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CommandSubscribe_SubType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CommandSubscribe_SubType(num)
	return nil
}

// Deprecated: Use CommandSubscribe_SubType.Descriptor instead.
func (CommandSubscribe_SubType) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{16, 0}
}

type CommandSubscribe_InitialPosition int32

const (
	CommandSubscribe_Latest   CommandSubscribe_InitialPosition = 0
	CommandSubscribe_Earliest CommandSubscribe_InitialPosition = 1
)

// Enum value maps for CommandSubscribe_InitialPosition.
var (
	CommandSubscribe_InitialPosition_name = map[int32]string{
		0: "Latest",
		1: "Earliest",
	}
	CommandSubscribe_InitialPosition_value = map[string]int32{
		"Latest":   0,
		"Earliest": 1,
	}
)

func (x CommandSubscribe_InitialPosition) Enum() *CommandSubscribe_InitialPosition {
	p := new(CommandSubscribe_InitialPosition)
	*p = x
	return p
}

func (x CommandSubscribe_InitialPosition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommandSubscribe_InitialPosition) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[9].Descriptor()
}

func (CommandSubscribe_InitialPosition) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[9]
}

func (x CommandSubscribe_InitialPosition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CommandSubscribe_InitialPosition) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CommandSubscribe_InitialPosition(num)
	return nil
}

// Deprecated: Use CommandSubscribe_InitialPosition.Descriptor instead.
func (CommandSubscribe_InitialPosition) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{16, 1}
}

type CommandPartitionedTopicMetadataResponse_LookupType int32

const (
	CommandPartitionedTopicMetadataResponse_Success CommandPartitionedTopicMetadataResponse_LookupType = 0
	CommandPartitionedTopicMetadataResponse_Failed  CommandPartitionedTopicMetadataResponse_LookupType = 1
)

// Enum value maps for CommandPartitionedTopicMetadataResponse_LookupType.
var (
	CommandPartitionedTopicMetadataResponse_LookupType_name = map[int32]string{
		0: "Success",
		1: "Failed",
	}
	CommandPartitionedTopicMetadataResponse_LookupType_value = map[string]int32{
		"Success": 0,
		"Failed":  1,
	}
)

func (x CommandPartitionedTopicMetadataResponse_LookupType) Enum() *CommandPartitionedTopicMetadataResponse_LookupType {
	p := new(CommandPartitionedTopicMetadataResponse_LookupType)
	*p = x
	return p
}

func (x CommandPartitionedTopicMetadataResponse_LookupType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommandPartitionedTopicMetadataResponse_LookupType) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[10].Descriptor()
}

func (CommandPartitionedTopicMetadataResponse_LookupType) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[10]
}

func (x CommandPartitionedTopicMetadataResponse_LookupType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CommandPartitionedTopicMetadataResponse_LookupType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CommandPartitionedTopicMetadataResponse_LookupType(num)
	return nil
}

// Deprecated: Use CommandPartitionedTopicMetadataResponse_LookupType.Descriptor instead.
func (CommandPartitionedTopicMetadataResponse_LookupType) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{18, 0}
}

type CommandLookupTopicResponse_LookupType int32

const (
	CommandLookupTopicResponse_Redirect CommandLookupTopicResponse_LookupType = 0
	CommandLookupTopicResponse_Connect  CommandLookupTopicResponse_LookupType = 1
	CommandLookupTopicResponse_Failed   CommandLookupTopicResponse_LookupType = 2
)

// Enum value maps for CommandLookupTopicResponse_LookupType.
var (
	CommandLookupTopicResponse_LookupType_name = map[int32]string{
		0: "Redirect",
		1: "Connect",
		2: "Failed",
	}
	CommandLookupTopicResponse_LookupType_value = map[string]int32{
		"Redirect": 0,
		"Connect":  1,
		"Failed":   2,
	}
)

func (x CommandLookupTopicResponse_LookupType) Enum() *CommandLookupTopicResponse_LookupType {
	p := new(CommandLookupTopicResponse_LookupType)
	*p = x
	return p
}

func (x CommandLookupTopicResponse_LookupType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommandLookupTopicResponse_LookupType) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[11].Descriptor()
}

func (CommandLookupTopicResponse_LookupType) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[11]
}

func (x CommandLookupTopicResponse_LookupType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CommandLookupTopicResponse_LookupType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CommandLookupTopicResponse_LookupType(num)
	return nil
}

// Deprecated: Use CommandLookupTopicResponse_LookupType.Descriptor instead.
func (CommandLookupTopicResponse_LookupType) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{20, 0}
}

type CommandAck_AckType int32

const (
	CommandAck_Individual CommandAck_AckType = 0
	CommandAck_Cumulative CommandAck_AckType = 1
)

// Enum value maps for CommandAck_AckType.
var (
	CommandAck_AckType_name = map[int32]string{
		0: "Individual",
		1: "Cumulative",
	}
	CommandAck_AckType_value = map[string]int32{
		"Individual": 0,
		"Cumulative": 1,
	}
)

func (x CommandAck_AckType) Enum() *CommandAck_AckType {
	p := new(CommandAck_AckType)
	*p = x
	return p
}

func (x CommandAck_AckType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommandAck_AckType) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[12].Descriptor()
}

func (CommandAck_AckType) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[12]
}

func (x CommandAck_AckType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CommandAck_AckType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CommandAck_AckType(num)
	return nil
}

// Deprecated: Use CommandAck_AckType.Descriptor instead.
func (CommandAck_AckType) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{26, 0}
}

// Acks can contain a flag to indicate the consumer
// received an invalid message that got discarded
// before being passed on to the application.
type CommandAck_ValidationError int32

const (
	CommandAck_UncompressedSizeCorruption CommandAck_ValidationError = 0
	CommandAck_DecompressionError         CommandAck_ValidationError = 1
	CommandAck_ChecksumMismatch           CommandAck_ValidationError = 2
	CommandAck_BatchDeSerializeError      CommandAck_ValidationError = 3
	CommandAck_DecryptionError            CommandAck_ValidationError = 4
)

// Enum value maps for CommandAck_ValidationError.
var (
	CommandAck_ValidationError_name = map[int32]string{
		0: "UncompressedSizeCorruption",
		1: "DecompressionError",
		2: "ChecksumMismatch",
		3: "BatchDeSerializeError",
		4: "DecryptionError",
	}
	CommandAck_ValidationError_value = map[string]int32{
		"UncompressedSizeCorruption": 0,
		"DecompressionError":         1,
		"ChecksumMismatch":           2,
		"BatchDeSerializeError":      3,
		"DecryptionError":            4,
	}
)

func (x CommandAck_ValidationError) Enum() *CommandAck_ValidationError {
	p := new(CommandAck_ValidationError)
	*p = x
	return p
}

func (x CommandAck_ValidationError) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommandAck_ValidationError) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[13].Descriptor()
}

func (CommandAck_ValidationError) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[13]
}

func (x CommandAck_ValidationError) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CommandAck_ValidationError) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CommandAck_ValidationError(num)
	return nil
}

// Deprecated: Use CommandAck_ValidationError.Descriptor instead.
func (CommandAck_ValidationError) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{26, 1}
}

type CommandTopicMigrated_ResourceType int32

const (
	CommandTopicMigrated_Producer CommandTopicMigrated_ResourceType = 0
	CommandTopicMigrated_Consumer CommandTopicMigrated_ResourceType = 1
)

// Enum value maps for CommandTopicMigrated_ResourceType.
var (
	CommandTopicMigrated_ResourceType_name = map[int32]string{
		0: "Producer",
		1: "Consumer",
	}
	CommandTopicMigrated_ResourceType_value = map[string]int32{
		"Producer": 0,
		"Consumer": 1,
	}
)

func (x CommandTopicMigrated_ResourceType) Enum() *CommandTopicMigrated_ResourceType {
	p := new(CommandTopicMigrated_ResourceType)
	*p = x
	return p
}

func (x CommandTopicMigrated_ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommandTopicMigrated_ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[14].Descriptor()
}

func (CommandTopicMigrated_ResourceType) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[14]
}

func (x CommandTopicMigrated_ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CommandTopicMigrated_ResourceType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CommandTopicMigrated_ResourceType(num)
	return nil
}

// Deprecated: Use CommandTopicMigrated_ResourceType.Descriptor instead.
func (CommandTopicMigrated_ResourceType) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{33, 0}
}

type CommandGetTopicsOfNamespace_Mode int32

const (
	CommandGetTopicsOfNamespace_PERSISTENT     CommandGetTopicsOfNamespace_Mode = 0
	CommandGetTopicsOfNamespace_NON_PERSISTENT CommandGetTopicsOfNamespace_Mode = 1
	CommandGetTopicsOfNamespace_ALL            CommandGetTopicsOfNamespace_Mode = 2
)

// Enum value maps for CommandGetTopicsOfNamespace_Mode.
var (
	CommandGetTopicsOfNamespace_Mode_name = map[int32]string{
		0: "PERSISTENT",
		1: "NON_PERSISTENT",
		2: "ALL",
	}
	CommandGetTopicsOfNamespace_Mode_value = map[string]int32{
		"PERSISTENT":     0,
		"NON_PERSISTENT": 1,
		"ALL":            2,
	}
)

func (x CommandGetTopicsOfNamespace_Mode) Enum() *CommandGetTopicsOfNamespace_Mode {
	p := new(CommandGetTopicsOfNamespace_Mode)
	*p = x
	return p
}

func (x CommandGetTopicsOfNamespace_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommandGetTopicsOfNamespace_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[15].Descriptor()
}

func (CommandGetTopicsOfNamespace_Mode) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[15]
}

func (x CommandGetTopicsOfNamespace_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CommandGetTopicsOfNamespace_Mode) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CommandGetTopicsOfNamespace_Mode(num)
	return nil
}

// Deprecated: Use CommandGetTopicsOfNamespace_Mode.Descriptor instead.
func (CommandGetTopicsOfNamespace_Mode) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{46, 0}
}

type BaseCommand_Type int32

const (
	BaseCommand_CONNECT                           BaseCommand_Type = 2
	BaseCommand_CONNECTED                         BaseCommand_Type = 3
	BaseCommand_SUBSCRIBE                         BaseCommand_Type = 4
	BaseCommand_PRODUCER                          BaseCommand_Type = 5
	BaseCommand_SEND                              BaseCommand_Type = 6
	BaseCommand_SEND_RECEIPT                      BaseCommand_Type = 7
	BaseCommand_SEND_ERROR                        BaseCommand_Type = 8
	BaseCommand_MESSAGE                           BaseCommand_Type = 9
	BaseCommand_ACK                               BaseCommand_Type = 10
	BaseCommand_FLOW                              BaseCommand_Type = 11
	BaseCommand_UNSUBSCRIBE                       BaseCommand_Type = 12
	BaseCommand_SUCCESS                           BaseCommand_Type = 13
	BaseCommand_ERROR                             BaseCommand_Type = 14
	BaseCommand_CLOSE_PRODUCER                    BaseCommand_Type = 15
	BaseCommand_CLOSE_CONSUMER                    BaseCommand_Type = 16
	BaseCommand_PRODUCER_SUCCESS                  BaseCommand_Type = 17
	BaseCommand_PING                              BaseCommand_Type = 18
	BaseCommand_PONG                              BaseCommand_Type = 19
	BaseCommand_REDELIVER_UNACKNOWLEDGED_MESSAGES BaseCommand_Type = 20
	BaseCommand_PARTITIONED_METADATA              BaseCommand_Type = 21
	BaseCommand_PARTITIONED_METADATA_RESPONSE     BaseCommand_Type = 22
	BaseCommand_LOOKUP                            BaseCommand_Type = 23
	BaseCommand_LOOKUP_RESPONSE                   BaseCommand_Type = 24
	BaseCommand_CONSUMER_STATS                    BaseCommand_Type = 25
	BaseCommand_CONSUMER_STATS_RESPONSE           BaseCommand_Type = 26
	BaseCommand_REACHED_END_OF_TOPIC              BaseCommand_Type = 27
	BaseCommand_SEEK                              BaseCommand_Type = 28
	BaseCommand_GET_LAST_MESSAGE_ID               BaseCommand_Type = 29
	BaseCommand_GET_LAST_MESSAGE_ID_RESPONSE      BaseCommand_Type = 30
	BaseCommand_ACTIVE_CONSUMER_CHANGE            BaseCommand_Type = 31
	BaseCommand_GET_TOPICS_OF_NAMESPACE           BaseCommand_Type = 32
	BaseCommand_GET_TOPICS_OF_NAMESPACE_RESPONSE  BaseCommand_Type = 33
	BaseCommand_GET_SCHEMA                        BaseCommand_Type = 34
	BaseCommand_GET_SCHEMA_RESPONSE               BaseCommand_Type = 35
	BaseCommand_AUTH_CHALLENGE                    BaseCommand_Type = 36
	BaseCommand_AUTH_RESPONSE                     BaseCommand_Type = 37
	BaseCommand_ACK_RESPONSE                      BaseCommand_Type = 38
	BaseCommand_GET_OR_CREATE_SCHEMA              BaseCommand_Type = 39
	BaseCommand_GET_OR_CREATE_SCHEMA_RESPONSE     BaseCommand_Type = 40
	// transaction related
	BaseCommand_NEW_TXN                          BaseCommand_Type = 50
	BaseCommand_NEW_TXN_RESPONSE                 BaseCommand_Type = 51
	BaseCommand_ADD_PARTITION_TO_TXN             BaseCommand_Type = 52
	BaseCommand_ADD_PARTITION_TO_TXN_RESPONSE    BaseCommand_Type = 53
	BaseCommand_ADD_SUBSCRIPTION_TO_TXN          BaseCommand_Type = 54
	BaseCommand_ADD_SUBSCRIPTION_TO_TXN_RESPONSE BaseCommand_Type = 55
	BaseCommand_END_TXN                          BaseCommand_Type = 56
	BaseCommand_END_TXN_RESPONSE                 BaseCommand_Type = 57
	BaseCommand_END_TXN_ON_PARTITION             BaseCommand_Type = 58
	BaseCommand_END_TXN_ON_PARTITION_RESPONSE    BaseCommand_Type = 59
	BaseCommand_END_TXN_ON_SUBSCRIPTION          BaseCommand_Type = 60
	BaseCommand_END_TXN_ON_SUBSCRIPTION_RESPONSE BaseCommand_Type = 61
	BaseCommand_TC_CLIENT_CONNECT_REQUEST        BaseCommand_Type = 62
	BaseCommand_TC_CLIENT_CONNECT_RESPONSE       BaseCommand_Type = 63
	BaseCommand_WATCH_TOPIC_LIST                 BaseCommand_Type = 64
	BaseCommand_WATCH_TOPIC_LIST_SUCCESS         BaseCommand_Type = 65
	BaseCommand_WATCH_TOPIC_UPDATE               BaseCommand_Type = 66
	BaseCommand_WATCH_TOPIC_LIST_CLOSE           BaseCommand_Type = 67
	BaseCommand_TOPIC_MIGRATED                   BaseCommand_Type = 68
)

// Enum value maps for BaseCommand_Type.
var (
	BaseCommand_Type_name = map[int32]string{
		2:  "CONNECT",
		3:  "CONNECTED",
		4:  "SUBSCRIBE",
		5:  "PRODUCER",
		6:  "SEND",
		7:  "SEND_RECEIPT",
		8:  "SEND_ERROR",
		9:  "MESSAGE",
		10: "ACK",
		11: "FLOW",
		12: "UNSUBSCRIBE",
		13: "SUCCESS",
		14: "ERROR",
		15: "CLOSE_PRODUCER",
		16: "CLOSE_CONSUMER",
		17: "PRODUCER_SUCCESS",
		18: "PING",
		19: "PONG",
		20: "REDELIVER_UNACKNOWLEDGED_MESSAGES",
		21: "PARTITIONED_METADATA",
		22: "PARTITIONED_METADATA_RESPONSE",
		23: "LOOKUP",
		24: "LOOKUP_RESPONSE",
		25: "CONSUMER_STATS",
		26: "CONSUMER_STATS_RESPONSE",
		27: "REACHED_END_OF_TOPIC",
		28: "SEEK",
		29: "GET_LAST_MESSAGE_ID",
		30: "GET_LAST_MESSAGE_ID_RESPONSE",
		31: "ACTIVE_CONSUMER_CHANGE",
		32: "GET_TOPICS_OF_NAMESPACE",
		33: "GET_TOPICS_OF_NAMESPACE_RESPONSE",
		34: "GET_SCHEMA",
		35: "GET_SCHEMA_RESPONSE",
		36: "AUTH_CHALLENGE",
		37: "AUTH_RESPONSE",
		38: "ACK_RESPONSE",
		39: "GET_OR_CREATE_SCHEMA",
		40: "GET_OR_CREATE_SCHEMA_RESPONSE",
		50: "NEW_TXN",
		51: "NEW_TXN_RESPONSE",
		52: "ADD_PARTITION_TO_TXN",
		53: "ADD_PARTITION_TO_TXN_RESPONSE",
		54: "ADD_SUBSCRIPTION_TO_TXN",
		55: "ADD_SUBSCRIPTION_TO_TXN_RESPONSE",
		56: "END_TXN",
		57: "END_TXN_RESPONSE",
		58: "END_TXN_ON_PARTITION",
		59: "END_TXN_ON_PARTITION_RESPONSE",
		60: "END_TXN_ON_SUBSCRIPTION",
		61: "END_TXN_ON_SUBSCRIPTION_RESPONSE",
		62: "TC_CLIENT_CONNECT_REQUEST",
		63: "TC_CLIENT_CONNECT_RESPONSE",
		64: "WATCH_TOPIC_LIST",
		65: "WATCH_TOPIC_LIST_SUCCESS",
		66: "WATCH_TOPIC_UPDATE",
		67: "WATCH_TOPIC_LIST_CLOSE",
		68: "TOPIC_MIGRATED",
	}
	BaseCommand_Type_value = map[string]int32{
		"CONNECT":                           2,
		"CONNECTED":                         3,
		"SUBSCRIBE":                         4,
		"PRODUCER":                          5,
		"SEND":                              6,
		"SEND_RECEIPT":                      7,
		"SEND_ERROR":                        8,
		"MESSAGE":                           9,
		"ACK":                               10,
		"FLOW":                              11,
		"UNSUBSCRIBE":                       12,
		"SUCCESS":                           13,
		"ERROR":                             14,
		"CLOSE_PRODUCER":                    15,
		"CLOSE_CONSUMER":                    16,
		"PRODUCER_SUCCESS":                  17,
		"PING":                              18,
		"PONG":                              19,
		"REDELIVER_UNACKNOWLEDGED_MESSAGES": 20,
		"PARTITIONED_METADATA":              21,
		"PARTITIONED_METADATA_RESPONSE":     22,
		"LOOKUP":                            23,
		"LOOKUP_RESPONSE":                   24,
		"CONSUMER_STATS":                    25,
		"CONSUMER_STATS_RESPONSE":           26,
		"REACHED_END_OF_TOPIC":              27,
		"SEEK":                              28,
		"GET_LAST_MESSAGE_ID":               29,
		"GET_LAST_MESSAGE_ID_RESPONSE":      30,
		"ACTIVE_CONSUMER_CHANGE":            31,
		"GET_TOPICS_OF_NAMESPACE":           32,
		"GET_TOPICS_OF_NAMESPACE_RESPONSE":  33,
		"GET_SCHEMA":                        34,
		"GET_SCHEMA_RESPONSE":               35,
		"AUTH_CHALLENGE":                    36,
		"AUTH_RESPONSE":                     37,
		"ACK_RESPONSE":                      38,
		"GET_OR_CREATE_SCHEMA":              39,
		"GET_OR_CREATE_SCHEMA_RESPONSE":     40,
		"NEW_TXN":                           50,
		"NEW_TXN_RESPONSE":                  51,
		"ADD_PARTITION_TO_TXN":              52,
		"ADD_PARTITION_TO_TXN_RESPONSE":     53,
		"ADD_SUBSCRIPTION_TO_TXN":           54,
		"ADD_SUBSCRIPTION_TO_TXN_RESPONSE":  55,
		"END_TXN":                           56,
		"END_TXN_RESPONSE":                  57,
		"END_TXN_ON_PARTITION":              58,
		"END_TXN_ON_PARTITION_RESPONSE":     59,
		"END_TXN_ON_SUBSCRIPTION":           60,
		"END_TXN_ON_SUBSCRIPTION_RESPONSE":  61,
		"TC_CLIENT_CONNECT_REQUEST":         62,
		"TC_CLIENT_CONNECT_RESPONSE":        63,
		"WATCH_TOPIC_LIST":                  64,
		"WATCH_TOPIC_LIST_SUCCESS":          65,
		"WATCH_TOPIC_UPDATE":                66,
		"WATCH_TOPIC_LIST_CLOSE":            67,
		"TOPIC_MIGRATED":                    68,
	}
)

func (x BaseCommand_Type) Enum() *BaseCommand_Type {
	p := new(BaseCommand_Type)
	*p = x
	return p
}

func (x BaseCommand_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BaseCommand_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_PulsarApi_proto_enumTypes[16].Descriptor()
}

func (BaseCommand_Type) Type() protoreflect.EnumType {
	return &file_PulsarApi_proto_enumTypes[16]
}

func (x BaseCommand_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *BaseCommand_Type) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = BaseCommand_Type(num)
	return nil
}

// Deprecated: Use BaseCommand_Type.Descriptor instead.
func (BaseCommand_Type) EnumDescriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{71, 0}
}

type Schema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name       *string      `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	SchemaData []byte       `protobuf:"bytes,3,req,name=schema_data,json=schemaData" json:"schema_data,omitempty"`
	Type       *Schema_Type `protobuf:"varint,4,req,name=type,enum=pulsar.proto.Schema_Type" json:"type,omitempty"`
	Properties []*KeyValue  `protobuf:"bytes,5,rep,name=properties" json:"properties,omitempty"`
}

func (x *Schema) Reset() {
	*x = Schema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{0}
}

func (x *Schema) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Schema) GetSchemaData() []byte {
	if x != nil {
		return x.SchemaData
	}
	return nil
}

func (x *Schema) GetType() Schema_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return Schema_None
}

func (x *Schema) GetProperties() []*KeyValue {
	if x != nil {
		return x.Properties
	}
	return nil
}

type MessageIdData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LedgerId   *uint64 `protobuf:"varint,1,req,name=ledgerId" json:"ledgerId,omitempty"`
	EntryId    *uint64 `protobuf:"varint,2,req,name=entryId" json:"entryId,omitempty"`
	Partition  *int32  `protobuf:"varint,3,opt,name=partition,def=-1" json:"partition,omitempty"`
	BatchIndex *int32  `protobuf:"varint,4,opt,name=batch_index,json=batchIndex,def=-1" json:"batch_index,omitempty"`
	AckSet     []int64 `protobuf:"varint,5,rep,name=ack_set,json=ackSet" json:"ack_set,omitempty"`
	BatchSize  *int32  `protobuf:"varint,6,opt,name=batch_size,json=batchSize" json:"batch_size,omitempty"`
	// For the chunk message id, we need to specify the first chunk message id.
	FirstChunkMessageId *MessageIdData `protobuf:"bytes,7,opt,name=first_chunk_message_id,json=firstChunkMessageId" json:"first_chunk_message_id,omitempty"`
}

// Default values for MessageIdData fields.
const (
	Default_MessageIdData_Partition  = int32(-1)
	Default_MessageIdData_BatchIndex = int32(-1)
)

func (x *MessageIdData) Reset() {
	*x = MessageIdData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageIdData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageIdData) ProtoMessage() {}

func (x *MessageIdData) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageIdData.ProtoReflect.Descriptor instead.
func (*MessageIdData) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{1}
}

func (x *MessageIdData) GetLedgerId() uint64 {
	if x != nil && x.LedgerId != nil {
		return *x.LedgerId
	}
	return 0
}

func (x *MessageIdData) GetEntryId() uint64 {
	if x != nil && x.EntryId != nil {
		return *x.EntryId
	}
	return 0
}

func (x *MessageIdData) GetPartition() int32 {
	if x != nil && x.Partition != nil {
		return *x.Partition
	}
	return Default_MessageIdData_Partition
}

func (x *MessageIdData) GetBatchIndex() int32 {
	if x != nil && x.BatchIndex != nil {
		return *x.BatchIndex
	}
	return Default_MessageIdData_BatchIndex
}

func (x *MessageIdData) GetAckSet() []int64 {
	if x != nil {
		return x.AckSet
	}
	return nil
}

func (x *MessageIdData) GetBatchSize() int32 {
	if x != nil && x.BatchSize != nil {
		return *x.BatchSize
	}
	return 0
}

func (x *MessageIdData) GetFirstChunkMessageId() *MessageIdData {
	if x != nil {
		return x.FirstChunkMessageId
	}
	return nil
}

type KeyValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
}

func (x *KeyValue) Reset() {
	*x = KeyValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyValue) ProtoMessage() {}

func (x *KeyValue) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyValue.ProtoReflect.Descriptor instead.
func (*KeyValue) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{2}
}

func (x *KeyValue) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

func (x *KeyValue) GetValue() string {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return ""
}

type KeyLongValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value *uint64 `protobuf:"varint,2,req,name=value" json:"value,omitempty"`
}

func (x *KeyLongValue) Reset() {
	*x = KeyLongValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyLongValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyLongValue) ProtoMessage() {}

func (x *KeyLongValue) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyLongValue.ProtoReflect.Descriptor instead.
func (*KeyLongValue) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{3}
}

func (x *KeyLongValue) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

func (x *KeyLongValue) GetValue() uint64 {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return 0
}

type IntRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Start *int32 `protobuf:"varint,1,req,name=start" json:"start,omitempty"`
	End   *int32 `protobuf:"varint,2,req,name=end" json:"end,omitempty"`
}

func (x *IntRange) Reset() {
	*x = IntRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntRange) ProtoMessage() {}

func (x *IntRange) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntRange.ProtoReflect.Descriptor instead.
func (*IntRange) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{4}
}

func (x *IntRange) GetStart() int32 {
	if x != nil && x.Start != nil {
		return *x.Start
	}
	return 0
}

func (x *IntRange) GetEnd() int32 {
	if x != nil && x.End != nil {
		return *x.End
	}
	return 0
}

type EncryptionKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key      *string     `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value    []byte      `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	Metadata []*KeyValue `protobuf:"bytes,3,rep,name=metadata" json:"metadata,omitempty"`
}

func (x *EncryptionKeys) Reset() {
	*x = EncryptionKeys{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncryptionKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionKeys) ProtoMessage() {}

func (x *EncryptionKeys) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionKeys.ProtoReflect.Descriptor instead.
func (*EncryptionKeys) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{5}
}

func (x *EncryptionKeys) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

func (x *EncryptionKeys) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *EncryptionKeys) GetMetadata() []*KeyValue {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type MessageMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProducerName *string     `protobuf:"bytes,1,req,name=producer_name,json=producerName" json:"producer_name,omitempty"`
	SequenceId   *uint64     `protobuf:"varint,2,req,name=sequence_id,json=sequenceId" json:"sequence_id,omitempty"`
	PublishTime  *uint64     `protobuf:"varint,3,req,name=publish_time,json=publishTime" json:"publish_time,omitempty"`
	Properties   []*KeyValue `protobuf:"bytes,4,rep,name=properties" json:"properties,omitempty"`
	// Property set on replicated message,
	// includes the source cluster name
	ReplicatedFrom *string `protobuf:"bytes,5,opt,name=replicated_from,json=replicatedFrom" json:"replicated_from,omitempty"`
	// key to decide partition for the msg
	PartitionKey *string `protobuf:"bytes,6,opt,name=partition_key,json=partitionKey" json:"partition_key,omitempty"`
	// Override namespace's replication
	ReplicateTo      []string         `protobuf:"bytes,7,rep,name=replicate_to,json=replicateTo" json:"replicate_to,omitempty"`
	Compression      *CompressionType `protobuf:"varint,8,opt,name=compression,enum=pulsar.proto.CompressionType,def=0" json:"compression,omitempty"`
	UncompressedSize *uint32          `protobuf:"varint,9,opt,name=uncompressed_size,json=uncompressedSize,def=0" json:"uncompressed_size,omitempty"`
	// Removed below checksum field from Metadata as
	// it should be part of send-command which keeps checksum of header + payload
	// optional sfixed64 checksum = 10;
	// differentiate single and batch message metadata
	NumMessagesInBatch *int32 `protobuf:"varint,11,opt,name=num_messages_in_batch,json=numMessagesInBatch,def=1" json:"num_messages_in_batch,omitempty"`
	// the timestamp that this event occurs. it is typically set by applications.
	// if this field is omitted, `publish_time` can be used for the purpose of `event_time`.
	EventTime *uint64 `protobuf:"varint,12,opt,name=event_time,json=eventTime,def=0" json:"event_time,omitempty"`
	// Contains encryption key name, encrypted key and metadata to describe the key
	EncryptionKeys []*EncryptionKeys `protobuf:"bytes,13,rep,name=encryption_keys,json=encryptionKeys" json:"encryption_keys,omitempty"`
	// Algorithm used to encrypt data key
	EncryptionAlgo *string `protobuf:"bytes,14,opt,name=encryption_algo,json=encryptionAlgo" json:"encryption_algo,omitempty"`
	// Additional parameters required by encryption
	EncryptionParam        []byte `protobuf:"bytes,15,opt,name=encryption_param,json=encryptionParam" json:"encryption_param,omitempty"`
	SchemaVersion          []byte `protobuf:"bytes,16,opt,name=schema_version,json=schemaVersion" json:"schema_version,omitempty"`
	PartitionKeyB64Encoded *bool  `protobuf:"varint,17,opt,name=partition_key_b64_encoded,json=partitionKeyB64Encoded,def=0" json:"partition_key_b64_encoded,omitempty"`
	// Specific a key to overwrite the message key which used for ordering dispatch in Key_Shared mode.
	OrderingKey []byte `protobuf:"bytes,18,opt,name=ordering_key,json=orderingKey" json:"ordering_key,omitempty"`
	// Mark the message to be delivered at or after the specified timestamp
	DeliverAtTime *int64 `protobuf:"varint,19,opt,name=deliver_at_time,json=deliverAtTime" json:"deliver_at_time,omitempty"`
	// Identify whether a message is a "marker" message used for
	// internal metadata instead of application published data.
	// Markers will generally not be propagated back to clients
	MarkerType *int32 `protobuf:"varint,20,opt,name=marker_type,json=markerType" json:"marker_type,omitempty"`
	// transaction related message info
	TxnidLeastBits *uint64 `protobuf:"varint,22,opt,name=txnid_least_bits,json=txnidLeastBits" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64 `protobuf:"varint,23,opt,name=txnid_most_bits,json=txnidMostBits" json:"txnid_most_bits,omitempty"`
	// / Add highest sequence id to support batch message with external sequence id
	HighestSequenceId *uint64 `protobuf:"varint,24,opt,name=highest_sequence_id,json=highestSequenceId,def=0" json:"highest_sequence_id,omitempty"`
	// Indicate if the message payload value is set
	NullValue         *bool   `protobuf:"varint,25,opt,name=null_value,json=nullValue,def=0" json:"null_value,omitempty"`
	Uuid              *string `protobuf:"bytes,26,opt,name=uuid" json:"uuid,omitempty"`
	NumChunksFromMsg  *int32  `protobuf:"varint,27,opt,name=num_chunks_from_msg,json=numChunksFromMsg" json:"num_chunks_from_msg,omitempty"`
	TotalChunkMsgSize *int32  `protobuf:"varint,28,opt,name=total_chunk_msg_size,json=totalChunkMsgSize" json:"total_chunk_msg_size,omitempty"`
	ChunkId           *int32  `protobuf:"varint,29,opt,name=chunk_id,json=chunkId" json:"chunk_id,omitempty"`
	// Indicate if the message partition key is set
	NullPartitionKey *bool `protobuf:"varint,30,opt,name=null_partition_key,json=nullPartitionKey,def=0" json:"null_partition_key,omitempty"`
}

// Default values for MessageMetadata fields.
const (
	Default_MessageMetadata_Compression            = CompressionType_NONE
	Default_MessageMetadata_UncompressedSize       = uint32(0)
	Default_MessageMetadata_NumMessagesInBatch     = int32(1)
	Default_MessageMetadata_EventTime              = uint64(0)
	Default_MessageMetadata_PartitionKeyB64Encoded = bool(false)
	Default_MessageMetadata_HighestSequenceId      = uint64(0)
	Default_MessageMetadata_NullValue              = bool(false)
	Default_MessageMetadata_NullPartitionKey       = bool(false)
)

func (x *MessageMetadata) Reset() {
	*x = MessageMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageMetadata) ProtoMessage() {}

func (x *MessageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageMetadata.ProtoReflect.Descriptor instead.
func (*MessageMetadata) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{6}
}

func (x *MessageMetadata) GetProducerName() string {
	if x != nil && x.ProducerName != nil {
		return *x.ProducerName
	}
	return ""
}

func (x *MessageMetadata) GetSequenceId() uint64 {
	if x != nil && x.SequenceId != nil {
		return *x.SequenceId
	}
	return 0
}

func (x *MessageMetadata) GetPublishTime() uint64 {
	if x != nil && x.PublishTime != nil {
		return *x.PublishTime
	}
	return 0
}

func (x *MessageMetadata) GetProperties() []*KeyValue {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *MessageMetadata) GetReplicatedFrom() string {
	if x != nil && x.ReplicatedFrom != nil {
		return *x.ReplicatedFrom
	}
	return ""
}

func (x *MessageMetadata) GetPartitionKey() string {
	if x != nil && x.PartitionKey != nil {
		return *x.PartitionKey
	}
	return ""
}

func (x *MessageMetadata) GetReplicateTo() []string {
	if x != nil {
		return x.ReplicateTo
	}
	return nil
}

func (x *MessageMetadata) GetCompression() CompressionType {
	if x != nil && x.Compression != nil {
		return *x.Compression
	}
	return Default_MessageMetadata_Compression
}

func (x *MessageMetadata) GetUncompressedSize() uint32 {
	if x != nil && x.UncompressedSize != nil {
		return *x.UncompressedSize
	}
	return Default_MessageMetadata_UncompressedSize
}

func (x *MessageMetadata) GetNumMessagesInBatch() int32 {
	if x != nil && x.NumMessagesInBatch != nil {
		return *x.NumMessagesInBatch
	}
	return Default_MessageMetadata_NumMessagesInBatch
}

func (x *MessageMetadata) GetEventTime() uint64 {
	if x != nil && x.EventTime != nil {
		return *x.EventTime
	}
	return Default_MessageMetadata_EventTime
}

func (x *MessageMetadata) GetEncryptionKeys() []*EncryptionKeys {
	if x != nil {
		return x.EncryptionKeys
	}
	return nil
}

func (x *MessageMetadata) GetEncryptionAlgo() string {
	if x != nil && x.EncryptionAlgo != nil {
		return *x.EncryptionAlgo
	}
	return ""
}

func (x *MessageMetadata) GetEncryptionParam() []byte {
	if x != nil {
		return x.EncryptionParam
	}
	return nil
}

func (x *MessageMetadata) GetSchemaVersion() []byte {
	if x != nil {
		return x.SchemaVersion
	}
	return nil
}

func (x *MessageMetadata) GetPartitionKeyB64Encoded() bool {
	if x != nil && x.PartitionKeyB64Encoded != nil {
		return *x.PartitionKeyB64Encoded
	}
	return Default_MessageMetadata_PartitionKeyB64Encoded
}

func (x *MessageMetadata) GetOrderingKey() []byte {
	if x != nil {
		return x.OrderingKey
	}
	return nil
}

func (x *MessageMetadata) GetDeliverAtTime() int64 {
	if x != nil && x.DeliverAtTime != nil {
		return *x.DeliverAtTime
	}
	return 0
}

func (x *MessageMetadata) GetMarkerType() int32 {
	if x != nil && x.MarkerType != nil {
		return *x.MarkerType
	}
	return 0
}

func (x *MessageMetadata) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return 0
}

func (x *MessageMetadata) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return 0
}

func (x *MessageMetadata) GetHighestSequenceId() uint64 {
	if x != nil && x.HighestSequenceId != nil {
		return *x.HighestSequenceId
	}
	return Default_MessageMetadata_HighestSequenceId
}

func (x *MessageMetadata) GetNullValue() bool {
	if x != nil && x.NullValue != nil {
		return *x.NullValue
	}
	return Default_MessageMetadata_NullValue
}

func (x *MessageMetadata) GetUuid() string {
	if x != nil && x.Uuid != nil {
		return *x.Uuid
	}
	return ""
}

func (x *MessageMetadata) GetNumChunksFromMsg() int32 {
	if x != nil && x.NumChunksFromMsg != nil {
		return *x.NumChunksFromMsg
	}
	return 0
}

func (x *MessageMetadata) GetTotalChunkMsgSize() int32 {
	if x != nil && x.TotalChunkMsgSize != nil {
		return *x.TotalChunkMsgSize
	}
	return 0
}

func (x *MessageMetadata) GetChunkId() int32 {
	if x != nil && x.ChunkId != nil {
		return *x.ChunkId
	}
	return 0
}

func (x *MessageMetadata) GetNullPartitionKey() bool {
	if x != nil && x.NullPartitionKey != nil {
		return *x.NullPartitionKey
	}
	return Default_MessageMetadata_NullPartitionKey
}

type SingleMessageMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Properties   []*KeyValue `protobuf:"bytes,1,rep,name=properties" json:"properties,omitempty"`
	PartitionKey *string     `protobuf:"bytes,2,opt,name=partition_key,json=partitionKey" json:"partition_key,omitempty"`
	PayloadSize  *int32      `protobuf:"varint,3,req,name=payload_size,json=payloadSize" json:"payload_size,omitempty"`
	CompactedOut *bool       `protobuf:"varint,4,opt,name=compacted_out,json=compactedOut,def=0" json:"compacted_out,omitempty"`
	// the timestamp that this event occurs. it is typically set by applications.
	// if this field is omitted, `publish_time` can be used for the purpose of `event_time`.
	EventTime              *uint64 `protobuf:"varint,5,opt,name=event_time,json=eventTime,def=0" json:"event_time,omitempty"`
	PartitionKeyB64Encoded *bool   `protobuf:"varint,6,opt,name=partition_key_b64_encoded,json=partitionKeyB64Encoded,def=0" json:"partition_key_b64_encoded,omitempty"`
	// Specific a key to overwrite the message key which used for ordering dispatch in Key_Shared mode.
	OrderingKey []byte `protobuf:"bytes,7,opt,name=ordering_key,json=orderingKey" json:"ordering_key,omitempty"`
	// Allows consumer retrieve the sequence id that the producer set.
	SequenceId *uint64 `protobuf:"varint,8,opt,name=sequence_id,json=sequenceId" json:"sequence_id,omitempty"`
	// Indicate if the message payload value is set
	NullValue *bool `protobuf:"varint,9,opt,name=null_value,json=nullValue,def=0" json:"null_value,omitempty"`
	// Indicate if the message partition key is set
	NullPartitionKey *bool `protobuf:"varint,10,opt,name=null_partition_key,json=nullPartitionKey,def=0" json:"null_partition_key,omitempty"`
}

// Default values for SingleMessageMetadata fields.
const (
	Default_SingleMessageMetadata_CompactedOut           = bool(false)
	Default_SingleMessageMetadata_EventTime              = uint64(0)
	Default_SingleMessageMetadata_PartitionKeyB64Encoded = bool(false)
	Default_SingleMessageMetadata_NullValue              = bool(false)
	Default_SingleMessageMetadata_NullPartitionKey       = bool(false)
)

func (x *SingleMessageMetadata) Reset() {
	*x = SingleMessageMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SingleMessageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleMessageMetadata) ProtoMessage() {}

func (x *SingleMessageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleMessageMetadata.ProtoReflect.Descriptor instead.
func (*SingleMessageMetadata) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{7}
}

func (x *SingleMessageMetadata) GetProperties() []*KeyValue {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *SingleMessageMetadata) GetPartitionKey() string {
	if x != nil && x.PartitionKey != nil {
		return *x.PartitionKey
	}
	return ""
}

func (x *SingleMessageMetadata) GetPayloadSize() int32 {
	if x != nil && x.PayloadSize != nil {
		return *x.PayloadSize
	}
	return 0
}

func (x *SingleMessageMetadata) GetCompactedOut() bool {
	if x != nil && x.CompactedOut != nil {
		return *x.CompactedOut
	}
	return Default_SingleMessageMetadata_CompactedOut
}

func (x *SingleMessageMetadata) GetEventTime() uint64 {
	if x != nil && x.EventTime != nil {
		return *x.EventTime
	}
	return Default_SingleMessageMetadata_EventTime
}

func (x *SingleMessageMetadata) GetPartitionKeyB64Encoded() bool {
	if x != nil && x.PartitionKeyB64Encoded != nil {
		return *x.PartitionKeyB64Encoded
	}
	return Default_SingleMessageMetadata_PartitionKeyB64Encoded
}

func (x *SingleMessageMetadata) GetOrderingKey() []byte {
	if x != nil {
		return x.OrderingKey
	}
	return nil
}

func (x *SingleMessageMetadata) GetSequenceId() uint64 {
	if x != nil && x.SequenceId != nil {
		return *x.SequenceId
	}
	return 0
}

func (x *SingleMessageMetadata) GetNullValue() bool {
	if x != nil && x.NullValue != nil {
		return *x.NullValue
	}
	return Default_SingleMessageMetadata_NullValue
}

func (x *SingleMessageMetadata) GetNullPartitionKey() bool {
	if x != nil && x.NullPartitionKey != nil {
		return *x.NullPartitionKey
	}
	return Default_SingleMessageMetadata_NullPartitionKey
}

// metadata added for entry from broker
type BrokerEntryMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BrokerTimestamp *uint64 `protobuf:"varint,1,opt,name=broker_timestamp,json=brokerTimestamp" json:"broker_timestamp,omitempty"`
	Index           *uint64 `protobuf:"varint,2,opt,name=index" json:"index,omitempty"`
}

func (x *BrokerEntryMetadata) Reset() {
	*x = BrokerEntryMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BrokerEntryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BrokerEntryMetadata) ProtoMessage() {}

func (x *BrokerEntryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BrokerEntryMetadata.ProtoReflect.Descriptor instead.
func (*BrokerEntryMetadata) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{8}
}

func (x *BrokerEntryMetadata) GetBrokerTimestamp() uint64 {
	if x != nil && x.BrokerTimestamp != nil {
		return *x.BrokerTimestamp
	}
	return 0
}

func (x *BrokerEntryMetadata) GetIndex() uint64 {
	if x != nil && x.Index != nil {
		return *x.Index
	}
	return 0
}

type CommandConnect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientVersion   *string     `protobuf:"bytes,1,req,name=client_version,json=clientVersion" json:"client_version,omitempty"`
	AuthMethod      *AuthMethod `protobuf:"varint,2,opt,name=auth_method,json=authMethod,enum=pulsar.proto.AuthMethod" json:"auth_method,omitempty"` // Deprecated. Use "auth_method_name" instead.
	AuthMethodName  *string     `protobuf:"bytes,5,opt,name=auth_method_name,json=authMethodName" json:"auth_method_name,omitempty"`
	AuthData        []byte      `protobuf:"bytes,3,opt,name=auth_data,json=authData" json:"auth_data,omitempty"`
	ProtocolVersion *int32      `protobuf:"varint,4,opt,name=protocol_version,json=protocolVersion,def=0" json:"protocol_version,omitempty"`
	// Client can ask to be proxyied to a specific broker
	// This is only honored by a Pulsar proxy
	ProxyToBrokerUrl *string `protobuf:"bytes,6,opt,name=proxy_to_broker_url,json=proxyToBrokerUrl" json:"proxy_to_broker_url,omitempty"`
	// Original principal that was verified by
	// a Pulsar proxy. In this case the auth info above
	// will be the auth of the proxy itself
	OriginalPrincipal *string `protobuf:"bytes,7,opt,name=original_principal,json=originalPrincipal" json:"original_principal,omitempty"`
	// Original auth role and auth Method that was passed
	// to the proxy. In this case the auth info above
	// will be the auth of the proxy itself
	OriginalAuthData   *string `protobuf:"bytes,8,opt,name=original_auth_data,json=originalAuthData" json:"original_auth_data,omitempty"`
	OriginalAuthMethod *string `protobuf:"bytes,9,opt,name=original_auth_method,json=originalAuthMethod" json:"original_auth_method,omitempty"`
	// Feature flags
	FeatureFlags *FeatureFlags `protobuf:"bytes,10,opt,name=feature_flags,json=featureFlags" json:"feature_flags,omitempty"`
}

// Default values for CommandConnect fields.
const (
	Default_CommandConnect_ProtocolVersion = int32(0)
)

func (x *CommandConnect) Reset() {
	*x = CommandConnect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandConnect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandConnect) ProtoMessage() {}

func (x *CommandConnect) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandConnect.ProtoReflect.Descriptor instead.
func (*CommandConnect) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{9}
}

func (x *CommandConnect) GetClientVersion() string {
	if x != nil && x.ClientVersion != nil {
		return *x.ClientVersion
	}
	return ""
}

func (x *CommandConnect) GetAuthMethod() AuthMethod {
	if x != nil && x.AuthMethod != nil {
		return *x.AuthMethod
	}
	return AuthMethod_AuthMethodNone
}

func (x *CommandConnect) GetAuthMethodName() string {
	if x != nil && x.AuthMethodName != nil {
		return *x.AuthMethodName
	}
	return ""
}

func (x *CommandConnect) GetAuthData() []byte {
	if x != nil {
		return x.AuthData
	}
	return nil
}

func (x *CommandConnect) GetProtocolVersion() int32 {
	if x != nil && x.ProtocolVersion != nil {
		return *x.ProtocolVersion
	}
	return Default_CommandConnect_ProtocolVersion
}

func (x *CommandConnect) GetProxyToBrokerUrl() string {
	if x != nil && x.ProxyToBrokerUrl != nil {
		return *x.ProxyToBrokerUrl
	}
	return ""
}

func (x *CommandConnect) GetOriginalPrincipal() string {
	if x != nil && x.OriginalPrincipal != nil {
		return *x.OriginalPrincipal
	}
	return ""
}

func (x *CommandConnect) GetOriginalAuthData() string {
	if x != nil && x.OriginalAuthData != nil {
		return *x.OriginalAuthData
	}
	return ""
}

func (x *CommandConnect) GetOriginalAuthMethod() string {
	if x != nil && x.OriginalAuthMethod != nil {
		return *x.OriginalAuthMethod
	}
	return ""
}

func (x *CommandConnect) GetFeatureFlags() *FeatureFlags {
	if x != nil {
		return x.FeatureFlags
	}
	return nil
}

type FeatureFlags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SupportsAuthRefresh         *bool `protobuf:"varint,1,opt,name=supports_auth_refresh,json=supportsAuthRefresh,def=0" json:"supports_auth_refresh,omitempty"`
	SupportsBrokerEntryMetadata *bool `protobuf:"varint,2,opt,name=supports_broker_entry_metadata,json=supportsBrokerEntryMetadata,def=0" json:"supports_broker_entry_metadata,omitempty"`
	SupportsPartialProducer     *bool `protobuf:"varint,3,opt,name=supports_partial_producer,json=supportsPartialProducer,def=0" json:"supports_partial_producer,omitempty"`
	SupportsTopicWatchers       *bool `protobuf:"varint,4,opt,name=supports_topic_watchers,json=supportsTopicWatchers,def=0" json:"supports_topic_watchers,omitempty"`
}

// Default values for FeatureFlags fields.
const (
	Default_FeatureFlags_SupportsAuthRefresh         = bool(false)
	Default_FeatureFlags_SupportsBrokerEntryMetadata = bool(false)
	Default_FeatureFlags_SupportsPartialProducer     = bool(false)
	Default_FeatureFlags_SupportsTopicWatchers       = bool(false)
)

func (x *FeatureFlags) Reset() {
	*x = FeatureFlags{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeatureFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureFlags) ProtoMessage() {}

func (x *FeatureFlags) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureFlags.ProtoReflect.Descriptor instead.
func (*FeatureFlags) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{10}
}

func (x *FeatureFlags) GetSupportsAuthRefresh() bool {
	if x != nil && x.SupportsAuthRefresh != nil {
		return *x.SupportsAuthRefresh
	}
	return Default_FeatureFlags_SupportsAuthRefresh
}

func (x *FeatureFlags) GetSupportsBrokerEntryMetadata() bool {
	if x != nil && x.SupportsBrokerEntryMetadata != nil {
		return *x.SupportsBrokerEntryMetadata
	}
	return Default_FeatureFlags_SupportsBrokerEntryMetadata
}

func (x *FeatureFlags) GetSupportsPartialProducer() bool {
	if x != nil && x.SupportsPartialProducer != nil {
		return *x.SupportsPartialProducer
	}
	return Default_FeatureFlags_SupportsPartialProducer
}

func (x *FeatureFlags) GetSupportsTopicWatchers() bool {
	if x != nil && x.SupportsTopicWatchers != nil {
		return *x.SupportsTopicWatchers
	}
	return Default_FeatureFlags_SupportsTopicWatchers
}

type CommandConnected struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ServerVersion   *string       `protobuf:"bytes,1,req,name=server_version,json=serverVersion" json:"server_version,omitempty"`
	ProtocolVersion *int32        `protobuf:"varint,2,opt,name=protocol_version,json=protocolVersion,def=0" json:"protocol_version,omitempty"`
	MaxMessageSize  *int32        `protobuf:"varint,3,opt,name=max_message_size,json=maxMessageSize" json:"max_message_size,omitempty"`
	FeatureFlags    *FeatureFlags `protobuf:"bytes,4,opt,name=feature_flags,json=featureFlags" json:"feature_flags,omitempty"`
}

// Default values for CommandConnected fields.
const (
	Default_CommandConnected_ProtocolVersion = int32(0)
)

func (x *CommandConnected) Reset() {
	*x = CommandConnected{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandConnected) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandConnected) ProtoMessage() {}

func (x *CommandConnected) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandConnected.ProtoReflect.Descriptor instead.
func (*CommandConnected) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{11}
}

func (x *CommandConnected) GetServerVersion() string {
	if x != nil && x.ServerVersion != nil {
		return *x.ServerVersion
	}
	return ""
}

func (x *CommandConnected) GetProtocolVersion() int32 {
	if x != nil && x.ProtocolVersion != nil {
		return *x.ProtocolVersion
	}
	return Default_CommandConnected_ProtocolVersion
}

func (x *CommandConnected) GetMaxMessageSize() int32 {
	if x != nil && x.MaxMessageSize != nil {
		return *x.MaxMessageSize
	}
	return 0
}

func (x *CommandConnected) GetFeatureFlags() *FeatureFlags {
	if x != nil {
		return x.FeatureFlags
	}
	return nil
}

type CommandAuthResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientVersion   *string   `protobuf:"bytes,1,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
	Response        *AuthData `protobuf:"bytes,2,opt,name=response" json:"response,omitempty"`
	ProtocolVersion *int32    `protobuf:"varint,3,opt,name=protocol_version,json=protocolVersion,def=0" json:"protocol_version,omitempty"`
}

// Default values for CommandAuthResponse fields.
const (
	Default_CommandAuthResponse_ProtocolVersion = int32(0)
)

func (x *CommandAuthResponse) Reset() {
	*x = CommandAuthResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandAuthResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandAuthResponse) ProtoMessage() {}

func (x *CommandAuthResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandAuthResponse.ProtoReflect.Descriptor instead.
func (*CommandAuthResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{12}
}

func (x *CommandAuthResponse) GetClientVersion() string {
	if x != nil && x.ClientVersion != nil {
		return *x.ClientVersion
	}
	return ""
}

func (x *CommandAuthResponse) GetResponse() *AuthData {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *CommandAuthResponse) GetProtocolVersion() int32 {
	if x != nil && x.ProtocolVersion != nil {
		return *x.ProtocolVersion
	}
	return Default_CommandAuthResponse_ProtocolVersion
}

type CommandAuthChallenge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ServerVersion   *string   `protobuf:"bytes,1,opt,name=server_version,json=serverVersion" json:"server_version,omitempty"`
	Challenge       *AuthData `protobuf:"bytes,2,opt,name=challenge" json:"challenge,omitempty"`
	ProtocolVersion *int32    `protobuf:"varint,3,opt,name=protocol_version,json=protocolVersion,def=0" json:"protocol_version,omitempty"`
}

// Default values for CommandAuthChallenge fields.
const (
	Default_CommandAuthChallenge_ProtocolVersion = int32(0)
)

func (x *CommandAuthChallenge) Reset() {
	*x = CommandAuthChallenge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandAuthChallenge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandAuthChallenge) ProtoMessage() {}

func (x *CommandAuthChallenge) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandAuthChallenge.ProtoReflect.Descriptor instead.
func (*CommandAuthChallenge) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{13}
}

func (x *CommandAuthChallenge) GetServerVersion() string {
	if x != nil && x.ServerVersion != nil {
		return *x.ServerVersion
	}
	return ""
}

func (x *CommandAuthChallenge) GetChallenge() *AuthData {
	if x != nil {
		return x.Challenge
	}
	return nil
}

func (x *CommandAuthChallenge) GetProtocolVersion() int32 {
	if x != nil && x.ProtocolVersion != nil {
		return *x.ProtocolVersion
	}
	return Default_CommandAuthChallenge_ProtocolVersion
}

// To support mutual authentication type, such as Sasl, reuse this command to mutual auth.
type AuthData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AuthMethodName *string `protobuf:"bytes,1,opt,name=auth_method_name,json=authMethodName" json:"auth_method_name,omitempty"`
	AuthData       []byte  `protobuf:"bytes,2,opt,name=auth_data,json=authData" json:"auth_data,omitempty"`
}

func (x *AuthData) Reset() {
	*x = AuthData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthData) ProtoMessage() {}

func (x *AuthData) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthData.ProtoReflect.Descriptor instead.
func (*AuthData) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{14}
}

func (x *AuthData) GetAuthMethodName() string {
	if x != nil && x.AuthMethodName != nil {
		return *x.AuthMethodName
	}
	return ""
}

func (x *AuthData) GetAuthData() []byte {
	if x != nil {
		return x.AuthData
	}
	return nil
}

type KeySharedMeta struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeySharedMode           *KeySharedMode `protobuf:"varint,1,req,name=keySharedMode,enum=pulsar.proto.KeySharedMode" json:"keySharedMode,omitempty"`
	HashRanges              []*IntRange    `protobuf:"bytes,3,rep,name=hashRanges" json:"hashRanges,omitempty"`
	AllowOutOfOrderDelivery *bool          `protobuf:"varint,4,opt,name=allowOutOfOrderDelivery,def=0" json:"allowOutOfOrderDelivery,omitempty"`
}

// Default values for KeySharedMeta fields.
const (
	Default_KeySharedMeta_AllowOutOfOrderDelivery = bool(false)
)

func (x *KeySharedMeta) Reset() {
	*x = KeySharedMeta{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeySharedMeta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeySharedMeta) ProtoMessage() {}

func (x *KeySharedMeta) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeySharedMeta.ProtoReflect.Descriptor instead.
func (*KeySharedMeta) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{15}
}

func (x *KeySharedMeta) GetKeySharedMode() KeySharedMode {
	if x != nil && x.KeySharedMode != nil {
		return *x.KeySharedMode
	}
	return KeySharedMode_AUTO_SPLIT
}

func (x *KeySharedMeta) GetHashRanges() []*IntRange {
	if x != nil {
		return x.HashRanges
	}
	return nil
}

func (x *KeySharedMeta) GetAllowOutOfOrderDelivery() bool {
	if x != nil && x.AllowOutOfOrderDelivery != nil {
		return *x.AllowOutOfOrderDelivery
	}
	return Default_KeySharedMeta_AllowOutOfOrderDelivery
}

type CommandSubscribe struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic         *string                   `protobuf:"bytes,1,req,name=topic" json:"topic,omitempty"`
	Subscription  *string                   `protobuf:"bytes,2,req,name=subscription" json:"subscription,omitempty"`
	SubType       *CommandSubscribe_SubType `protobuf:"varint,3,req,name=subType,enum=pulsar.proto.CommandSubscribe_SubType" json:"subType,omitempty"`
	ConsumerId    *uint64                   `protobuf:"varint,4,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	RequestId     *uint64                   `protobuf:"varint,5,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	ConsumerName  *string                   `protobuf:"bytes,6,opt,name=consumer_name,json=consumerName" json:"consumer_name,omitempty"`
	PriorityLevel *int32                    `protobuf:"varint,7,opt,name=priority_level,json=priorityLevel" json:"priority_level,omitempty"`
	// Signal wether the subscription should be backed by a
	// durable cursor or not
	Durable *bool `protobuf:"varint,8,opt,name=durable,def=1" json:"durable,omitempty"`
	// If specified, the subscription will position the cursor
	// markd-delete position  on the particular message id and
	// will send messages from that point
	StartMessageId *MessageIdData `protobuf:"bytes,9,opt,name=start_message_id,json=startMessageId" json:"start_message_id,omitempty"`
	// / Add optional metadata key=value to this consumer
	Metadata      []*KeyValue `protobuf:"bytes,10,rep,name=metadata" json:"metadata,omitempty"`
	ReadCompacted *bool       `protobuf:"varint,11,opt,name=read_compacted,json=readCompacted" json:"read_compacted,omitempty"`
	Schema        *Schema     `protobuf:"bytes,12,opt,name=schema" json:"schema,omitempty"`
	// Signal whether the subscription will initialize on latest
	// or not -- earliest
	InitialPosition *CommandSubscribe_InitialPosition `protobuf:"varint,13,opt,name=initialPosition,enum=pulsar.proto.CommandSubscribe_InitialPosition,def=0" json:"initialPosition,omitempty"`
	// Mark the subscription as "replicated". Pulsar will make sure
	// to periodically sync the state of replicated subscriptions
	// across different clusters (when using geo-replication).
	ReplicateSubscriptionState *bool `protobuf:"varint,14,opt,name=replicate_subscription_state,json=replicateSubscriptionState" json:"replicate_subscription_state,omitempty"`
	// If true, the subscribe operation will cause a topic to be
	// created if it does not exist already (and if topic auto-creation
	// is allowed by broker.
	// If false, the subscribe operation will fail if the topic
	// does not exist.
	ForceTopicCreation *bool `protobuf:"varint,15,opt,name=force_topic_creation,json=forceTopicCreation,def=1" json:"force_topic_creation,omitempty"`
	// If specified, the subscription will reset cursor's position back
	// to specified seconds and  will send messages from that point
	StartMessageRollbackDurationSec *uint64        `protobuf:"varint,16,opt,name=start_message_rollback_duration_sec,json=startMessageRollbackDurationSec,def=0" json:"start_message_rollback_duration_sec,omitempty"`
	KeySharedMeta                   *KeySharedMeta `protobuf:"bytes,17,opt,name=keySharedMeta" json:"keySharedMeta,omitempty"`
	SubscriptionProperties          []*KeyValue    `protobuf:"bytes,18,rep,name=subscription_properties,json=subscriptionProperties" json:"subscription_properties,omitempty"`
	// The consumer epoch, when exclusive and failover consumer redeliver unack message will increase the epoch
	ConsumerEpoch *uint64 `protobuf:"varint,19,opt,name=consumer_epoch,json=consumerEpoch" json:"consumer_epoch,omitempty"`
}

// Default values for CommandSubscribe fields.
const (
	Default_CommandSubscribe_Durable                         = bool(true)
	Default_CommandSubscribe_InitialPosition                 = CommandSubscribe_Latest
	Default_CommandSubscribe_ForceTopicCreation              = bool(true)
	Default_CommandSubscribe_StartMessageRollbackDurationSec = uint64(0)
)

func (x *CommandSubscribe) Reset() {
	*x = CommandSubscribe{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandSubscribe) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandSubscribe) ProtoMessage() {}

func (x *CommandSubscribe) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandSubscribe.ProtoReflect.Descriptor instead.
func (*CommandSubscribe) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{16}
}

func (x *CommandSubscribe) GetTopic() string {
	if x != nil && x.Topic != nil {
		return *x.Topic
	}
	return ""
}

func (x *CommandSubscribe) GetSubscription() string {
	if x != nil && x.Subscription != nil {
		return *x.Subscription
	}
	return ""
}

func (x *CommandSubscribe) GetSubType() CommandSubscribe_SubType {
	if x != nil && x.SubType != nil {
		return *x.SubType
	}
	return CommandSubscribe_Exclusive
}

func (x *CommandSubscribe) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandSubscribe) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandSubscribe) GetConsumerName() string {
	if x != nil && x.ConsumerName != nil {
		return *x.ConsumerName
	}
	return ""
}

func (x *CommandSubscribe) GetPriorityLevel() int32 {
	if x != nil && x.PriorityLevel != nil {
		return *x.PriorityLevel
	}
	return 0
}

func (x *CommandSubscribe) GetDurable() bool {
	if x != nil && x.Durable != nil {
		return *x.Durable
	}
	return Default_CommandSubscribe_Durable
}

func (x *CommandSubscribe) GetStartMessageId() *MessageIdData {
	if x != nil {
		return x.StartMessageId
	}
	return nil
}

func (x *CommandSubscribe) GetMetadata() []*KeyValue {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *CommandSubscribe) GetReadCompacted() bool {
	if x != nil && x.ReadCompacted != nil {
		return *x.ReadCompacted
	}
	return false
}

func (x *CommandSubscribe) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *CommandSubscribe) GetInitialPosition() CommandSubscribe_InitialPosition {
	if x != nil && x.InitialPosition != nil {
		return *x.InitialPosition
	}
	return Default_CommandSubscribe_InitialPosition
}

func (x *CommandSubscribe) GetReplicateSubscriptionState() bool {
	if x != nil && x.ReplicateSubscriptionState != nil {
		return *x.ReplicateSubscriptionState
	}
	return false
}

func (x *CommandSubscribe) GetForceTopicCreation() bool {
	if x != nil && x.ForceTopicCreation != nil {
		return *x.ForceTopicCreation
	}
	return Default_CommandSubscribe_ForceTopicCreation
}

func (x *CommandSubscribe) GetStartMessageRollbackDurationSec() uint64 {
	if x != nil && x.StartMessageRollbackDurationSec != nil {
		return *x.StartMessageRollbackDurationSec
	}
	return Default_CommandSubscribe_StartMessageRollbackDurationSec
}

func (x *CommandSubscribe) GetKeySharedMeta() *KeySharedMeta {
	if x != nil {
		return x.KeySharedMeta
	}
	return nil
}

func (x *CommandSubscribe) GetSubscriptionProperties() []*KeyValue {
	if x != nil {
		return x.SubscriptionProperties
	}
	return nil
}

func (x *CommandSubscribe) GetConsumerEpoch() uint64 {
	if x != nil && x.ConsumerEpoch != nil {
		return *x.ConsumerEpoch
	}
	return 0
}

type CommandPartitionedTopicMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic     *string `protobuf:"bytes,1,req,name=topic" json:"topic,omitempty"`
	RequestId *uint64 `protobuf:"varint,2,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	// TODO - Remove original_principal, original_auth_data, original_auth_method
	// Original principal that was verified by
	// a Pulsar proxy.
	OriginalPrincipal *string `protobuf:"bytes,3,opt,name=original_principal,json=originalPrincipal" json:"original_principal,omitempty"`
	// Original auth role and auth Method that was passed
	// to the proxy.
	OriginalAuthData   *string `protobuf:"bytes,4,opt,name=original_auth_data,json=originalAuthData" json:"original_auth_data,omitempty"`
	OriginalAuthMethod *string `protobuf:"bytes,5,opt,name=original_auth_method,json=originalAuthMethod" json:"original_auth_method,omitempty"`
}

func (x *CommandPartitionedTopicMetadata) Reset() {
	*x = CommandPartitionedTopicMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandPartitionedTopicMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandPartitionedTopicMetadata) ProtoMessage() {}

func (x *CommandPartitionedTopicMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandPartitionedTopicMetadata.ProtoReflect.Descriptor instead.
func (*CommandPartitionedTopicMetadata) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{17}
}

func (x *CommandPartitionedTopicMetadata) GetTopic() string {
	if x != nil && x.Topic != nil {
		return *x.Topic
	}
	return ""
}

func (x *CommandPartitionedTopicMetadata) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandPartitionedTopicMetadata) GetOriginalPrincipal() string {
	if x != nil && x.OriginalPrincipal != nil {
		return *x.OriginalPrincipal
	}
	return ""
}

func (x *CommandPartitionedTopicMetadata) GetOriginalAuthData() string {
	if x != nil && x.OriginalAuthData != nil {
		return *x.OriginalAuthData
	}
	return ""
}

func (x *CommandPartitionedTopicMetadata) GetOriginalAuthMethod() string {
	if x != nil && x.OriginalAuthMethod != nil {
		return *x.OriginalAuthMethod
	}
	return ""
}

type CommandPartitionedTopicMetadataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Partitions *uint32                                             `protobuf:"varint,1,opt,name=partitions" json:"partitions,omitempty"` // Optional in case of error
	RequestId  *uint64                                             `protobuf:"varint,2,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Response   *CommandPartitionedTopicMetadataResponse_LookupType `protobuf:"varint,3,opt,name=response,enum=pulsar.proto.CommandPartitionedTopicMetadataResponse_LookupType" json:"response,omitempty"`
	Error      *ServerError                                        `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message    *string                                             `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
}

func (x *CommandPartitionedTopicMetadataResponse) Reset() {
	*x = CommandPartitionedTopicMetadataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandPartitionedTopicMetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandPartitionedTopicMetadataResponse) ProtoMessage() {}

func (x *CommandPartitionedTopicMetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandPartitionedTopicMetadataResponse.ProtoReflect.Descriptor instead.
func (*CommandPartitionedTopicMetadataResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{18}
}

func (x *CommandPartitionedTopicMetadataResponse) GetPartitions() uint32 {
	if x != nil && x.Partitions != nil {
		return *x.Partitions
	}
	return 0
}

func (x *CommandPartitionedTopicMetadataResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandPartitionedTopicMetadataResponse) GetResponse() CommandPartitionedTopicMetadataResponse_LookupType {
	if x != nil && x.Response != nil {
		return *x.Response
	}
	return CommandPartitionedTopicMetadataResponse_Success
}

func (x *CommandPartitionedTopicMetadataResponse) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandPartitionedTopicMetadataResponse) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

type CommandLookupTopic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic         *string `protobuf:"bytes,1,req,name=topic" json:"topic,omitempty"`
	RequestId     *uint64 `protobuf:"varint,2,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Authoritative *bool   `protobuf:"varint,3,opt,name=authoritative,def=0" json:"authoritative,omitempty"`
	// TODO - Remove original_principal, original_auth_data, original_auth_method
	// Original principal that was verified by
	// a Pulsar proxy.
	OriginalPrincipal *string `protobuf:"bytes,4,opt,name=original_principal,json=originalPrincipal" json:"original_principal,omitempty"`
	// Original auth role and auth Method that was passed
	// to the proxy.
	OriginalAuthData       *string `protobuf:"bytes,5,opt,name=original_auth_data,json=originalAuthData" json:"original_auth_data,omitempty"`
	OriginalAuthMethod     *string `protobuf:"bytes,6,opt,name=original_auth_method,json=originalAuthMethod" json:"original_auth_method,omitempty"`
	AdvertisedListenerName *string `protobuf:"bytes,7,opt,name=advertised_listener_name,json=advertisedListenerName" json:"advertised_listener_name,omitempty"`
	// The properties used for topic lookup
	Properties []*KeyValue `protobuf:"bytes,8,rep,name=properties" json:"properties,omitempty"`
}

// Default values for CommandLookupTopic fields.
const (
	Default_CommandLookupTopic_Authoritative = bool(false)
)

func (x *CommandLookupTopic) Reset() {
	*x = CommandLookupTopic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandLookupTopic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandLookupTopic) ProtoMessage() {}

func (x *CommandLookupTopic) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandLookupTopic.ProtoReflect.Descriptor instead.
func (*CommandLookupTopic) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{19}
}

func (x *CommandLookupTopic) GetTopic() string {
	if x != nil && x.Topic != nil {
		return *x.Topic
	}
	return ""
}

func (x *CommandLookupTopic) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandLookupTopic) GetAuthoritative() bool {
	if x != nil && x.Authoritative != nil {
		return *x.Authoritative
	}
	return Default_CommandLookupTopic_Authoritative
}

func (x *CommandLookupTopic) GetOriginalPrincipal() string {
	if x != nil && x.OriginalPrincipal != nil {
		return *x.OriginalPrincipal
	}
	return ""
}

func (x *CommandLookupTopic) GetOriginalAuthData() string {
	if x != nil && x.OriginalAuthData != nil {
		return *x.OriginalAuthData
	}
	return ""
}

func (x *CommandLookupTopic) GetOriginalAuthMethod() string {
	if x != nil && x.OriginalAuthMethod != nil {
		return *x.OriginalAuthMethod
	}
	return ""
}

func (x *CommandLookupTopic) GetAdvertisedListenerName() string {
	if x != nil && x.AdvertisedListenerName != nil {
		return *x.AdvertisedListenerName
	}
	return ""
}

func (x *CommandLookupTopic) GetProperties() []*KeyValue {
	if x != nil {
		return x.Properties
	}
	return nil
}

type CommandLookupTopicResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BrokerServiceUrl    *string                                `protobuf:"bytes,1,opt,name=brokerServiceUrl" json:"brokerServiceUrl,omitempty"` // Optional in case of error
	BrokerServiceUrlTls *string                                `protobuf:"bytes,2,opt,name=brokerServiceUrlTls" json:"brokerServiceUrlTls,omitempty"`
	Response            *CommandLookupTopicResponse_LookupType `protobuf:"varint,3,opt,name=response,enum=pulsar.proto.CommandLookupTopicResponse_LookupType" json:"response,omitempty"`
	RequestId           *uint64                                `protobuf:"varint,4,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Authoritative       *bool                                  `protobuf:"varint,5,opt,name=authoritative,def=0" json:"authoritative,omitempty"`
	Error               *ServerError                           `protobuf:"varint,6,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message             *string                                `protobuf:"bytes,7,opt,name=message" json:"message,omitempty"`
	// If it's true, indicates to the client that it must
	// always connect through the service url after the
	// lookup has been completed.
	ProxyThroughServiceUrl *bool `protobuf:"varint,8,opt,name=proxy_through_service_url,json=proxyThroughServiceUrl,def=0" json:"proxy_through_service_url,omitempty"`
}

// Default values for CommandLookupTopicResponse fields.
const (
	Default_CommandLookupTopicResponse_Authoritative          = bool(false)
	Default_CommandLookupTopicResponse_ProxyThroughServiceUrl = bool(false)
)

func (x *CommandLookupTopicResponse) Reset() {
	*x = CommandLookupTopicResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandLookupTopicResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandLookupTopicResponse) ProtoMessage() {}

func (x *CommandLookupTopicResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandLookupTopicResponse.ProtoReflect.Descriptor instead.
func (*CommandLookupTopicResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{20}
}

func (x *CommandLookupTopicResponse) GetBrokerServiceUrl() string {
	if x != nil && x.BrokerServiceUrl != nil {
		return *x.BrokerServiceUrl
	}
	return ""
}

func (x *CommandLookupTopicResponse) GetBrokerServiceUrlTls() string {
	if x != nil && x.BrokerServiceUrlTls != nil {
		return *x.BrokerServiceUrlTls
	}
	return ""
}

func (x *CommandLookupTopicResponse) GetResponse() CommandLookupTopicResponse_LookupType {
	if x != nil && x.Response != nil {
		return *x.Response
	}
	return CommandLookupTopicResponse_Redirect
}

func (x *CommandLookupTopicResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandLookupTopicResponse) GetAuthoritative() bool {
	if x != nil && x.Authoritative != nil {
		return *x.Authoritative
	}
	return Default_CommandLookupTopicResponse_Authoritative
}

func (x *CommandLookupTopicResponse) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandLookupTopicResponse) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

func (x *CommandLookupTopicResponse) GetProxyThroughServiceUrl() bool {
	if x != nil && x.ProxyThroughServiceUrl != nil {
		return *x.ProxyThroughServiceUrl
	}
	return Default_CommandLookupTopicResponse_ProxyThroughServiceUrl
}

// / Create a new Producer on a topic, assigning the given producer_id,
// / all messages sent with this producer_id will be persisted on the topic
type CommandProducer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic      *string `protobuf:"bytes,1,req,name=topic" json:"topic,omitempty"`
	ProducerId *uint64 `protobuf:"varint,2,req,name=producer_id,json=producerId" json:"producer_id,omitempty"`
	RequestId  *uint64 `protobuf:"varint,3,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	// / If a producer name is specified, the name will be used,
	// / otherwise the broker will generate a unique name
	ProducerName *string `protobuf:"bytes,4,opt,name=producer_name,json=producerName" json:"producer_name,omitempty"`
	Encrypted    *bool   `protobuf:"varint,5,opt,name=encrypted,def=0" json:"encrypted,omitempty"`
	// / Add optional metadata key=value to this producer
	Metadata []*KeyValue `protobuf:"bytes,6,rep,name=metadata" json:"metadata,omitempty"`
	Schema   *Schema     `protobuf:"bytes,7,opt,name=schema" json:"schema,omitempty"`
	// If producer reconnect to broker, the epoch of this producer will +1
	Epoch *uint64 `protobuf:"varint,8,opt,name=epoch,def=0" json:"epoch,omitempty"`
	// Indicate the name of the producer is generated or user provided
	// Use default true here is in order to be forward compatible with the client
	UserProvidedProducerName *bool `protobuf:"varint,9,opt,name=user_provided_producer_name,json=userProvidedProducerName,def=1" json:"user_provided_producer_name,omitempty"`
	// Require that this producers will be the only producer allowed on the topic
	ProducerAccessMode *ProducerAccessMode `protobuf:"varint,10,opt,name=producer_access_mode,json=producerAccessMode,enum=pulsar.proto.ProducerAccessMode,def=0" json:"producer_access_mode,omitempty"`
	// Topic epoch is used to fence off producers that reconnects after a new
	// exclusive producer has already taken over. This id is assigned by the
	// broker on the CommandProducerSuccess. The first time, the client will
	// leave it empty and then it will always carry the same epoch number on
	// the subsequent reconnections.
	TopicEpoch *uint64 `protobuf:"varint,11,opt,name=topic_epoch,json=topicEpoch" json:"topic_epoch,omitempty"`
	TxnEnabled *bool   `protobuf:"varint,12,opt,name=txn_enabled,json=txnEnabled,def=0" json:"txn_enabled,omitempty"`
	// Name of the initial subscription of the topic.
	// If this field is not set, the initial subscription will not be created.
	// If this field is set but the broker's `allowAutoSubscriptionCreation`
	// is disabled, the producer will fail to be created.
	InitialSubscriptionName *string `protobuf:"bytes,13,opt,name=initial_subscription_name,json=initialSubscriptionName" json:"initial_subscription_name,omitempty"`
}

// Default values for CommandProducer fields.
const (
	Default_CommandProducer_Encrypted                = bool(false)
	Default_CommandProducer_Epoch                    = uint64(0)
	Default_CommandProducer_UserProvidedProducerName = bool(true)
	Default_CommandProducer_ProducerAccessMode       = ProducerAccessMode_Shared
	Default_CommandProducer_TxnEnabled               = bool(false)
)

func (x *CommandProducer) Reset() {
	*x = CommandProducer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandProducer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandProducer) ProtoMessage() {}

func (x *CommandProducer) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandProducer.ProtoReflect.Descriptor instead.
func (*CommandProducer) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{21}
}

func (x *CommandProducer) GetTopic() string {
	if x != nil && x.Topic != nil {
		return *x.Topic
	}
	return ""
}

func (x *CommandProducer) GetProducerId() uint64 {
	if x != nil && x.ProducerId != nil {
		return *x.ProducerId
	}
	return 0
}

func (x *CommandProducer) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandProducer) GetProducerName() string {
	if x != nil && x.ProducerName != nil {
		return *x.ProducerName
	}
	return ""
}

func (x *CommandProducer) GetEncrypted() bool {
	if x != nil && x.Encrypted != nil {
		return *x.Encrypted
	}
	return Default_CommandProducer_Encrypted
}

func (x *CommandProducer) GetMetadata() []*KeyValue {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *CommandProducer) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *CommandProducer) GetEpoch() uint64 {
	if x != nil && x.Epoch != nil {
		return *x.Epoch
	}
	return Default_CommandProducer_Epoch
}

func (x *CommandProducer) GetUserProvidedProducerName() bool {
	if x != nil && x.UserProvidedProducerName != nil {
		return *x.UserProvidedProducerName
	}
	return Default_CommandProducer_UserProvidedProducerName
}

func (x *CommandProducer) GetProducerAccessMode() ProducerAccessMode {
	if x != nil && x.ProducerAccessMode != nil {
		return *x.ProducerAccessMode
	}
	return Default_CommandProducer_ProducerAccessMode
}

func (x *CommandProducer) GetTopicEpoch() uint64 {
	if x != nil && x.TopicEpoch != nil {
		return *x.TopicEpoch
	}
	return 0
}

func (x *CommandProducer) GetTxnEnabled() bool {
	if x != nil && x.TxnEnabled != nil {
		return *x.TxnEnabled
	}
	return Default_CommandProducer_TxnEnabled
}

func (x *CommandProducer) GetInitialSubscriptionName() string {
	if x != nil && x.InitialSubscriptionName != nil {
		return *x.InitialSubscriptionName
	}
	return ""
}

type CommandSend struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProducerId     *uint64 `protobuf:"varint,1,req,name=producer_id,json=producerId" json:"producer_id,omitempty"`
	SequenceId     *uint64 `protobuf:"varint,2,req,name=sequence_id,json=sequenceId" json:"sequence_id,omitempty"`
	NumMessages    *int32  `protobuf:"varint,3,opt,name=num_messages,json=numMessages,def=1" json:"num_messages,omitempty"`
	TxnidLeastBits *uint64 `protobuf:"varint,4,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64 `protobuf:"varint,5,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	// / Add highest sequence id to support batch message with external sequence id
	HighestSequenceId *uint64 `protobuf:"varint,6,opt,name=highest_sequence_id,json=highestSequenceId,def=0" json:"highest_sequence_id,omitempty"`
	IsChunk           *bool   `protobuf:"varint,7,opt,name=is_chunk,json=isChunk,def=0" json:"is_chunk,omitempty"`
	// Specify if the message being published is a Pulsar marker or not
	Marker *bool `protobuf:"varint,8,opt,name=marker,def=0" json:"marker,omitempty"`
	// Message id of this message, currently is used in replicator for shadow topic.
	MessageId *MessageIdData `protobuf:"bytes,9,opt,name=message_id,json=messageId" json:"message_id,omitempty"`
}

// Default values for CommandSend fields.
const (
	Default_CommandSend_NumMessages       = int32(1)
	Default_CommandSend_TxnidLeastBits    = uint64(0)
	Default_CommandSend_TxnidMostBits     = uint64(0)
	Default_CommandSend_HighestSequenceId = uint64(0)
	Default_CommandSend_IsChunk           = bool(false)
	Default_CommandSend_Marker            = bool(false)
)

func (x *CommandSend) Reset() {
	*x = CommandSend{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandSend) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandSend) ProtoMessage() {}

func (x *CommandSend) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandSend.ProtoReflect.Descriptor instead.
func (*CommandSend) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{22}
}

func (x *CommandSend) GetProducerId() uint64 {
	if x != nil && x.ProducerId != nil {
		return *x.ProducerId
	}
	return 0
}

func (x *CommandSend) GetSequenceId() uint64 {
	if x != nil && x.SequenceId != nil {
		return *x.SequenceId
	}
	return 0
}

func (x *CommandSend) GetNumMessages() int32 {
	if x != nil && x.NumMessages != nil {
		return *x.NumMessages
	}
	return Default_CommandSend_NumMessages
}

func (x *CommandSend) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandSend_TxnidLeastBits
}

func (x *CommandSend) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandSend_TxnidMostBits
}

func (x *CommandSend) GetHighestSequenceId() uint64 {
	if x != nil && x.HighestSequenceId != nil {
		return *x.HighestSequenceId
	}
	return Default_CommandSend_HighestSequenceId
}

func (x *CommandSend) GetIsChunk() bool {
	if x != nil && x.IsChunk != nil {
		return *x.IsChunk
	}
	return Default_CommandSend_IsChunk
}

func (x *CommandSend) GetMarker() bool {
	if x != nil && x.Marker != nil {
		return *x.Marker
	}
	return Default_CommandSend_Marker
}

func (x *CommandSend) GetMessageId() *MessageIdData {
	if x != nil {
		return x.MessageId
	}
	return nil
}

type CommandSendReceipt struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProducerId        *uint64        `protobuf:"varint,1,req,name=producer_id,json=producerId" json:"producer_id,omitempty"`
	SequenceId        *uint64        `protobuf:"varint,2,req,name=sequence_id,json=sequenceId" json:"sequence_id,omitempty"`
	MessageId         *MessageIdData `protobuf:"bytes,3,opt,name=message_id,json=messageId" json:"message_id,omitempty"`
	HighestSequenceId *uint64        `protobuf:"varint,4,opt,name=highest_sequence_id,json=highestSequenceId,def=0" json:"highest_sequence_id,omitempty"`
}

// Default values for CommandSendReceipt fields.
const (
	Default_CommandSendReceipt_HighestSequenceId = uint64(0)
)

func (x *CommandSendReceipt) Reset() {
	*x = CommandSendReceipt{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandSendReceipt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandSendReceipt) ProtoMessage() {}

func (x *CommandSendReceipt) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandSendReceipt.ProtoReflect.Descriptor instead.
func (*CommandSendReceipt) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{23}
}

func (x *CommandSendReceipt) GetProducerId() uint64 {
	if x != nil && x.ProducerId != nil {
		return *x.ProducerId
	}
	return 0
}

func (x *CommandSendReceipt) GetSequenceId() uint64 {
	if x != nil && x.SequenceId != nil {
		return *x.SequenceId
	}
	return 0
}

func (x *CommandSendReceipt) GetMessageId() *MessageIdData {
	if x != nil {
		return x.MessageId
	}
	return nil
}

func (x *CommandSendReceipt) GetHighestSequenceId() uint64 {
	if x != nil && x.HighestSequenceId != nil {
		return *x.HighestSequenceId
	}
	return Default_CommandSendReceipt_HighestSequenceId
}

type CommandSendError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProducerId *uint64      `protobuf:"varint,1,req,name=producer_id,json=producerId" json:"producer_id,omitempty"`
	SequenceId *uint64      `protobuf:"varint,2,req,name=sequence_id,json=sequenceId" json:"sequence_id,omitempty"`
	Error      *ServerError `protobuf:"varint,3,req,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message    *string      `protobuf:"bytes,4,req,name=message" json:"message,omitempty"`
}

func (x *CommandSendError) Reset() {
	*x = CommandSendError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandSendError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandSendError) ProtoMessage() {}

func (x *CommandSendError) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandSendError.ProtoReflect.Descriptor instead.
func (*CommandSendError) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{24}
}

func (x *CommandSendError) GetProducerId() uint64 {
	if x != nil && x.ProducerId != nil {
		return *x.ProducerId
	}
	return 0
}

func (x *CommandSendError) GetSequenceId() uint64 {
	if x != nil && x.SequenceId != nil {
		return *x.SequenceId
	}
	return 0
}

func (x *CommandSendError) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandSendError) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

type CommandMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId      *uint64        `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	MessageId       *MessageIdData `protobuf:"bytes,2,req,name=message_id,json=messageId" json:"message_id,omitempty"`
	RedeliveryCount *uint32        `protobuf:"varint,3,opt,name=redelivery_count,json=redeliveryCount,def=0" json:"redelivery_count,omitempty"`
	AckSet          []int64        `protobuf:"varint,4,rep,name=ack_set,json=ackSet" json:"ack_set,omitempty"`
	ConsumerEpoch   *uint64        `protobuf:"varint,5,opt,name=consumer_epoch,json=consumerEpoch" json:"consumer_epoch,omitempty"`
}

// Default values for CommandMessage fields.
const (
	Default_CommandMessage_RedeliveryCount = uint32(0)
)

func (x *CommandMessage) Reset() {
	*x = CommandMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandMessage) ProtoMessage() {}

func (x *CommandMessage) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandMessage.ProtoReflect.Descriptor instead.
func (*CommandMessage) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{25}
}

func (x *CommandMessage) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandMessage) GetMessageId() *MessageIdData {
	if x != nil {
		return x.MessageId
	}
	return nil
}

func (x *CommandMessage) GetRedeliveryCount() uint32 {
	if x != nil && x.RedeliveryCount != nil {
		return *x.RedeliveryCount
	}
	return Default_CommandMessage_RedeliveryCount
}

func (x *CommandMessage) GetAckSet() []int64 {
	if x != nil {
		return x.AckSet
	}
	return nil
}

func (x *CommandMessage) GetConsumerEpoch() uint64 {
	if x != nil && x.ConsumerEpoch != nil {
		return *x.ConsumerEpoch
	}
	return 0
}

type CommandAck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId *uint64             `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	AckType    *CommandAck_AckType `protobuf:"varint,2,req,name=ack_type,json=ackType,enum=pulsar.proto.CommandAck_AckType" json:"ack_type,omitempty"`
	// In case of individual acks, the client can pass a list of message ids
	MessageId       []*MessageIdData            `protobuf:"bytes,3,rep,name=message_id,json=messageId" json:"message_id,omitempty"`
	ValidationError *CommandAck_ValidationError `protobuf:"varint,4,opt,name=validation_error,json=validationError,enum=pulsar.proto.CommandAck_ValidationError" json:"validation_error,omitempty"`
	Properties      []*KeyLongValue             `protobuf:"bytes,5,rep,name=properties" json:"properties,omitempty"`
	TxnidLeastBits  *uint64                     `protobuf:"varint,6,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits   *uint64                     `protobuf:"varint,7,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	RequestId       *uint64                     `protobuf:"varint,8,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
}

// Default values for CommandAck fields.
const (
	Default_CommandAck_TxnidLeastBits = uint64(0)
	Default_CommandAck_TxnidMostBits  = uint64(0)
)

func (x *CommandAck) Reset() {
	*x = CommandAck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandAck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandAck) ProtoMessage() {}

func (x *CommandAck) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandAck.ProtoReflect.Descriptor instead.
func (*CommandAck) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{26}
}

func (x *CommandAck) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandAck) GetAckType() CommandAck_AckType {
	if x != nil && x.AckType != nil {
		return *x.AckType
	}
	return CommandAck_Individual
}

func (x *CommandAck) GetMessageId() []*MessageIdData {
	if x != nil {
		return x.MessageId
	}
	return nil
}

func (x *CommandAck) GetValidationError() CommandAck_ValidationError {
	if x != nil && x.ValidationError != nil {
		return *x.ValidationError
	}
	return CommandAck_UncompressedSizeCorruption
}

func (x *CommandAck) GetProperties() []*KeyLongValue {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *CommandAck) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandAck_TxnidLeastBits
}

func (x *CommandAck) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandAck_TxnidMostBits
}

func (x *CommandAck) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

type CommandAckResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId     *uint64      `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	TxnidLeastBits *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Error          *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message        *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	RequestId      *uint64      `protobuf:"varint,6,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
}

// Default values for CommandAckResponse fields.
const (
	Default_CommandAckResponse_TxnidLeastBits = uint64(0)
	Default_CommandAckResponse_TxnidMostBits  = uint64(0)
)

func (x *CommandAckResponse) Reset() {
	*x = CommandAckResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandAckResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandAckResponse) ProtoMessage() {}

func (x *CommandAckResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandAckResponse.ProtoReflect.Descriptor instead.
func (*CommandAckResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{27}
}

func (x *CommandAckResponse) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandAckResponse) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandAckResponse_TxnidLeastBits
}

func (x *CommandAckResponse) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandAckResponse_TxnidMostBits
}

func (x *CommandAckResponse) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandAckResponse) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

func (x *CommandAckResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

// changes on active consumer
type CommandActiveConsumerChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId *uint64 `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	IsActive   *bool   `protobuf:"varint,2,opt,name=is_active,json=isActive,def=0" json:"is_active,omitempty"`
}

// Default values for CommandActiveConsumerChange fields.
const (
	Default_CommandActiveConsumerChange_IsActive = bool(false)
)

func (x *CommandActiveConsumerChange) Reset() {
	*x = CommandActiveConsumerChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandActiveConsumerChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandActiveConsumerChange) ProtoMessage() {}

func (x *CommandActiveConsumerChange) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandActiveConsumerChange.ProtoReflect.Descriptor instead.
func (*CommandActiveConsumerChange) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{28}
}

func (x *CommandActiveConsumerChange) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandActiveConsumerChange) GetIsActive() bool {
	if x != nil && x.IsActive != nil {
		return *x.IsActive
	}
	return Default_CommandActiveConsumerChange_IsActive
}

type CommandFlow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId *uint64 `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	// Max number of messages to prefetch, in addition
	// of any number previously specified
	MessagePermits *uint32 `protobuf:"varint,2,req,name=messagePermits" json:"messagePermits,omitempty"`
}

func (x *CommandFlow) Reset() {
	*x = CommandFlow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandFlow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandFlow) ProtoMessage() {}

func (x *CommandFlow) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandFlow.ProtoReflect.Descriptor instead.
func (*CommandFlow) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{29}
}

func (x *CommandFlow) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandFlow) GetMessagePermits() uint32 {
	if x != nil && x.MessagePermits != nil {
		return *x.MessagePermits
	}
	return 0
}

type CommandUnsubscribe struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId *uint64 `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	RequestId  *uint64 `protobuf:"varint,2,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Force      *bool   `protobuf:"varint,3,opt,name=force,def=0" json:"force,omitempty"`
}

// Default values for CommandUnsubscribe fields.
const (
	Default_CommandUnsubscribe_Force = bool(false)
)

func (x *CommandUnsubscribe) Reset() {
	*x = CommandUnsubscribe{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandUnsubscribe) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandUnsubscribe) ProtoMessage() {}

func (x *CommandUnsubscribe) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandUnsubscribe.ProtoReflect.Descriptor instead.
func (*CommandUnsubscribe) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{30}
}

func (x *CommandUnsubscribe) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandUnsubscribe) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandUnsubscribe) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return Default_CommandUnsubscribe_Force
}

// Reset an existing consumer to a particular message id
type CommandSeek struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId         *uint64        `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	RequestId          *uint64        `protobuf:"varint,2,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	MessageId          *MessageIdData `protobuf:"bytes,3,opt,name=message_id,json=messageId" json:"message_id,omitempty"`
	MessagePublishTime *uint64        `protobuf:"varint,4,opt,name=message_publish_time,json=messagePublishTime" json:"message_publish_time,omitempty"`
}

func (x *CommandSeek) Reset() {
	*x = CommandSeek{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandSeek) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandSeek) ProtoMessage() {}

func (x *CommandSeek) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandSeek.ProtoReflect.Descriptor instead.
func (*CommandSeek) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{31}
}

func (x *CommandSeek) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandSeek) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandSeek) GetMessageId() *MessageIdData {
	if x != nil {
		return x.MessageId
	}
	return nil
}

func (x *CommandSeek) GetMessagePublishTime() uint64 {
	if x != nil && x.MessagePublishTime != nil {
		return *x.MessagePublishTime
	}
	return 0
}

// Message sent by broker to client when a topic
// has been forcefully terminated and there are no more
// messages left to consume
type CommandReachedEndOfTopic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId *uint64 `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
}

func (x *CommandReachedEndOfTopic) Reset() {
	*x = CommandReachedEndOfTopic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandReachedEndOfTopic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandReachedEndOfTopic) ProtoMessage() {}

func (x *CommandReachedEndOfTopic) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandReachedEndOfTopic.ProtoReflect.Descriptor instead.
func (*CommandReachedEndOfTopic) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{32}
}

func (x *CommandReachedEndOfTopic) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

type CommandTopicMigrated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ResourceId          *uint64                            `protobuf:"varint,1,req,name=resource_id,json=resourceId" json:"resource_id,omitempty"`
	ResourceType        *CommandTopicMigrated_ResourceType `protobuf:"varint,2,req,name=resource_type,json=resourceType,enum=pulsar.proto.CommandTopicMigrated_ResourceType" json:"resource_type,omitempty"`
	BrokerServiceUrl    *string                            `protobuf:"bytes,3,opt,name=brokerServiceUrl" json:"brokerServiceUrl,omitempty"`
	BrokerServiceUrlTls *string                            `protobuf:"bytes,4,opt,name=brokerServiceUrlTls" json:"brokerServiceUrlTls,omitempty"`
}

func (x *CommandTopicMigrated) Reset() {
	*x = CommandTopicMigrated{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandTopicMigrated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandTopicMigrated) ProtoMessage() {}

func (x *CommandTopicMigrated) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandTopicMigrated.ProtoReflect.Descriptor instead.
func (*CommandTopicMigrated) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{33}
}

func (x *CommandTopicMigrated) GetResourceId() uint64 {
	if x != nil && x.ResourceId != nil {
		return *x.ResourceId
	}
	return 0
}

func (x *CommandTopicMigrated) GetResourceType() CommandTopicMigrated_ResourceType {
	if x != nil && x.ResourceType != nil {
		return *x.ResourceType
	}
	return CommandTopicMigrated_Producer
}

func (x *CommandTopicMigrated) GetBrokerServiceUrl() string {
	if x != nil && x.BrokerServiceUrl != nil {
		return *x.BrokerServiceUrl
	}
	return ""
}

func (x *CommandTopicMigrated) GetBrokerServiceUrlTls() string {
	if x != nil && x.BrokerServiceUrlTls != nil {
		return *x.BrokerServiceUrlTls
	}
	return ""
}

type CommandCloseProducer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProducerId                  *uint64 `protobuf:"varint,1,req,name=producer_id,json=producerId" json:"producer_id,omitempty"`
	RequestId                   *uint64 `protobuf:"varint,2,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	AssignedBrokerServiceUrl    *string `protobuf:"bytes,3,opt,name=assignedBrokerServiceUrl" json:"assignedBrokerServiceUrl,omitempty"`
	AssignedBrokerServiceUrlTls *string `protobuf:"bytes,4,opt,name=assignedBrokerServiceUrlTls" json:"assignedBrokerServiceUrlTls,omitempty"`
}

func (x *CommandCloseProducer) Reset() {
	*x = CommandCloseProducer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandCloseProducer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandCloseProducer) ProtoMessage() {}

func (x *CommandCloseProducer) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandCloseProducer.ProtoReflect.Descriptor instead.
func (*CommandCloseProducer) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{34}
}

func (x *CommandCloseProducer) GetProducerId() uint64 {
	if x != nil && x.ProducerId != nil {
		return *x.ProducerId
	}
	return 0
}

func (x *CommandCloseProducer) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandCloseProducer) GetAssignedBrokerServiceUrl() string {
	if x != nil && x.AssignedBrokerServiceUrl != nil {
		return *x.AssignedBrokerServiceUrl
	}
	return ""
}

func (x *CommandCloseProducer) GetAssignedBrokerServiceUrlTls() string {
	if x != nil && x.AssignedBrokerServiceUrlTls != nil {
		return *x.AssignedBrokerServiceUrlTls
	}
	return ""
}

type CommandCloseConsumer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId                  *uint64 `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	RequestId                   *uint64 `protobuf:"varint,2,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	AssignedBrokerServiceUrl    *string `protobuf:"bytes,3,opt,name=assignedBrokerServiceUrl" json:"assignedBrokerServiceUrl,omitempty"`
	AssignedBrokerServiceUrlTls *string `protobuf:"bytes,4,opt,name=assignedBrokerServiceUrlTls" json:"assignedBrokerServiceUrlTls,omitempty"`
}

func (x *CommandCloseConsumer) Reset() {
	*x = CommandCloseConsumer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandCloseConsumer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandCloseConsumer) ProtoMessage() {}

func (x *CommandCloseConsumer) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandCloseConsumer.ProtoReflect.Descriptor instead.
func (*CommandCloseConsumer) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{35}
}

func (x *CommandCloseConsumer) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandCloseConsumer) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandCloseConsumer) GetAssignedBrokerServiceUrl() string {
	if x != nil && x.AssignedBrokerServiceUrl != nil {
		return *x.AssignedBrokerServiceUrl
	}
	return ""
}

func (x *CommandCloseConsumer) GetAssignedBrokerServiceUrlTls() string {
	if x != nil && x.AssignedBrokerServiceUrlTls != nil {
		return *x.AssignedBrokerServiceUrlTls
	}
	return ""
}

type CommandRedeliverUnacknowledgedMessages struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId    *uint64          `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	MessageIds    []*MessageIdData `protobuf:"bytes,2,rep,name=message_ids,json=messageIds" json:"message_ids,omitempty"`
	ConsumerEpoch *uint64          `protobuf:"varint,3,opt,name=consumer_epoch,json=consumerEpoch" json:"consumer_epoch,omitempty"`
}

func (x *CommandRedeliverUnacknowledgedMessages) Reset() {
	*x = CommandRedeliverUnacknowledgedMessages{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandRedeliverUnacknowledgedMessages) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandRedeliverUnacknowledgedMessages) ProtoMessage() {}

func (x *CommandRedeliverUnacknowledgedMessages) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandRedeliverUnacknowledgedMessages.ProtoReflect.Descriptor instead.
func (*CommandRedeliverUnacknowledgedMessages) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{36}
}

func (x *CommandRedeliverUnacknowledgedMessages) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandRedeliverUnacknowledgedMessages) GetMessageIds() []*MessageIdData {
	if x != nil {
		return x.MessageIds
	}
	return nil
}

func (x *CommandRedeliverUnacknowledgedMessages) GetConsumerEpoch() uint64 {
	if x != nil && x.ConsumerEpoch != nil {
		return *x.ConsumerEpoch
	}
	return 0
}

type CommandSuccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId *uint64 `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Schema    *Schema `protobuf:"bytes,2,opt,name=schema" json:"schema,omitempty"`
}

func (x *CommandSuccess) Reset() {
	*x = CommandSuccess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandSuccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandSuccess) ProtoMessage() {}

func (x *CommandSuccess) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandSuccess.ProtoReflect.Descriptor instead.
func (*CommandSuccess) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{37}
}

func (x *CommandSuccess) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandSuccess) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

// / Response from CommandProducer
type CommandProducerSuccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId    *uint64 `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	ProducerName *string `protobuf:"bytes,2,req,name=producer_name,json=producerName" json:"producer_name,omitempty"`
	// The last sequence id that was stored by this producer in the previous session
	// This will only be meaningful if deduplication has been enabled.
	LastSequenceId *int64 `protobuf:"varint,3,opt,name=last_sequence_id,json=lastSequenceId,def=-1" json:"last_sequence_id,omitempty"`
	SchemaVersion  []byte `protobuf:"bytes,4,opt,name=schema_version,json=schemaVersion" json:"schema_version,omitempty"`
	// The topic epoch assigned by the broker. This field will only be set if we
	// were requiring exclusive access when creating the producer.
	TopicEpoch *uint64 `protobuf:"varint,5,opt,name=topic_epoch,json=topicEpoch" json:"topic_epoch,omitempty"`
	// If producer is not "ready", the client will avoid to timeout the request
	// for creating the producer. Instead it will wait indefinitely until it gets
	// a subsequent  `CommandProducerSuccess` with `producer_ready==true`.
	ProducerReady *bool `protobuf:"varint,6,opt,name=producer_ready,json=producerReady,def=1" json:"producer_ready,omitempty"`
}

// Default values for CommandProducerSuccess fields.
const (
	Default_CommandProducerSuccess_LastSequenceId = int64(-1)
	Default_CommandProducerSuccess_ProducerReady  = bool(true)
)

func (x *CommandProducerSuccess) Reset() {
	*x = CommandProducerSuccess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandProducerSuccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandProducerSuccess) ProtoMessage() {}

func (x *CommandProducerSuccess) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandProducerSuccess.ProtoReflect.Descriptor instead.
func (*CommandProducerSuccess) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{38}
}

func (x *CommandProducerSuccess) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandProducerSuccess) GetProducerName() string {
	if x != nil && x.ProducerName != nil {
		return *x.ProducerName
	}
	return ""
}

func (x *CommandProducerSuccess) GetLastSequenceId() int64 {
	if x != nil && x.LastSequenceId != nil {
		return *x.LastSequenceId
	}
	return Default_CommandProducerSuccess_LastSequenceId
}

func (x *CommandProducerSuccess) GetSchemaVersion() []byte {
	if x != nil {
		return x.SchemaVersion
	}
	return nil
}

func (x *CommandProducerSuccess) GetTopicEpoch() uint64 {
	if x != nil && x.TopicEpoch != nil {
		return *x.TopicEpoch
	}
	return 0
}

func (x *CommandProducerSuccess) GetProducerReady() bool {
	if x != nil && x.ProducerReady != nil {
		return *x.ProducerReady
	}
	return Default_CommandProducerSuccess_ProducerReady
}

type CommandError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Error     *ServerError `protobuf:"varint,2,req,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message   *string      `protobuf:"bytes,3,req,name=message" json:"message,omitempty"`
}

func (x *CommandError) Reset() {
	*x = CommandError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandError) ProtoMessage() {}

func (x *CommandError) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandError.ProtoReflect.Descriptor instead.
func (*CommandError) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{39}
}

func (x *CommandError) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandError) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandError) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

// Commands to probe the state of connection.
// When either client or broker doesn't receive commands for certain
// amount of time, they will send a Ping probe.
type CommandPing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CommandPing) Reset() {
	*x = CommandPing{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandPing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandPing) ProtoMessage() {}

func (x *CommandPing) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandPing.ProtoReflect.Descriptor instead.
func (*CommandPing) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{40}
}

type CommandPong struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CommandPong) Reset() {
	*x = CommandPong{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandPong) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandPong) ProtoMessage() {}

func (x *CommandPong) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandPong.ProtoReflect.Descriptor instead.
func (*CommandPong) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{41}
}

type CommandConsumerStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId *uint64 `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	// required string topic_name         = 2;
	// required string subscription_name  = 3;
	ConsumerId *uint64 `protobuf:"varint,4,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
}

func (x *CommandConsumerStats) Reset() {
	*x = CommandConsumerStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandConsumerStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandConsumerStats) ProtoMessage() {}

func (x *CommandConsumerStats) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandConsumerStats.ProtoReflect.Descriptor instead.
func (*CommandConsumerStats) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{42}
}

func (x *CommandConsumerStats) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandConsumerStats) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

type CommandConsumerStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId    *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	ErrorCode    *ServerError `protobuf:"varint,2,opt,name=error_code,json=errorCode,enum=pulsar.proto.ServerError" json:"error_code,omitempty"`
	ErrorMessage *string      `protobuf:"bytes,3,opt,name=error_message,json=errorMessage" json:"error_message,omitempty"`
	// / Total rate of messages delivered to the consumer. msg/s
	MsgRateOut *float64 `protobuf:"fixed64,4,opt,name=msgRateOut" json:"msgRateOut,omitempty"`
	// / Total throughput delivered to the consumer. bytes/s
	MsgThroughputOut *float64 `protobuf:"fixed64,5,opt,name=msgThroughputOut" json:"msgThroughputOut,omitempty"`
	// / Total rate of messages redelivered by this consumer. msg/s
	MsgRateRedeliver *float64 `protobuf:"fixed64,6,opt,name=msgRateRedeliver" json:"msgRateRedeliver,omitempty"`
	// / Name of the consumer
	ConsumerName *string `protobuf:"bytes,7,opt,name=consumerName" json:"consumerName,omitempty"`
	// / Number of available message permits for the consumer
	AvailablePermits *uint64 `protobuf:"varint,8,opt,name=availablePermits" json:"availablePermits,omitempty"`
	// / Number of unacknowledged messages for the consumer
	UnackedMessages *uint64 `protobuf:"varint,9,opt,name=unackedMessages" json:"unackedMessages,omitempty"`
	// / Flag to verify if consumer is blocked due to reaching threshold of unacked messages
	BlockedConsumerOnUnackedMsgs *bool `protobuf:"varint,10,opt,name=blockedConsumerOnUnackedMsgs" json:"blockedConsumerOnUnackedMsgs,omitempty"`
	// / Address of this consumer
	Address *string `protobuf:"bytes,11,opt,name=address" json:"address,omitempty"`
	// / Timestamp of connection
	ConnectedSince *string `protobuf:"bytes,12,opt,name=connectedSince" json:"connectedSince,omitempty"`
	// / Whether this subscription is Exclusive or Shared or Failover
	Type *string `protobuf:"bytes,13,opt,name=type" json:"type,omitempty"`
	// / Total rate of messages expired on this subscription. msg/s
	MsgRateExpired *float64 `protobuf:"fixed64,14,opt,name=msgRateExpired" json:"msgRateExpired,omitempty"`
	// / Number of messages in the subscription backlog
	MsgBacklog *uint64 `protobuf:"varint,15,opt,name=msgBacklog" json:"msgBacklog,omitempty"`
	// / Total rate of messages ack. msg/s
	MessageAckRate *float64 `protobuf:"fixed64,16,opt,name=messageAckRate" json:"messageAckRate,omitempty"`
}

func (x *CommandConsumerStatsResponse) Reset() {
	*x = CommandConsumerStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandConsumerStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandConsumerStatsResponse) ProtoMessage() {}

func (x *CommandConsumerStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandConsumerStatsResponse.ProtoReflect.Descriptor instead.
func (*CommandConsumerStatsResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{43}
}

func (x *CommandConsumerStatsResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandConsumerStatsResponse) GetErrorCode() ServerError {
	if x != nil && x.ErrorCode != nil {
		return *x.ErrorCode
	}
	return ServerError_UnknownError
}

func (x *CommandConsumerStatsResponse) GetErrorMessage() string {
	if x != nil && x.ErrorMessage != nil {
		return *x.ErrorMessage
	}
	return ""
}

func (x *CommandConsumerStatsResponse) GetMsgRateOut() float64 {
	if x != nil && x.MsgRateOut != nil {
		return *x.MsgRateOut
	}
	return 0
}

func (x *CommandConsumerStatsResponse) GetMsgThroughputOut() float64 {
	if x != nil && x.MsgThroughputOut != nil {
		return *x.MsgThroughputOut
	}
	return 0
}

func (x *CommandConsumerStatsResponse) GetMsgRateRedeliver() float64 {
	if x != nil && x.MsgRateRedeliver != nil {
		return *x.MsgRateRedeliver
	}
	return 0
}

func (x *CommandConsumerStatsResponse) GetConsumerName() string {
	if x != nil && x.ConsumerName != nil {
		return *x.ConsumerName
	}
	return ""
}

func (x *CommandConsumerStatsResponse) GetAvailablePermits() uint64 {
	if x != nil && x.AvailablePermits != nil {
		return *x.AvailablePermits
	}
	return 0
}

func (x *CommandConsumerStatsResponse) GetUnackedMessages() uint64 {
	if x != nil && x.UnackedMessages != nil {
		return *x.UnackedMessages
	}
	return 0
}

func (x *CommandConsumerStatsResponse) GetBlockedConsumerOnUnackedMsgs() bool {
	if x != nil && x.BlockedConsumerOnUnackedMsgs != nil {
		return *x.BlockedConsumerOnUnackedMsgs
	}
	return false
}

func (x *CommandConsumerStatsResponse) GetAddress() string {
	if x != nil && x.Address != nil {
		return *x.Address
	}
	return ""
}

func (x *CommandConsumerStatsResponse) GetConnectedSince() string {
	if x != nil && x.ConnectedSince != nil {
		return *x.ConnectedSince
	}
	return ""
}

func (x *CommandConsumerStatsResponse) GetType() string {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return ""
}

func (x *CommandConsumerStatsResponse) GetMsgRateExpired() float64 {
	if x != nil && x.MsgRateExpired != nil {
		return *x.MsgRateExpired
	}
	return 0
}

func (x *CommandConsumerStatsResponse) GetMsgBacklog() uint64 {
	if x != nil && x.MsgBacklog != nil {
		return *x.MsgBacklog
	}
	return 0
}

func (x *CommandConsumerStatsResponse) GetMessageAckRate() float64 {
	if x != nil && x.MessageAckRate != nil {
		return *x.MessageAckRate
	}
	return 0
}

type CommandGetLastMessageId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConsumerId *uint64 `protobuf:"varint,1,req,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	RequestId  *uint64 `protobuf:"varint,2,req,name=request_id,json=requestId" json:"request_id,omitempty"`
}

func (x *CommandGetLastMessageId) Reset() {
	*x = CommandGetLastMessageId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetLastMessageId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetLastMessageId) ProtoMessage() {}

func (x *CommandGetLastMessageId) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetLastMessageId.ProtoReflect.Descriptor instead.
func (*CommandGetLastMessageId) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{44}
}

func (x *CommandGetLastMessageId) GetConsumerId() uint64 {
	if x != nil && x.ConsumerId != nil {
		return *x.ConsumerId
	}
	return 0
}

func (x *CommandGetLastMessageId) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

type CommandGetLastMessageIdResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LastMessageId              *MessageIdData `protobuf:"bytes,1,req,name=last_message_id,json=lastMessageId" json:"last_message_id,omitempty"`
	RequestId                  *uint64        `protobuf:"varint,2,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	ConsumerMarkDeletePosition *MessageIdData `protobuf:"bytes,3,opt,name=consumer_mark_delete_position,json=consumerMarkDeletePosition" json:"consumer_mark_delete_position,omitempty"`
}

func (x *CommandGetLastMessageIdResponse) Reset() {
	*x = CommandGetLastMessageIdResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetLastMessageIdResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetLastMessageIdResponse) ProtoMessage() {}

func (x *CommandGetLastMessageIdResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetLastMessageIdResponse.ProtoReflect.Descriptor instead.
func (*CommandGetLastMessageIdResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{45}
}

func (x *CommandGetLastMessageIdResponse) GetLastMessageId() *MessageIdData {
	if x != nil {
		return x.LastMessageId
	}
	return nil
}

func (x *CommandGetLastMessageIdResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandGetLastMessageIdResponse) GetConsumerMarkDeletePosition() *MessageIdData {
	if x != nil {
		return x.ConsumerMarkDeletePosition
	}
	return nil
}

type CommandGetTopicsOfNamespace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId     *uint64                           `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Namespace     *string                           `protobuf:"bytes,2,req,name=namespace" json:"namespace,omitempty"`
	Mode          *CommandGetTopicsOfNamespace_Mode `protobuf:"varint,3,opt,name=mode,enum=pulsar.proto.CommandGetTopicsOfNamespace_Mode,def=0" json:"mode,omitempty"`
	TopicsPattern *string                           `protobuf:"bytes,4,opt,name=topics_pattern,json=topicsPattern" json:"topics_pattern,omitempty"`
	TopicsHash    *string                           `protobuf:"bytes,5,opt,name=topics_hash,json=topicsHash" json:"topics_hash,omitempty"`
}

// Default values for CommandGetTopicsOfNamespace fields.
const (
	Default_CommandGetTopicsOfNamespace_Mode = CommandGetTopicsOfNamespace_PERSISTENT
)

func (x *CommandGetTopicsOfNamespace) Reset() {
	*x = CommandGetTopicsOfNamespace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetTopicsOfNamespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetTopicsOfNamespace) ProtoMessage() {}

func (x *CommandGetTopicsOfNamespace) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetTopicsOfNamespace.ProtoReflect.Descriptor instead.
func (*CommandGetTopicsOfNamespace) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{46}
}

func (x *CommandGetTopicsOfNamespace) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandGetTopicsOfNamespace) GetNamespace() string {
	if x != nil && x.Namespace != nil {
		return *x.Namespace
	}
	return ""
}

func (x *CommandGetTopicsOfNamespace) GetMode() CommandGetTopicsOfNamespace_Mode {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return Default_CommandGetTopicsOfNamespace_Mode
}

func (x *CommandGetTopicsOfNamespace) GetTopicsPattern() string {
	if x != nil && x.TopicsPattern != nil {
		return *x.TopicsPattern
	}
	return ""
}

func (x *CommandGetTopicsOfNamespace) GetTopicsHash() string {
	if x != nil && x.TopicsHash != nil {
		return *x.TopicsHash
	}
	return ""
}

type CommandGetTopicsOfNamespaceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId *uint64  `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Topics    []string `protobuf:"bytes,2,rep,name=topics" json:"topics,omitempty"`
	// true iff the topic list was filtered by the pattern supplied by the client
	Filtered *bool `protobuf:"varint,3,opt,name=filtered,def=0" json:"filtered,omitempty"`
	// hash computed from the names of matching topics
	TopicsHash *string `protobuf:"bytes,4,opt,name=topics_hash,json=topicsHash" json:"topics_hash,omitempty"`
	// if false, topics is empty and the list of matching topics has not changed
	Changed *bool `protobuf:"varint,5,opt,name=changed,def=1" json:"changed,omitempty"`
}

// Default values for CommandGetTopicsOfNamespaceResponse fields.
const (
	Default_CommandGetTopicsOfNamespaceResponse_Filtered = bool(false)
	Default_CommandGetTopicsOfNamespaceResponse_Changed  = bool(true)
)

func (x *CommandGetTopicsOfNamespaceResponse) Reset() {
	*x = CommandGetTopicsOfNamespaceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetTopicsOfNamespaceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetTopicsOfNamespaceResponse) ProtoMessage() {}

func (x *CommandGetTopicsOfNamespaceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetTopicsOfNamespaceResponse.ProtoReflect.Descriptor instead.
func (*CommandGetTopicsOfNamespaceResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{47}
}

func (x *CommandGetTopicsOfNamespaceResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandGetTopicsOfNamespaceResponse) GetTopics() []string {
	if x != nil {
		return x.Topics
	}
	return nil
}

func (x *CommandGetTopicsOfNamespaceResponse) GetFiltered() bool {
	if x != nil && x.Filtered != nil {
		return *x.Filtered
	}
	return Default_CommandGetTopicsOfNamespaceResponse_Filtered
}

func (x *CommandGetTopicsOfNamespaceResponse) GetTopicsHash() string {
	if x != nil && x.TopicsHash != nil {
		return *x.TopicsHash
	}
	return ""
}

func (x *CommandGetTopicsOfNamespaceResponse) GetChanged() bool {
	if x != nil && x.Changed != nil {
		return *x.Changed
	}
	return Default_CommandGetTopicsOfNamespaceResponse_Changed
}

type CommandWatchTopicList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId     *uint64 `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	WatcherId     *uint64 `protobuf:"varint,2,req,name=watcher_id,json=watcherId" json:"watcher_id,omitempty"`
	Namespace     *string `protobuf:"bytes,3,req,name=namespace" json:"namespace,omitempty"`
	TopicsPattern *string `protobuf:"bytes,4,req,name=topics_pattern,json=topicsPattern" json:"topics_pattern,omitempty"`
	// Only present when the client reconnects:
	TopicsHash *string `protobuf:"bytes,5,opt,name=topics_hash,json=topicsHash" json:"topics_hash,omitempty"`
}

func (x *CommandWatchTopicList) Reset() {
	*x = CommandWatchTopicList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandWatchTopicList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandWatchTopicList) ProtoMessage() {}

func (x *CommandWatchTopicList) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandWatchTopicList.ProtoReflect.Descriptor instead.
func (*CommandWatchTopicList) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{48}
}

func (x *CommandWatchTopicList) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandWatchTopicList) GetWatcherId() uint64 {
	if x != nil && x.WatcherId != nil {
		return *x.WatcherId
	}
	return 0
}

func (x *CommandWatchTopicList) GetNamespace() string {
	if x != nil && x.Namespace != nil {
		return *x.Namespace
	}
	return ""
}

func (x *CommandWatchTopicList) GetTopicsPattern() string {
	if x != nil && x.TopicsPattern != nil {
		return *x.TopicsPattern
	}
	return ""
}

func (x *CommandWatchTopicList) GetTopicsHash() string {
	if x != nil && x.TopicsHash != nil {
		return *x.TopicsHash
	}
	return ""
}

type CommandWatchTopicListSuccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId  *uint64  `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	WatcherId  *uint64  `protobuf:"varint,2,req,name=watcher_id,json=watcherId" json:"watcher_id,omitempty"`
	Topic      []string `protobuf:"bytes,3,rep,name=topic" json:"topic,omitempty"`
	TopicsHash *string  `protobuf:"bytes,4,req,name=topics_hash,json=topicsHash" json:"topics_hash,omitempty"`
}

func (x *CommandWatchTopicListSuccess) Reset() {
	*x = CommandWatchTopicListSuccess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandWatchTopicListSuccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandWatchTopicListSuccess) ProtoMessage() {}

func (x *CommandWatchTopicListSuccess) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandWatchTopicListSuccess.ProtoReflect.Descriptor instead.
func (*CommandWatchTopicListSuccess) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{49}
}

func (x *CommandWatchTopicListSuccess) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandWatchTopicListSuccess) GetWatcherId() uint64 {
	if x != nil && x.WatcherId != nil {
		return *x.WatcherId
	}
	return 0
}

func (x *CommandWatchTopicListSuccess) GetTopic() []string {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *CommandWatchTopicListSuccess) GetTopicsHash() string {
	if x != nil && x.TopicsHash != nil {
		return *x.TopicsHash
	}
	return ""
}

type CommandWatchTopicUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	WatcherId     *uint64  `protobuf:"varint,1,req,name=watcher_id,json=watcherId" json:"watcher_id,omitempty"`
	NewTopics     []string `protobuf:"bytes,2,rep,name=new_topics,json=newTopics" json:"new_topics,omitempty"`
	DeletedTopics []string `protobuf:"bytes,3,rep,name=deleted_topics,json=deletedTopics" json:"deleted_topics,omitempty"`
	TopicsHash    *string  `protobuf:"bytes,4,req,name=topics_hash,json=topicsHash" json:"topics_hash,omitempty"`
}

func (x *CommandWatchTopicUpdate) Reset() {
	*x = CommandWatchTopicUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandWatchTopicUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandWatchTopicUpdate) ProtoMessage() {}

func (x *CommandWatchTopicUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandWatchTopicUpdate.ProtoReflect.Descriptor instead.
func (*CommandWatchTopicUpdate) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{50}
}

func (x *CommandWatchTopicUpdate) GetWatcherId() uint64 {
	if x != nil && x.WatcherId != nil {
		return *x.WatcherId
	}
	return 0
}

func (x *CommandWatchTopicUpdate) GetNewTopics() []string {
	if x != nil {
		return x.NewTopics
	}
	return nil
}

func (x *CommandWatchTopicUpdate) GetDeletedTopics() []string {
	if x != nil {
		return x.DeletedTopics
	}
	return nil
}

func (x *CommandWatchTopicUpdate) GetTopicsHash() string {
	if x != nil && x.TopicsHash != nil {
		return *x.TopicsHash
	}
	return ""
}

type CommandWatchTopicListClose struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId *uint64 `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	WatcherId *uint64 `protobuf:"varint,2,req,name=watcher_id,json=watcherId" json:"watcher_id,omitempty"`
}

func (x *CommandWatchTopicListClose) Reset() {
	*x = CommandWatchTopicListClose{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandWatchTopicListClose) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandWatchTopicListClose) ProtoMessage() {}

func (x *CommandWatchTopicListClose) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandWatchTopicListClose.ProtoReflect.Descriptor instead.
func (*CommandWatchTopicListClose) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{51}
}

func (x *CommandWatchTopicListClose) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandWatchTopicListClose) GetWatcherId() uint64 {
	if x != nil && x.WatcherId != nil {
		return *x.WatcherId
	}
	return 0
}

type CommandGetSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId     *uint64 `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Topic         *string `protobuf:"bytes,2,req,name=topic" json:"topic,omitempty"`
	SchemaVersion []byte  `protobuf:"bytes,3,opt,name=schema_version,json=schemaVersion" json:"schema_version,omitempty"`
}

func (x *CommandGetSchema) Reset() {
	*x = CommandGetSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetSchema) ProtoMessage() {}

func (x *CommandGetSchema) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetSchema.ProtoReflect.Descriptor instead.
func (*CommandGetSchema) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{52}
}

func (x *CommandGetSchema) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandGetSchema) GetTopic() string {
	if x != nil && x.Topic != nil {
		return *x.Topic
	}
	return ""
}

func (x *CommandGetSchema) GetSchemaVersion() []byte {
	if x != nil {
		return x.SchemaVersion
	}
	return nil
}

type CommandGetSchemaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId     *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	ErrorCode     *ServerError `protobuf:"varint,2,opt,name=error_code,json=errorCode,enum=pulsar.proto.ServerError" json:"error_code,omitempty"`
	ErrorMessage  *string      `protobuf:"bytes,3,opt,name=error_message,json=errorMessage" json:"error_message,omitempty"`
	Schema        *Schema      `protobuf:"bytes,4,opt,name=schema" json:"schema,omitempty"`
	SchemaVersion []byte       `protobuf:"bytes,5,opt,name=schema_version,json=schemaVersion" json:"schema_version,omitempty"`
}

func (x *CommandGetSchemaResponse) Reset() {
	*x = CommandGetSchemaResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetSchemaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetSchemaResponse) ProtoMessage() {}

func (x *CommandGetSchemaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetSchemaResponse.ProtoReflect.Descriptor instead.
func (*CommandGetSchemaResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{53}
}

func (x *CommandGetSchemaResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandGetSchemaResponse) GetErrorCode() ServerError {
	if x != nil && x.ErrorCode != nil {
		return *x.ErrorCode
	}
	return ServerError_UnknownError
}

func (x *CommandGetSchemaResponse) GetErrorMessage() string {
	if x != nil && x.ErrorMessage != nil {
		return *x.ErrorMessage
	}
	return ""
}

func (x *CommandGetSchemaResponse) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *CommandGetSchemaResponse) GetSchemaVersion() []byte {
	if x != nil {
		return x.SchemaVersion
	}
	return nil
}

type CommandGetOrCreateSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId *uint64 `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Topic     *string `protobuf:"bytes,2,req,name=topic" json:"topic,omitempty"`
	Schema    *Schema `protobuf:"bytes,3,req,name=schema" json:"schema,omitempty"`
}

func (x *CommandGetOrCreateSchema) Reset() {
	*x = CommandGetOrCreateSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetOrCreateSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetOrCreateSchema) ProtoMessage() {}

func (x *CommandGetOrCreateSchema) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetOrCreateSchema.ProtoReflect.Descriptor instead.
func (*CommandGetOrCreateSchema) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{54}
}

func (x *CommandGetOrCreateSchema) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandGetOrCreateSchema) GetTopic() string {
	if x != nil && x.Topic != nil {
		return *x.Topic
	}
	return ""
}

func (x *CommandGetOrCreateSchema) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

type CommandGetOrCreateSchemaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId     *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	ErrorCode     *ServerError `protobuf:"varint,2,opt,name=error_code,json=errorCode,enum=pulsar.proto.ServerError" json:"error_code,omitempty"`
	ErrorMessage  *string      `protobuf:"bytes,3,opt,name=error_message,json=errorMessage" json:"error_message,omitempty"`
	SchemaVersion []byte       `protobuf:"bytes,4,opt,name=schema_version,json=schemaVersion" json:"schema_version,omitempty"`
}

func (x *CommandGetOrCreateSchemaResponse) Reset() {
	*x = CommandGetOrCreateSchemaResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetOrCreateSchemaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetOrCreateSchemaResponse) ProtoMessage() {}

func (x *CommandGetOrCreateSchemaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetOrCreateSchemaResponse.ProtoReflect.Descriptor instead.
func (*CommandGetOrCreateSchemaResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{55}
}

func (x *CommandGetOrCreateSchemaResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandGetOrCreateSchemaResponse) GetErrorCode() ServerError {
	if x != nil && x.ErrorCode != nil {
		return *x.ErrorCode
	}
	return ServerError_UnknownError
}

func (x *CommandGetOrCreateSchemaResponse) GetErrorMessage() string {
	if x != nil && x.ErrorMessage != nil {
		return *x.ErrorMessage
	}
	return ""
}

func (x *CommandGetOrCreateSchemaResponse) GetSchemaVersion() []byte {
	if x != nil {
		return x.SchemaVersion
	}
	return nil
}

type CommandTcClientConnectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId *uint64 `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TcId      *uint64 `protobuf:"varint,2,req,name=tc_id,json=tcId,def=0" json:"tc_id,omitempty"`
}

// Default values for CommandTcClientConnectRequest fields.
const (
	Default_CommandTcClientConnectRequest_TcId = uint64(0)
)

func (x *CommandTcClientConnectRequest) Reset() {
	*x = CommandTcClientConnectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandTcClientConnectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandTcClientConnectRequest) ProtoMessage() {}

func (x *CommandTcClientConnectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandTcClientConnectRequest.ProtoReflect.Descriptor instead.
func (*CommandTcClientConnectRequest) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{56}
}

func (x *CommandTcClientConnectRequest) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandTcClientConnectRequest) GetTcId() uint64 {
	if x != nil && x.TcId != nil {
		return *x.TcId
	}
	return Default_CommandTcClientConnectRequest_TcId
}

type CommandTcClientConnectResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	Error     *ServerError `protobuf:"varint,2,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message   *string      `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
}

func (x *CommandTcClientConnectResponse) Reset() {
	*x = CommandTcClientConnectResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandTcClientConnectResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandTcClientConnectResponse) ProtoMessage() {}

func (x *CommandTcClientConnectResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandTcClientConnectResponse.ProtoReflect.Descriptor instead.
func (*CommandTcClientConnectResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{57}
}

func (x *CommandTcClientConnectResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandTcClientConnectResponse) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandTcClientConnectResponse) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

type CommandNewTxn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId     *uint64 `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnTtlSeconds *uint64 `protobuf:"varint,2,opt,name=txn_ttl_seconds,json=txnTtlSeconds,def=0" json:"txn_ttl_seconds,omitempty"`
	TcId          *uint64 `protobuf:"varint,3,opt,name=tc_id,json=tcId,def=0" json:"tc_id,omitempty"`
}

// Default values for CommandNewTxn fields.
const (
	Default_CommandNewTxn_TxnTtlSeconds = uint64(0)
	Default_CommandNewTxn_TcId          = uint64(0)
)

func (x *CommandNewTxn) Reset() {
	*x = CommandNewTxn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandNewTxn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandNewTxn) ProtoMessage() {}

func (x *CommandNewTxn) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandNewTxn.ProtoReflect.Descriptor instead.
func (*CommandNewTxn) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{58}
}

func (x *CommandNewTxn) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandNewTxn) GetTxnTtlSeconds() uint64 {
	if x != nil && x.TxnTtlSeconds != nil {
		return *x.TxnTtlSeconds
	}
	return Default_CommandNewTxn_TxnTtlSeconds
}

func (x *CommandNewTxn) GetTcId() uint64 {
	if x != nil && x.TcId != nil {
		return *x.TcId
	}
	return Default_CommandNewTxn_TcId
}

type CommandNewTxnResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId      *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Error          *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message        *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
}

// Default values for CommandNewTxnResponse fields.
const (
	Default_CommandNewTxnResponse_TxnidLeastBits = uint64(0)
	Default_CommandNewTxnResponse_TxnidMostBits  = uint64(0)
)

func (x *CommandNewTxnResponse) Reset() {
	*x = CommandNewTxnResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandNewTxnResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandNewTxnResponse) ProtoMessage() {}

func (x *CommandNewTxnResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandNewTxnResponse.ProtoReflect.Descriptor instead.
func (*CommandNewTxnResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{59}
}

func (x *CommandNewTxnResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandNewTxnResponse) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandNewTxnResponse_TxnidLeastBits
}

func (x *CommandNewTxnResponse) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandNewTxnResponse_TxnidMostBits
}

func (x *CommandNewTxnResponse) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandNewTxnResponse) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

type CommandAddPartitionToTxn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId      *uint64  `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits *uint64  `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64  `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Partitions     []string `protobuf:"bytes,4,rep,name=partitions" json:"partitions,omitempty"`
}

// Default values for CommandAddPartitionToTxn fields.
const (
	Default_CommandAddPartitionToTxn_TxnidLeastBits = uint64(0)
	Default_CommandAddPartitionToTxn_TxnidMostBits  = uint64(0)
)

func (x *CommandAddPartitionToTxn) Reset() {
	*x = CommandAddPartitionToTxn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandAddPartitionToTxn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandAddPartitionToTxn) ProtoMessage() {}

func (x *CommandAddPartitionToTxn) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandAddPartitionToTxn.ProtoReflect.Descriptor instead.
func (*CommandAddPartitionToTxn) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{60}
}

func (x *CommandAddPartitionToTxn) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandAddPartitionToTxn) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandAddPartitionToTxn_TxnidLeastBits
}

func (x *CommandAddPartitionToTxn) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandAddPartitionToTxn_TxnidMostBits
}

func (x *CommandAddPartitionToTxn) GetPartitions() []string {
	if x != nil {
		return x.Partitions
	}
	return nil
}

type CommandAddPartitionToTxnResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId      *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Error          *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message        *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
}

// Default values for CommandAddPartitionToTxnResponse fields.
const (
	Default_CommandAddPartitionToTxnResponse_TxnidLeastBits = uint64(0)
	Default_CommandAddPartitionToTxnResponse_TxnidMostBits  = uint64(0)
)

func (x *CommandAddPartitionToTxnResponse) Reset() {
	*x = CommandAddPartitionToTxnResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandAddPartitionToTxnResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandAddPartitionToTxnResponse) ProtoMessage() {}

func (x *CommandAddPartitionToTxnResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandAddPartitionToTxnResponse.ProtoReflect.Descriptor instead.
func (*CommandAddPartitionToTxnResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{61}
}

func (x *CommandAddPartitionToTxnResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandAddPartitionToTxnResponse) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandAddPartitionToTxnResponse_TxnidLeastBits
}

func (x *CommandAddPartitionToTxnResponse) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandAddPartitionToTxnResponse_TxnidMostBits
}

func (x *CommandAddPartitionToTxnResponse) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandAddPartitionToTxnResponse) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

type Subscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic        *string `protobuf:"bytes,1,req,name=topic" json:"topic,omitempty"`
	Subscription *string `protobuf:"bytes,2,req,name=subscription" json:"subscription,omitempty"`
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{62}
}

func (x *Subscription) GetTopic() string {
	if x != nil && x.Topic != nil {
		return *x.Topic
	}
	return ""
}

func (x *Subscription) GetSubscription() string {
	if x != nil && x.Subscription != nil {
		return *x.Subscription
	}
	return ""
}

type CommandAddSubscriptionToTxn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId      *uint64         `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits *uint64         `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64         `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Subscription   []*Subscription `protobuf:"bytes,4,rep,name=subscription" json:"subscription,omitempty"`
}

// Default values for CommandAddSubscriptionToTxn fields.
const (
	Default_CommandAddSubscriptionToTxn_TxnidLeastBits = uint64(0)
	Default_CommandAddSubscriptionToTxn_TxnidMostBits  = uint64(0)
)

func (x *CommandAddSubscriptionToTxn) Reset() {
	*x = CommandAddSubscriptionToTxn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandAddSubscriptionToTxn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandAddSubscriptionToTxn) ProtoMessage() {}

func (x *CommandAddSubscriptionToTxn) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandAddSubscriptionToTxn.ProtoReflect.Descriptor instead.
func (*CommandAddSubscriptionToTxn) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{63}
}

func (x *CommandAddSubscriptionToTxn) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandAddSubscriptionToTxn) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandAddSubscriptionToTxn_TxnidLeastBits
}

func (x *CommandAddSubscriptionToTxn) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandAddSubscriptionToTxn_TxnidMostBits
}

func (x *CommandAddSubscriptionToTxn) GetSubscription() []*Subscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

type CommandAddSubscriptionToTxnResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId      *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Error          *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message        *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
}

// Default values for CommandAddSubscriptionToTxnResponse fields.
const (
	Default_CommandAddSubscriptionToTxnResponse_TxnidLeastBits = uint64(0)
	Default_CommandAddSubscriptionToTxnResponse_TxnidMostBits  = uint64(0)
)

func (x *CommandAddSubscriptionToTxnResponse) Reset() {
	*x = CommandAddSubscriptionToTxnResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandAddSubscriptionToTxnResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandAddSubscriptionToTxnResponse) ProtoMessage() {}

func (x *CommandAddSubscriptionToTxnResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandAddSubscriptionToTxnResponse.ProtoReflect.Descriptor instead.
func (*CommandAddSubscriptionToTxnResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{64}
}

func (x *CommandAddSubscriptionToTxnResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandAddSubscriptionToTxnResponse) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandAddSubscriptionToTxnResponse_TxnidLeastBits
}

func (x *CommandAddSubscriptionToTxnResponse) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandAddSubscriptionToTxnResponse_TxnidMostBits
}

func (x *CommandAddSubscriptionToTxnResponse) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandAddSubscriptionToTxnResponse) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

type CommandEndTxn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId      *uint64    `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits *uint64    `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64    `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	TxnAction      *TxnAction `protobuf:"varint,4,opt,name=txn_action,json=txnAction,enum=pulsar.proto.TxnAction" json:"txn_action,omitempty"`
}

// Default values for CommandEndTxn fields.
const (
	Default_CommandEndTxn_TxnidLeastBits = uint64(0)
	Default_CommandEndTxn_TxnidMostBits  = uint64(0)
)

func (x *CommandEndTxn) Reset() {
	*x = CommandEndTxn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandEndTxn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandEndTxn) ProtoMessage() {}

func (x *CommandEndTxn) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandEndTxn.ProtoReflect.Descriptor instead.
func (*CommandEndTxn) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{65}
}

func (x *CommandEndTxn) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandEndTxn) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandEndTxn_TxnidLeastBits
}

func (x *CommandEndTxn) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandEndTxn_TxnidMostBits
}

func (x *CommandEndTxn) GetTxnAction() TxnAction {
	if x != nil && x.TxnAction != nil {
		return *x.TxnAction
	}
	return TxnAction_COMMIT
}

type CommandEndTxnResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId      *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Error          *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message        *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
}

// Default values for CommandEndTxnResponse fields.
const (
	Default_CommandEndTxnResponse_TxnidLeastBits = uint64(0)
	Default_CommandEndTxnResponse_TxnidMostBits  = uint64(0)
)

func (x *CommandEndTxnResponse) Reset() {
	*x = CommandEndTxnResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandEndTxnResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandEndTxnResponse) ProtoMessage() {}

func (x *CommandEndTxnResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandEndTxnResponse.ProtoReflect.Descriptor instead.
func (*CommandEndTxnResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{66}
}

func (x *CommandEndTxnResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandEndTxnResponse) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandEndTxnResponse_TxnidLeastBits
}

func (x *CommandEndTxnResponse) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandEndTxnResponse_TxnidMostBits
}

func (x *CommandEndTxnResponse) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandEndTxnResponse) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

type CommandEndTxnOnPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId                    *uint64    `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits               *uint64    `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits                *uint64    `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Topic                        *string    `protobuf:"bytes,4,opt,name=topic" json:"topic,omitempty"`
	TxnAction                    *TxnAction `protobuf:"varint,5,opt,name=txn_action,json=txnAction,enum=pulsar.proto.TxnAction" json:"txn_action,omitempty"`
	TxnidLeastBitsOfLowWatermark *uint64    `protobuf:"varint,6,opt,name=txnid_least_bits_of_low_watermark,json=txnidLeastBitsOfLowWatermark" json:"txnid_least_bits_of_low_watermark,omitempty"`
}

// Default values for CommandEndTxnOnPartition fields.
const (
	Default_CommandEndTxnOnPartition_TxnidLeastBits = uint64(0)
	Default_CommandEndTxnOnPartition_TxnidMostBits  = uint64(0)
)

func (x *CommandEndTxnOnPartition) Reset() {
	*x = CommandEndTxnOnPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandEndTxnOnPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandEndTxnOnPartition) ProtoMessage() {}

func (x *CommandEndTxnOnPartition) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandEndTxnOnPartition.ProtoReflect.Descriptor instead.
func (*CommandEndTxnOnPartition) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{67}
}

func (x *CommandEndTxnOnPartition) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandEndTxnOnPartition) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandEndTxnOnPartition_TxnidLeastBits
}

func (x *CommandEndTxnOnPartition) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandEndTxnOnPartition_TxnidMostBits
}

func (x *CommandEndTxnOnPartition) GetTopic() string {
	if x != nil && x.Topic != nil {
		return *x.Topic
	}
	return ""
}

func (x *CommandEndTxnOnPartition) GetTxnAction() TxnAction {
	if x != nil && x.TxnAction != nil {
		return *x.TxnAction
	}
	return TxnAction_COMMIT
}

func (x *CommandEndTxnOnPartition) GetTxnidLeastBitsOfLowWatermark() uint64 {
	if x != nil && x.TxnidLeastBitsOfLowWatermark != nil {
		return *x.TxnidLeastBitsOfLowWatermark
	}
	return 0
}

type CommandEndTxnOnPartitionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId      *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Error          *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message        *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
}

// Default values for CommandEndTxnOnPartitionResponse fields.
const (
	Default_CommandEndTxnOnPartitionResponse_TxnidLeastBits = uint64(0)
	Default_CommandEndTxnOnPartitionResponse_TxnidMostBits  = uint64(0)
)

func (x *CommandEndTxnOnPartitionResponse) Reset() {
	*x = CommandEndTxnOnPartitionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandEndTxnOnPartitionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandEndTxnOnPartitionResponse) ProtoMessage() {}

func (x *CommandEndTxnOnPartitionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandEndTxnOnPartitionResponse.ProtoReflect.Descriptor instead.
func (*CommandEndTxnOnPartitionResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{68}
}

func (x *CommandEndTxnOnPartitionResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandEndTxnOnPartitionResponse) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandEndTxnOnPartitionResponse_TxnidLeastBits
}

func (x *CommandEndTxnOnPartitionResponse) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandEndTxnOnPartitionResponse_TxnidMostBits
}

func (x *CommandEndTxnOnPartitionResponse) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandEndTxnOnPartitionResponse) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

type CommandEndTxnOnSubscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId                    *uint64       `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits               *uint64       `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits                *uint64       `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Subscription                 *Subscription `protobuf:"bytes,4,opt,name=subscription" json:"subscription,omitempty"`
	TxnAction                    *TxnAction    `protobuf:"varint,5,opt,name=txn_action,json=txnAction,enum=pulsar.proto.TxnAction" json:"txn_action,omitempty"`
	TxnidLeastBitsOfLowWatermark *uint64       `protobuf:"varint,6,opt,name=txnid_least_bits_of_low_watermark,json=txnidLeastBitsOfLowWatermark" json:"txnid_least_bits_of_low_watermark,omitempty"`
}

// Default values for CommandEndTxnOnSubscription fields.
const (
	Default_CommandEndTxnOnSubscription_TxnidLeastBits = uint64(0)
	Default_CommandEndTxnOnSubscription_TxnidMostBits  = uint64(0)
)

func (x *CommandEndTxnOnSubscription) Reset() {
	*x = CommandEndTxnOnSubscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandEndTxnOnSubscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandEndTxnOnSubscription) ProtoMessage() {}

func (x *CommandEndTxnOnSubscription) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandEndTxnOnSubscription.ProtoReflect.Descriptor instead.
func (*CommandEndTxnOnSubscription) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{69}
}

func (x *CommandEndTxnOnSubscription) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandEndTxnOnSubscription) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandEndTxnOnSubscription_TxnidLeastBits
}

func (x *CommandEndTxnOnSubscription) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandEndTxnOnSubscription_TxnidMostBits
}

func (x *CommandEndTxnOnSubscription) GetSubscription() *Subscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

func (x *CommandEndTxnOnSubscription) GetTxnAction() TxnAction {
	if x != nil && x.TxnAction != nil {
		return *x.TxnAction
	}
	return TxnAction_COMMIT
}

func (x *CommandEndTxnOnSubscription) GetTxnidLeastBitsOfLowWatermark() uint64 {
	if x != nil && x.TxnidLeastBitsOfLowWatermark != nil {
		return *x.TxnidLeastBitsOfLowWatermark
	}
	return 0
}

type CommandEndTxnOnSubscriptionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId      *uint64      `protobuf:"varint,1,req,name=request_id,json=requestId" json:"request_id,omitempty"`
	TxnidLeastBits *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,json=txnidLeastBits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,json=txnidMostBits,def=0" json:"txnid_most_bits,omitempty"`
	Error          *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message        *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
}

// Default values for CommandEndTxnOnSubscriptionResponse fields.
const (
	Default_CommandEndTxnOnSubscriptionResponse_TxnidLeastBits = uint64(0)
	Default_CommandEndTxnOnSubscriptionResponse_TxnidMostBits  = uint64(0)
)

func (x *CommandEndTxnOnSubscriptionResponse) Reset() {
	*x = CommandEndTxnOnSubscriptionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandEndTxnOnSubscriptionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandEndTxnOnSubscriptionResponse) ProtoMessage() {}

func (x *CommandEndTxnOnSubscriptionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandEndTxnOnSubscriptionResponse.ProtoReflect.Descriptor instead.
func (*CommandEndTxnOnSubscriptionResponse) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{70}
}

func (x *CommandEndTxnOnSubscriptionResponse) GetRequestId() uint64 {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return 0
}

func (x *CommandEndTxnOnSubscriptionResponse) GetTxnidLeastBits() uint64 {
	if x != nil && x.TxnidLeastBits != nil {
		return *x.TxnidLeastBits
	}
	return Default_CommandEndTxnOnSubscriptionResponse_TxnidLeastBits
}

func (x *CommandEndTxnOnSubscriptionResponse) GetTxnidMostBits() uint64 {
	if x != nil && x.TxnidMostBits != nil {
		return *x.TxnidMostBits
	}
	return Default_CommandEndTxnOnSubscriptionResponse_TxnidMostBits
}

func (x *CommandEndTxnOnSubscriptionResponse) GetError() ServerError {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ServerError_UnknownError
}

func (x *CommandEndTxnOnSubscriptionResponse) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

type BaseCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type                            *BaseCommand_Type                        `protobuf:"varint,1,req,name=type,enum=pulsar.proto.BaseCommand_Type" json:"type,omitempty"`
	Connect                         *CommandConnect                          `protobuf:"bytes,2,opt,name=connect" json:"connect,omitempty"`
	Connected                       *CommandConnected                        `protobuf:"bytes,3,opt,name=connected" json:"connected,omitempty"`
	Subscribe                       *CommandSubscribe                        `protobuf:"bytes,4,opt,name=subscribe" json:"subscribe,omitempty"`
	Producer                        *CommandProducer                         `protobuf:"bytes,5,opt,name=producer" json:"producer,omitempty"`
	Send                            *CommandSend                             `protobuf:"bytes,6,opt,name=send" json:"send,omitempty"`
	SendReceipt                     *CommandSendReceipt                      `protobuf:"bytes,7,opt,name=send_receipt,json=sendReceipt" json:"send_receipt,omitempty"`
	SendError                       *CommandSendError                        `protobuf:"bytes,8,opt,name=send_error,json=sendError" json:"send_error,omitempty"`
	Message                         *CommandMessage                          `protobuf:"bytes,9,opt,name=message" json:"message,omitempty"`
	Ack                             *CommandAck                              `protobuf:"bytes,10,opt,name=ack" json:"ack,omitempty"`
	Flow                            *CommandFlow                             `protobuf:"bytes,11,opt,name=flow" json:"flow,omitempty"`
	Unsubscribe                     *CommandUnsubscribe                      `protobuf:"bytes,12,opt,name=unsubscribe" json:"unsubscribe,omitempty"`
	Success                         *CommandSuccess                          `protobuf:"bytes,13,opt,name=success" json:"success,omitempty"`
	Error                           *CommandError                            `protobuf:"bytes,14,opt,name=error" json:"error,omitempty"`
	CloseProducer                   *CommandCloseProducer                    `protobuf:"bytes,15,opt,name=close_producer,json=closeProducer" json:"close_producer,omitempty"`
	CloseConsumer                   *CommandCloseConsumer                    `protobuf:"bytes,16,opt,name=close_consumer,json=closeConsumer" json:"close_consumer,omitempty"`
	ProducerSuccess                 *CommandProducerSuccess                  `protobuf:"bytes,17,opt,name=producer_success,json=producerSuccess" json:"producer_success,omitempty"`
	Ping                            *CommandPing                             `protobuf:"bytes,18,opt,name=ping" json:"ping,omitempty"`
	Pong                            *CommandPong                             `protobuf:"bytes,19,opt,name=pong" json:"pong,omitempty"`
	RedeliverUnacknowledgedMessages *CommandRedeliverUnacknowledgedMessages  `protobuf:"bytes,20,opt,name=redeliverUnacknowledgedMessages" json:"redeliverUnacknowledgedMessages,omitempty"`
	PartitionMetadata               *CommandPartitionedTopicMetadata         `protobuf:"bytes,21,opt,name=partitionMetadata" json:"partitionMetadata,omitempty"`
	PartitionMetadataResponse       *CommandPartitionedTopicMetadataResponse `protobuf:"bytes,22,opt,name=partitionMetadataResponse" json:"partitionMetadataResponse,omitempty"`
	LookupTopic                     *CommandLookupTopic                      `protobuf:"bytes,23,opt,name=lookupTopic" json:"lookupTopic,omitempty"`
	LookupTopicResponse             *CommandLookupTopicResponse              `protobuf:"bytes,24,opt,name=lookupTopicResponse" json:"lookupTopicResponse,omitempty"`
	ConsumerStats                   *CommandConsumerStats                    `protobuf:"bytes,25,opt,name=consumerStats" json:"consumerStats,omitempty"`
	ConsumerStatsResponse           *CommandConsumerStatsResponse            `protobuf:"bytes,26,opt,name=consumerStatsResponse" json:"consumerStatsResponse,omitempty"`
	ReachedEndOfTopic               *CommandReachedEndOfTopic                `protobuf:"bytes,27,opt,name=reachedEndOfTopic" json:"reachedEndOfTopic,omitempty"`
	Seek                            *CommandSeek                             `protobuf:"bytes,28,opt,name=seek" json:"seek,omitempty"`
	GetLastMessageId                *CommandGetLastMessageId                 `protobuf:"bytes,29,opt,name=getLastMessageId" json:"getLastMessageId,omitempty"`
	GetLastMessageIdResponse        *CommandGetLastMessageIdResponse         `protobuf:"bytes,30,opt,name=getLastMessageIdResponse" json:"getLastMessageIdResponse,omitempty"`
	ActiveConsumerChange            *CommandActiveConsumerChange             `protobuf:"bytes,31,opt,name=active_consumer_change,json=activeConsumerChange" json:"active_consumer_change,omitempty"`
	GetTopicsOfNamespace            *CommandGetTopicsOfNamespace             `protobuf:"bytes,32,opt,name=getTopicsOfNamespace" json:"getTopicsOfNamespace,omitempty"`
	GetTopicsOfNamespaceResponse    *CommandGetTopicsOfNamespaceResponse     `protobuf:"bytes,33,opt,name=getTopicsOfNamespaceResponse" json:"getTopicsOfNamespaceResponse,omitempty"`
	GetSchema                       *CommandGetSchema                        `protobuf:"bytes,34,opt,name=getSchema" json:"getSchema,omitempty"`
	GetSchemaResponse               *CommandGetSchemaResponse                `protobuf:"bytes,35,opt,name=getSchemaResponse" json:"getSchemaResponse,omitempty"`
	AuthChallenge                   *CommandAuthChallenge                    `protobuf:"bytes,36,opt,name=authChallenge" json:"authChallenge,omitempty"`
	AuthResponse                    *CommandAuthResponse                     `protobuf:"bytes,37,opt,name=authResponse" json:"authResponse,omitempty"`
	AckResponse                     *CommandAckResponse                      `protobuf:"bytes,38,opt,name=ackResponse" json:"ackResponse,omitempty"`
	GetOrCreateSchema               *CommandGetOrCreateSchema                `protobuf:"bytes,39,opt,name=getOrCreateSchema" json:"getOrCreateSchema,omitempty"`
	GetOrCreateSchemaResponse       *CommandGetOrCreateSchemaResponse        `protobuf:"bytes,40,opt,name=getOrCreateSchemaResponse" json:"getOrCreateSchemaResponse,omitempty"`
	// transaction related
	NewTxn                       *CommandNewTxn                       `protobuf:"bytes,50,opt,name=newTxn" json:"newTxn,omitempty"`
	NewTxnResponse               *CommandNewTxnResponse               `protobuf:"bytes,51,opt,name=newTxnResponse" json:"newTxnResponse,omitempty"`
	AddPartitionToTxn            *CommandAddPartitionToTxn            `protobuf:"bytes,52,opt,name=addPartitionToTxn" json:"addPartitionToTxn,omitempty"`
	AddPartitionToTxnResponse    *CommandAddPartitionToTxnResponse    `protobuf:"bytes,53,opt,name=addPartitionToTxnResponse" json:"addPartitionToTxnResponse,omitempty"`
	AddSubscriptionToTxn         *CommandAddSubscriptionToTxn         `protobuf:"bytes,54,opt,name=addSubscriptionToTxn" json:"addSubscriptionToTxn,omitempty"`
	AddSubscriptionToTxnResponse *CommandAddSubscriptionToTxnResponse `protobuf:"bytes,55,opt,name=addSubscriptionToTxnResponse" json:"addSubscriptionToTxnResponse,omitempty"`
	EndTxn                       *CommandEndTxn                       `protobuf:"bytes,56,opt,name=endTxn" json:"endTxn,omitempty"`
	EndTxnResponse               *CommandEndTxnResponse               `protobuf:"bytes,57,opt,name=endTxnResponse" json:"endTxnResponse,omitempty"`
	EndTxnOnPartition            *CommandEndTxnOnPartition            `protobuf:"bytes,58,opt,name=endTxnOnPartition" json:"endTxnOnPartition,omitempty"`
	EndTxnOnPartitionResponse    *CommandEndTxnOnPartitionResponse    `protobuf:"bytes,59,opt,name=endTxnOnPartitionResponse" json:"endTxnOnPartitionResponse,omitempty"`
	EndTxnOnSubscription         *CommandEndTxnOnSubscription         `protobuf:"bytes,60,opt,name=endTxnOnSubscription" json:"endTxnOnSubscription,omitempty"`
	EndTxnOnSubscriptionResponse *CommandEndTxnOnSubscriptionResponse `protobuf:"bytes,61,opt,name=endTxnOnSubscriptionResponse" json:"endTxnOnSubscriptionResponse,omitempty"`
	TcClientConnectRequest       *CommandTcClientConnectRequest       `protobuf:"bytes,62,opt,name=tcClientConnectRequest" json:"tcClientConnectRequest,omitempty"`
	TcClientConnectResponse      *CommandTcClientConnectResponse      `protobuf:"bytes,63,opt,name=tcClientConnectResponse" json:"tcClientConnectResponse,omitempty"`
	WatchTopicList               *CommandWatchTopicList               `protobuf:"bytes,64,opt,name=watchTopicList" json:"watchTopicList,omitempty"`
	WatchTopicListSuccess        *CommandWatchTopicListSuccess        `protobuf:"bytes,65,opt,name=watchTopicListSuccess" json:"watchTopicListSuccess,omitempty"`
	WatchTopicUpdate             *CommandWatchTopicUpdate             `protobuf:"bytes,66,opt,name=watchTopicUpdate" json:"watchTopicUpdate,omitempty"`
	WatchTopicListClose          *CommandWatchTopicListClose          `protobuf:"bytes,67,opt,name=watchTopicListClose" json:"watchTopicListClose,omitempty"`
	TopicMigrated                *CommandTopicMigrated                `protobuf:"bytes,68,opt,name=topicMigrated" json:"topicMigrated,omitempty"`
}

func (x *BaseCommand) Reset() {
	*x = BaseCommand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_PulsarApi_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BaseCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BaseCommand) ProtoMessage() {}

func (x *BaseCommand) ProtoReflect() protoreflect.Message {
	mi := &file_PulsarApi_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BaseCommand.ProtoReflect.Descriptor instead.
func (*BaseCommand) Descriptor() ([]byte, []int) {
	return file_PulsarApi_proto_rawDescGZIP(), []int{71}
}

func (x *BaseCommand) GetType() BaseCommand_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return BaseCommand_CONNECT
}

func (x *BaseCommand) GetConnect() *CommandConnect {
	if x != nil {
		return x.Connect
	}
	return nil
}

func (x *BaseCommand) GetConnected() *CommandConnected {
	if x != nil {
		return x.Connected
	}
	return nil
}

func (x *BaseCommand) GetSubscribe() *CommandSubscribe {
	if x != nil {
		return x.Subscribe
	}
	return nil
}

func (x *BaseCommand) GetProducer() *CommandProducer {
	if x != nil {
		return x.Producer
	}
	return nil
}

func (x *BaseCommand) GetSend() *CommandSend {
	if x != nil {
		return x.Send
	}
	return nil
}

func (x *BaseCommand) GetSendReceipt() *CommandSendReceipt {
	if x != nil {
		return x.SendReceipt
	}
	return nil
}

func (x *BaseCommand) GetSendError() *CommandSendError {
	if x != nil {
		return x.SendError
	}
	return nil
}

func (x *BaseCommand) GetMessage() *CommandMessage {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *BaseCommand) GetAck() *CommandAck {
	if x != nil {
		return x.Ack
	}
	return nil
}

func (x *BaseCommand) GetFlow() *CommandFlow {
	if x != nil {
		return x.Flow
	}
	return nil
}

func (x *BaseCommand) GetUnsubscribe() *CommandUnsubscribe {
	if x != nil {
		return x.Unsubscribe
	}
	return nil
}

func (x *BaseCommand) GetSuccess() *CommandSuccess {
	if x != nil {
		return x.Success
	}
	return nil
}

func (x *BaseCommand) GetError() *CommandError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *BaseCommand) GetCloseProducer() *CommandCloseProducer {
	if x != nil {
		return x.CloseProducer
	}
	return nil
}

func (x *BaseCommand) GetCloseConsumer() *CommandCloseConsumer {
	if x != nil {
		return x.CloseConsumer
	}
	return nil
}

func (x *BaseCommand) GetProducerSuccess() *CommandProducerSuccess {
	if x != nil {
		return x.ProducerSuccess
	}
	return nil
}

func (x *BaseCommand) GetPing() *CommandPing {
	if x != nil {
		return x.Ping
	}
	return nil
}

func (x *BaseCommand) GetPong() *CommandPong {
	if x != nil {
		return x.Pong
	}
	return nil
}

func (x *BaseCommand) GetRedeliverUnacknowledgedMessages() *CommandRedeliverUnacknowledgedMessages {
	if x != nil {
		return x.RedeliverUnacknowledgedMessages
	}
	return nil
}

func (x *BaseCommand) GetPartitionMetadata() *CommandPartitionedTopicMetadata {
	if x != nil {
		return x.PartitionMetadata
	}
	return nil
}

func (x *BaseCommand) GetPartitionMetadataResponse() *CommandPartitionedTopicMetadataResponse {
	if x != nil {
		return x.PartitionMetadataResponse
	}
	return nil
}

func (x *BaseCommand) GetLookupTopic() *CommandLookupTopic {
	if x != nil {
		return x.LookupTopic
	}
	return nil
}

func (x *BaseCommand) GetLookupTopicResponse() *CommandLookupTopicResponse {
	if x != nil {
		return x.LookupTopicResponse
	}
	return nil
}

func (x *BaseCommand) GetConsumerStats() *CommandConsumerStats {
	if x != nil {
		return x.ConsumerStats
	}
	return nil
}

func (x *BaseCommand) GetConsumerStatsResponse() *CommandConsumerStatsResponse {
	if x != nil {
		return x.ConsumerStatsResponse
	}
	return nil
}

func (x *BaseCommand) GetReachedEndOfTopic() *CommandReachedEndOfTopic {
	if x != nil {
		return x.ReachedEndOfTopic
	}
	return nil
}

func (x *BaseCommand) GetSeek() *CommandSeek {
	if x != nil {
		return x.Seek
	}
	return nil
}

func (x *BaseCommand) GetGetLastMessageId() *CommandGetLastMessageId {
	if x != nil {
		return x.GetLastMessageId
	}
	return nil
}

func (x *BaseCommand) GetGetLastMessageIdResponse() *CommandGetLastMessageIdResponse {
	if x != nil {
		return x.GetLastMessageIdResponse
	}
	return nil
}

func (x *BaseCommand) GetActiveConsumerChange() *CommandActiveConsumerChange {
	if x != nil {
		return x.ActiveConsumerChange
	}
	return nil
}

func (x *BaseCommand) GetGetTopicsOfNamespace() *CommandGetTopicsOfNamespace {
	if x != nil {
		return x.GetTopicsOfNamespace
	}
	return nil
}

func (x *BaseCommand) GetGetTopicsOfNamespaceResponse() *CommandGetTopicsOfNamespaceResponse {
	if x != nil {
		return x.GetTopicsOfNamespaceResponse
	}
	return nil
}

func (x *BaseCommand) GetGetSchema() *CommandGetSchema {
	if x != nil {
		return x.GetSchema
	}
	return nil
}

func (x *BaseCommand) GetGetSchemaResponse() *CommandGetSchemaResponse {
	if x != nil {
		return x.GetSchemaResponse
	}
	return nil
}

func (x *BaseCommand) GetAuthChallenge() *CommandAuthChallenge {
	if x != nil {
		return x.AuthChallenge
	}
	return nil
}

func (x *BaseCommand) GetAuthResponse() *CommandAuthResponse {
	if x != nil {
		return x.AuthResponse
	}
	return nil
}

func (x *BaseCommand) GetAckResponse() *CommandAckResponse {
	if x != nil {
		return x.AckResponse
	}
	return nil
}

func (x *BaseCommand) GetGetOrCreateSchema() *CommandGetOrCreateSchema {
	if x != nil {
		return x.GetOrCreateSchema
	}
	return nil
}

func (x *BaseCommand) GetGetOrCreateSchemaResponse() *CommandGetOrCreateSchemaResponse {
	if x != nil {
		return x.GetOrCreateSchemaResponse
	}
	return nil
}

func (x *BaseCommand) GetNewTxn() *CommandNewTxn {
	if x != nil {
		return x.NewTxn
	}
	return nil
}

func (x *BaseCommand) GetNewTxnResponse() *CommandNewTxnResponse {
	if x != nil {
		return x.NewTxnResponse
	}
	return nil
}

func (x *BaseCommand) GetAddPartitionToTxn() *CommandAddPartitionToTxn {
	if x != nil {
		return x.AddPartitionToTxn
	}
	return nil
}

func (x *BaseCommand) GetAddPartitionToTxnResponse() *CommandAddPartitionToTxnResponse {
	if x != nil {
		return x.AddPartitionToTxnResponse
	}
	return nil
}

func (x *BaseCommand) GetAddSubscriptionToTxn() *CommandAddSubscriptionToTxn {
	if x != nil {
		return x.AddSubscriptionToTxn
	}
	return nil
}

func (x *BaseCommand) GetAddSubscriptionToTxnResponse() *CommandAddSubscriptionToTxnResponse {
	if x != nil {
		return x.AddSubscriptionToTxnResponse
	}
	return nil
}

func (x *BaseCommand) GetEndTxn() *CommandEndTxn {
	if x != nil {
		return x.EndTxn
	}
	return nil
}

func (x *BaseCommand) GetEndTxnResponse() *CommandEndTxnResponse {
	if x != nil {
		return x.EndTxnResponse
	}
	return nil
}

func (x *BaseCommand) GetEndTxnOnPartition() *CommandEndTxnOnPartition {
	if x != nil {
		return x.EndTxnOnPartition
	}
	return nil
}

func (x *BaseCommand) GetEndTxnOnPartitionResponse() *CommandEndTxnOnPartitionResponse {
	if x != nil {
		return x.EndTxnOnPartitionResponse
	}
	return nil
}

func (x *BaseCommand) GetEndTxnOnSubscription() *CommandEndTxnOnSubscription {
	if x != nil {
		return x.EndTxnOnSubscription
	}
	return nil
}

func (x *BaseCommand) GetEndTxnOnSubscriptionResponse() *CommandEndTxnOnSubscriptionResponse {
	if x != nil {
		return x.EndTxnOnSubscriptionResponse
	}
	return nil
}

func (x *BaseCommand) GetTcClientConnectRequest() *CommandTcClientConnectRequest {
	if x != nil {
		return x.TcClientConnectRequest
	}
	return nil
}

func (x *BaseCommand) GetTcClientConnectResponse() *CommandTcClientConnectResponse {
	if x != nil {
		return x.TcClientConnectResponse
	}
	return nil
}

func (x *BaseCommand) GetWatchTopicList() *CommandWatchTopicList {
	if x != nil {
		return x.WatchTopicList
	}
	return nil
}

func (x *BaseCommand) GetWatchTopicListSuccess() *CommandWatchTopicListSuccess {
	if x != nil {
		return x.WatchTopicListSuccess
	}
	return nil
}

func (x *BaseCommand) GetWatchTopicUpdate() *CommandWatchTopicUpdate {
	if x != nil {
		return x.WatchTopicUpdate
	}
	return nil
}

func (x *BaseCommand) GetWatchTopicListClose() *CommandWatchTopicListClose {
	if x != nil {
		return x.WatchTopicListClose
	}
	return nil
}

func (x *BaseCommand) GetTopicMigrated() *CommandTopicMigrated {
	if x != nil {
		return x.TopicMigrated
	}
	return nil
}

var File_PulsarApi_proto protoreflect.FileDescriptor

var file_PulsarApi_proto_rawDesc = []byte{
	0x0a, 0x0f, 0x50, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x41, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x0c, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xb4, 0x03, 0x0a, 0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x02, 0x28, 0x0c, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x2d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x19, 0x2e,
	0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x36,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0x8d, 0x02, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x08, 0x0a, 0x04, 0x4e, 0x6f, 0x6e, 0x65, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x73, 0x6f, 0x6e, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x10, 0x03, 0x12, 0x08, 0x0a,
	0x04, 0x41, 0x76, 0x72, 0x6f, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x6f, 0x6f, 0x6c, 0x10,
	0x05, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x6e, 0x74, 0x38, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x49,
	0x6e, 0x74, 0x31, 0x36, 0x10, 0x07, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x10,
	0x08, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x10, 0x09, 0x12, 0x09, 0x0a, 0x05,
	0x46, 0x6c, 0x6f, 0x61, 0x74, 0x10, 0x0a, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x10, 0x0b, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x61, 0x74, 0x65, 0x10, 0x0c, 0x12, 0x08, 0x0a,
	0x04, 0x54, 0x69, 0x6d, 0x65, 0x10, 0x0d, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x10, 0x0e, 0x12, 0x0c, 0x0a, 0x08, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x10, 0x0f, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x10,
	0x10, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x61, 0x74, 0x65, 0x10, 0x11,
	0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x10, 0x12, 0x12,
	0x11, 0x0a, 0x0d, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x10, 0x13, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x4e, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x10, 0x14, 0x22, 0x96, 0x02, 0x0a, 0x0d, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x64, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x72, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x08, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x49, 0x64, 0x18,
	0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x49, 0x64, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x3a, 0x02, 0x2d, 0x31, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x0a, 0x0b, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x02, 0x2d, 0x31, 0x52, 0x0a, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x17, 0x0a, 0x07, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x65, 0x74,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x03, 0x52, 0x06, 0x61, 0x63, 0x6b, 0x53, 0x65, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x09, 0x62, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x50, 0x0a,
	0x16, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x13, 0x66, 0x69, 0x72, 0x73,
	0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x22,
	0x32, 0x0a, 0x08, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0x36, 0x0a, 0x0c, 0x4b, 0x65, 0x79, 0x4c, 0x6f, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x04, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x32, 0x0a, 0x08, 0x49,
	0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x05, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22,
	0x6c, 0x0a, 0x0e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x73, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x32, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x75,
	0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xd1, 0x09,
	0x0a, 0x0f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x73, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0b, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b, 0x65,
	0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x12, 0x23, 0x0a, 0x0d, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x6f,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x54, 0x6f, 0x12, 0x45, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x52, 0x0b, 0x63,
	0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x11, 0x75, 0x6e,
	0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x01, 0x30, 0x52, 0x10, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x34, 0x0a, 0x15, 0x6e, 0x75,
	0x6d, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x01, 0x31, 0x52, 0x12, 0x6e, 0x75,
	0x6d, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x49, 0x6e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x12, 0x20, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x75,
	0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c,
	0x67, 0x6f, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x12, 0x25, 0x0a,
	0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x19, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x62, 0x36, 0x34, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65,
	0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x16,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x42, 0x36, 0x34, 0x45,
	0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x26, 0x0a, 0x0f, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0d, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x41, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x73,
	0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x74, 0x78,
	0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74,
	0x42, 0x69, 0x74, 0x73, 0x12, 0x31, 0x0a, 0x13, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x5f,
	0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x18, 0x20, 0x01, 0x28,
	0x04, 0x3a, 0x01, 0x30, 0x52, 0x11, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x53, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0a, 0x6e, 0x75, 0x6c, 0x6c, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c,
	0x73, 0x65, 0x52, 0x09, 0x6e, 0x75, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x75, 0x69,
	0x64, 0x12, 0x2d, 0x0a, 0x13, 0x6e, 0x75, 0x6d, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x5f,
	0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6d, 0x73, 0x67, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10,
	0x6e, 0x75, 0x6d, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x4d, 0x73, 0x67,
	0x12, 0x2f, 0x0a, 0x14, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f,
	0x6d, 0x73, 0x67, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x4d, 0x73, 0x67, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x1d, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x07, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x49, 0x64, 0x12, 0x33, 0x0a, 0x12,
	0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52,
	0x10, 0x6e, 0x75, 0x6c, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x22, 0xc6, 0x03, 0x0a, 0x15, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x36, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b,
	0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x05, 0x52, 0x0b,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2a, 0x0a, 0x0d, 0x63,
	0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x61,
	0x63, 0x74, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x12, 0x20, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x09,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x19, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x62, 0x36, 0x34, 0x5f, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61,
	0x6c, 0x73, 0x65, 0x52, 0x16, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x42, 0x36, 0x34, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0b, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x1f,
	0x0a, 0x0b, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x0a, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x24, 0x0a, 0x0a, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x09, 0x6e, 0x75, 0x6c, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x33, 0x0a, 0x12, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x10, 0x6e, 0x75, 0x6c, 0x6c, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0x56, 0x0a, 0x13, 0x42, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x29, 0x0a, 0x10, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x62, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x14, 0x0a, 0x05,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x22, 0xe6, 0x03, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0d, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0b,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x18, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0a, 0x61, 0x75, 0x74,
	0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x68, 0x5f,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x2c,
	0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x01, 0x30, 0x52, 0x0f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x13,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x74, 0x6f, 0x5f, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x5f,
	0x75, 0x72, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x54, 0x6f, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x55, 0x72, 0x6c, 0x12, 0x2d, 0x0a, 0x12, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x41, 0x75, 0x74, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x30, 0x0a, 0x14, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x3f, 0x0a, 0x0d, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x0c, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x22, 0x97, 0x02, 0x0a, 0x0c,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x39, 0x0a, 0x15,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x72, 0x65,
	0x66, 0x72, 0x65, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c,
	0x73, 0x65, 0x52, 0x13, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x41, 0x75, 0x74, 0x68,
	0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x12, 0x4a, 0x0a, 0x1e, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x5f, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x3a,
	0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x1b, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x41, 0x0a, 0x19, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x17, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x12, 0x3d, 0x0a, 0x17, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x15,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x57, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x73, 0x22, 0xd2, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x2c, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x01, 0x30, 0x52, 0x0f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x28, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x3f, 0x0a, 0x0d, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x0c, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x22, 0x9e, 0x01, 0x0a, 0x13, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x75, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x08, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x75,
	0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a,
	0x10, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x01, 0x30, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x14,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x75, 0x74, 0x68, 0x43, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x09, 0x63,
	0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x44, 0x61, 0x74, 0x61, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67,
	0x65, 0x12, 0x2c, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x01, 0x30, 0x52, 0x0f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x51, 0x0a, 0x08, 0x41, 0x75, 0x74, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x28, 0x0a, 0x10, 0x61,
	0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x44, 0x61,
	0x74, 0x61, 0x22, 0xcb, 0x01, 0x0a, 0x0d, 0x4b, 0x65, 0x79, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64,
	0x4d, 0x65, 0x74, 0x61, 0x12, 0x41, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x53, 0x68, 0x61, 0x72, 0x65,
	0x64, 0x4d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x70, 0x75,
	0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b, 0x65, 0x79, 0x53, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0d, 0x6b, 0x65, 0x79, 0x53, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x36, 0x0a, 0x0a, 0x68, 0x61, 0x73, 0x68, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x75,
	0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x6e, 0x74, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x0a, 0x68, 0x61, 0x73, 0x68, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12,
	0x3f, 0x0a, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4f, 0x75, 0x74, 0x4f, 0x66, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4f, 0x75,
	0x74, 0x4f, 0x66, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x22, 0xe3, 0x08, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x22, 0x0a, 0x0c, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x40, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0e,
	0x32, 0x26, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
	0x2e, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x73, 0x75, 0x62, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x05, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d,
	0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1e, 0x0a,
	0x07, 0x64, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x04,
	0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x64, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x45, 0x0a,
	0x10, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x72, 0x65, 0x61, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x65, 0x64, 0x12,
	0x2c, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x60, 0x0a,
	0x0f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x50, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x06, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x52, 0x0f,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x40, 0x0a, 0x1c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x36, 0x0a, 0x14, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x3a,
	0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x12, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x23, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x62,
	0x61, 0x63, 0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x63,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x1f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x12, 0x41, 0x0a, 0x0d, 0x6b, 0x65,
	0x79, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x4b, 0x65, 0x79, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x0d,
	0x6b, 0x65, 0x79, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x4f, 0x0a,
	0x17, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b, 0x65,
	0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x45, 0x70, 0x6f, 0x63, 0x68, 0x22, 0x42, 0x0a, 0x07, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0d, 0x0a, 0x09, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46,
	0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x4b, 0x65, 0x79,
	0x5f, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x10, 0x03, 0x22, 0x2b, 0x0a, 0x0f, 0x49, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0a, 0x0a, 0x06,
	0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x61, 0x72, 0x6c,
	0x69, 0x65, 0x73, 0x74, 0x10, 0x01, 0x22, 0xe5, 0x01, 0x0a, 0x1f, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x2d, 0x0a, 0x12, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x69, 0x6e,
	0x63, 0x69, 0x70, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x2c,
	0x0a, 0x12, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x61, 0x6c, 0x41, 0x75, 0x74, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x30, 0x0a, 0x14,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x61, 0x6c, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0xb8,
	0x02, 0x0a, 0x27, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x65, 0x64, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x5c, 0x0a, 0x08, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x70, 0x75,
	0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x22, 0x25, 0x0a, 0x0a, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0b, 0x0a, 0x07, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x10, 0x01, 0x22, 0xf7, 0x02, 0x0a, 0x12, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x61, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61,
	0x6c, 0x73, 0x65, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70,
	0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x75,
	0x74, 0x68, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x41, 0x75, 0x74, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x30, 0x0a, 0x14, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x12, 0x38, 0x0a, 0x18, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x64, 0x5f,
	0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x16, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x64, 0x4c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b,
	0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x22, 0xd9, 0x03, 0x0a, 0x1a, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4c,
	0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x62, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x30,
	0x0a, 0x13, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55,
	0x72, 0x6c, 0x54, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x62, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x54, 0x6c, 0x73,
	0x12, 0x4f, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x33, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x6f, 0x6f,
	0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x12, 0x2b, 0x0a, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x0d,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x61, 0x74, 0x69, 0x76, 0x65, 0x12, 0x2f, 0x0a,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70,
	0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x40, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c,
	0x73, 0x65, 0x52, 0x16, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x22, 0x33, 0x0a, 0x0a, 0x4c, 0x6f,
	0x6f, 0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x65, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x10, 0x02, 0x22,
	0xd2, 0x04, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23,
	0x0a, 0x09, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x09, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x65, 0x64, 0x12, 0x32, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2c, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x17, 0x0a, 0x05, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x05, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x12, 0x43,
	0x0a, 0x1b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x5f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x08, 0x3a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x18, 0x75, 0x73, 0x65, 0x72, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x20, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d,
	0x6f, 0x64, 0x65, 0x3a, 0x06, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x52, 0x12, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x70, 0x6f, 0x63, 0x68,
	0x12, 0x26, 0x0a, 0x0b, 0x74, 0x78, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x0a, 0x74, 0x78,
	0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x3a, 0x0a, 0x19, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0xfd, 0x02, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x53, 0x65, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x73, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0c, 0x6e, 0x75, 0x6d, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x3a, 0x01, 0x31, 0x52,
	0x0b, 0x6e, 0x75, 0x6d, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x10,
	0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64,
	0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e,
	0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74,
	0x42, 0x69, 0x74, 0x73, 0x12, 0x31, 0x0a, 0x13, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x5f,
	0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x04, 0x3a, 0x01, 0x30, 0x52, 0x11, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x53, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x63, 0x68,
	0x75, 0x6e, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65,
	0x52, 0x07, 0x69, 0x73, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x1d, 0x0a, 0x06, 0x6d, 0x61, 0x72,
	0x6b, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65,
	0x52, 0x06, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x12, 0x3a, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70,
	0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x49, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x64, 0x22, 0xc5, 0x01, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x53, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04,
	0x52, 0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x04, 0x52, 0x0a, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x3a, 0x0a,
	0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x09,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x13, 0x68, 0x69, 0x67,
	0x68, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x11, 0x68, 0x69, 0x67, 0x68, 0x65,
	0x73, 0x74, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x22, 0x9f, 0x01, 0x0a,
	0x10, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x65, 0x6e, 0x64, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x65, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x04, 0x20, 0x02, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xdb,
	0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x3a, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x2c,
	0x0a, 0x10, 0x72, 0x65, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x01, 0x30, 0x52, 0x0f, 0x72, 0x65, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x07,
	0x61, 0x63, 0x6b, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28, 0x03, 0x52, 0x06, 0x61,
	0x63, 0x6b, 0x53, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x22, 0xeb, 0x04, 0x0a,
	0x0a, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x63, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x08,
	0x61, 0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x20,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x63, 0x6b, 0x2e, 0x41, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x07, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a, 0x0a, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x28, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x63, 0x6b, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x3a, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b, 0x65,
	0x79, 0x4c, 0x6f, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f,
	0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04,
	0x3a, 0x01, 0x30, 0x52, 0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42,
	0x69, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73,
	0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x0d, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x29, 0x0a,
	0x07, 0x41, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x6e, 0x64, 0x69,
	0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x75, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x10, 0x01, 0x22, 0x8f, 0x01, 0x0a, 0x0f, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x1e, 0x0a, 0x1a,
	0x55, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65,
	0x43, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12,
	0x44, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d,
	0x4d, 0x69, 0x73, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x65, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x04, 0x22, 0xf7, 0x01, 0x0a, 0x12, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x73,
	0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12,
	0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x62, 0x69,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d, 0x74, 0x78, 0x6e,
	0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73,
	0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0x62, 0x0a, 0x1b, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x09, 0x69, 0x73, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x08,
	0x69, 0x73, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x22, 0x56, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x46, 0x6c, 0x6f, 0x77, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0d,
	0x52, 0x0e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x73,
	0x22, 0x71, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x55, 0x6e, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x05, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53,
	0x65, 0x65, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12,
	0x30, 0x0a, 0x14, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x69, 0x6d,
	0x65, 0x22, 0x3b, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x45, 0x6e, 0x64, 0x4f, 0x66, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x22, 0x97,
	0x02, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x54, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0e, 0x32,
	0x2f, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x65, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a,
	0x0a, 0x10, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55,
	0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x30, 0x0a, 0x13, 0x62, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x54, 0x6c,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x54, 0x6c, 0x73, 0x22, 0x2a, 0x0a, 0x0c,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0c, 0x0a, 0x08,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x10, 0x01, 0x22, 0xd4, 0x01, 0x0a, 0x14, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65,
	0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x3a, 0x0a, 0x18, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x42, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x18, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x42, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x40, 0x0a,
	0x1b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x54, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x1b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x42, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x54, 0x6c, 0x73, 0x22,
	0xd4, 0x01, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x6c, 0x6f, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x18, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x55, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x55, 0x72, 0x6c, 0x12, 0x40, 0x0a, 0x1b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64,
	0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c,
	0x54, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1b, 0x61, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x55, 0x72, 0x6c, 0x54, 0x6c, 0x73, 0x22, 0xae, 0x01, 0x0a, 0x26, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x52, 0x65, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x61, 0x63, 0x6b,
	0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x3c, 0x0a, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x65, 0x70, 0x6f,
	0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x22, 0x5d, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0xff, 0x01, 0x0a, 0x16, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x3a,
	0x02, 0x2d, 0x31, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x65, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x12, 0x2b, 0x0a, 0x0e, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x79, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x3a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x72, 0x52, 0x65, 0x61, 0x64, 0x79, 0x22, 0x78, 0x0a, 0x0c, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x22, 0x0d, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x69, 0x6e,
	0x67, 0x22, 0x0d, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x6f, 0x6e, 0x67,
	0x22, 0x56, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x22, 0x98, 0x05, 0x0a, 0x1c, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70,
	0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x73, 0x67, 0x52, 0x61,
	0x74, 0x65, 0x4f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x6d, 0x73, 0x67,
	0x52, 0x61, 0x74, 0x65, 0x4f, 0x75, 0x74, 0x12, 0x2a, 0x0a, 0x10, 0x6d, 0x73, 0x67, 0x54, 0x68,
	0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74, 0x4f, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x10, 0x6d, 0x73, 0x67, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74,
	0x4f, 0x75, 0x74, 0x12, 0x2a, 0x0a, 0x10, 0x6d, 0x73, 0x67, 0x52, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x6d,
	0x73, 0x67, 0x52, 0x61, 0x74, 0x65, 0x52, 0x65, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x12,
	0x22, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x10, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x73, 0x12,
	0x28, 0x0a, 0x0f, 0x75, 0x6e, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x75, 0x6e, 0x61, 0x63, 0x6b, 0x65,
	0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x1c, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x6e, 0x55, 0x6e,
	0x61, 0x63, 0x6b, 0x65, 0x64, 0x4d, 0x73, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x1c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x4f, 0x6e, 0x55, 0x6e, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x4d, 0x73, 0x67, 0x73, 0x12, 0x18, 0x0a,
	0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x6d, 0x73, 0x67, 0x52, 0x61, 0x74, 0x65, 0x45, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0e, 0x6d, 0x73, 0x67,
	0x52, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x6d,
	0x73, 0x67, 0x42, 0x61, 0x63, 0x6b, 0x6c, 0x6f, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0a, 0x6d, 0x73, 0x67, 0x42, 0x61, 0x63, 0x6b, 0x6c, 0x6f, 0x67, 0x12, 0x26, 0x0a, 0x0e, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x63, 0x6b, 0x52, 0x61, 0x74, 0x65, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x0e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x63, 0x6b, 0x52,
	0x61, 0x74, 0x65, 0x22, 0x59, 0x0a, 0x17, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65,
	0x74, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x1f,
	0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe5,
	0x01, 0x0a, 0x1f, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x73,
	0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x43, 0x0a, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x75,
	0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x5e, 0x0a, 0x1d, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x1a, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x72, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa7, 0x02, 0x0a, 0x1b, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x4f, 0x66, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x12, 0x4e, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2e, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x73, 0x4f, 0x66, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x3a, 0x0a, 0x50, 0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x52, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x5f, 0x70, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x73, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x73, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x48, 0x61, 0x73, 0x68, 0x22, 0x33, 0x0a, 0x04, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e,
	0x54, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x53, 0x49,
	0x53, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x02,
	0x22, 0xc0, 0x01, 0x0a, 0x23, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x73, 0x4f, 0x66, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x12,
	0x21, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x5f, 0x68, 0x61, 0x73,
	0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x48,
	0x61, 0x73, 0x68, 0x12, 0x1e, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x3a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x64, 0x22, 0xbb, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x57,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a,
	0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04,
	0x52, 0x09, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x04, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x0d, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e,
	0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x48, 0x61, 0x73,
	0x68, 0x22, 0x93, 0x01, 0x0a, 0x1c, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x57, 0x61, 0x74,
	0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73,
	0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x73, 0x48, 0x61, 0x73, 0x68, 0x22, 0x9f, 0x01, 0x0a, 0x17, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x57, 0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x65, 0x77, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x65, 0x77, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x73, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x73, 0x48, 0x61, 0x73, 0x68, 0x22, 0x5a, 0x0a, 0x1a, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x57, 0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x77, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x49, 0x64, 0x22, 0x6e, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x47, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x25,
	0x0a, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xed, 0x01, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x47, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x2c, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x25,
	0x0a, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x7d, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x47, 0x65, 0x74, 0x4f, 0x72, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x2c, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x22, 0xc7, 0x01, 0x0a, 0x20, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x47, 0x65, 0x74, 0x4f, 0x72, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70,
	0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x56,
	0x0a, 0x1d, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54, 0x63, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x16,
	0x0a, 0x05, 0x74, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x3a, 0x01, 0x30,
	0x52, 0x04, 0x74, 0x63, 0x49, 0x64, 0x22, 0x8a, 0x01, 0x0a, 0x1e, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x54, 0x63, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x22, 0x71, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4e, 0x65,
	0x77, 0x54, 0x78, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x5f, 0x74, 0x74, 0x6c, 0x5f, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x0d, 0x74, 0x78, 0x6e, 0x54, 0x74, 0x6c, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x16,
	0x0a, 0x05, 0x74, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30,
	0x52, 0x04, 0x74, 0x63, 0x49, 0x64, 0x22, 0xd9, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x4e, 0x65, 0x77, 0x54, 0x78, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62,
	0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0e, 0x74, 0x78,
	0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0f,
	0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d,
	0x6f, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x64,
	0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2b,
	0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0e, 0x74, 0x78, 0x6e,
	0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0f, 0x74,
	0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f,
	0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe4, 0x01, 0x0a, 0x20, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x41, 0x64, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f,
	0x54, 0x78, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78,
	0x6e, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65,
	0x61, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64,
	0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x3a, 0x01, 0x30, 0x52, 0x0d, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69,
	0x74, 0x73, 0x12, 0x2f, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x48, 0x0a,
	0x0c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd4, 0x01, 0x0a, 0x1b, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f,
	0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04,
	0x3a, 0x01, 0x30, 0x52, 0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42,
	0x69, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73,
	0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x0d, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x3e,
	0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe7,
	0x01, 0x0a, 0x23, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6c,
	0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x3a,
	0x01, 0x30, 0x52, 0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69,
	0x74, 0x73, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73, 0x74,
	0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d,
	0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2f, 0x0a,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70,
	0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xbe, 0x01, 0x0a, 0x0d, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e,
	0x69, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61,
	0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f,
	0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a,
	0x01, 0x30, 0x52, 0x0d, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69, 0x74,
	0x73, 0x12, 0x36, 0x0a, 0x0a, 0x74, 0x78, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x78, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09,
	0x74, 0x78, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd9, 0x01, 0x0a, 0x15, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x73,
	0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12,
	0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x62, 0x69,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d, 0x74, 0x78, 0x6e,
	0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73,
	0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xa8, 0x02, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x45, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x73, 0x74,
	0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0e,
	0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x29,
	0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d, 0x74, 0x78, 0x6e, 0x69,
	0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12,
	0x36, 0x0a, 0x0a, 0x74, 0x78, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x54, 0x78, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x74, 0x78,
	0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x21, 0x74, 0x78, 0x6e, 0x69, 0x64,
	0x5f, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x6c,
	0x6f, 0x77, 0x5f, 0x77, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x1c, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69,
	0x74, 0x73, 0x4f, 0x66, 0x4c, 0x6f, 0x77, 0x57, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b,
	0x22, 0xe4, 0x01, 0x0a, 0x20, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x64, 0x54,
	0x78, 0x6e, 0x4f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6c, 0x65,
	0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01,
	0x30, 0x52, 0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69, 0x74,
	0x73, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f,
	0x62, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d, 0x74,
	0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x75,
	0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xd5, 0x02, 0x0a, 0x1b, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x45, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f,
	0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04,
	0x3a, 0x01, 0x30, 0x52, 0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42,
	0x69, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73,
	0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x0d, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x3e,
	0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36,
	0x0a, 0x0a, 0x74, 0x78, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x17, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x54, 0x78, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x74, 0x78, 0x6e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x21, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f,
	0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x6c, 0x6f,
	0x77, 0x5f, 0x77, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x1c, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42, 0x69, 0x74,
	0x73, 0x4f, 0x66, 0x4c, 0x6f, 0x77, 0x57, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x22,
	0xe7, 0x01, 0x0a, 0x23, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x64, 0x54, 0x78,
	0x6e, 0x4f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x10, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f,
	0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04,
	0x3a, 0x01, 0x30, 0x52, 0x0e, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x42,
	0x69, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0f, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x73,
	0x74, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x0d, 0x74, 0x78, 0x6e, 0x69, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2f,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e,
	0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xf8, 0x2e, 0x0a, 0x0b, 0x42, 0x61,
	0x73, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x32, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x36, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x07, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x3c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x12, 0x3c, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x52, 0x09, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x12, 0x39, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x65, 0x72, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x04,
	0x73, 0x65, 0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c,
	0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x53, 0x65, 0x6e, 0x64, 0x52, 0x04, 0x73, 0x65, 0x6e, 0x64, 0x12, 0x43, 0x0a, 0x0c, 0x73,
	0x65, 0x6e, 0x64, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x63, 0x65,
	0x69, 0x70, 0x74, 0x52, 0x0b, 0x73, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74,
	0x12, 0x3d, 0x0a, 0x0a, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x65, 0x6e, 0x64, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x36, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x2a, 0x0a, 0x03, 0x61, 0x63, 0x6b, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x63, 0x6b, 0x52, 0x03,
	0x61, 0x63, 0x6b, 0x12, 0x2d, 0x0a, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x04, 0x66, 0x6c,
	0x6f, 0x77, 0x12, 0x42, 0x0a, 0x0b, 0x75, 0x6e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x55, 0x6e,
	0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x52, 0x0b, 0x75, 0x6e, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x36, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x75,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x30,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x49, 0x0a, 0x0e, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x65, 0x72, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x43,
	0x6c, 0x6f, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x52, 0x0d, 0x63, 0x6c,
	0x6f, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x12, 0x49, 0x0a, 0x0e, 0x63,
	0x6c, 0x6f, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x43,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x52, 0x0d, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x12, 0x4f, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x65, 0x72, 0x5f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x53,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x2d, 0x0a, 0x04, 0x70, 0x69, 0x6e, 0x67, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x69, 0x6e, 0x67,
	0x52, 0x04, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x2d, 0x0a, 0x04, 0x70, 0x6f, 0x6e, 0x67, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x6f, 0x6e, 0x67, 0x52,
	0x04, 0x70, 0x6f, 0x6e, 0x67, 0x12, 0x7e, 0x0a, 0x1f, 0x72, 0x65, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x55, 0x6e, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x64,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x55, 0x6e,
	0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x52, 0x1f, 0x72, 0x65, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x55,
	0x6e, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x64, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x65, 0x64, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x73, 0x0a, 0x19, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x19, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x6c, 0x6f, 0x6f, 0x6b, 0x75,
	0x70, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x70,
	0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x0b,
	0x6c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x5a, 0x0a, 0x13, 0x6c,
	0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4c,
	0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x52, 0x13, 0x6c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x60, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x15, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x11, 0x72, 0x65, 0x61, 0x63, 0x68, 0x65, 0x64, 0x45, 0x6e,
	0x64, 0x4f, 0x66, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x61, 0x63, 0x68, 0x65, 0x64, 0x45, 0x6e, 0x64, 0x4f,
	0x66, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x11, 0x72, 0x65, 0x61, 0x63, 0x68, 0x65, 0x64, 0x45,
	0x6e, 0x64, 0x4f, 0x66, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x2d, 0x0a, 0x04, 0x73, 0x65, 0x65,
	0x6b, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x65,
	0x65, 0x6b, 0x52, 0x04, 0x73, 0x65, 0x65, 0x6b, 0x12, 0x51, 0x0a, 0x10, 0x67, 0x65, 0x74, 0x4c,
	0x61, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x18, 0x1d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x73, 0x74,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x52, 0x10, 0x67, 0x65, 0x74, 0x4c, 0x61,
	0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x69, 0x0a, 0x18, 0x67,
	0x65, 0x74, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x18, 0x67, 0x65,
	0x74, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a, 0x16, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x14, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x5d, 0x0a, 0x14, 0x67, 0x65, 0x74, 0x54, 0x6f,
	0x70, 0x69, 0x63, 0x73, 0x4f, 0x66, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18,
	0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x73, 0x4f, 0x66, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x52, 0x14, 0x67, 0x65, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x4f, 0x66, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x75, 0x0a, 0x1c, 0x67, 0x65, 0x74, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x73, 0x4f, 0x66, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x70,
	0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x4f, 0x66, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52,
	0x1c, 0x67, 0x65, 0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x4f, 0x66, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a,
	0x09, 0x67, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x52, 0x09, 0x67, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x54, 0x0a, 0x11, 0x67,
	0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x11,
	0x67, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x48, 0x0a, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e,
	0x67, 0x65, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41,
	0x75, 0x74, 0x68, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52, 0x0d, 0x61, 0x75,
	0x74, 0x68, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x12, 0x45, 0x0a, 0x0c, 0x61,
	0x75, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x25, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x75, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x63,
	0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0b, 0x61, 0x63, 0x6b, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x11, 0x67, 0x65, 0x74, 0x4f, 0x72, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x27, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x11, 0x67, 0x65, 0x74, 0x4f, 0x72,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x6c, 0x0a, 0x19,
	0x67, 0x65, 0x74, 0x4f, 0x72, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52,
	0x19, 0x67, 0x65, 0x74, 0x4f, 0x72, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x6e, 0x65,
	0x77, 0x54, 0x78, 0x6e, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c,
	0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x4e, 0x65, 0x77, 0x54, 0x78, 0x6e, 0x52, 0x06, 0x6e, 0x65, 0x77, 0x54, 0x78, 0x6e, 0x12,
	0x4b, 0x0a, 0x0e, 0x6e, 0x65, 0x77, 0x54, 0x78, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x18, 0x33, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4e, 0x65,
	0x77, 0x54, 0x78, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0e, 0x6e, 0x65,
	0x77, 0x54, 0x78, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x11,
	0x61, 0x64, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78,
	0x6e, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x64,
	0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x52,
	0x11, 0x61, 0x64, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54,
	0x78, 0x6e, 0x12, 0x6c, 0x0a, 0x19, 0x61, 0x64, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18,
	0x35, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x19, 0x61, 0x64, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5d, 0x0a, 0x14, 0x61, 0x64, 0x64, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x18, 0x36, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x52, 0x14, 0x61, 0x64, 0x64, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x12,
	0x75, 0x0a, 0x1c, 0x61, 0x64, 0x64, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18,
	0x37, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x1c, 0x61, 0x64, 0x64, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x54, 0x78, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x65, 0x6e, 0x64, 0x54, 0x78, 0x6e,
	0x18, 0x38, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x64,
	0x54, 0x78, 0x6e, 0x52, 0x06, 0x65, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x12, 0x4b, 0x0a, 0x0e, 0x65,
	0x6e, 0x64, 0x54, 0x78, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x39, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x64, 0x54, 0x78, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0e, 0x65, 0x6e, 0x64, 0x54, 0x78, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x11, 0x65, 0x6e, 0x64, 0x54,
	0x78, 0x6e, 0x4f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x3a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x64, 0x54, 0x78, 0x6e,
	0x4f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x65, 0x6e, 0x64,
	0x54, 0x78, 0x6e, 0x4f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c,
	0x0a, 0x19, 0x65, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x3b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x52, 0x19, 0x65, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x14,
	0x65, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x70, 0x75, 0x6c,
	0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x45, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x65, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x75, 0x0a, 0x1c, 0x65,
	0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x3d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x52, 0x1c, 0x65, 0x6e, 0x64, 0x54, 0x78, 0x6e, 0x4f, 0x6e, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x63, 0x0a, 0x16, 0x74, 0x63, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x3e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54, 0x63, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x16, 0x74, 0x63, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x66, 0x0a, 0x17, 0x74, 0x63, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x18, 0x3f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54,
	0x63, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x17, 0x74, 0x63, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4b, 0x0a, 0x0e, 0x77, 0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73,
	0x74, 0x18, 0x40, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x57, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x0e, 0x77, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x15,
	0x77, 0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x41, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x70, 0x75,
	0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x57, 0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x15, 0x77, 0x61, 0x74, 0x63, 0x68, 0x54, 0x6f,
	0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x51,
	0x0a, 0x10, 0x77, 0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x42, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x57,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52,
	0x10, 0x77, 0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x12, 0x5a, 0x0a, 0x13, 0x77, 0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x18, 0x43, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x57, 0x61, 0x74, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x52, 0x13, 0x77, 0x61, 0x74, 0x63, 0x68, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x12, 0x48, 0x0a,
	0x0d, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x18, 0x44,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x52, 0x0d, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x22, 0x9a, 0x0a, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x50,
	0x52, 0x4f, 0x44, 0x55, 0x43, 0x45, 0x52, 0x10, 0x05, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x45, 0x4e,
	0x44, 0x10, 0x06, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x45, 0x4e, 0x44, 0x5f, 0x52, 0x45, 0x43, 0x45,
	0x49, 0x50, 0x54, 0x10, 0x07, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x45, 0x4e, 0x44, 0x5f, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45,
	0x10, 0x09, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x43, 0x4b, 0x10, 0x0a, 0x12, 0x08, 0x0a, 0x04, 0x46,
	0x4c, 0x4f, 0x57, 0x10, 0x0b, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x55, 0x42, 0x53, 0x43,
	0x52, 0x49, 0x42, 0x45, 0x10, 0x0c, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x10, 0x0d, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x0e, 0x12, 0x12,
	0x0a, 0x0e, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x45, 0x52,
	0x10, 0x0f, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x53,
	0x55, 0x4d, 0x45, 0x52, 0x10, 0x10, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43,
	0x45, 0x52, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x11, 0x12, 0x08, 0x0a, 0x04,
	0x50, 0x49, 0x4e, 0x47, 0x10, 0x12, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x4f, 0x4e, 0x47, 0x10, 0x13,
	0x12, 0x25, 0x0a, 0x21, 0x52, 0x45, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x5f, 0x55, 0x4e,
	0x41, 0x43, 0x4b, 0x4e, 0x4f, 0x57, 0x4c, 0x45, 0x44, 0x47, 0x45, 0x44, 0x5f, 0x4d, 0x45, 0x53,
	0x53, 0x41, 0x47, 0x45, 0x53, 0x10, 0x14, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x41, 0x52, 0x54, 0x49,
	0x54, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x10,
	0x15, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x45, 0x44,
	0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e,
	0x53, 0x45, 0x10, 0x16, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x4f, 0x4f, 0x4b, 0x55, 0x50, 0x10, 0x17,
	0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x4f, 0x4f, 0x4b, 0x55, 0x50, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f,
	0x4e, 0x53, 0x45, 0x10, 0x18, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45,
	0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x53, 0x10, 0x19, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4f, 0x4e,
	0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x53, 0x5f, 0x52, 0x45, 0x53, 0x50,
	0x4f, 0x4e, 0x53, 0x45, 0x10, 0x1a, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x41, 0x43, 0x48, 0x45,
	0x44, 0x5f, 0x45, 0x4e, 0x44, 0x5f, 0x4f, 0x46, 0x5f, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x10, 0x1b,
	0x12, 0x08, 0x0a, 0x04, 0x53, 0x45, 0x45, 0x4b, 0x10, 0x1c, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x45,
	0x54, 0x5f, 0x4c, 0x41, 0x53, 0x54, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x49,
	0x44, 0x10, 0x1d, 0x12, 0x20, 0x0a, 0x1c, 0x47, 0x45, 0x54, 0x5f, 0x4c, 0x41, 0x53, 0x54, 0x5f,
	0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f,
	0x4e, 0x53, 0x45, 0x10, 0x1e, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f,
	0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x10,
	0x1f, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x45, 0x54, 0x5f, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x53, 0x5f,
	0x4f, 0x46, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x10, 0x20, 0x12, 0x24,
	0x0a, 0x20, 0x47, 0x45, 0x54, 0x5f, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x53, 0x5f, 0x4f, 0x46, 0x5f,
	0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e,
	0x53, 0x45, 0x10, 0x21, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x45, 0x54, 0x5f, 0x53, 0x43, 0x48, 0x45,
	0x4d, 0x41, 0x10, 0x22, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x45, 0x54, 0x5f, 0x53, 0x43, 0x48, 0x45,
	0x4d, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x23, 0x12, 0x12, 0x0a,
	0x0e, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x41, 0x4c, 0x4c, 0x45, 0x4e, 0x47, 0x45, 0x10,
	0x24, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e,
	0x53, 0x45, 0x10, 0x25, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x43, 0x4b, 0x5f, 0x52, 0x45, 0x53, 0x50,
	0x4f, 0x4e, 0x53, 0x45, 0x10, 0x26, 0x12, 0x18, 0x0a, 0x14, 0x47, 0x45, 0x54, 0x5f, 0x4f, 0x52,
	0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x10, 0x27,
	0x12, 0x21, 0x0a, 0x1d, 0x47, 0x45, 0x54, 0x5f, 0x4f, 0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53,
	0x45, 0x10, 0x28, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x45, 0x57, 0x5f, 0x54, 0x58, 0x4e, 0x10, 0x32,
	0x12, 0x14, 0x0a, 0x10, 0x4e, 0x45, 0x57, 0x5f, 0x54, 0x58, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x50,
	0x4f, 0x4e, 0x53, 0x45, 0x10, 0x33, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x44, 0x44, 0x5f, 0x50, 0x41,
	0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x4f, 0x5f, 0x54, 0x58, 0x4e, 0x10, 0x34,
	0x12, 0x21, 0x0a, 0x1d, 0x41, 0x44, 0x44, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x54, 0x4f, 0x5f, 0x54, 0x58, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53,
	0x45, 0x10, 0x35, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x44, 0x44, 0x5f, 0x53, 0x55, 0x42, 0x53, 0x43,
	0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x4f, 0x5f, 0x54, 0x58, 0x4e, 0x10, 0x36,
	0x12, 0x24, 0x0a, 0x20, 0x41, 0x44, 0x44, 0x5f, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x50,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x4f, 0x5f, 0x54, 0x58, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x50,
	0x4f, 0x4e, 0x53, 0x45, 0x10, 0x37, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x58,
	0x4e, 0x10, 0x38, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x58, 0x4e, 0x5f, 0x52,
	0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x39, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x44,
	0x5f, 0x54, 0x58, 0x4e, 0x5f, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x3a, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x58, 0x4e, 0x5f, 0x4f,
	0x4e, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x50,
	0x4f, 0x4e, 0x53, 0x45, 0x10, 0x3b, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x58,
	0x4e, 0x5f, 0x4f, 0x4e, 0x5f, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x3c, 0x12, 0x24, 0x0a, 0x20, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x58, 0x4e, 0x5f, 0x4f,
	0x4e, 0x5f, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52,
	0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x3d, 0x12, 0x1d, 0x0a, 0x19, 0x54, 0x43, 0x5f,
	0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x5f, 0x52,
	0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x3e, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x43, 0x5f, 0x43,
	0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x5f, 0x52, 0x45,
	0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x3f, 0x12, 0x14, 0x0a, 0x10, 0x57, 0x41, 0x54, 0x43,
	0x48, 0x5f, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x40, 0x12, 0x1c,
	0x0a, 0x18, 0x57, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x5f, 0x4c, 0x49,
	0x53, 0x54, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x41, 0x12, 0x16, 0x0a, 0x12,
	0x57, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x5f, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x10, 0x42, 0x12, 0x1a, 0x0a, 0x16, 0x57, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x4f,
	0x50, 0x49, 0x43, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x10, 0x43,
	0x12, 0x12, 0x0a, 0x0e, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x44, 0x2a, 0x44, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10,
	0x00, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x5a, 0x34, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x5a, 0x4c,
	0x49, 0x42, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x5a, 0x53, 0x54, 0x44, 0x10, 0x03, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x4e, 0x41, 0x50, 0x50, 0x59, 0x10, 0x04, 0x2a, 0x5f, 0x0a, 0x12, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x0a, 0x0a, 0x06, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x57,
	0x61, 0x69, 0x74, 0x46, 0x6f, 0x72, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x10,
	0x02, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x57, 0x69,
	0x74, 0x68, 0x46, 0x65, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x10, 0x03, 0x2a, 0x82, 0x05, 0x0a, 0x0b,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x10, 0x0a, 0x0c, 0x55,
	0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x00, 0x12, 0x11, 0x0a,
	0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x01,
	0x12, 0x14, 0x0a, 0x10, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x03, 0x12,
	0x16, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x42, 0x75, 0x73, 0x79, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x52, 0x65, 0x61, 0x64, 0x79, 0x10, 0x06, 0x12, 0x25,
	0x0a, 0x21, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x65,
	0x64, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x45, 0x78, 0x63, 0x65, 0x65, 0x64, 0x65, 0x64, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x10, 0x07, 0x12, 0x29, 0x0a, 0x25, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65,
	0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x45, 0x78, 0x63,
	0x65, 0x65, 0x64, 0x65, 0x64, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x10, 0x08,
	0x12, 0x11, 0x0a, 0x0d, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x10, 0x09, 0x12, 0x1b, 0x0a, 0x17, 0x55, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x0a,
	0x12, 0x11, 0x0a, 0x0d, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e,
	0x64, 0x10, 0x0b, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x10, 0x0c, 0x12, 0x14, 0x0a,
	0x10, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e,
	0x64, 0x10, 0x0d, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x6f, 0x6f, 0x4d, 0x61, 0x6e, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x10, 0x0e, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x10, 0x0f, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x42, 0x75,
	0x73, 0x79, 0x10, 0x10, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x10, 0x11, 0x12, 0x16, 0x0a, 0x12, 0x49, 0x6e,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x10, 0x12, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x13, 0x12, 0x22, 0x0a, 0x1e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69,
	0x6e, 0x61, 0x74, 0x6f, 0x72, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x10, 0x14, 0x12,
	0x14, 0x0a, 0x10, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x54, 0x78, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x10, 0x15, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x6f, 0x74, 0x41, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x16, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63,
	0x74, 0x10, 0x17, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x10, 0x18, 0x12, 0x12, 0x0a, 0x0e,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x46, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x10, 0x19,
	0x2a, 0x4b, 0x0a, 0x0a, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x12,
	0x0a, 0x0e, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4e, 0x6f, 0x6e, 0x65,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x59, 0x63, 0x61, 0x56, 0x31, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x75, 0x74, 0x68, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x74, 0x68, 0x65, 0x6e, 0x73, 0x10, 0x02, 0x2a, 0xc4, 0x01,
	0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x06, 0x0a, 0x02, 0x76, 0x30, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x76, 0x31, 0x10,
	0x01, 0x12, 0x06, 0x0a, 0x02, 0x76, 0x32, 0x10, 0x02, 0x12, 0x06, 0x0a, 0x02, 0x76, 0x33, 0x10,
	0x03, 0x12, 0x06, 0x0a, 0x02, 0x76, 0x34, 0x10, 0x04, 0x12, 0x06, 0x0a, 0x02, 0x76, 0x35, 0x10,
	0x05, 0x12, 0x06, 0x0a, 0x02, 0x76, 0x36, 0x10, 0x06, 0x12, 0x06, 0x0a, 0x02, 0x76, 0x37, 0x10,
	0x07, 0x12, 0x06, 0x0a, 0x02, 0x76, 0x38, 0x10, 0x08, 0x12, 0x06, 0x0a, 0x02, 0x76, 0x39, 0x10,
	0x09, 0x12, 0x07, 0x0a, 0x03, 0x76, 0x31, 0x30, 0x10, 0x0a, 0x12, 0x07, 0x0a, 0x03, 0x76, 0x31,
	0x31, 0x10, 0x0b, 0x12, 0x07, 0x0a, 0x03, 0x76, 0x31, 0x32, 0x10, 0x0c, 0x12, 0x07, 0x0a, 0x03,
	0x76, 0x31, 0x33, 0x10, 0x0d, 0x12, 0x07, 0x0a, 0x03, 0x76, 0x31, 0x34, 0x10, 0x0e, 0x12, 0x07,
	0x0a, 0x03, 0x76, 0x31, 0x35, 0x10, 0x0f, 0x12, 0x07, 0x0a, 0x03, 0x76, 0x31, 0x36, 0x10, 0x10,
	0x12, 0x07, 0x0a, 0x03, 0x76, 0x31, 0x37, 0x10, 0x11, 0x12, 0x07, 0x0a, 0x03, 0x76, 0x31, 0x38,
	0x10, 0x12, 0x12, 0x07, 0x0a, 0x03, 0x76, 0x31, 0x39, 0x10, 0x13, 0x12, 0x07, 0x0a, 0x03, 0x76,
	0x32, 0x30, 0x10, 0x14, 0x2a, 0x2b, 0x0a, 0x0d, 0x4b, 0x65, 0x79, 0x53, 0x68, 0x61, 0x72, 0x65,
	0x64, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x53, 0x50,
	0x4c, 0x49, 0x54, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x49, 0x43, 0x4b, 0x59, 0x10,
	0x01, 0x2a, 0x22, 0x0a, 0x09, 0x54, 0x78, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0a,
	0x0a, 0x06, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x42,
	0x4f, 0x52, 0x54, 0x10, 0x01, 0x42, 0x2f, 0x0a, 0x22, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x48, 0x03, 0x5a, 0x07, 0x2e,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
}

var (
	file_PulsarApi_proto_rawDescOnce sync.Once
	file_PulsarApi_proto_rawDescData = file_PulsarApi_proto_rawDesc
)

func file_PulsarApi_proto_rawDescGZIP() []byte {
	file_PulsarApi_proto_rawDescOnce.Do(func() {
		file_PulsarApi_proto_rawDescData = protoimpl.X.CompressGZIP(file_PulsarApi_proto_rawDescData)
	})
	return file_PulsarApi_proto_rawDescData
}

var file_PulsarApi_proto_enumTypes = make([]protoimpl.EnumInfo, 17)
var file_PulsarApi_proto_msgTypes = make([]protoimpl.MessageInfo, 72)
var file_PulsarApi_proto_goTypes = []interface{}{
	(CompressionType)(0),                  // 0: pulsar.proto.CompressionType
	(ProducerAccessMode)(0),               // 1: pulsar.proto.ProducerAccessMode
	(ServerError)(0),                      // 2: pulsar.proto.ServerError
	(AuthMethod)(0),                       // 3: pulsar.proto.AuthMethod
	(ProtocolVersion)(0),                  // 4: pulsar.proto.ProtocolVersion
	(KeySharedMode)(0),                    // 5: pulsar.proto.KeySharedMode
	(TxnAction)(0),                        // 6: pulsar.proto.TxnAction
	(Schema_Type)(0),                      // 7: pulsar.proto.Schema.Type
	(CommandSubscribe_SubType)(0),         // 8: pulsar.proto.CommandSubscribe.SubType
	(CommandSubscribe_InitialPosition)(0), // 9: pulsar.proto.CommandSubscribe.InitialPosition
	(CommandPartitionedTopicMetadataResponse_LookupType)(0), // 10: pulsar.proto.CommandPartitionedTopicMetadataResponse.LookupType
	(CommandLookupTopicResponse_LookupType)(0),              // 11: pulsar.proto.CommandLookupTopicResponse.LookupType
	(CommandAck_AckType)(0),                                 // 12: pulsar.proto.CommandAck.AckType
	(CommandAck_ValidationError)(0),                         // 13: pulsar.proto.CommandAck.ValidationError
	(CommandTopicMigrated_ResourceType)(0),                  // 14: pulsar.proto.CommandTopicMigrated.ResourceType
	(CommandGetTopicsOfNamespace_Mode)(0),                   // 15: pulsar.proto.CommandGetTopicsOfNamespace.Mode
	(BaseCommand_Type)(0),                                   // 16: pulsar.proto.BaseCommand.Type
	(*Schema)(nil),                                          // 17: pulsar.proto.Schema
	(*MessageIdData)(nil),                                   // 18: pulsar.proto.MessageIdData
	(*KeyValue)(nil),                                        // 19: pulsar.proto.KeyValue
	(*KeyLongValue)(nil),                                    // 20: pulsar.proto.KeyLongValue
	(*IntRange)(nil),                                        // 21: pulsar.proto.IntRange
	(*EncryptionKeys)(nil),                                  // 22: pulsar.proto.EncryptionKeys
	(*MessageMetadata)(nil),                                 // 23: pulsar.proto.MessageMetadata
	(*SingleMessageMetadata)(nil),                           // 24: pulsar.proto.SingleMessageMetadata
	(*BrokerEntryMetadata)(nil),                             // 25: pulsar.proto.BrokerEntryMetadata
	(*CommandConnect)(nil),                                  // 26: pulsar.proto.CommandConnect
	(*FeatureFlags)(nil),                                    // 27: pulsar.proto.FeatureFlags
	(*CommandConnected)(nil),                                // 28: pulsar.proto.CommandConnected
	(*CommandAuthResponse)(nil),                             // 29: pulsar.proto.CommandAuthResponse
	(*CommandAuthChallenge)(nil),                            // 30: pulsar.proto.CommandAuthChallenge
	(*AuthData)(nil),                                        // 31: pulsar.proto.AuthData
	(*KeySharedMeta)(nil),                                   // 32: pulsar.proto.KeySharedMeta
	(*CommandSubscribe)(nil),                                // 33: pulsar.proto.CommandSubscribe
	(*CommandPartitionedTopicMetadata)(nil),                 // 34: pulsar.proto.CommandPartitionedTopicMetadata
	(*CommandPartitionedTopicMetadataResponse)(nil),         // 35: pulsar.proto.CommandPartitionedTopicMetadataResponse
	(*CommandLookupTopic)(nil),                              // 36: pulsar.proto.CommandLookupTopic
	(*CommandLookupTopicResponse)(nil),                      // 37: pulsar.proto.CommandLookupTopicResponse
	(*CommandProducer)(nil),                                 // 38: pulsar.proto.CommandProducer
	(*CommandSend)(nil),                                     // 39: pulsar.proto.CommandSend
	(*CommandSendReceipt)(nil),                              // 40: pulsar.proto.CommandSendReceipt
	(*CommandSendError)(nil),                                // 41: pulsar.proto.CommandSendError
	(*CommandMessage)(nil),                                  // 42: pulsar.proto.CommandMessage
	(*CommandAck)(nil),                                      // 43: pulsar.proto.CommandAck
	(*CommandAckResponse)(nil),                              // 44: pulsar.proto.CommandAckResponse
	(*CommandActiveConsumerChange)(nil),                     // 45: pulsar.proto.CommandActiveConsumerChange
	(*CommandFlow)(nil),                                     // 46: pulsar.proto.CommandFlow
	(*CommandUnsubscribe)(nil),                              // 47: pulsar.proto.CommandUnsubscribe
	(*CommandSeek)(nil),                                     // 48: pulsar.proto.CommandSeek
	(*CommandReachedEndOfTopic)(nil),                        // 49: pulsar.proto.CommandReachedEndOfTopic
	(*CommandTopicMigrated)(nil),                            // 50: pulsar.proto.CommandTopicMigrated
	(*CommandCloseProducer)(nil),                            // 51: pulsar.proto.CommandCloseProducer
	(*CommandCloseConsumer)(nil),                            // 52: pulsar.proto.CommandCloseConsumer
	(*CommandRedeliverUnacknowledgedMessages)(nil),          // 53: pulsar.proto.CommandRedeliverUnacknowledgedMessages
	(*CommandSuccess)(nil),                                  // 54: pulsar.proto.CommandSuccess
	(*CommandProducerSuccess)(nil),                          // 55: pulsar.proto.CommandProducerSuccess
	(*CommandError)(nil),                                    // 56: pulsar.proto.CommandError
	(*CommandPing)(nil),                                     // 57: pulsar.proto.CommandPing
	(*CommandPong)(nil),                                     // 58: pulsar.proto.CommandPong
	(*CommandConsumerStats)(nil),                            // 59: pulsar.proto.CommandConsumerStats
	(*CommandConsumerStatsResponse)(nil),                    // 60: pulsar.proto.CommandConsumerStatsResponse
	(*CommandGetLastMessageId)(nil),                         // 61: pulsar.proto.CommandGetLastMessageId
	(*CommandGetLastMessageIdResponse)(nil),                 // 62: pulsar.proto.CommandGetLastMessageIdResponse
	(*CommandGetTopicsOfNamespace)(nil),                     // 63: pulsar.proto.CommandGetTopicsOfNamespace
	(*CommandGetTopicsOfNamespaceResponse)(nil),             // 64: pulsar.proto.CommandGetTopicsOfNamespaceResponse
	(*CommandWatchTopicList)(nil),                           // 65: pulsar.proto.CommandWatchTopicList
	(*CommandWatchTopicListSuccess)(nil),                    // 66: pulsar.proto.CommandWatchTopicListSuccess
	(*CommandWatchTopicUpdate)(nil),                         // 67: pulsar.proto.CommandWatchTopicUpdate
	(*CommandWatchTopicListClose)(nil),                      // 68: pulsar.proto.CommandWatchTopicListClose
	(*CommandGetSchema)(nil),                                // 69: pulsar.proto.CommandGetSchema
	(*CommandGetSchemaResponse)(nil),                        // 70: pulsar.proto.CommandGetSchemaResponse
	(*CommandGetOrCreateSchema)(nil),                        // 71: pulsar.proto.CommandGetOrCreateSchema
	(*CommandGetOrCreateSchemaResponse)(nil),                // 72: pulsar.proto.CommandGetOrCreateSchemaResponse
	(*CommandTcClientConnectRequest)(nil),                   // 73: pulsar.proto.CommandTcClientConnectRequest
	(*CommandTcClientConnectResponse)(nil),                  // 74: pulsar.proto.CommandTcClientConnectResponse
	(*CommandNewTxn)(nil),                                   // 75: pulsar.proto.CommandNewTxn
	(*CommandNewTxnResponse)(nil),                           // 76: pulsar.proto.CommandNewTxnResponse
	(*CommandAddPartitionToTxn)(nil),                        // 77: pulsar.proto.CommandAddPartitionToTxn
	(*CommandAddPartitionToTxnResponse)(nil),                // 78: pulsar.proto.CommandAddPartitionToTxnResponse
	(*Subscription)(nil),                                    // 79: pulsar.proto.Subscription
	(*CommandAddSubscriptionToTxn)(nil),                     // 80: pulsar.proto.CommandAddSubscriptionToTxn
	(*CommandAddSubscriptionToTxnResponse)(nil),             // 81: pulsar.proto.CommandAddSubscriptionToTxnResponse
	(*CommandEndTxn)(nil),                                   // 82: pulsar.proto.CommandEndTxn
	(*CommandEndTxnResponse)(nil),                           // 83: pulsar.proto.CommandEndTxnResponse
	(*CommandEndTxnOnPartition)(nil),                        // 84: pulsar.proto.CommandEndTxnOnPartition
	(*CommandEndTxnOnPartitionResponse)(nil),                // 85: pulsar.proto.CommandEndTxnOnPartitionResponse
	(*CommandEndTxnOnSubscription)(nil),                     // 86: pulsar.proto.CommandEndTxnOnSubscription
	(*CommandEndTxnOnSubscriptionResponse)(nil),             // 87: pulsar.proto.CommandEndTxnOnSubscriptionResponse
	(*BaseCommand)(nil),                                     // 88: pulsar.proto.BaseCommand
}
var file_PulsarApi_proto_depIdxs = []int32{
	7,   // 0: pulsar.proto.Schema.type:type_name -> pulsar.proto.Schema.Type
	19,  // 1: pulsar.proto.Schema.properties:type_name -> pulsar.proto.KeyValue
	18,  // 2: pulsar.proto.MessageIdData.first_chunk_message_id:type_name -> pulsar.proto.MessageIdData
	19,  // 3: pulsar.proto.EncryptionKeys.metadata:type_name -> pulsar.proto.KeyValue
	19,  // 4: pulsar.proto.MessageMetadata.properties:type_name -> pulsar.proto.KeyValue
	0,   // 5: pulsar.proto.MessageMetadata.compression:type_name -> pulsar.proto.CompressionType
	22,  // 6: pulsar.proto.MessageMetadata.encryption_keys:type_name -> pulsar.proto.EncryptionKeys
	19,  // 7: pulsar.proto.SingleMessageMetadata.properties:type_name -> pulsar.proto.KeyValue
	3,   // 8: pulsar.proto.CommandConnect.auth_method:type_name -> pulsar.proto.AuthMethod
	27,  // 9: pulsar.proto.CommandConnect.feature_flags:type_name -> pulsar.proto.FeatureFlags
	27,  // 10: pulsar.proto.CommandConnected.feature_flags:type_name -> pulsar.proto.FeatureFlags
	31,  // 11: pulsar.proto.CommandAuthResponse.response:type_name -> pulsar.proto.AuthData
	31,  // 12: pulsar.proto.CommandAuthChallenge.challenge:type_name -> pulsar.proto.AuthData
	5,   // 13: pulsar.proto.KeySharedMeta.keySharedMode:type_name -> pulsar.proto.KeySharedMode
	21,  // 14: pulsar.proto.KeySharedMeta.hashRanges:type_name -> pulsar.proto.IntRange
	8,   // 15: pulsar.proto.CommandSubscribe.subType:type_name -> pulsar.proto.CommandSubscribe.SubType
	18,  // 16: pulsar.proto.CommandSubscribe.start_message_id:type_name -> pulsar.proto.MessageIdData
	19,  // 17: pulsar.proto.CommandSubscribe.metadata:type_name -> pulsar.proto.KeyValue
	17,  // 18: pulsar.proto.CommandSubscribe.schema:type_name -> pulsar.proto.Schema
	9,   // 19: pulsar.proto.CommandSubscribe.initialPosition:type_name -> pulsar.proto.CommandSubscribe.InitialPosition
	32,  // 20: pulsar.proto.CommandSubscribe.keySharedMeta:type_name -> pulsar.proto.KeySharedMeta
	19,  // 21: pulsar.proto.CommandSubscribe.subscription_properties:type_name -> pulsar.proto.KeyValue
	10,  // 22: pulsar.proto.CommandPartitionedTopicMetadataResponse.response:type_name -> pulsar.proto.CommandPartitionedTopicMetadataResponse.LookupType
	2,   // 23: pulsar.proto.CommandPartitionedTopicMetadataResponse.error:type_name -> pulsar.proto.ServerError
	19,  // 24: pulsar.proto.CommandLookupTopic.properties:type_name -> pulsar.proto.KeyValue
	11,  // 25: pulsar.proto.CommandLookupTopicResponse.response:type_name -> pulsar.proto.CommandLookupTopicResponse.LookupType
	2,   // 26: pulsar.proto.CommandLookupTopicResponse.error:type_name -> pulsar.proto.ServerError
	19,  // 27: pulsar.proto.CommandProducer.metadata:type_name -> pulsar.proto.KeyValue
	17,  // 28: pulsar.proto.CommandProducer.schema:type_name -> pulsar.proto.Schema
	1,   // 29: pulsar.proto.CommandProducer.producer_access_mode:type_name -> pulsar.proto.ProducerAccessMode
	18,  // 30: pulsar.proto.CommandSend.message_id:type_name -> pulsar.proto.MessageIdData
	18,  // 31: pulsar.proto.CommandSendReceipt.message_id:type_name -> pulsar.proto.MessageIdData
	2,   // 32: pulsar.proto.CommandSendError.error:type_name -> pulsar.proto.ServerError
	18,  // 33: pulsar.proto.CommandMessage.message_id:type_name -> pulsar.proto.MessageIdData
	12,  // 34: pulsar.proto.CommandAck.ack_type:type_name -> pulsar.proto.CommandAck.AckType
	18,  // 35: pulsar.proto.CommandAck.message_id:type_name -> pulsar.proto.MessageIdData
	13,  // 36: pulsar.proto.CommandAck.validation_error:type_name -> pulsar.proto.CommandAck.ValidationError
	20,  // 37: pulsar.proto.CommandAck.properties:type_name -> pulsar.proto.KeyLongValue
	2,   // 38: pulsar.proto.CommandAckResponse.error:type_name -> pulsar.proto.ServerError
	18,  // 39: pulsar.proto.CommandSeek.message_id:type_name -> pulsar.proto.MessageIdData
	14,  // 40: pulsar.proto.CommandTopicMigrated.resource_type:type_name -> pulsar.proto.CommandTopicMigrated.ResourceType
	18,  // 41: pulsar.proto.CommandRedeliverUnacknowledgedMessages.message_ids:type_name -> pulsar.proto.MessageIdData
	17,  // 42: pulsar.proto.CommandSuccess.schema:type_name -> pulsar.proto.Schema
	2,   // 43: pulsar.proto.CommandError.error:type_name -> pulsar.proto.ServerError
	2,   // 44: pulsar.proto.CommandConsumerStatsResponse.error_code:type_name -> pulsar.proto.ServerError
	18,  // 45: pulsar.proto.CommandGetLastMessageIdResponse.last_message_id:type_name -> pulsar.proto.MessageIdData
	18,  // 46: pulsar.proto.CommandGetLastMessageIdResponse.consumer_mark_delete_position:type_name -> pulsar.proto.MessageIdData
	15,  // 47: pulsar.proto.CommandGetTopicsOfNamespace.mode:type_name -> pulsar.proto.CommandGetTopicsOfNamespace.Mode
	2,   // 48: pulsar.proto.CommandGetSchemaResponse.error_code:type_name -> pulsar.proto.ServerError
	17,  // 49: pulsar.proto.CommandGetSchemaResponse.schema:type_name -> pulsar.proto.Schema
	17,  // 50: pulsar.proto.CommandGetOrCreateSchema.schema:type_name -> pulsar.proto.Schema
	2,   // 51: pulsar.proto.CommandGetOrCreateSchemaResponse.error_code:type_name -> pulsar.proto.ServerError
	2,   // 52: pulsar.proto.CommandTcClientConnectResponse.error:type_name -> pulsar.proto.ServerError
	2,   // 53: pulsar.proto.CommandNewTxnResponse.error:type_name -> pulsar.proto.ServerError
	2,   // 54: pulsar.proto.CommandAddPartitionToTxnResponse.error:type_name -> pulsar.proto.ServerError
	79,  // 55: pulsar.proto.CommandAddSubscriptionToTxn.subscription:type_name -> pulsar.proto.Subscription
	2,   // 56: pulsar.proto.CommandAddSubscriptionToTxnResponse.error:type_name -> pulsar.proto.ServerError
	6,   // 57: pulsar.proto.CommandEndTxn.txn_action:type_name -> pulsar.proto.TxnAction
	2,   // 58: pulsar.proto.CommandEndTxnResponse.error:type_name -> pulsar.proto.ServerError
	6,   // 59: pulsar.proto.CommandEndTxnOnPartition.txn_action:type_name -> pulsar.proto.TxnAction
	2,   // 60: pulsar.proto.CommandEndTxnOnPartitionResponse.error:type_name -> pulsar.proto.ServerError
	79,  // 61: pulsar.proto.CommandEndTxnOnSubscription.subscription:type_name -> pulsar.proto.Subscription
	6,   // 62: pulsar.proto.CommandEndTxnOnSubscription.txn_action:type_name -> pulsar.proto.TxnAction
	2,   // 63: pulsar.proto.CommandEndTxnOnSubscriptionResponse.error:type_name -> pulsar.proto.ServerError
	16,  // 64: pulsar.proto.BaseCommand.type:type_name -> pulsar.proto.BaseCommand.Type
	26,  // 65: pulsar.proto.BaseCommand.connect:type_name -> pulsar.proto.CommandConnect
	28,  // 66: pulsar.proto.BaseCommand.connected:type_name -> pulsar.proto.CommandConnected
	33,  // 67: pulsar.proto.BaseCommand.subscribe:type_name -> pulsar.proto.CommandSubscribe
	38,  // 68: pulsar.proto.BaseCommand.producer:type_name -> pulsar.proto.CommandProducer
	39,  // 69: pulsar.proto.BaseCommand.send:type_name -> pulsar.proto.CommandSend
	40,  // 70: pulsar.proto.BaseCommand.send_receipt:type_name -> pulsar.proto.CommandSendReceipt
	41,  // 71: pulsar.proto.BaseCommand.send_error:type_name -> pulsar.proto.CommandSendError
	42,  // 72: pulsar.proto.BaseCommand.message:type_name -> pulsar.proto.CommandMessage
	43,  // 73: pulsar.proto.BaseCommand.ack:type_name -> pulsar.proto.CommandAck
	46,  // 74: pulsar.proto.BaseCommand.flow:type_name -> pulsar.proto.CommandFlow
	47,  // 75: pulsar.proto.BaseCommand.unsubscribe:type_name -> pulsar.proto.CommandUnsubscribe
	54,  // 76: pulsar.proto.BaseCommand.success:type_name -> pulsar.proto.CommandSuccess
	56,  // 77: pulsar.proto.BaseCommand.error:type_name -> pulsar.proto.CommandError
	51,  // 78: pulsar.proto.BaseCommand.close_producer:type_name -> pulsar.proto.CommandCloseProducer
	52,  // 79: pulsar.proto.BaseCommand.close_consumer:type_name -> pulsar.proto.CommandCloseConsumer
	55,  // 80: pulsar.proto.BaseCommand.producer_success:type_name -> pulsar.proto.CommandProducerSuccess
	57,  // 81: pulsar.proto.BaseCommand.ping:type_name -> pulsar.proto.CommandPing
	58,  // 82: pulsar.proto.BaseCommand.pong:type_name -> pulsar.proto.CommandPong
	53,  // 83: pulsar.proto.BaseCommand.redeliverUnacknowledgedMessages:type_name -> pulsar.proto.CommandRedeliverUnacknowledgedMessages
	34,  // 84: pulsar.proto.BaseCommand.partitionMetadata:type_name -> pulsar.proto.CommandPartitionedTopicMetadata
	35,  // 85: pulsar.proto.BaseCommand.partitionMetadataResponse:type_name -> pulsar.proto.CommandPartitionedTopicMetadataResponse
	36,  // 86: pulsar.proto.BaseCommand.lookupTopic:type_name -> pulsar.proto.CommandLookupTopic
	37,  // 87: pulsar.proto.BaseCommand.lookupTopicResponse:type_name -> pulsar.proto.CommandLookupTopicResponse
	59,  // 88: pulsar.proto.BaseCommand.consumerStats:type_name -> pulsar.proto.CommandConsumerStats
	60,  // 89: pulsar.proto.BaseCommand.consumerStatsResponse:type_name -> pulsar.proto.CommandConsumerStatsResponse
	49,  // 90: pulsar.proto.BaseCommand.reachedEndOfTopic:type_name -> pulsar.proto.CommandReachedEndOfTopic
	48,  // 91: pulsar.proto.BaseCommand.seek:type_name -> pulsar.proto.CommandSeek
	61,  // 92: pulsar.proto.BaseCommand.getLastMessageId:type_name -> pulsar.proto.CommandGetLastMessageId
	62,  // 93: pulsar.proto.BaseCommand.getLastMessageIdResponse:type_name -> pulsar.proto.CommandGetLastMessageIdResponse
	45,  // 94: pulsar.proto.BaseCommand.active_consumer_change:type_name -> pulsar.proto.CommandActiveConsumerChange
	63,  // 95: pulsar.proto.BaseCommand.getTopicsOfNamespace:type_name -> pulsar.proto.CommandGetTopicsOfNamespace
	64,  // 96: pulsar.proto.BaseCommand.getTopicsOfNamespaceResponse:type_name -> pulsar.proto.CommandGetTopicsOfNamespaceResponse
	69,  // 97: pulsar.proto.BaseCommand.getSchema:type_name -> pulsar.proto.CommandGetSchema
	70,  // 98: pulsar.proto.BaseCommand.getSchemaResponse:type_name -> pulsar.proto.CommandGetSchemaResponse
	30,  // 99: pulsar.proto.BaseCommand.authChallenge:type_name -> pulsar.proto.CommandAuthChallenge
	29,  // 100: pulsar.proto.BaseCommand.authResponse:type_name -> pulsar.proto.CommandAuthResponse
	44,  // 101: pulsar.proto.BaseCommand.ackResponse:type_name -> pulsar.proto.CommandAckResponse
	71,  // 102: pulsar.proto.BaseCommand.getOrCreateSchema:type_name -> pulsar.proto.CommandGetOrCreateSchema
	72,  // 103: pulsar.proto.BaseCommand.getOrCreateSchemaResponse:type_name -> pulsar.proto.CommandGetOrCreateSchemaResponse
	75,  // 104: pulsar.proto.BaseCommand.newTxn:type_name -> pulsar.proto.CommandNewTxn
	76,  // 105: pulsar.proto.BaseCommand.newTxnResponse:type_name -> pulsar.proto.CommandNewTxnResponse
	77,  // 106: pulsar.proto.BaseCommand.addPartitionToTxn:type_name -> pulsar.proto.CommandAddPartitionToTxn
	78,  // 107: pulsar.proto.BaseCommand.addPartitionToTxnResponse:type_name -> pulsar.proto.CommandAddPartitionToTxnResponse
	80,  // 108: pulsar.proto.BaseCommand.addSubscriptionToTxn:type_name -> pulsar.proto.CommandAddSubscriptionToTxn
	81,  // 109: pulsar.proto.BaseCommand.addSubscriptionToTxnResponse:type_name -> pulsar.proto.CommandAddSubscriptionToTxnResponse
	82,  // 110: pulsar.proto.BaseCommand.endTxn:type_name -> pulsar.proto.CommandEndTxn
	83,  // 111: pulsar.proto.BaseCommand.endTxnResponse:type_name -> pulsar.proto.CommandEndTxnResponse
	84,  // 112: pulsar.proto.BaseCommand.endTxnOnPartition:type_name -> pulsar.proto.CommandEndTxnOnPartition
	85,  // 113: pulsar.proto.BaseCommand.endTxnOnPartitionResponse:type_name -> pulsar.proto.CommandEndTxnOnPartitionResponse
	86,  // 114: pulsar.proto.BaseCommand.endTxnOnSubscription:type_name -> pulsar.proto.CommandEndTxnOnSubscription
	87,  // 115: pulsar.proto.BaseCommand.endTxnOnSubscriptionResponse:type_name -> pulsar.proto.CommandEndTxnOnSubscriptionResponse
	73,  // 116: pulsar.proto.BaseCommand.tcClientConnectRequest:type_name -> pulsar.proto.CommandTcClientConnectRequest
	74,  // 117: pulsar.proto.BaseCommand.tcClientConnectResponse:type_name -> pulsar.proto.CommandTcClientConnectResponse
	65,  // 118: pulsar.proto.BaseCommand.watchTopicList:type_name -> pulsar.proto.CommandWatchTopicList
	66,  // 119: pulsar.proto.BaseCommand.watchTopicListSuccess:type_name -> pulsar.proto.CommandWatchTopicListSuccess
	67,  // 120: pulsar.proto.BaseCommand.watchTopicUpdate:type_name -> pulsar.proto.CommandWatchTopicUpdate
	68,  // 121: pulsar.proto.BaseCommand.watchTopicListClose:type_name -> pulsar.proto.CommandWatchTopicListClose
	50,  // 122: pulsar.proto.BaseCommand.topicMigrated:type_name -> pulsar.proto.CommandTopicMigrated
	123, // [123:123] is the sub-list for method output_type
	123, // [123:123] is the sub-list for method input_type
	123, // [123:123] is the sub-list for extension type_name
	123, // [123:123] is the sub-list for extension extendee
	0,   // [0:123] is the sub-list for field type_name
}

func init() { file_PulsarApi_proto_init() }
func file_PulsarApi_proto_init() {
	if File_PulsarApi_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_PulsarApi_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageIdData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyLongValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncryptionKeys); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SingleMessageMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BrokerEntryMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandConnect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeatureFlags); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandConnected); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandAuthResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandAuthChallenge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeySharedMeta); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandSubscribe); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandPartitionedTopicMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandPartitionedTopicMetadataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandLookupTopic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandLookupTopicResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandProducer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandSend); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandSendReceipt); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandSendError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandAck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandAckResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandActiveConsumerChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandFlow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandUnsubscribe); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandSeek); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandReachedEndOfTopic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandTopicMigrated); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandCloseProducer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandCloseConsumer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandRedeliverUnacknowledgedMessages); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandSuccess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandProducerSuccess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandPing); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandPong); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandConsumerStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandConsumerStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetLastMessageId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetLastMessageIdResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetTopicsOfNamespace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetTopicsOfNamespaceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandWatchTopicList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandWatchTopicListSuccess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandWatchTopicUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandWatchTopicListClose); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetSchemaResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetOrCreateSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetOrCreateSchemaResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandTcClientConnectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandTcClientConnectResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandNewTxn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandNewTxnResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandAddPartitionToTxn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandAddPartitionToTxnResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandAddSubscriptionToTxn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandAddSubscriptionToTxnResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandEndTxn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandEndTxnResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandEndTxnOnPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandEndTxnOnPartitionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandEndTxnOnSubscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandEndTxnOnSubscriptionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_PulsarApi_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BaseCommand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_PulsarApi_proto_rawDesc,
			NumEnums:      17,
			NumMessages:   72,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_PulsarApi_proto_goTypes,
		DependencyIndexes: file_PulsarApi_proto_depIdxs,
		EnumInfos:         file_PulsarApi_proto_enumTypes,
		MessageInfos:      file_PulsarApi_proto_msgTypes,
	}.Build()
	File_PulsarApi_proto = out.File
	file_PulsarApi_proto_rawDesc = nil
	file_PulsarApi_proto_goTypes = nil
	file_PulsarApi_proto_depIdxs = nil
}
