/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.TrustStore;

@ManagedObject(category=false, type="SiteSpecificTrustStore", description="Obtains a SSL/TLS certificate from a given URL which the Trust Store will trust for secure connections (e.g., HTTPS or AMQPS)")
public interface SiteSpecificTrustStore<X extends SiteSpecificTrustStore<X>>
extends TrustStore<X> {
    public static final String CERTIFICATE = "certificate";
    public static final String TRUST_STORE_SITE_SPECIFIC_CONNECT_TIMEOUT = "qpid.trustStore.siteSpecific.connectTimeout";
    @ManagedContextDefault(name="qpid.trustStore.siteSpecific.connectTimeout")
    public static final int DEFAULT_TRUST_STORE_SITE_SPECIFIC_CONNECT_TIMEOUT = 60000;
    public static final String TRUST_STORE_SITE_SPECIFIC_READ_TIMEOUT = "qpid.trustStore.siteSpecific.readTimeout";
    @ManagedContextDefault(name="qpid.trustStore.siteSpecific.readTimeout")
    public static final int DEFAULT_TRUST_STORE_SITE_SPECIFIC_READ_TIMEOUT = 60000;

    @ManagedAttribute(immutable=true, description="The URL from which to obtain the trusted certificate. Example: https://example.com or https://example.com:8443")
    public String getSiteUrl();

    @DerivedAttribute(persist=true, description="The X.509 certificate obtained from the given URL as base64 encoded representation of the ASN.1 DER encoding")
    public String getCertificate();

    @ManagedOperation(description="Re-download the certificate from the URL", changesConfiguredObjectState=false)
    public void refreshCertificate();
}

