/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.http.utils;

import java.lang.management.ManagementFactory;
import java.util.Optional;

public final class SystemUtils {
    private static final String SYSTEM_PROP_OS_NAME = "os.name";
    private static final String WIN_OS_NAME_PREFIX = "Windows";

    private SystemUtils() {
    }

    public static String getCurrentPID() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static boolean isWindows() {
        return SystemUtils.getOsName().map(n -> n.startsWith(WIN_OS_NAME_PREFIX)).orElse(false);
    }

    public static Optional<String> getOsName() {
        try {
            return Optional.of(System.getProperty(SYSTEM_PROP_OS_NAME));
        }
        catch (SecurityException e) {
            return Optional.empty();
        }
    }
}

