/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.builder.AccessorHelper;
import io.fury.codegen.CodegenContext;
import io.fury.codegen.Expression;
import io.fury.collection.Tuple2;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoHolder;
import io.fury.type.Descriptor;
import io.fury.type.FinalObjectTypeStub;
import io.fury.type.TypeUtils;
import io.fury.util.GraalvmSupport;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import io.fury.util.ReflectionUtils;
import io.fury.util.StringUtils;
import io.fury.util.function.Functions;
import io.fury.util.record.RecordComponent;
import io.fury.util.record.RecordUtils;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public abstract class CodecBuilder {
    protected static final String ROOT_OBJECT_NAME = "obj";
    protected static final String FURY_NAME = "fury";
    static TypeToken<Object[]> objectArrayTypeToken = TypeToken.of(Object[].class);
    static TypeToken<MemoryBuffer> bufferTypeToken = TypeToken.of(MemoryBuffer.class);
    static TypeToken<ClassInfo> classInfoTypeToken = TypeToken.of(ClassInfo.class);
    static TypeToken<ClassInfoHolder> classInfoHolderTypeToken = TypeToken.of(ClassInfoHolder.class);
    protected final CodegenContext ctx;
    protected final TypeToken<?> beanType;
    protected final Class<?> beanClass;
    protected final boolean isRecord;
    private final Set<String> duplicatedFields;
    protected Expression.Reference furyRef = new Expression.Reference("fury", TypeToken.of(Fury.class));
    public static final Expression.Reference recordComponentDefaultValues = new Expression.Reference("recordComponentDefaultValues", TypeUtils.OBJECT_ARRAY_TYPE);
    protected final Map<String, Expression.Reference> fieldMap = new HashMap<String, Expression.Reference>();
    protected boolean recordCtrAccessible;
    private final boolean fieldNullable = false;

    public CodecBuilder(CodegenContext ctx, TypeToken<?> beanType) {
        this.ctx = ctx;
        this.beanType = beanType;
        this.beanClass = TypeUtils.getRawType(beanType);
        this.isRecord = RecordUtils.isRecord(this.beanClass);
        if (this.isRecord) {
            this.recordCtrAccessible = CodecBuilder.recordCtrAccessible(this.beanClass);
        }
        this.duplicatedFields = Descriptor.getSortedDuplicatedFields(this.beanClass).keySet();
        ctx.reserveName(FURY_NAME);
        ctx.reserveName(ROOT_OBJECT_NAME);
    }

    public abstract String genCode();

    public abstract Expression buildEncodeExpression();

    protected boolean sourcePublicAccessible(Class<?> cls) {
        return this.ctx.sourcePublicAccessible(cls);
    }

    protected Expression tryInlineCast(Expression expression, TypeToken<?> targetType) {
        return this.tryCastIfPublic(expression, targetType, true);
    }

    protected Expression tryCastIfPublic(Expression expression, TypeToken<?> targetType) {
        return this.tryCastIfPublic(expression, targetType, false);
    }

    protected Expression tryCastIfPublic(Expression expression, TypeToken<?> targetType, boolean inline) {
        Class<?> rawType = TypeUtils.getRawType(targetType);
        if (rawType == FinalObjectTypeStub.class) {
            return expression;
        }
        if (inline) {
            if (this.sourcePublicAccessible(rawType)) {
                return new Expression.Cast(expression, targetType);
            }
            return new Expression.Cast(expression, ReflectionUtils.getPublicSuperType(TypeToken.of(rawType)));
        }
        return this.tryCastIfPublic(expression, targetType, "castedValue");
    }

    protected Expression tryCastIfPublic(Expression expression, TypeToken<?> targetType, String valuePrefix) {
        Class<?> rawType = TypeUtils.getRawType(targetType);
        if (this.sourcePublicAccessible(rawType) && !expression.type().wrap().isSubtypeOf(targetType.wrap())) {
            return new Expression.Cast(expression, targetType, valuePrefix);
        }
        return expression;
    }

    protected Expression.Reference getRecordCtrHandle() {
        String fieldName = "_record_ctr_";
        Expression.Reference fieldRef = this.fieldMap.get(fieldName);
        if (fieldRef == null) {
            Expression.StaticInvoke getRecordCtrHandle = new Expression.StaticInvoke(RecordUtils.class, "getRecordCtrHandle", TypeToken.of(MethodHandle.class), this.beanClassExpr());
            this.ctx.addField(this.ctx.type(MethodHandle.class), fieldName, (Expression)getRecordCtrHandle);
            fieldRef = new Expression.Reference(fieldName, TypeToken.of(MethodHandle.class));
            this.fieldMap.put(fieldName, fieldRef);
        }
        return fieldRef;
    }

    protected Expression buildDefaultComponentsArray() {
        return new Expression.StaticInvoke(Platform.class, "copyObjectArray", TypeUtils.OBJECT_ARRAY_TYPE, recordComponentDefaultValues);
    }

    protected Expression getFieldValue(Expression inputBeanExpr, Descriptor descriptor) {
        TypeToken<?> fieldType = descriptor.getTypeToken();
        Class<?> rawType = descriptor.getRawType();
        String fieldName = descriptor.getName();
        if (this.isRecord) {
            return this.getRecordFieldValue(inputBeanExpr, descriptor);
        }
        if (this.duplicatedFields.contains(fieldName) || !Modifier.isPublic(this.beanClass.getModifiers())) {
            return this.unsafeAccessField(inputBeanExpr, this.beanClass, descriptor);
        }
        if (!this.sourcePublicAccessible(rawType)) {
            fieldType = TypeUtils.OBJECT_TYPE;
        }
        if (Modifier.isPublic(descriptor.getModifiers())) {
            return new Expression.FieldValue(inputBeanExpr, fieldName, fieldType, false, false);
        }
        if (descriptor.getReadMethod() != null && Modifier.isPublic(descriptor.getReadMethod().getModifiers())) {
            return new Expression.Invoke(inputBeanExpr, descriptor.getReadMethod().getName(), fieldName, fieldType, false, new Expression[0]);
        }
        if (!Modifier.isPrivate(descriptor.getModifiers()) && AccessorHelper.defineAccessor(descriptor.getField())) {
            return new Expression.StaticInvoke(AccessorHelper.getAccessorClass(descriptor.getField()), fieldName, fieldType, false, inputBeanExpr);
        }
        if (descriptor.getReadMethod() != null && !Modifier.isPrivate(descriptor.getReadMethod().getModifiers()) && AccessorHelper.defineAccessor(descriptor.getReadMethod())) {
            return new Expression.StaticInvoke(AccessorHelper.getAccessorClass(descriptor.getReadMethod()), descriptor.getReadMethod().getName(), fieldType, false, inputBeanExpr);
        }
        return this.unsafeAccessField(inputBeanExpr, this.beanClass, descriptor);
    }

    private Expression getRecordFieldValue(Expression inputBeanExpr, Descriptor descriptor) {
        TypeToken<?> fieldType = descriptor.getTypeToken();
        if (!this.sourcePublicAccessible(descriptor.getRawType())) {
            fieldType = TypeUtils.OBJECT_TYPE;
        }
        String fieldName = descriptor.getName();
        if (Modifier.isPublic(this.beanClass.getModifiers())) {
            Preconditions.checkNotNull(descriptor.getReadMethod());
            return new Expression.Invoke(inputBeanExpr, descriptor.getReadMethod().getName(), fieldName, fieldType, false, new Expression[0]);
        }
        String key = "_" + fieldName + "_getter_";
        Expression.Reference ref = this.fieldMap.get(key);
        Tuple2<Class<?>, String> methodInfo = Functions.getterMethodInfo(descriptor.getRawType());
        if (ref == null) {
            Class funcInterface = (Class)methodInfo.f0;
            TypeToken getterType = TypeToken.of((Class)funcInterface);
            Expression.Inlineable getter = new Expression.StaticInvoke(Functions.class, "makeGetterFunction", TypeUtils.OBJECT_TYPE, this.beanClassExpr(), Expression.Literal.ofString(fieldName));
            getter = new Expression.Cast(getter, getterType);
            this.ctx.addField(funcInterface, key, (Expression)getter);
            ref = new Expression.Reference(key, getterType);
            this.fieldMap.put(key, ref);
        }
        if (!fieldType.isPrimitive()) {
            Expression.Invoke v = Expression.Invoke.inlineInvoke((Expression)ref, (String)methodInfo.f1, TypeUtils.OBJECT_TYPE, false, inputBeanExpr);
            return this.tryCastIfPublic((Expression)v, descriptor.getTypeToken(), fieldName);
        }
        return new Expression.Invoke((Expression)ref, (String)methodInfo.f1, fieldType, false, inputBeanExpr);
    }

    private Expression reflectAccessField(Expression inputObject, Class<?> cls, Descriptor descriptor) {
        Expression.Reference fieldRef = this.getReflectField(cls, descriptor.getField());
        Expression.Invoke getObj = new Expression.Invoke((Expression)fieldRef, "get", TypeUtils.OBJECT_TYPE, false, inputObject);
        return new Expression.Cast(getObj, descriptor.getTypeToken(), descriptor.getName());
    }

    private Expression unsafeAccessField(Expression inputObject, Class<?> cls, Descriptor descriptor) {
        String fieldName = descriptor.getName();
        Expression fieldOffsetExpr = this.getFieldOffset(cls, descriptor);
        if (descriptor.getTypeToken().isPrimitive()) {
            Preconditions.checkArgument(true);
            TypeToken<?> returnType = descriptor.getTypeToken();
            String funcName = "get" + StringUtils.capitalize(descriptor.getRawType().toString());
            return new Expression.StaticInvoke(Platform.class, funcName, returnType, false, inputObject, fieldOffsetExpr);
        }
        Expression.StaticInvoke getObj = new Expression.StaticInvoke(Platform.class, "getObject", TypeUtils.OBJECT_TYPE, false, inputObject, fieldOffsetExpr);
        return this.tryCastIfPublic((Expression)getObj, descriptor.getTypeToken(), fieldName);
    }

    private Expression getFieldOffset(Class<?> cls, Descriptor descriptor) {
        Field field = descriptor.getField();
        String fieldName = descriptor.getName();
        if (GraalvmSupport.isGraalBuildtime()) {
            return this.getOrCreateField(true, Long.TYPE, fieldName + "_offset_", () -> {
                Expression classExpr = this.beanClassExpr(field.getDeclaringClass());
                new Expression.Invoke(classExpr, "getDeclaredField", TypeToken.of(Field.class));
                Expression.Reference reflectFieldRef = this.getReflectField(cls, field, false);
                return new Expression.StaticInvoke(Platform.class, "objectFieldOffset", TypeUtils.PRIMITIVE_LONG_TYPE, reflectFieldRef).inline();
            });
        }
        long fieldOffset = ReflectionUtils.getFieldOffset(field);
        Preconditions.checkArgument(fieldOffset != -1L);
        return Expression.Literal.ofLong(fieldOffset);
    }

    public abstract Expression buildDecodeExpression();

    protected Expression setFieldValue(Expression bean, Descriptor d, Expression value) {
        String fieldName = d.getName();
        if (value instanceof Expression.Inlineable) {
            ((Expression.Inlineable)value).inline();
        }
        if (this.duplicatedFields.contains(fieldName) || !this.sourcePublicAccessible(this.beanClass)) {
            return this.unsafeSetField(bean, d, value);
        }
        if (!Modifier.isFinal(d.getModifiers()) && Modifier.isPublic(d.getModifiers())) {
            return new Expression.SetField(bean, fieldName, value);
        }
        if (d.getWriteMethod() != null && Modifier.isPublic(d.getWriteMethod().getModifiers())) {
            return new Expression.Invoke(bean, d.getWriteMethod().getName(), value);
        }
        if (!Modifier.isFinal(d.getModifiers()) && !Modifier.isPrivate(d.getModifiers()) && AccessorHelper.defineSetter(d.getField())) {
            Class<?> accessorClass = AccessorHelper.getAccessorClass(d.getField());
            if (!value.type().equals(d.getTypeToken())) {
                value = new Expression.Cast(value, d.getTypeToken());
            }
            return new Expression.StaticInvoke(accessorClass, d.getName(), TypeUtils.PRIMITIVE_VOID_TYPE, false, bean, value);
        }
        if (d.getWriteMethod() != null && !Modifier.isPrivate(d.getWriteMethod().getModifiers()) && AccessorHelper.defineSetter(d.getWriteMethod())) {
            Class<?> accessorClass = AccessorHelper.getAccessorClass(d.getWriteMethod());
            if (!value.type().equals(d.getTypeToken())) {
                value = new Expression.Cast(value, d.getTypeToken());
            }
            return new Expression.StaticInvoke(accessorClass, d.getWriteMethod().getName(), TypeUtils.PRIMITIVE_VOID_TYPE, false, bean, value);
        }
        return this.unsafeSetField(bean, d, value);
    }

    private Expression reflectSetField(Expression bean, Field field, Expression value) {
        Expression.Reference fieldRef = this.getReflectField(TypeUtils.getRawType(bean.type()), field);
        Preconditions.checkNotNull(fieldRef);
        return new Expression.Invoke((Expression)fieldRef, "set", bean, value);
    }

    private Expression unsafeSetField(Expression bean, Descriptor descriptor, Expression value) {
        TypeToken<?> fieldType = descriptor.getTypeToken();
        Expression fieldOffsetExpr = this.getFieldOffset(this.beanClass, descriptor);
        if (descriptor.getTypeToken().isPrimitive()) {
            Preconditions.checkArgument(value.type().equals(fieldType));
            String funcName = "put" + StringUtils.capitalize(TypeUtils.getRawType(fieldType).toString());
            return new Expression.StaticInvoke(Platform.class, funcName, bean, fieldOffsetExpr, value);
        }
        return new Expression.StaticInvoke(Platform.class, "putObject", bean, fieldOffsetExpr, value);
    }

    private Expression.Reference getReflectField(Class<?> cls, Field field) {
        return this.getReflectField(cls, field, true);
    }

    private Expression.Reference getReflectField(Class<?> cls, Field field, boolean setAccessible) {
        String fieldName = field.getName();
        String fieldRefName = this.duplicatedFields.contains(fieldName) ? cls.getName().replaceAll("\\.|\\$", "_") + "_" + fieldName + "_Field" : fieldName + "_Field";
        return this.getOrCreateField(true, Field.class, fieldRefName, () -> {
            TypeToken fieldTypeToken = TypeToken.of(Field.class);
            Expression classExpr = this.beanClassExpr(field.getDeclaringClass());
            Expression.BaseInvoke fieldExpr = GraalvmSupport.isGraalBuildtime() ? Expression.Invoke.inlineInvoke(classExpr, "getDeclaredField", fieldTypeToken, Expression.Literal.ofString(fieldName)) : new Expression.StaticInvoke(ReflectionUtils.class, "getField", fieldTypeToken, classExpr, Expression.Literal.ofString(fieldName));
            if (!setAccessible) {
                return fieldExpr;
            }
            Expression.Invoke setAccess = new Expression.Invoke((Expression)fieldExpr, "setAccessible", Expression.Literal.True);
            return new Expression.ListExpression(setAccess, fieldExpr);
        });
    }

    private Expression.Reference getOrCreateField(boolean isStatic, Class<?> type, String fieldName, Supplier<Expression> value) {
        Expression.Reference fieldRef = this.fieldMap.get(fieldName);
        if (fieldRef == null) {
            this.ctx.addField(isStatic, true, this.ctx.type(type), fieldName, value.get());
            fieldRef = new Expression.Reference(fieldName, TypeToken.of(type));
            this.fieldMap.put(fieldName, fieldRef);
        }
        return fieldRef;
    }

    protected Expression newBean() {
        if (this.sourcePublicAccessible(this.beanClass)) {
            return new Expression.NewInstance(this.beanType, new Expression[0]);
        }
        return new Expression.StaticInvoke(Platform.class, "newInstance", TypeUtils.OBJECT_TYPE, this.beanClassExpr());
    }

    protected void buildRecordComponentDefaultValues() {
        this.ctx.reserveName(recordComponentDefaultValues.name());
        Expression.StaticInvoke expr = new Expression.StaticInvoke(RecordUtils.class, "buildRecordComponentDefaultValues", TypeUtils.OBJECT_ARRAY_TYPE, this.beanClassExpr());
        this.ctx.addField(Object[].class, recordComponentDefaultValues.name(), (Expression)expr);
    }

    static boolean recordCtrAccessible(Class<?> cls) {
        if (!Modifier.isPublic(cls.getModifiers())) {
            return false;
        }
        for (RecordComponent component : Objects.requireNonNull(RecordUtils.getRecordComponents(cls))) {
            if (Modifier.isPublic(component.getType().getModifiers())) continue;
            return false;
        }
        return true;
    }

    protected Expression beanClassExpr(Class<?> cls) {
        if (cls == this.beanClass) {
            return this.staticBeanClassExpr();
        }
        if (GraalvmSupport.isGraalBuildtime()) {
            String name = cls.getName().replaceAll("\\.|\\$", "_") + "__class__";
            return this.getOrCreateField(true, Class.class, name, () -> new Expression.StaticInvoke(ReflectionUtils.class, "loadClass", TypeUtils.CLASS_TYPE, Expression.Literal.ofString(cls.getName())).inline());
        }
        throw new UnsupportedOperationException();
    }

    protected Expression beanClassExpr() {
        if (GraalvmSupport.isGraalBuildtime()) {
            return this.staticBeanClassExpr();
        }
        throw new UnsupportedOperationException();
    }

    protected Expression staticBeanClassExpr() {
        return this.getOrCreateField(true, Class.class, "__class__", () -> new Expression.StaticInvoke(ReflectionUtils.class, "loadClass", TypeUtils.CLASS_TYPE, Expression.Literal.ofString(this.beanClass.getName())).inline());
    }

    protected Expression unsafePut(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafePut", base, pos, value);
    }

    protected Expression unsafePutBoolean(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafePutBoolean", base, pos, value);
    }

    protected Expression unsafePutChar(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafePutChar", base, pos, value);
    }

    protected Expression unsafePutShort(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafePutShort", base, pos, value);
    }

    protected Expression unsafePutInt(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafePutInt", base, pos, value);
    }

    protected Expression unsafePutLong(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafePutLong", base, pos, value);
    }

    protected Expression unsafePutFloat(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafePutFloat", base, pos, value);
    }

    protected Expression unsafePutDouble(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafePutDouble", base, pos, value);
    }

    protected Expression unsafeGet(Expression base, Expression pos) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafeGet", TypeUtils.PRIMITIVE_BYTE_TYPE, base, pos);
    }

    protected Expression unsafeGetBoolean(Expression base, Expression pos) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafeGetBoolean", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, base, pos);
    }

    protected Expression unsafeGetChar(Expression base, Expression pos) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafeGetChar", TypeUtils.PRIMITIVE_CHAR_TYPE, base, pos);
    }

    protected Expression unsafeGetShort(Expression base, Expression pos) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafeGetShort", TypeUtils.PRIMITIVE_SHORT_TYPE, base, pos);
    }

    protected Expression unsafeGetInt(Expression base, Expression pos) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafeGetInt", TypeUtils.PRIMITIVE_INT_TYPE, base, pos);
    }

    protected Expression unsafeGetLong(Expression base, Expression pos) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafeGetLong", TypeUtils.PRIMITIVE_LONG_TYPE, base, pos);
    }

    protected Expression unsafeGetFloat(Expression base, Expression pos) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafeGetFloat", TypeUtils.PRIMITIVE_FLOAT_TYPE, base, pos);
    }

    protected Expression unsafeGetDouble(Expression base, Expression pos) {
        return new Expression.StaticInvoke(MemoryBuffer.class, "unsafeGetDouble", TypeUtils.PRIMITIVE_DOUBLE_TYPE, base, pos);
    }
}

