/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.registry;

import com.alipay.common.tracer.core.registry.BinaryFormater;
import com.alipay.common.tracer.core.registry.HttpHeadersB3Formatter;
import com.alipay.common.tracer.core.registry.HttpHeadersFormatter;
import com.alipay.common.tracer.core.registry.RegistryExtractorInjector;
import com.alipay.common.tracer.core.registry.TextMapB3Formatter;
import com.alipay.common.tracer.core.registry.TextMapFormatter;
import io.opentracing.propagation.Format;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TracerFormatRegistry {
    private static final Map<Format<?>, RegistryExtractorInjector<?>> injectorsAndExtractors = new ConcurrentHashMap();

    public static <T> RegistryExtractorInjector<T> getRegistry(Format<T> format) {
        return injectorsAndExtractors.get(format);
    }

    public static <T> void register(Format<T> format, RegistryExtractorInjector<T> extractor) {
        injectorsAndExtractors.put(format, extractor);
    }

    static {
        TextMapFormatter textMapFormatter = new TextMapFormatter();
        HttpHeadersFormatter httpHeadersFormatter = new HttpHeadersFormatter();
        BinaryFormater binaryFormater = new BinaryFormater();
        TextMapB3Formatter textMapB3Formatter = new TextMapB3Formatter();
        HttpHeadersB3Formatter httpHeadersB3Formatter = new HttpHeadersB3Formatter();
        injectorsAndExtractors.put(textMapFormatter.getFormatType(), textMapFormatter);
        injectorsAndExtractors.put(httpHeadersFormatter.getFormatType(), httpHeadersFormatter);
        injectorsAndExtractors.put(binaryFormater.getFormatType(), binaryFormater);
        injectorsAndExtractors.put(textMapB3Formatter.getFormatType(), textMapB3Formatter);
        injectorsAndExtractors.put(httpHeadersB3Formatter.getFormatType(), httpHeadersB3Formatter);
    }
}

