/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.remoting.http.HttpHandler;

public class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 5766349180380479888L;
    private static final Map<Integer, HttpHandler> HANDLERS = new ConcurrentHashMap<Integer, HttpHandler>();
    private static DispatcherServlet INSTANCE;

    public DispatcherServlet() {
        INSTANCE = this;
    }

    public static void addHttpHandler(int port, HttpHandler processor) {
        HANDLERS.put(port, processor);
    }

    public static void removeHttpHandler(int port) {
        HANDLERS.remove(port);
    }

    public static DispatcherServlet getInstance() {
        return INSTANCE;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpHandler handler = HANDLERS.get(request.getLocalPort());
        if (handler == null) {
            response.sendError(404, "Service not found.");
        } else {
            handler.handle(request, response);
        }
    }
}

