/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.reactive;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.OnlyOnceLoggingDenyMeterFilter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.reactive.observation.ServerRequestObservationConvention;

@AutoConfiguration(after={SimpleMetricsExportAutoConfiguration.class, ObservationAutoConfiguration.class})
@ConditionalOnClass(value={Observation.class, MeterRegistry.class})
@ConditionalOnBean(value={ObservationRegistry.class, MeterRegistry.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={MetricsProperties.class, ObservationProperties.class})
public class WebFluxObservationAutoConfiguration {
    private final ObservationProperties observationProperties;

    WebFluxObservationAutoConfiguration(ObservationProperties observationProperties) {
        this.observationProperties = observationProperties;
    }

    @Bean
    @Order(value=0)
    MeterFilter metricsHttpServerUriTagFilter(MetricsProperties metricsProperties) {
        String name = this.observationProperties.getHttp().getServer().getRequests().getName();
        OnlyOnceLoggingDenyMeterFilter filter = new OnlyOnceLoggingDenyMeterFilter(() -> "Reached the maximum number of URI tags for '%s'.".formatted(name));
        return MeterFilter.maximumAllowableTags((String)name, (String)"uri", (int)metricsProperties.getWeb().getServer().getMaxUriTags(), (MeterFilter)filter);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServerRequestObservationConvention.class})
    DefaultServerRequestObservationConvention defaultServerRequestObservationConvention() {
        return new DefaultServerRequestObservationConvention(this.observationProperties.getHttp().getServer().getRequests().getName());
    }
}

