/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public final class CompositeException
extends RuntimeException {
    private static final long serialVersionUID = 3026362227162912146L;
    static final int DEFAULT_MAX_NUM_STACK_TRACES = 20;
    private final List<Throwable> exceptions;
    private final String message;
    private boolean isVerboseException;
    @Nullable
    private Throwable cause;
    private final ReentrantLock reentrantLock = new ReentrantShortLock();

    public CompositeException(Throwable ... exceptions) {
        this(ImmutableList.copyOf(Objects.requireNonNull(exceptions, "exceptions")));
    }

    public CompositeException(Iterable<? extends Throwable> errors) {
        this(errors, Flags.verboseExceptionSampler());
    }

    CompositeException(Iterable<? extends Throwable> errors, Sampler<Class<? extends Throwable>> verboseExceptionSampler) {
        Objects.requireNonNull(errors, "errors");
        Objects.requireNonNull(verboseExceptionSampler, "verboseExceptionSampler");
        LinkedHashSet<Throwable> deDupedExceptions = new LinkedHashSet<Throwable>();
        for (Throwable throwable : errors) {
            if (throwable instanceof CompositeException) {
                deDupedExceptions.addAll(((CompositeException)throwable).getExceptions());
                continue;
            }
            if (throwable != null) {
                deDupedExceptions.add(throwable);
                continue;
            }
            deDupedExceptions.add(new NullPointerException("Throwable was null!"));
        }
        if (deDupedExceptions.isEmpty()) {
            throw new IllegalArgumentException("errors is empty.");
        }
        this.exceptions = ImmutableList.copyOf(deDupedExceptions);
        this.message = this.exceptions.size() + " exceptions occurred. ";
        this.isVerboseException = verboseExceptionSampler.isSampled(this.getClass());
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Throwable getCause() {
        this.lock();
        try {
            if (this.cause == null) {
                String separator = System.getProperty("line.separator");
                if (this.exceptions.size() > 1) {
                    IdentityHashMap<Throwable, Boolean> seenCauses = new IdentityHashMap<Throwable, Boolean>();
                    StringBuilder aggregateMessage = new StringBuilder();
                    aggregateMessage.append("Multiple exceptions (").append(this.exceptions.size()).append(')').append(separator);
                    block3: for (Throwable inner : this.exceptions) {
                        int depth = 0;
                        while (inner != null) {
                            Class<?> innerClass = inner.getClass();
                            for (int i = 0; i < depth; ++i) {
                                aggregateMessage.append("  ");
                            }
                            aggregateMessage.append("|-- ");
                            aggregateMessage.append(innerClass.getCanonicalName()).append(": ");
                            String innerMessage = inner.getMessage();
                            String messagePadding = Strings.repeat("  ", depth + 2);
                            if (innerMessage != null && innerMessage.contains(separator)) {
                                aggregateMessage.append(separator);
                                for (String line : innerMessage.split(separator)) {
                                    aggregateMessage.append(messagePadding).append(line).append(separator);
                                }
                            } else {
                                aggregateMessage.append(innerMessage);
                                aggregateMessage.append(separator);
                            }
                            StackTraceElement[] st = inner.getStackTrace();
                            if (st.length > 0) {
                                int maxStackTraceSize = this.isVerboseException ? st.length : Math.min(20, st.length);
                                for (int i = 0; i < maxStackTraceSize; ++i) {
                                    aggregateMessage.append(messagePadding).append("at ").append(st[i]).append(separator);
                                }
                            }
                            if (!seenCauses.containsKey(inner)) {
                                seenCauses.put(inner, true);
                                inner = inner.getCause();
                                ++depth;
                                continue;
                            }
                            if ((inner = inner.getCause()) == null) continue block3;
                            aggregateMessage.append(messagePadding);
                            aggregateMessage.append("|-- ");
                            aggregateMessage.append("(cause not expanded again) ");
                            aggregateMessage.append(inner.getClass().getCanonicalName()).append(": ");
                            aggregateMessage.append(inner.getMessage());
                            aggregateMessage.append(separator);
                            continue block3;
                        }
                    }
                    this.cause = new ExceptionOverview(aggregateMessage.toString().trim());
                } else {
                    this.cause = this.exceptions.get(0);
                }
            }
            Throwable throwable = this.cause;
            return throwable;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new WrappedPrintStream(s));
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(new WrappedPrintWriter(s));
    }

    private void printStackTrace(PrintStreamOrWriter s) {
        StringBuilder b = new StringBuilder(128);
        b.append(this).append('\n');
        for (StackTraceElement myStackElement : this.getStackTrace()) {
            b.append("\tat ").append(myStackElement).append('\n');
        }
        int i = 1;
        for (Throwable ex : this.exceptions) {
            b.append("  ComposedException ").append(i).append(" :\n");
            CompositeException.appendStackTrace(b, ex, "\t");
            ++i;
        }
        s.println(b.toString());
    }

    private static void appendStackTrace(StringBuilder b, Throwable ex, String prefix) {
        b.append(prefix).append(ex).append('\n');
        for (StackTraceElement stackElement : ex.getStackTrace()) {
            b.append("\t\tat ").append(stackElement).append('\n');
        }
        if (ex.getCause() != null) {
            b.append("\tCaused by: ");
            CompositeException.appendStackTrace(b, ex.getCause(), "");
        }
    }

    public int size() {
        return this.exceptions.size();
    }

    void lock() {
        this.reentrantLock.lock();
    }

    void unlock() {
        this.reentrantLock.unlock();
    }

    static final class ExceptionOverview
    extends RuntimeException {
        private static final long serialVersionUID = 3875212506787802066L;

        ExceptionOverview(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class WrappedPrintStream
    extends PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        void println(Object o) {
            this.printStream.println(o);
        }
    }

    static abstract class PrintStreamOrWriter {
        PrintStreamOrWriter() {
        }

        abstract void println(Object var1);
    }

    static final class WrappedPrintWriter
    extends PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        void println(Object o) {
            this.printWriter.println(o);
        }
    }
}

