/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.linecorp.armeria.common.ExchangeType;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcExchangeTypeUtil {
    private static final Logger logger = LoggerFactory.getLogger(GrpcExchangeTypeUtil.class);
    private static boolean warnedUnknownMethodType;

    public static ExchangeType toExchangeType(MethodDescriptor.MethodType methodType) {
        switch (methodType) {
            case UNARY: {
                return ExchangeType.UNARY;
            }
            case CLIENT_STREAMING: {
                return ExchangeType.REQUEST_STREAMING;
            }
            case SERVER_STREAMING: {
                return ExchangeType.RESPONSE_STREAMING;
            }
            case BIDI_STREAMING: {
                return ExchangeType.BIDI_STREAMING;
            }
        }
        if (!warnedUnknownMethodType) {
            warnedUnknownMethodType = true;
            logger.warn("Unknown MethodType: {}; using {}", (Object)methodType, (Object)ExchangeType.BIDI_STREAMING);
        }
        return ExchangeType.BIDI_STREAMING;
    }

    private GrpcExchangeTypeUtil() {
    }
}

