/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.tracing;

import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLTypeUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

@PublicApi
public class TracingSupport
implements InstrumentationState {
    private final Instant startRequestTime;
    private final long startRequestNanos;
    private final ConcurrentLinkedQueue<Map<String, Object>> fieldData;
    private final Map<String, Object> parseMap = new LinkedHashMap<String, Object>();
    private final Map<String, Object> validationMap = new LinkedHashMap<String, Object>();
    private final boolean includeTrivialDataFetchers;

    public TracingSupport(boolean includeTrivialDataFetchers) {
        this.includeTrivialDataFetchers = includeTrivialDataFetchers;
        this.startRequestNanos = System.nanoTime();
        this.startRequestTime = Instant.now();
        this.fieldData = new ConcurrentLinkedQueue();
    }

    public TracingContext beginField(DataFetchingEnvironment dataFetchingEnvironment, boolean trivialDataFetcher) {
        if (!this.includeTrivialDataFetchers && trivialDataFetcher) {
            return () -> {};
        }
        long startFieldFetch = System.nanoTime();
        return () -> {
            long now = System.nanoTime();
            long duration = now - startFieldFetch;
            long startOffset = startFieldFetch - this.startRequestNanos;
            ExecutionStepInfo executionStepInfo = dataFetchingEnvironment.getExecutionStepInfo();
            LinkedHashMap<String, Object> fetchMap = new LinkedHashMap<String, Object>();
            fetchMap.put("path", executionStepInfo.getPath().toList());
            fetchMap.put("parentType", GraphQLTypeUtil.simplePrint(executionStepInfo.getParent().getUnwrappedNonNullType()));
            fetchMap.put("returnType", executionStepInfo.simplePrint());
            fetchMap.put("fieldName", executionStepInfo.getFieldDefinition().getName());
            fetchMap.put("startOffset", startOffset);
            fetchMap.put("duration", duration);
            this.fieldData.add(fetchMap);
        };
    }

    public TracingContext beginParse() {
        return this.traceToMap(this.parseMap);
    }

    public TracingContext beginValidation() {
        return this.traceToMap(this.validationMap);
    }

    private TracingContext traceToMap(Map<String, Object> map) {
        long start = System.nanoTime();
        return () -> {
            long now = System.nanoTime();
            long duration = now - start;
            long startOffset = now - this.startRequestNanos;
            map.put("startOffset", startOffset);
            map.put("duration", duration);
        };
    }

    public Map<String, Object> snapshotTracingData() {
        LinkedHashMap<String, Object> traceMap = new LinkedHashMap<String, Object>();
        traceMap.put("version", 1L);
        traceMap.put("startTime", this.rfc3339(this.startRequestTime));
        traceMap.put("endTime", this.rfc3339(Instant.now()));
        traceMap.put("duration", System.nanoTime() - this.startRequestNanos);
        traceMap.put("parsing", this.copyMap(this.parseMap));
        traceMap.put("validation", this.copyMap(this.validationMap));
        traceMap.put("execution", this.executionData());
        return traceMap;
    }

    private Object copyMap(Map<String, Object> map) {
        return new LinkedHashMap<String, Object>(map);
    }

    private Map<String, Object> executionData() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ImmutableList<Map<String, Object>> list = ImmutableList.copyOf(this.fieldData);
        map.put("resolvers", list);
        return map;
    }

    private String rfc3339(Instant time) {
        return DateTimeFormatter.ISO_INSTANT.format(time);
    }

    public static interface TracingContext {
        public void onEnd();
    }
}

