/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.dsl;

import com.google.common.collect.ImmutableMap;
import io.vavr.Function2;
import io.vavr.Tuple2;
import java.time.Duration;
import java.util.function.Function;
import lombok.Generated;
import org.apache.skywalking.oap.meter.analyzer.dsl.counter.CounterWindow;

public class Sample {
    final String name;
    final ImmutableMap<String, String> labels;
    final double value;
    final long timestamp;

    Sample newValue(Function<Double, Double> transform) {
        return this.toBuilder().value(transform.apply(this.value)).build();
    }

    Sample increase(String range, String metricName, Function2<Double, Long, Double> transform) {
        Tuple2<Long, Double> i = CounterWindow.INSTANCE.increase(metricName, this.labels, this.value, Duration.parse(range).toMillis(), this.timestamp);
        double nv = (Double)transform.apply((Object)((Double)i._2), (Object)((Long)i._1));
        return this.newValue(ignored -> nv);
    }

    Sample increase(String metricName, Function2<Double, Long, Double> transform) {
        Tuple2<Long, Double> i = CounterWindow.INSTANCE.pop(metricName, this.labels, this.value, this.timestamp);
        double nv = (Double)transform.apply((Object)((Double)i._2), (Object)((Long)i._1));
        return this.newValue(ignored -> nv);
    }

    @Generated
    Sample(String name, ImmutableMap<String, String> labels, double value, long timestamp) {
        this.name = name;
        this.labels = labels;
        this.value = value;
        this.timestamp = timestamp;
    }

    @Generated
    public static SampleBuilder builder() {
        return new SampleBuilder();
    }

    @Generated
    public SampleBuilder toBuilder() {
        return new SampleBuilder().name(this.name).labels(this.labels).value(this.value).timestamp(this.timestamp);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ImmutableMap<String, String> this$labels = this.getLabels();
        ImmutableMap<String, String> other$labels = other.getLabels();
        return !(this$labels == null ? other$labels != null : !this$labels.equals(other$labels));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Sample;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ImmutableMap<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : $labels.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Sample(name=" + this.getName() + ", labels=" + String.valueOf(this.getLabels()) + ", value=" + this.getValue() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ImmutableMap<String, String> getLabels() {
        return this.labels;
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public static class SampleBuilder {
        @Generated
        private String name;
        @Generated
        private ImmutableMap<String, String> labels;
        @Generated
        private double value;
        @Generated
        private long timestamp;

        @Generated
        SampleBuilder() {
        }

        @Generated
        public SampleBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public SampleBuilder labels(ImmutableMap<String, String> labels) {
            this.labels = labels;
            return this;
        }

        @Generated
        public SampleBuilder value(double value) {
            this.value = value;
            return this;
        }

        @Generated
        public SampleBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public Sample build() {
            return new Sample(this.name, this.labels, this.value, this.timestamp);
        }

        @Generated
        public String toString() {
            return "Sample.SampleBuilder(name=" + this.name + ", labels=" + String.valueOf(this.labels) + ", value=" + this.value + ", timestamp=" + this.timestamp + ")";
        }
    }
}

