/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.factory.v7plus;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestBuilder;
import com.linecorp.armeria.common.MediaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.requests.IndexRequest;
import org.apache.skywalking.library.elasticsearch.requests.UpdateRequest;
import org.apache.skywalking.library.elasticsearch.requests.factory.DocumentFactory;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class V7DocumentFactory
implements DocumentFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V7DocumentFactory.class);
    private final ElasticSearchVersion version;

    @Override
    public HttpRequest exist(String index, String type, String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id cannot be null or empty");
        return HttpRequest.builder().head("/{index}/_doc/{id}").pathParam("index", (Object)index).pathParam("id", (Object)id).build();
    }

    @Override
    public HttpRequest get(String index, String type, String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id cannot be null or empty");
        return HttpRequest.builder().get("/{index}/_doc/{id}").pathParam("index", (Object)index).pathParam("id", (Object)id).build();
    }

    @Override
    public HttpRequest mget(String index, String type, Iterable<String> ids) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        Preconditions.checkArgument((ids != null && !Iterables.isEmpty(ids) ? 1 : 0) != 0, (Object)"ids cannot be null or empty");
        ImmutableMap m = ImmutableMap.of((Object)"ids", ids);
        byte[] content = this.version.codec().encode(m);
        if (log.isDebugEnabled()) {
            log.debug("mget {} ids: {}", (Object)index, ids);
        }
        return HttpRequest.builder().get("/{index}/_doc/_mget").pathParam("index", (Object)index).content(MediaType.JSON, content).build();
    }

    @Override
    public HttpRequest mget(String type, Map<String, List<String>> indexIds) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        Preconditions.checkArgument((indexIds != null && !indexIds.isEmpty() ? 1 : 0) != 0, (Object)"ids cannot be null or empty");
        ArrayList indexIdList = new ArrayList();
        indexIds.forEach((index, ids) -> {
            Preconditions.checkArgument((ids != null && !Iterables.isEmpty((Iterable)ids) ? 1 : 0) != 0, (Object)"ids cannot be null or empty");
            ids.forEach(id -> indexIdList.add(ImmutableMap.of((Object)"_index", (Object)index, (Object)"_id", (Object)id)));
        });
        ImmutableMap m = ImmutableMap.of((Object)"docs", indexIdList);
        byte[] content = this.version.codec().encode(m);
        if (log.isDebugEnabled()) {
            log.debug("mget indexIds request: {}", (Object)new String(content));
        }
        return HttpRequest.builder().get("/_mget").content(MediaType.JSON, content).build();
    }

    @Override
    public HttpRequest index(IndexRequest request, Map<String, ?> params) {
        Objects.requireNonNull(request, "request");
        String index = request.getIndex();
        String type = request.getType();
        String id = request.getId();
        Map<String, ?> doc = request.getDoc();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"request.index cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"request.type cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"request.id cannot be null or empty");
        HttpRequestBuilder builder = HttpRequest.builder();
        if (params != null) {
            params.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).queryParam(arg_0, arg_1));
        }
        byte[] content = this.version.codec().encode(doc);
        builder.put("/{index}/_doc/{id}").pathParam("index", (Object)index).pathParam("id", (Object)id).content(MediaType.JSON, content);
        return builder.build();
    }

    @Override
    public HttpRequest update(UpdateRequest request, Map<String, ?> params) {
        Objects.requireNonNull(request, "request");
        String index = request.getIndex();
        String type = request.getType();
        String id = request.getId();
        Map<String, Object> doc = request.getDoc();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id cannot be null or empty");
        Preconditions.checkArgument((doc != null && !Iterables.isEmpty(doc.entrySet()) ? 1 : 0) != 0, (Object)"doc cannot be null or empty");
        HttpRequestBuilder builder = HttpRequest.builder();
        if (params != null) {
            params.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).queryParam(arg_0, arg_1));
        }
        byte[] content = this.version.codec().encode(ImmutableMap.of((Object)"doc", doc));
        builder.post("/{index}/_doc/{id}/_update").pathParam("index", (Object)index).pathParam("id", (Object)id).content(MediaType.JSON, content);
        return builder.build();
    }

    @Override
    public HttpRequest delete(String index, String type, Query query, Map<String, ?> params) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        Objects.requireNonNull(query, "query");
        HttpRequestBuilder builder = HttpRequest.builder();
        if (params != null) {
            params.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).queryParam(arg_0, arg_1));
        }
        byte[] content = this.version.codec().encode(ImmutableMap.of((Object)"query", (Object)query));
        return builder.delete("/{index}/_doc/_delete_by_query").pathParam("index", (Object)index).content(MediaType.JSON, content).build();
    }

    @Override
    public HttpRequest deleteById(String index, String type, String id, Map<String, ?> params) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id cannot be null or empty");
        HttpRequestBuilder builder = HttpRequest.builder();
        if (params != null) {
            params.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).queryParam(arg_0, arg_1));
        }
        return builder.delete("/{index}/_doc/{id}").pathParam("index", (Object)index).pathParam("id", (Object)id).build();
    }

    @Generated
    public V7DocumentFactory(ElasticSearchVersion version) {
        this.version = version;
    }
}

