/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.HighlyCompressedMapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;

public final class HighlyCompressedMapStatus$
implements Serializable {
    public static final HighlyCompressedMapStatus$ MODULE$ = new HighlyCompressedMapStatus$();

    private long $lessinit$greater$default$7() {
        return 0L;
    }

    public HighlyCompressedMapStatus apply(BlockManagerId loc, long[] uncompressedSizes, long mapTaskId, long checksumVal) {
        double d;
        int i = 0;
        int numNonEmptyBlocks = 0;
        int numSmallBlocks = 0;
        long totalSmallBlockSize = 0L;
        RoaringBitmap emptyBlocks = new RoaringBitmap();
        int totalNumBlocks = uncompressedSizes.length;
        double accurateBlockSkewedFactor = BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)HighlyCompressedMapStatus$.$anonfun$apply$1(x$3))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)package$.MODULE$.SHUFFLE_ACCURATE_BLOCK_SKEWED_FACTOR().defaultValue().get())));
        long shuffleAccurateBlockThreshold = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)HighlyCompressedMapStatus$.$anonfun$apply$3(x$4))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)package$.MODULE$.SHUFFLE_ACCURATE_BLOCK_THRESHOLD().defaultValue().get())));
        if (accurateBlockSkewedFactor > 0.0) {
            long[] sortedSizes = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(uncompressedSizes), (Ordering)Ordering.Long$.MODULE$);
            long medianSize = Utils$.MODULE$.median(sortedSizes, true);
            int maxAccurateSkewedBlockNumber = Math.min(BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)HighlyCompressedMapStatus$.$anonfun$apply$5(x$5))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)package$.MODULE$.SHUFFLE_MAX_ACCURATE_SKEWED_BLOCK_NUMBER().defaultValue().get()))), totalNumBlocks);
            double skewSizeThreshold = Math.max((double)medianSize * accurateBlockSkewedFactor, (double)sortedSizes[totalNumBlocks - maxAccurateSkewedBlockNumber]);
            d = Math.min((double)shuffleAccurateBlockThreshold, skewSizeThreshold);
        } else {
            d = shuffleAccurateBlockThreshold;
        }
        double threshold = d;
        scala.collection.mutable.Map hugeBlockSizes = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        while (i < totalNumBlocks) {
            long size = uncompressedSizes[i];
            if (size > 0L) {
                ++numNonEmptyBlocks;
                if ((double)size < threshold) {
                    totalSmallBlockSize += size;
                    ++numSmallBlocks;
                } else {
                    hugeBlockSizes.update((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToByte((byte)MapStatus$.MODULE$.compressSize(uncompressedSizes[i])));
                }
            } else {
                emptyBlocks.add(i);
            }
            ++i;
        }
        long avgSize = numSmallBlocks > 0 ? totalSmallBlockSize / (long)numSmallBlocks : 0L;
        emptyBlocks.trim();
        emptyBlocks.runOptimize();
        return new HighlyCompressedMapStatus(loc, numNonEmptyBlocks, emptyBlocks, avgSize, (Map<Object, Object>)hugeBlockSizes, mapTaskId, checksumVal);
    }

    public long apply$default$4() {
        return 0L;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HighlyCompressedMapStatus$.class);
    }

    public static final /* synthetic */ double $anonfun$apply$1(SparkEnv x$3) {
        return BoxesRunTime.unboxToDouble((Object)x$3.conf().get(package$.MODULE$.SHUFFLE_ACCURATE_BLOCK_SKEWED_FACTOR()));
    }

    public static final /* synthetic */ long $anonfun$apply$3(SparkEnv x$4) {
        return BoxesRunTime.unboxToLong((Object)x$4.conf().get(package$.MODULE$.SHUFFLE_ACCURATE_BLOCK_THRESHOLD()));
    }

    public static final /* synthetic */ int $anonfun$apply$5(SparkEnv x$5) {
        return BoxesRunTime.unboxToInt((Object)x$5.conf().get(package$.MODULE$.SHUFFLE_MAX_ACCURATE_SKEWED_BLOCK_NUMBER()));
    }

    private HighlyCompressedMapStatus$() {
    }
}

