/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaIndexToStringExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaIndexToStringExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{0, "a"}), RowFactory.create((Object[])new Object[]{1, "b"}), RowFactory.create((Object[])new Object[]{2, "c"}), RowFactory.create((Object[])new Object[]{3, "a"}), RowFactory.create((Object[])new Object[]{4, "a"}), RowFactory.create((Object[])new Object[]{5, "c"}));
        StructType schema = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("category", DataTypes.StringType, false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        StringIndexerModel indexer = new StringIndexer().setInputCol("category").setOutputCol("categoryIndex").fit(df);
        Dataset indexed = indexer.transform(df);
        System.out.println("Transformed string column '" + indexer.getInputCol() + "' to indexed column '" + indexer.getOutputCol() + "'");
        indexed.show();
        StructField inputColSchema = indexed.schema().apply(indexer.getOutputCol());
        System.out.println("StringIndexer will store labels in output column metadata: " + Attribute.fromStructField((StructField)inputColSchema).toString() + "\n");
        IndexToString converter = new IndexToString().setInputCol("categoryIndex").setOutputCol("originalCategory");
        Dataset converted = converter.transform(indexed);
        System.out.println("Transformed indexed column '" + converter.getInputCol() + "' back to original string column '" + converter.getOutputCol() + "' using labels in metadata");
        converted.select("id", new String[]{"categoryIndex", "originalCategory"}).show();
        spark.stop();
    }
}

