/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.mllib.classification.StreamingLogisticRegressionWithSGD;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class StreamingLogisticRegression$ {
    public static final StreamingLogisticRegression$ MODULE$ = new StreamingLogisticRegression$();

    public void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage: StreamingLogisticRegression <trainingDir> <testDir> <batchDuration> <numFeatures>");
            System.exit(1);
        }
        SparkConf conf = new SparkConf().setMaster("local").setAppName("StreamingLogisticRegression");
        StreamingContext ssc = new StreamingContext(conf, Seconds$.MODULE$.apply(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(args[2]))));
        DStream trainingData = ssc.textFileStream(args[0]).map((Function1 & Serializable)s -> LabeledPoint$.MODULE$.parse(s), ClassTag$.MODULE$.apply(LabeledPoint.class));
        DStream testData = ssc.textFileStream(args[1]).map((Function1 & Serializable)s -> LabeledPoint$.MODULE$.parse(s), ClassTag$.MODULE$.apply(LabeledPoint.class));
        StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.zeros(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[3]))));
        model.trainOn(trainingData);
        model.predictOnValues(testData.map((Function1 & Serializable)lp -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)lp.features()), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Double()).print();
        ssc.start();
        ssc.awaitTermination();
    }

    private StreamingLogisticRegression$() {
    }
}

