/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.state.AcquiredThreadInfo;
import org.apache.spark.sql.execution.streaming.state.AcquiredThreadInfo$;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$ACQUIRED$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$CLOSE$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$CLOSED$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$LOAD$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$MAINTENANCE$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$RELEASE$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateMachine$RELEASED$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rEa\u0001\u00024h\u0001YD!\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011BA\u0005\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\r%\t\u0019\u0003\u0001I\u0001$S\t)cB\u0004\u0002D\u0002AI)!/\u0007\u000f\u0005M\u0006\u0001##\u00026\"9\u0011\u0011\u0004\u0004\u0005\u0002\u0005]\u0006\"CA*\r\u0005\u0005I\u0011IA+\u0011%\t9GBA\u0001\n\u0003\tI\u0007C\u0005\u0002r\u0019\t\t\u0011\"\u0001\u0002<\"I\u0011q\u0010\u0004\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0003\u001f3\u0011\u0011!C\u0001\u0003\u007fC\u0011\"a'\u0007\u0003\u0003%\t%!(\t\u0013\u0005}e!!A\u0005B\u0005\u0005vaBAc\u0001!%\u0015\u0011\u000b\u0004\b\u0003S\u0001\u0001\u0012RA\u0016\u0011\u001d\tI\u0002\u0005C\u0001\u0003\u001fB\u0011\"a\u0015\u0011\u0003\u0003%\t%!\u0016\t\u0013\u0005\u001d\u0004#!A\u0005\u0002\u0005%\u0004\"CA9!\u0005\u0005I\u0011AA:\u0011%\ty\bEA\u0001\n\u0003\n\t\tC\u0005\u0002\u0010B\t\t\u0011\"\u0001\u0002\u0012\"I\u00111\u0014\t\u0002\u0002\u0013\u0005\u0013Q\u0014\u0005\n\u0003?\u0003\u0012\u0011!C!\u0003C;q!a2\u0001\u0011\u0013\u000bIKB\u0004\u0002$\u0002AI)!*\t\u000f\u0005e!\u0004\"\u0001\u0002(\"I\u00111\u000b\u000e\u0002\u0002\u0013\u0005\u0013Q\u000b\u0005\n\u0003OR\u0012\u0011!C\u0001\u0003SB\u0011\"!\u001d\u001b\u0003\u0003%\t!a+\t\u0013\u0005}$$!A\u0005B\u0005\u0005\u0005\"CAH5\u0005\u0005I\u0011AAX\u0011%\tYJGA\u0001\n\u0003\ni\nC\u0005\u0002 j\t\t\u0011\"\u0011\u0002\"\u001a9\u0011\u0011\u001a\u0001\u0002*\u0005-\u0007BCAgG\t\u0005\t\u0015!\u0003\u0002P\"9\u0011\u0011D\u0012\u0005\u0002\u0005u\u0007bBAPG\u0011\u0005\u00131]\u0004\b\u0005O\u0001\u0001\u0012RA\u007f\r\u001d\t9\u0010\u0001EE\u0003sDq!!\u0007)\t\u0003\tY\u0010C\u0005\u0002T!\n\t\u0011\"\u0011\u0002V!I\u0011q\r\u0015\u0002\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0003cB\u0013\u0011!C\u0001\u0003\u007fD\u0011\"a )\u0003\u0003%\t%!!\t\u0013\u0005=\u0005&!A\u0005\u0002\t\r\u0001\"CANQ\u0005\u0005I\u0011IAO\u000f\u001d\u0011I\u0003\u0001EE\u0005;1qAa\u0006\u0001\u0011\u0013\u0013I\u0002C\u0004\u0002\u001aE\"\tAa\u0007\t\u0013\u0005M\u0013'!A\u0005B\u0005U\u0003\"CA4c\u0005\u0005I\u0011AA5\u0011%\t\t(MA\u0001\n\u0003\u0011y\u0002C\u0005\u0002\u0000E\n\t\u0011\"\u0011\u0002\u0002\"I\u0011qR\u0019\u0002\u0002\u0013\u0005!1\u0005\u0005\n\u00037\u000b\u0014\u0011!C!\u0003;;qAa\u000b\u0001\u0011\u0013\u000biOB\u0004\u0002h\u0002AI)!;\t\u000f\u0005e!\b\"\u0001\u0002l\"I\u00111\u000b\u001e\u0002\u0002\u0013\u0005\u0013Q\u000b\u0005\n\u0003OR\u0014\u0011!C\u0001\u0003SB\u0011\"!\u001d;\u0003\u0003%\t!a<\t\u0013\u0005}$(!A\u0005B\u0005\u0005\u0005\"CAHu\u0005\u0005I\u0011AAz\u0011%\tYJOA\u0001\n\u0003\nijB\u0004\u0003.\u0001AII!\u0004\u0007\u000f\t\u001d\u0001\u0001##\u0003\n!9\u0011\u0011D\"\u0005\u0002\t-\u0001\"CA*\u0007\u0006\u0005I\u0011IA+\u0011%\t9gQA\u0001\n\u0003\tI\u0007C\u0005\u0002r\r\u000b\t\u0011\"\u0001\u0003\u0010!I\u0011qP\"\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0003\u001f\u001b\u0015\u0011!C\u0001\u0005'A\u0011\"a'D\u0003\u0003%\t%!(\t\u0013\t=\u0002A1A\u0005\n\tE\u0002\u0002\u0003B\u001d\u0001\u0001\u0006IAa\r\t\u0011!\u0004\u0001\u0019!C\u0005\u0005wA\u0011B!\u0010\u0001\u0001\u0004%IAa\u0010\t\u0011\t%\u0003\u0001)Q\u0005\u0003[A1B!\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003h!Y!q\u000e\u0001A\u0002\u0003\u0007I\u0011\u0002B9\u0011-\u0011)\b\u0001a\u0001\u0002\u0003\u0006KA!\u001b\t\u0013\te\u0004A1A\u0005\n\tm\u0004\u0002\u0003BB\u0001\u0001\u0006IA! \t\u0013\t\u0015\u0005A1A\u0005\n\t\u001d\u0005\u0002\u0003BK\u0001\u0001\u0006IA!#\t\u0011\t]\u0005\u0001\"\u0001p\u00053C!B!)\u0001\u0005\u0004%\ta\u001aBR\u0011!\u00119\f\u0001Q\u0001\n\t\u0015\u0006\"\u0003B]\u0001\u0001\u0007I\u0011\u0002B>\u0011%\u0011Y\f\u0001a\u0001\n\u0013\u0011i\f\u0003\u0005\u0003B\u0002\u0001\u000b\u0015\u0002B?\u0011\u001d\u0011)\r\u0001C\u0005\u0005wBqA!3\u0001\t\u0013\u0011Y\rC\u0004\u0003T\u0002!IA!6\t\u000f\tu\u0007\u0001\"\u0001\u0003`\"9!Q\u001d\u0001\u0005\u0002\t\u001d\b\"\u0003Bx\u0001E\u0005I\u0011\u0001By\u0011\u001d\u0019)\u0001\u0001C\u0001\u0007\u000fAqa!\u0003\u0001\t\u0003\u0019Y\u0001C\u0004\u0004\u000e\u0001!\taa\u0004\u0003'I{7m[:E\u0005N#\u0018\r^3NC\u000eD\u0017N\\3\u000b\u0005!L\u0017!B:uCR,'B\u00016l\u0003%\u0019HO]3b[&twM\u0003\u0002m[\u0006IQ\r_3dkRLwN\u001c\u0006\u0003]>\f1a]9m\u0015\t\u0001\u0018/A\u0003ta\u0006\u00148N\u0003\u0002sg\u00061\u0011\r]1dQ\u0016T\u0011\u0001^\u0001\u0004_J<7\u0001A\n\u0004\u0001]l\bC\u0001=|\u001b\u0005I(\"\u0001>\u0002\u000bM\u001c\u0017\r\\1\n\u0005qL(AB!osJ+g\rE\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003y\u0017\u0001C5oi\u0016\u0014h.\u00197\n\u0007\u0005\u0015qPA\u0004M_\u001e<\u0017N\\4\u0002\u0019M$\u0018\r^3Ti>\u0014X-\u00133\u0011\t\u0005-\u0011QB\u0007\u0002O&\u0019\u0011qB4\u0003\u0019M#\u0018\r^3Ti>\u0014X-\u00133\u0002\u0017I|7m[:E\u0005\u000e{gN\u001a\t\u0005\u0003\u0017\t)\"C\u0002\u0002\u0018\u001d\u00141BU8dWN$%iQ8oM\u00061A(\u001b8jiz\"b!!\b\u0002 \u0005\u0005\u0002cAA\u0006\u0001!9\u0011qA\u0002A\u0002\u0005%\u0001bBA\t\u0007\u0001\u0007\u00111\u0003\u0002\u0006'R\u000bE+R\n\u0003\t]LC\u0001\u0002\t\u001b\r\tA\u0011iQ)V\u0013J+Ei\u0005\u0005\u0011o\u00065\u0012\u0011GA\u001c!\r\ty\u0003B\u0007\u0002\u0001A\u0019\u00010a\r\n\u0007\u0005U\u0012PA\u0004Qe>$Wo\u0019;\u0011\t\u0005e\u0012\u0011\n\b\u0005\u0003w\t)E\u0004\u0003\u0002>\u0005\rSBAA \u0015\r\t\t%^\u0001\u0007yI|w\u000e\u001e \n\u0003iL1!a\u0012z\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0013\u0002N\ta1+\u001a:jC2L'0\u00192mK*\u0019\u0011qI=\u0015\u0005\u0005E\u0003cAA\u0018!\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0016\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!A.\u00198h\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA3\u00037\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA6!\rA\u0018QN\u0005\u0004\u0003_J(aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA;\u0003w\u00022\u0001_A<\u0013\r\tI(\u001f\u0002\u0004\u0003:L\b\"CA?)\u0005\u0005\t\u0019AA6\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0011\t\u0007\u0003\u000b\u000bY)!\u001e\u000e\u0005\u0005\u001d%bAAEs\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0015q\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0014\u0006e\u0005c\u0001=\u0002\u0016&\u0019\u0011qS=\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u0010\f\u0002\u0002\u0003\u0007\u0011QO\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111N\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u000b\u0002\u0007\u00072{5+\u0012#\u0014\u0011i9\u0018QFA\u0019\u0003o!\"!!+\u0011\u0007\u0005=\"\u0004\u0006\u0003\u0002v\u00055\u0006\"CA?=\u0005\u0005\t\u0019AA6)\u0011\t\u0019*!-\t\u0013\u0005u\u0004%!AA\u0002\u0005U$\u0001\u0003*F\u0019\u0016\u000b5+\u0012#\u0014\u0011\u00199\u0018QFA\u0019\u0003o!\"!!/\u0011\u0007\u0005=b\u0001\u0006\u0003\u0002v\u0005u\u0006\"CA?\u0015\u0005\u0005\t\u0019AA6)\u0011\t\u0019*!1\t\u0013\u0005uD\"!AA\u0002\u0005U\u0014\u0001\u0003*F\u0019\u0016\u000b5+\u0012#\u0002\u0011\u0005\u001b\u0015+V%S\u000b\u0012\u000baa\u0011'P'\u0016#%!C(Q\u000bJ\u000bE+S(O'\t\u0019s/\u0001\u0003oC6,\u0007\u0003BAi\u00033tA!a5\u0002VB\u0019\u0011QH=\n\u0007\u0005]\u00170\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\nYNC\u0002\u0002Xf$B!a8\u0002bB\u0019\u0011qF\u0012\t\u000f\u00055W\u00051\u0001\u0002PR\u0011\u0011qZ\u0015\u0006GiB3)\r\u0002\u0006\u00072{5+R\n\bu\u0005}\u0017\u0011GA\u001c)\t\ti\u000fE\u0002\u00020i\"B!!\u001e\u0002r\"I\u0011Q\u0010 \u0002\u0002\u0003\u0007\u00111\u000e\u000b\u0005\u0003'\u000b)\u0010C\u0005\u0002~\u0001\u000b\t\u00111\u0001\u0002v\t!AjT!E'\u001dA\u0013q\\A\u0019\u0003o!\"!!@\u0011\u0007\u0005=\u0002\u0006\u0006\u0003\u0002v\t\u0005\u0001\"CA?Y\u0005\u0005\t\u0019AA6)\u0011\t\u0019J!\u0002\t\u0013\u0005ud&!AA\u0002\u0005U$aC'B\u0013:#VIT!O\u0007\u0016\u001braQAp\u0003c\t9\u0004\u0006\u0002\u0003\u000eA\u0019\u0011qF\"\u0015\t\u0005U$\u0011\u0003\u0005\n\u0003{:\u0015\u0011!a\u0001\u0003W\"B!a%\u0003\u0016!I\u0011QP%\u0002\u0002\u0003\u0007\u0011Q\u000f\u0002\b%\u0016cU)Q*F'\u001d\t\u0014q\\A\u0019\u0003o!\"A!\b\u0011\u0007\u0005=\u0012\u0007\u0006\u0003\u0002v\t\u0005\u0002\"CA?k\u0005\u0005\t\u0019AA6)\u0011\t\u0019J!\n\t\u0013\u0005ut'!AA\u0002\u0005U\u0014\u0001\u0002'P\u0003\u0012\u000bqAU#M\u000b\u0006\u001bV)A\u0003D\u0019>\u001bV)A\u0006N\u0003&sE+\u0012(B\u001d\u000e+\u0015\u0001E:uCR,W*Y2iS:,Gj\\2l+\t\u0011\u0019\u0004\u0005\u0003\u0002Z\tU\u0012\u0002\u0002B\u001c\u00037\u0012aa\u00142kK\u000e$\u0018!E:uCR,W*Y2iS:,Gj\\2lAU\u0011\u0011QF\u0001\ngR\fG/Z0%KF$BA!\u0011\u0003HA\u0019\u0001Pa\u0011\n\u0007\t\u0015\u0013P\u0001\u0003V]&$\b\"CA?\u001d\u0006\u0005\t\u0019AA\u0017\u0003\u0019\u0019H/\u0019;fA!:qJ!\u0014\u0003b\t\r\u0004\u0003\u0002B(\u0005;j!A!\u0015\u000b\t\tM#QK\u0001\u000bG>t7-\u001e:sK:$(\u0002\u0002B,\u00053\n!\"\u00198o_R\fG/[8o\u0015\t\u0011Y&A\u0003kCZ\f\u00070\u0003\u0003\u0003`\tE#!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\t\u0011y#\u0001\nbGF,\u0018N]3e)\"\u0014X-\u00193J]\u001a|WC\u0001B5!\u0011\tYAa\u001b\n\u0007\t5tM\u0001\nBGF,\u0018N]3e)\"\u0014X-\u00193J]\u001a|\u0017AF1dcVL'/\u001a3UQJ,\u0017\rZ%oM>|F%Z9\u0015\t\t\u0005#1\u000f\u0005\n\u0003{\n\u0016\u0011!a\u0001\u0005S\n1#Y2rk&\u0014X\r\u001a+ie\u0016\fG-\u00138g_\u0002BsA\u0015B'\u0005C\u0012\u0019'\u0001\u000fS\u000b2+\u0015iU#E?N#\u0016\tV#`\u001b\u0006\u001b\u0005*\u0013(F?N#\u0016)\u0014)\u0016\u0005\tu\u0004c\u0001=\u0003\u0000%\u0019!\u0011Q=\u0003\t1{gnZ\u0001\u001e%\u0016cU)Q*F\t~\u001bF+\u0011+F?6\u000b5\tS%O\u000b~\u001bF+Q'QA\u00059\u0012\r\u001c7po\u0016$7\u000b^1uKR\u0013\u0018M\\:ji&|gn]\u000b\u0003\u0005\u0013\u0003\u0002\"!5\u0003\f\n=\u0015QF\u0005\u0005\u0005\u001b\u000bYNA\u0002NCB\u0004r\u0001\u001fBI\u0003[\ty.C\u0002\u0003\u0014f\u0014a\u0001V;qY\u0016\u0014\u0014\u0001G1mY><X\rZ*uCR,GK]1og&$\u0018n\u001c8tA\u0005)r-\u001a;BGF,\u0018N]3e)\"\u0014X-\u00193J]\u001a|WC\u0001BN!\u0015A(Q\u0014B5\u0013\r\u0011y*\u001f\u0002\u0007\u001fB$\u0018n\u001c8\u0002#\r,(O]3oiZ\u000bG.\u001b3Ti\u0006l\u0007/\u0006\u0002\u0003&B!!q\u0015BZ\u001b\t\u0011IK\u0003\u0003\u0003,\n5\u0016AB1u_6L7M\u0003\u0003\u0003T\t=&\u0002\u0002BY\u0003?\nA!\u001e;jY&!!Q\u0017BU\u0005)\tEo\\7jG2{gnZ\u0001\u0013GV\u0014(/\u001a8u-\u0006d\u0017\u000eZ*uC6\u0004\b%\u0001\bmCN$h+\u00197jIN#\u0018-\u001c9\u0002%1\f7\u000f\u001e,bY&$7\u000b^1na~#S-\u001d\u000b\u0005\u0005\u0003\u0012y\fC\u0005\u0002~m\u000b\t\u00111\u0001\u0003~\u0005yA.Y:u-\u0006d\u0017\u000eZ*uC6\u0004\b\u0005K\u0004]\u0005\u001b\u0012\tGa\u0019\u0002-%t7-\u00118e\u000f\u0016$8\u000b^1na^KG\u000f\u001b'pG.Ds!\u0018B'\u0005C\u0012\u0019'\u0001\rbo\u0006LGOT8u\u0003\u000e\fX/\u001b:fI^KG\u000f\u001b'pG.$BA!\u0011\u0003N\"9!q\u001a0A\u0002\u0005}\u0017!C8qKJ\fG/[8oQ\u001dq&Q\nB1\u0005G\n!D^1mS\u0012\fG/Z!oIR\u0013\u0018M\\:ji&|gn\u0015;bi\u0016$BAa6\u0003ZB9\u0001P!%\u0002.\u00055\u0002b\u0002Bh?\u0002\u0007\u0011q\u001c\u0015\b?\n5#\u0011\rB2\u0003-1XM]5gsN#\u0018-\u001c9\u0015\t\t\u0005#\u0011\u001d\u0005\b\u0005G\u0004\u0007\u0019\u0001B?\u0003\u0015\u0019H/Y7q\u00031\u0011X\r\\3bg\u0016\u001cF/Y7q)\u0019\t\u0019J!;\u0003l\"9!1]1A\u0002\tu\u0004\"\u0003BwCB\u0005\t\u0019AAJ\u0003\u001d!\bN]8x\u000bb\faC]3mK\u0006\u001cXm\u0015;b[B$C-\u001a4bk2$HEM\u000b\u0003\u0005gTC!a%\u0003v.\u0012!q\u001f\t\u0005\u0005s\u001c\t!\u0004\u0002\u0003|*!!Q B\u0000\u0003%)hn\u00195fG.,GMC\u0002\u0003XeLAaa\u0001\u0003|\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0019\u0005\u001c\u0017/^5sKN#\u0018-\u001c9\u0015\u0005\tu\u0014\u0001\u0006<fe&4\u0017PR8s\u001b\u0006Lg\u000e^3oC:\u001cW\r\u0006\u0002\u0003B\u0005)1\r\\8tKR\u0011\u00111\u0013")
public class RocksDBStateMachine
implements Logging {
    private volatile RocksDBStateMachine$RELEASED$ RELEASED$module;
    private volatile RocksDBStateMachine$ACQUIRED$ ACQUIRED$module;
    private volatile RocksDBStateMachine$CLOSED$ CLOSED$module;
    private volatile RocksDBStateMachine$LOAD$ LOAD$module;
    private volatile RocksDBStateMachine$RELEASE$ RELEASE$module;
    private volatile RocksDBStateMachine$CLOSE$ CLOSE$module;
    private volatile RocksDBStateMachine$MAINTENANCE$ MAINTENANCE$module;
    private final StateStoreId stateStoreId;
    private final RocksDBConf rocksDBConf;
    private final Object stateMachineLock;
    @GuardedBy(value="stateMachineLock")
    private STATE state;
    @GuardedBy(value="stateMachineLock")
    private AcquiredThreadInfo acquiredThreadInfo;
    private final long RELEASED_STATE_MACHINE_STAMP;
    private final scala.collection.immutable.Map<Tuple2<STATE, OPERATION>, STATE> allowedStateTransitions;
    private final AtomicLong currentValidStamp;
    @GuardedBy(value="stateMachineLock")
    private long lastValidStamp;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    private RocksDBStateMachine$RELEASED$ RELEASED() {
        if (this.RELEASED$module == null) {
            this.RELEASED$lzycompute$1();
        }
        return this.RELEASED$module;
    }

    private RocksDBStateMachine$ACQUIRED$ ACQUIRED() {
        if (this.ACQUIRED$module == null) {
            this.ACQUIRED$lzycompute$1();
        }
        return this.ACQUIRED$module;
    }

    private RocksDBStateMachine$CLOSED$ CLOSED() {
        if (this.CLOSED$module == null) {
            this.CLOSED$lzycompute$1();
        }
        return this.CLOSED$module;
    }

    private RocksDBStateMachine$LOAD$ LOAD() {
        if (this.LOAD$module == null) {
            this.LOAD$lzycompute$1();
        }
        return this.LOAD$module;
    }

    private RocksDBStateMachine$RELEASE$ RELEASE() {
        if (this.RELEASE$module == null) {
            this.RELEASE$lzycompute$1();
        }
        return this.RELEASE$module;
    }

    private RocksDBStateMachine$CLOSE$ CLOSE() {
        if (this.CLOSE$module == null) {
            this.CLOSE$lzycompute$1();
        }
        return this.CLOSE$module;
    }

    private RocksDBStateMachine$MAINTENANCE$ MAINTENANCE() {
        if (this.MAINTENANCE$module == null) {
            this.MAINTENANCE$lzycompute$1();
        }
        return this.MAINTENANCE$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Object stateMachineLock() {
        return this.stateMachineLock;
    }

    private STATE state() {
        return this.state;
    }

    private void state_$eq(STATE x$1) {
        this.state = x$1;
    }

    private AcquiredThreadInfo acquiredThreadInfo() {
        return this.acquiredThreadInfo;
    }

    private void acquiredThreadInfo_$eq(AcquiredThreadInfo x$1) {
        this.acquiredThreadInfo = x$1;
    }

    private long RELEASED_STATE_MACHINE_STAMP() {
        return this.RELEASED_STATE_MACHINE_STAMP;
    }

    private scala.collection.immutable.Map<Tuple2<STATE, OPERATION>, STATE> allowedStateTransitions() {
        return this.allowedStateTransitions;
    }

    public Option<AcquiredThreadInfo> getAcquiredThreadInfo() {
        Option option;
        Object object = this.stateMachineLock();
        synchronized (object) {
            option = Option$.MODULE$.apply((Object)this.acquiredThreadInfo()).map((Function1 & Serializable)x$2 -> x$2.copy(x$2.copy$default$1(), x$2.copy$default$2()));
        }
        return option;
    }

    public AtomicLong currentValidStamp() {
        return this.currentValidStamp;
    }

    private long lastValidStamp() {
        return this.lastValidStamp;
    }

    private void lastValidStamp_$eq(long x$1) {
        this.lastValidStamp = x$1;
    }

    @GuardedBy(value="stateMachineLock")
    private long incAndGetStampWithLock() {
        Predef$.MODULE$.assert(Thread.holdsLock(this.stateMachineLock()), (Function0 & Serializable)() -> "Instance lock must be held");
        this.lastValidStamp_$eq(this.lastValidStamp() + 1L);
        this.currentValidStamp().set(this.lastValidStamp());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"New stamp: ", " issued for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STAMP, BoxesRunTime.boxToLong((long)this.currentValidStamp().get()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.stateStoreId)})))));
        return this.lastValidStamp();
    }

    @GuardedBy(value="stateMachineLock")
    private void awaitNotAcquiredWithLock(OPERATION operation) {
        Predef$.MODULE$.assert(Thread.holdsLock(this.stateMachineLock()), (Function0 & Serializable)() -> "Instance lock must be held");
        long waitStartTime = System.nanoTime();
        while (true) {
            STATE sTATE = this.state();
            RocksDBStateMachine$ACQUIRED$ rocksDBStateMachine$ACQUIRED$ = this.ACQUIRED();
            if ((sTATE != null ? !sTATE.equals(rocksDBStateMachine$ACQUIRED$) : rocksDBStateMachine$ACQUIRED$ != null) || RocksDBStateMachine.timeWaitedMs$1(waitStartTime) >= this.rocksDBConf.lockAcquireTimeoutMs()) break;
            this.stateMachineLock().wait(10L);
            if (RocksDBStateMachine.timeWaitedMs$1(waitStartTime) % 30000L != 0L) continue;
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting to acquire lock for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.stateStoreId)}))));
        }
        STATE sTATE = this.state();
        RocksDBStateMachine$ACQUIRED$ rocksDBStateMachine$ACQUIRED$ = this.ACQUIRED();
        if (!(sTATE != null ? !sTATE.equals(rocksDBStateMachine$ACQUIRED$) : rocksDBStateMachine$ACQUIRED$ != null)) {
            AcquiredThreadInfo newAcquiredThreadInfo = new AcquiredThreadInfo(AcquiredThreadInfo$.MODULE$.apply$default$1(), AcquiredThreadInfo$.MODULE$.apply$default$2());
            String stackTraceOutput = Predef$.MODULE$.wrapRefArray((Object[])((Thread)this.acquiredThreadInfo().threadRef().get().get()).getStackTrace()).mkString("\n");
            String loggingId = "StateStoreId(opId=" + this.stateStoreId.operatorId() + ",partId=" + this.stateStoreId.partitionId() + ",name=" + this.stateStoreId.storeName() + ")";
            throw QueryExecutionErrors$.MODULE$.unreleasedThreadError(loggingId, operation.toString(), newAcquiredThreadInfo.toString(), this.acquiredThreadInfo().toString(), RocksDBStateMachine.timeWaitedMs$1(waitStartTime), stackTraceOutput);
        }
    }

    @GuardedBy(value="stateMachineLock")
    private Tuple2<STATE, STATE> validateAndTransitionState(OPERATION operation) {
        Predef$.MODULE$.assert(Thread.holdsLock(this.stateMachineLock()), (Function0 & Serializable)() -> "Instance lock must be held");
        STATE oldState = this.state();
        Option option = this.allowedStateTransitions().get((Object)new Tuple2((Object)oldState, (Object)operation));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                String string;
                OPERATION oPERATION = operation;
                if (this.LOAD().equals(oPERATION)) {
                    string = "ACQUIRED";
                } else if (this.RELEASE().equals(oPERATION)) {
                    string = "RELEASED";
                } else if (this.CLOSE().equals(oPERATION)) {
                    string = "CLOSED";
                } else if (this.MAINTENANCE().equals(oPERATION)) {
                    string = oldState.toString();
                } else {
                    throw new MatchError((Object)oPERATION);
                }
                String expectedState = string;
                throw StateStoreErrors$.MODULE$.invalidStateMachineTransition(oldState.toString(), expectedState, operation.toString(), this.stateStoreId);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        STATE nextState = (STATE)some.value();
        STATE newState = nextState;
        this.state_$eq(newState);
        STATE sTATE = newState;
        RocksDBStateMachine$ACQUIRED$ rocksDBStateMachine$ACQUIRED$ = this.ACQUIRED();
        if (!(sTATE != null ? !sTATE.equals(rocksDBStateMachine$ACQUIRED$) : rocksDBStateMachine$ACQUIRED$ != null)) {
            this.acquiredThreadInfo_$eq(new AcquiredThreadInfo(AcquiredThreadInfo$.MODULE$.apply$default$1(), AcquiredThreadInfo$.MODULE$.apply$default$2()));
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Transitioned state from ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_STATE, oldState)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_STATE, newState)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with operation ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.OPERATION, operation.toString())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for StateStoreId ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.stateStoreId)})))));
        return new Tuple2((Object)oldState, (Object)newState);
    }

    public void verifyStamp(long stamp) {
        long currentStamp = this.currentValidStamp().get();
        if (stamp != currentStamp) {
            throw StateStoreErrors$.MODULE$.invalidStamp(stamp, currentStamp);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean releaseStamp(long stamp, boolean throwEx) {
        Object object = this.stateMachineLock();
        synchronized (object) {
            boolean bl = this.currentValidStamp().compareAndSet(stamp, this.RELEASED_STATE_MACHINE_STAMP());
            if (bl) {
                this.validateAndTransitionState(this.RELEASE());
                return true;
            }
            if (false != bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            boolean bl2 = throwEx;
            if (bl2) {
                long actualStamp = this.currentValidStamp().get();
                throw StateStoreErrors$.MODULE$.invalidStamp(stamp, actualStamp);
            }
            if (false != bl2) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
            return false;
        }
    }

    public boolean releaseStamp$default$2() {
        return true;
    }

    public long acquireStamp() {
        long l;
        Object object = this.stateMachineLock();
        synchronized (object) {
            this.awaitNotAcquiredWithLock(this.LOAD());
            this.validateAndTransitionState(this.LOAD());
            l = this.incAndGetStampWithLock();
        }
        return l;
    }

    public void verifyForMaintenance() {
        Object object = this.stateMachineLock();
        synchronized (object) {
            this.validateAndTransitionState(this.MAINTENANCE());
        }
    }

    public boolean close() {
        boolean bl;
        Object object = this.stateMachineLock();
        synchronized (object) {
            boolean bl2;
            STATE sTATE = this.state();
            RocksDBStateMachine$CLOSED$ rocksDBStateMachine$CLOSED$ = this.CLOSED();
            if (!(sTATE != null ? !sTATE.equals(rocksDBStateMachine$CLOSED$) : rocksDBStateMachine$CLOSED$ != null)) {
                bl2 = false;
            } else {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to close store ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.stateStoreId)}))));
                this.awaitNotAcquiredWithLock(this.CLOSE());
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Finished waiting to acquire lock,"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" transitioning to close store ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_STORE_ID, $this.stateStoreId)})))));
                this.validateAndTransitionState(this.CLOSE());
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    private final void RELEASED$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.RELEASED$module == null) {
                this.RELEASED$module = new RocksDBStateMachine$RELEASED$(this);
            }
        }
    }

    private final void ACQUIRED$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.ACQUIRED$module == null) {
                this.ACQUIRED$module = new RocksDBStateMachine$ACQUIRED$(this);
            }
        }
    }

    private final void CLOSED$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.CLOSED$module == null) {
                this.CLOSED$module = new RocksDBStateMachine$CLOSED$(this);
            }
        }
    }

    private final void LOAD$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.LOAD$module == null) {
                this.LOAD$module = new RocksDBStateMachine$LOAD$(this);
            }
        }
    }

    private final void RELEASE$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.RELEASE$module == null) {
                this.RELEASE$module = new RocksDBStateMachine$RELEASE$(this);
            }
        }
    }

    private final void CLOSE$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.CLOSE$module == null) {
                this.CLOSE$module = new RocksDBStateMachine$CLOSE$(this);
            }
        }
    }

    private final void MAINTENANCE$lzycompute$1() {
        RocksDBStateMachine rocksDBStateMachine = this;
        synchronized (rocksDBStateMachine) {
            if (this.MAINTENANCE$module == null) {
                this.MAINTENANCE$module = new RocksDBStateMachine$MAINTENANCE$(this);
            }
        }
    }

    private static final long timeWaitedMs$1(long waitStartTime$1) {
        long elapsedNanos = System.nanoTime() - waitStartTime$1;
        return TimeUnit.MILLISECONDS.convert(elapsedNanos, TimeUnit.NANOSECONDS);
    }

    public RocksDBStateMachine(StateStoreId stateStoreId, RocksDBConf rocksDBConf) {
        this.stateStoreId = stateStoreId;
        this.rocksDBConf = rocksDBConf;
        Logging.$init$((Logging)this);
        this.stateMachineLock = new Object();
        this.state = this.RELEASED();
        this.RELEASED_STATE_MACHINE_STAMP = -1L;
        this.allowedStateTransitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.RELEASED(), (Object)this.LOAD())), (Object)this.ACQUIRED()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.ACQUIRED(), (Object)this.RELEASE())), (Object)this.RELEASED()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.RELEASED(), (Object)this.CLOSE())), (Object)this.CLOSED()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.CLOSED(), (Object)this.CLOSE())), (Object)this.CLOSED()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.RELEASED(), (Object)this.MAINTENANCE())), (Object)this.RELEASED()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.ACQUIRED(), (Object)this.MAINTENANCE())), (Object)this.ACQUIRED())}));
        this.currentValidStamp = new AtomicLong(this.RELEASED_STATE_MACHINE_STAMP());
        this.lastValidStamp = 0L;
    }

    private abstract class OPERATION {
        private final String name;
        public final /* synthetic */ RocksDBStateMachine $outer;

        public String toString() {
            return this.name;
        }

        public /* synthetic */ RocksDBStateMachine org$apache$spark$sql$execution$streaming$state$RocksDBStateMachine$OPERATION$$$outer() {
            return this.$outer;
        }

        public OPERATION(RocksDBStateMachine $outer, String name) {
            this.name = name;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private interface STATE {
    }
}

