/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.render;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.CannotRenderException;
import org.apache.tiles.request.render.Renderer;

public class ChainedDelegateRenderer
implements Renderer {
    private final List<Renderer> renderers = new ArrayList<Renderer>();

    public void addAttributeRenderer(Renderer renderer) {
        this.renderers.add(renderer);
    }

    @Override
    public void render(String value, Request request) throws IOException {
        if (value == null) {
            throw new NullPointerException("The attribute value is null");
        }
        for (Renderer renderer : this.renderers) {
            if (!renderer.isRenderable(value, request)) continue;
            renderer.render(value, request);
            return;
        }
        throw new CannotRenderException("Cannot renderer value '" + value + "'");
    }

    @Override
    public boolean isRenderable(String value, Request request) {
        for (Renderer renderer : this.renderers) {
            if (!renderer.isRenderable(value, request)) continue;
            return true;
        }
        return false;
    }
}

