/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.saml.common.binding.artifact.AbstractSAMLArtifact;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;

public class SamlCompliantUniqueTicketIdGenerator
implements UniqueTicketIdGenerator {
    private static final int ASSERTION_HANDLE_SIZE = 20;
    private static final byte[] ENDPOINT_ID = new byte[]{0, 1};
    private final byte[] sourceIdDigest = (byte[])FunctionUtils.doUnchecked(() -> DigestUtils.rawDigest((String)"SHA", (byte[])sourceId.getBytes(StandardCharsets.ISO_8859_1)));
    private boolean saml2compliant;

    public SamlCompliantUniqueTicketIdGenerator(String sourceId) {
    }

    public String getNewTicketId(String prefix) {
        return (String)FunctionUtils.doUnchecked(() -> {
            AbstractSAMLArtifact artifact = this.getSAMLArtifactType();
            return prefix + "-" + artifact.base64Encode();
        });
    }

    private AbstractSAMLArtifact getSAMLArtifactType() {
        if (this.saml2compliant) {
            return new SAML2ArtifactType0004(ENDPOINT_ID, SamlCompliantUniqueTicketIdGenerator.newAssertionHandle(), this.sourceIdDigest);
        }
        return new SAML1ArtifactType0001(this.sourceIdDigest, SamlCompliantUniqueTicketIdGenerator.newAssertionHandle());
    }

    private static byte[] newAssertionHandle() {
        byte[] handle = new byte[20];
        RandomUtils.getNativeInstance().nextBytes(handle);
        return handle;
    }

    @Generated
    public void setSaml2compliant(boolean saml2compliant) {
        this.saml2compliant = saml2compliant;
    }
}

