/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clients
extends InitializableObject {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Clients.class);
    private volatile List<Client> clients = new ArrayList<Client>();
    private Map<String, Client> clientsMap;
    private volatile Integer oldClientsHash;
    private String callbackUrl;
    private AjaxRequestResolver ajaxRequestResolver;
    private UrlResolver urlResolver;
    private CallbackUrlResolver callbackUrlResolver;
    private List<AuthorizationGenerator> authorizationGenerators = new ArrayList<AuthorizationGenerator>();
    private String defaultSecurityClients;

    public Clients() {
    }

    public Clients(String callbackUrl, List<Client> clients) {
        this.setCallbackUrl(callbackUrl);
        this.setClients(clients);
    }

    public Clients(String callbackUrl, Client ... clients) {
        this.setCallbackUrl(callbackUrl);
        this.setClients(clients);
    }

    public Clients(List<Client> clients) {
        this.setClients(clients);
    }

    public Clients(Client ... clients) {
        this.setClients(clients);
    }

    @Override
    protected boolean shouldInitialize(boolean forceReinit) {
        if (forceReinit) {
            return true;
        }
        return this.oldClientsHash == null || this.oldClientsHash.intValue() != this.clients.hashCode();
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        this.clientsMap = new HashMap<String, Client>();
        for (Client client : this.clients) {
            String name = client.getName();
            CommonHelper.assertNotBlank("name", name);
            String lowerTrimmedName = name.toLowerCase().trim();
            if (this.clientsMap.containsKey(lowerTrimmedName)) {
                throw new TechnicalException("Duplicate name in clients: " + name);
            }
            this.clientsMap.put(lowerTrimmedName, client);
            if (client instanceof IndirectClient) {
                IndirectClient indirectClient = (IndirectClient)client;
                if (this.callbackUrl != null && indirectClient.getCallbackUrl() == null) {
                    indirectClient.setCallbackUrl(this.callbackUrl);
                }
                if (this.urlResolver != null && indirectClient.getUrlResolver() == null) {
                    indirectClient.setUrlResolver(this.urlResolver);
                }
                if (this.callbackUrlResolver != null && indirectClient.getCallbackUrlResolver() == null) {
                    indirectClient.setCallbackUrlResolver(this.callbackUrlResolver);
                }
                if (this.ajaxRequestResolver != null && indirectClient.getAjaxRequestResolver() == null) {
                    indirectClient.setAjaxRequestResolver(this.ajaxRequestResolver);
                }
            }
            BaseClient baseClient = (BaseClient)client;
            if (this.authorizationGenerators.isEmpty()) continue;
            baseClient.addAuthorizationGenerators(this.authorizationGenerators);
        }
        this.oldClientsHash = this.clients.hashCode();
    }

    public Optional<Client> findClient(String name) {
        CommonHelper.assertNotBlank("name", name);
        this.init();
        Client foundClient = this.clientsMap.get(name.toLowerCase().trim());
        LOGGER.debug("Found client: {} for name: {}", (Object)foundClient, (Object)name);
        return Optional.ofNullable(foundClient);
    }

    public List<Client> findAllClients() {
        this.init();
        return this.getClients();
    }

    public void addClient(Client client) {
        this.clients.add(client);
    }

    public void setClients(List<Client> clients) {
        CommonHelper.assertNotNull("clients", clients);
        this.clients = clients;
    }

    public void setClients(Client ... clients) {
        CommonHelper.assertNotNull("clients", clients);
        this.setClients(new ArrayList<Client>(Arrays.asList(clients)));
    }

    public void setAuthorizationGenerators(List<AuthorizationGenerator> authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators = authorizationGenerators;
    }

    public void setAuthorizationGenerators(AuthorizationGenerator ... authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators = Arrays.asList(authorizationGenerators);
    }

    public void setAuthorizationGenerator(AuthorizationGenerator authorizationGenerator) {
        this.addAuthorizationGenerator(authorizationGenerator);
    }

    public void addAuthorizationGenerator(AuthorizationGenerator authorizationGenerator) {
        CommonHelper.assertNotNull("authorizationGenerator", authorizationGenerator);
        this.authorizationGenerators.add(authorizationGenerator);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Client> getClients() {
        return this.clients;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Client> getClientsMap() {
        return this.clientsMap;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getOldClientsHash() {
        return this.oldClientsHash;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<AuthorizationGenerator> getAuthorizationGenerators() {
        return this.authorizationGenerators;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDefaultSecurityClients() {
        return this.defaultSecurityClients;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientsMap(Map<String, Client> clientsMap) {
        this.clientsMap = clientsMap;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setOldClientsHash(Integer oldClientsHash) {
        this.oldClientsHash = oldClientsHash;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        this.ajaxRequestResolver = ajaxRequestResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDefaultSecurityClients(String defaultSecurityClients) {
        this.defaultSecurityClients = defaultSecurityClients;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Clients(clients=" + this.clients + ", clientsMap=" + this.clientsMap + ", oldClientsHash=" + this.oldClientsHash + ", callbackUrl=" + this.callbackUrl + ", ajaxRequestResolver=" + this.ajaxRequestResolver + ", urlResolver=" + this.urlResolver + ", callbackUrlResolver=" + this.callbackUrlResolver + ", authorizationGenerators=" + this.authorizationGenerators + ", defaultSecurityClients=" + this.defaultSecurityClients + ")";
    }
}

