/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.ReportCheck;
import org.springframework.scheduling.support.CronExpression;

public class ReportValidator
extends AbstractValidator<ReportCheck, Report> {
    public boolean isValid(Report report, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (ReportValidator.isHtml(report.getName())) {
            context.buildConstraintViolationWithTemplate(ReportValidator.getTemplate(EntityViolationType.InvalidName, report.getName())).addPropertyNode("name").addConstraintViolation();
            isValid = false;
        }
        if (report.getCronExpression() != null) {
            try {
                CronExpression.parse((String)report.getCronExpression());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid cron expression '{}'", (Object)report.getCronExpression(), (Object)e);
                isValid = false;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(ReportValidator.getTemplate(EntityViolationType.InvalidReport, "Invalid cron expression")).addPropertyNode("cronExpression").addConstraintViolation();
            }
        }
        return isValid;
    }
}

