/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationResponse;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientRegistrationUtils;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public class OidcDynamicClientRegistrationEndpointController
extends BaseOidcController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcDynamicClientRegistrationEndpointController.class);

    public OidcDynamicClientRegistrationEndpointController(OidcConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @PostMapping(value={"/oidc/register", "/**/register"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity handleRequestInternal(@RequestBody String jsonInput, HttpServletRequest request, HttpServletResponse response) {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "register")) {
            Map body = OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer");
            return new ResponseEntity((Object)body, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        try {
            OidcClientRegistrationRequest registrationRequest = (OidcClientRegistrationRequest)((OidcConfigurationContext)this.getConfigurationContext()).getClientRegistrationRequestSerializer().from(jsonInput);
            LOGGER.debug("Received client registration request [{}]", (Object)registrationRequest);
            OidcRegisteredService registeredService = ((OidcConfigurationContext)this.getConfigurationContext()).getClientRegistrationRequestTranslator().translate(registrationRequest, Optional.empty());
            registeredService.markAsDynamicallyRegistered();
            OidcRegisteredService savedService = (OidcRegisteredService)((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager().save((RegisteredService)registeredService);
            OidcClientRegistrationResponse clientResponse = OidcClientRegistrationUtils.getClientRegistrationResponse(savedService, ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getServer().getPrefix());
            OAuth20AccessToken accessToken = this.generateRegistrationAccessToken(request, response, savedService, registrationRequest);
            EncodableCipher cipher = OAuth20JwtAccessTokenEncoder.toEncodableCipher((OAuth20ConfigurationContext)this.getConfigurationContext(), (RegisteredService)savedService, (OAuth20Token)accessToken, (Service)accessToken.getService(), (boolean)false);
            String encodedAccessToken = (String)cipher.encode((Object)accessToken.getId());
            clientResponse.setRegistrationAccessToken(encodedAccessToken);
            return new ResponseEntity((Object)clientResponse, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            Map map = OAuth20Utils.getErrorResponseBody((String)"invalid_client_metadata", (String)((String)StringUtils.defaultIfBlank((CharSequence)e.getMessage(), (CharSequence)"None")));
            return new ResponseEntity((Object)map, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    protected OAuth20AccessToken generateRegistrationAccessToken(HttpServletRequest request, HttpServletResponse response, OidcRegisteredService registeredService, OidcClientRegistrationRequest registrationRequest) throws Throwable {
        Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(registeredService.getClientId());
        Authentication authn = DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).build();
        String clientConfigUri = OidcClientRegistrationUtils.getClientConfigurationUri(registeredService, ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getServer().getPrefix());
        WebApplicationService service = (WebApplicationService)((OidcConfigurationContext)this.getConfigurationContext()).getWebApplicationServiceServiceFactory().createService(clientConfigUri);
        OAuth20AccessTokenFactory factory = (OAuth20AccessTokenFactory)((OidcConfigurationContext)this.getConfigurationContext()).getTicketFactory().get(OAuth20AccessToken.class);
        OAuth20AccessToken accessToken = factory.create((Service)service, authn, List.of("client_configuration_scope"), registeredService.getClientId(), OAuth20ResponseTypes.NONE, OAuth20GrantTypes.NONE);
        ((OidcConfigurationContext)this.getConfigurationContext()).getTicketRegistry().addTicket((Ticket)accessToken);
        return accessToken;
    }
}

