/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.api.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.SCIMBean;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.apache.syncope.ext.scimv2.api.type.Resource;

@JsonPropertyOrder(value={"schemas", "scimType", "detail", "status"})
public class SCIMError
extends SCIMBean {
    private static final long serialVersionUID = -8836902509266522394L;
    private final List<String> schemas = List.of(Resource.Error.schema());
    private ErrorType scimType;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private int status;
    private final String detail;

    public SCIMError(BadRequestException ex) {
        this(ex.getErrorType(), Response.Status.BAD_REQUEST.getStatusCode(), ex.getMessage());
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SCIMError(@JsonProperty(value="scimType") ErrorType scimType, @JsonProperty(value="status") int status, @JsonProperty(value="detail") String detail) {
        this.scimType = scimType;
        this.status = status;
        this.detail = detail;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public ErrorType getScimType() {
        return this.scimType;
    }

    public String getDetail() {
        return this.detail;
    }

    public int getStatus() {
        return this.status;
    }
}

