/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients.service.token;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.common.clients.service.token.CSPURLConnectionFactory;
import com.wavefront.sdk.common.clients.service.token.TokenService;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSPServerTokenURLConnectionFactory
extends CSPURLConnectionFactory {
    private static final String OAUTH_PATH = "/csp/gateway/am/api/auth/authorize";
    private final String cspClientId;
    private final String cspClientSecret;
    private final byte[] postData;

    public CSPServerTokenURLConnectionFactory(@Nullable String cspBaseURL, String cspClientId, String cspClientSecret, @Nullable String cspOrgId) {
        super(cspBaseURL);
        this.cspClientId = cspClientId;
        this.cspClientSecret = cspClientSecret;
        String postData = "grant_type=client_credentials";
        if (!Utils.isNullOrEmpty(cspOrgId)) {
            postData = postData + "&orgId=" + cspOrgId;
        }
        this.postData = postData.getBytes(StandardCharsets.UTF_8);
    }

    public CSPServerTokenURLConnectionFactory(@Nullable String cspBaseURL, String cspClientId, String cspClientSecret, @Nullable String cspOrgId, int connectTimeoutMillis, int readTimeoutMillis) {
        this(cspBaseURL, cspClientId, cspClientSecret, cspOrgId);
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public CSPServerTokenURLConnectionFactory(String compoundCreds) {
        this(CSPServerTokenURLConnectionFactory.parseClientCredentials(compoundCreds));
    }

    private CSPServerTokenURLConnectionFactory(Map<CredentialPart, String> credentialParts) {
        this(credentialParts.getOrDefault((Object)CredentialPart.BASE_URL, null), credentialParts.get((Object)CredentialPart.CLIENT_ID), credentialParts.get((Object)CredentialPart.CLIENT_SECRET), credentialParts.getOrDefault((Object)CredentialPart.ORG_ID, null));
    }

    @Override
    public HttpURLConnection build() throws IOException {
        URL url = new URL(this.cspBaseURL + OAUTH_PATH);
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setConnectTimeout(this.connectTimeoutMillis);
        urlConn.setReadTimeout(this.readTimeoutMillis);
        urlConn.setRequestMethod("POST");
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setRequestProperty("Accept", "application/json");
        urlConn.setRequestProperty("Content-Length", Integer.toString(this.postData.length));
        urlConn.setRequestProperty("Authorization", "Basic " + this.buildHttpBasicToken(this.cspClientId, this.cspClientSecret));
        return urlConn;
    }

    @Override
    public byte[] getPostData() {
        return this.postData;
    }

    private String buildHttpBasicToken(String cspClientId, String cspClientSecret) {
        String encodeMe = cspClientId + ":" + cspClientSecret;
        return Base64.getEncoder().encodeToString(encodeMe.getBytes());
    }

    @Override
    public TokenService.Type getTokenType() {
        return TokenService.Type.CSP_CLIENT_CREDENTIALS;
    }

    @VisibleForTesting
    public static Map<CredentialPart, String> parseClientCredentials(String compoundCredentials) {
        IllegalArgumentException ex = new IllegalArgumentException("CSP Client Credentials must be a comma-delimited string of clientId, clientSecret, and an optional orgId and baseUrl.");
        HashMap<CredentialPart, String> parsedCreds = new HashMap<CredentialPart, String>();
        String[] parts = compoundCredentials.split(",");
        if (parts.length < 2 || parts.length > 4) {
            throw ex;
        }
        Pattern p = Pattern.compile("(clientId|clientSecret|orgId|baseUrl)=(\\\"|'?)(.+)(\\2)", 2);
        block12: for (String part : parts) {
            Matcher m = p.matcher(part.trim());
            if (!m.matches() || m.groupCount() != 4) {
                throw ex;
            }
            switch (m.group(1).toLowerCase()) {
                case "clientid": {
                    parsedCreds.put(CredentialPart.CLIENT_ID, m.group(3));
                    continue block12;
                }
                case "clientsecret": {
                    parsedCreds.put(CredentialPart.CLIENT_SECRET, m.group(3));
                    continue block12;
                }
                case "orgid": {
                    parsedCreds.put(CredentialPart.ORG_ID, m.group(3));
                    continue block12;
                }
                case "baseurl": {
                    parsedCreds.put(CredentialPart.BASE_URL, m.group(3));
                }
            }
        }
        return parsedCreds;
    }

    public static enum CredentialPart {
        BASE_URL,
        CLIENT_ID,
        CLIENT_SECRET,
        ORG_ID;

    }
}

