/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.provisioning.api.data.DynRealmDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class DynRealmLogic
extends AbstractTransactionalLogic<DynRealmTO> {
    protected final DynRealmDataBinder binder;
    protected final DynRealmDAO dynRealmDAO;

    public DynRealmLogic(DynRealmDataBinder binder, DynRealmDAO dynRealmDAO) {
        this.binder = binder;
        this.dynRealmDAO = dynRealmDAO;
    }

    @PreAuthorize(value="hasRole('DYNREALM_READ')")
    @Transactional(readOnly=true)
    public DynRealmTO read(String key) {
        DynRealm dynRealm = (DynRealm)this.dynRealmDAO.findById(key).orElseThrow(() -> new NotFoundException("DynRealm " + key));
        return this.binder.getDynRealmTO(dynRealm);
    }

    @Transactional(readOnly=true)
    public List<DynRealmTO> list() {
        return this.dynRealmDAO.findAll().stream().map(arg_0 -> ((DynRealmDataBinder)this.binder).getDynRealmTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('DYNREALM_CREATE')")
    public DynRealmTO create(DynRealmTO dynRealmTO) {
        return this.binder.getDynRealmTO(this.binder.create(dynRealmTO));
    }

    @PreAuthorize(value="hasRole('DYNREALM_UPDATE')")
    public DynRealmTO update(DynRealmTO dynRealmTO) {
        DynRealm dynRealm = (DynRealm)this.dynRealmDAO.findById(dynRealmTO.getKey()).orElseThrow(() -> new NotFoundException("DynRealm " + dynRealmTO.getKey()));
        return this.binder.getDynRealmTO(this.binder.update(dynRealm, dynRealmTO));
    }

    @PreAuthorize(value="hasRole('DYNREALM_DELETE')")
    public DynRealmTO delete(String key) {
        DynRealm dynRealm = (DynRealm)this.dynRealmDAO.findById(key).orElseThrow(() -> new NotFoundException("DynRealm " + key));
        DynRealmTO deleted = this.binder.getDynRealmTO(dynRealm);
        this.dynRealmDAO.deleteById(key);
        return deleted;
    }

    @Override
    protected DynRealmTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof DynRealmTO)) continue;
                DynRealmTO dynRealmTO = (DynRealmTO)object;
                key = dynRealmTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getDynRealmTO((DynRealm)this.dynRealmDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

