/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.introspection.BaseOAuth20IntrospectionAccessTokenResponse;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenFailureResponse;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenResponse;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class OAuth20IntrospectionEndpointController<T extends OAuth20ConfigurationContext>
extends BaseOAuth20Controller<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20IntrospectionEndpointController.class);

    public OAuth20IntrospectionEndpointController(T context) {
        super(context);
    }

    private static ResponseEntity<OAuth20IntrospectionAccessTokenFailureResponse> buildUnauthorizedResponseEntity(String code, boolean isAuthenticationFailure) {
        OAuth20IntrospectionAccessTokenFailureResponse response = new OAuth20IntrospectionAccessTokenFailureResponse();
        response.setError(code);
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        if (isAuthenticationFailure) {
            headers.add((Object)"WWW-Authenticate", (Object)"Basic");
        }
        return new ResponseEntity((Object)response, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    private static ResponseEntity<OAuth20IntrospectionAccessTokenFailureResponse> buildBadRequestResponseEntity(String code) {
        OAuth20IntrospectionAccessTokenFailureResponse response = new OAuth20IntrospectionAccessTokenFailureResponse();
        response.setError(code);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/oauth2.0/introspect"}, produces={"application/json"})
    public ResponseEntity<? extends BaseOAuth20IntrospectionAccessTokenResponse> handleRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.handlePostRequest(request, response);
    }

    @PostMapping(value={"/oauth2.0/introspect"}, produces={"application/json"})
    public ResponseEntity handlePostRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        try {
            JEEContext context = new JEEContext(request, response);
            Optional<Credentials> credentialsResult = this.extractCredentials(context);
            if (credentialsResult.isEmpty()) {
                LOGGER.warn("Unable to locate and extract credentials from the request");
                return OAuth20IntrospectionEndpointController.buildUnauthorizedResponseEntity("invalid_client", true);
            }
            UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)credentialsResult.get();
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(((OAuth20ConfigurationContext)this.getConfigurationContext()).getServicesManager(), credentials.getUsername());
            if (registeredService == null) {
                LOGGER.warn("Unable to locate service definition by client id [{}]", (Object)credentials.getUsername());
                return OAuth20IntrospectionEndpointController.buildUnauthorizedResponseEntity("invalid_client", true);
            }
            Optional<ResponseEntity<BaseOAuth20IntrospectionAccessTokenResponse>> validationError = this.validateIntrospectionRequest(registeredService, credentials, request);
            if (validationError.isPresent()) {
                return validationError.get();
            }
            String tokenId = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("token"), (CharSequence)request.getParameter("access_token"));
            LOGGER.debug("Located access token [{}] in the request", (Object)tokenId);
            Map protocolMap = CollectionUtils.wrap((String)"Token", (Object)tokenId, (String)"Client ID", (Object)registeredService.getClientId(), (String)"Service", (Object)registeredService.getName());
            LoggingUtils.protocolMessage((String)"OpenID Connect Introspection Request", (Map)protocolMap);
            OAuth20Token accessToken = this.fetchTokenFromRegistry(tokenId);
            OAuth20IntrospectionAccessTokenResponse introspect = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getIntrospectionResponseGenerator().stream().filter(generator -> generator.supports(accessToken)).findFirst().orElseThrow().generate(tokenId, accessToken);
            return this.buildIntrospectionEntityResponse((WebContext)context, introspect);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return OAuth20IntrospectionEndpointController.buildBadRequestResponseEntity("invalid_request");
        }
    }

    private OAuth20Token fetchTokenFromRegistry(String accessTokenId) {
        try {
            String token = this.extractAccessTokenFrom(accessTokenId);
            return (OAuth20Token)((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().getTicket(token, OAuth20Token.class);
        }
        catch (InvalidTicketException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            LOGGER.info("Unable to fetch access token [{}]: [{}]", (Object)accessTokenId, (Object)e.getMessage());
            return null;
        }
    }

    protected Optional<Credentials> extractCredentials(JEEContext context) {
        BasicAuthExtractor authExtractor = new BasicAuthExtractor();
        CallContext callContext = new CallContext((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore(), ((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthConfig().getProfileManagerFactory());
        return authExtractor.extract(callContext);
    }

    private Optional<ResponseEntity<? extends BaseOAuth20IntrospectionAccessTokenResponse>> validateIntrospectionRequest(OAuthRegisteredService registeredService, UsernamePasswordCredentials credentials, HttpServletRequest request) throws Throwable {
        boolean tokenExists;
        boolean bl = tokenExists = HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"token") || HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"access_token");
        if (!tokenExists) {
            LOGGER.warn("Access token cannot be found in the request");
            return Optional.of(OAuth20IntrospectionEndpointController.buildBadRequestResponseEntity("missing_accessToken"));
        }
        if (((OAuth20ConfigurationContext)this.getConfigurationContext()).getClientSecretValidator().validate(registeredService, credentials.getPassword())) {
            WebApplicationService service = (WebApplicationService)((OAuth20ConfigurationContext)this.getConfigurationContext()).getWebApplicationServiceServiceFactory().createService(registeredService.getServiceId());
            AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRegisteredServiceAccessStrategyEnforcer().execute(audit);
            return accessResult.isExecutionFailure() ? Optional.of(OAuth20IntrospectionEndpointController.buildUnauthorizedResponseEntity("unauthorized_client", false)) : Optional.empty();
        }
        LOGGER.warn("Unable to match client secret for registered service [{}] with client id [{}]", (Object)registeredService.getName(), (Object)registeredService.getClientId());
        return Optional.of(OAuth20IntrospectionEndpointController.buildUnauthorizedResponseEntity("invalid_client", true));
    }

    protected ResponseEntity buildIntrospectionEntityResponse(WebContext context, OAuth20IntrospectionAccessTokenResponse introspect) {
        return new ResponseEntity((Object)introspect, (HttpStatusCode)HttpStatus.OK);
    }
}

