/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import java.util.Set;
import org.ldaptive.CompareOperation;
import org.ldaptive.CompareRequest;
import org.ldaptive.CompareResponse;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapURL;
import org.ldaptive.ResultCode;
import org.ldaptive.handler.ReferralResultHandler;
import org.ldaptive.referral.AbstractFollowReferralHandler;
import org.ldaptive.referral.DefaultReferralConnectionFactory;
import org.ldaptive.referral.ReferralConnectionFactory;
import org.ldaptive.transport.DefaultCompareOperationHandle;

public class FollowCompareReferralHandler
extends AbstractFollowReferralHandler<CompareRequest, CompareResponse>
implements ReferralResultHandler<CompareResponse> {
    public FollowCompareReferralHandler() {
        this(10, 1, new DefaultReferralConnectionFactory(), false);
    }

    public FollowCompareReferralHandler(ReferralConnectionFactory factory) {
        this(10, 1, factory, false);
    }

    public FollowCompareReferralHandler(ReferralConnectionFactory factory, boolean tf) {
        this(10, 1, factory, tf);
    }

    public FollowCompareReferralHandler(int limit) {
        this(limit, 1, new DefaultReferralConnectionFactory(), false);
    }

    public FollowCompareReferralHandler(int limit, ReferralConnectionFactory factory) {
        this(limit, 1, factory, false);
    }

    public FollowCompareReferralHandler(int limit, ReferralConnectionFactory factory, boolean tf) {
        this(limit, 1, factory, tf);
    }

    private FollowCompareReferralHandler(int limit, int depth, ReferralConnectionFactory factory, boolean tf) {
        super(limit, depth, factory, tf);
    }

    @Override
    protected CompareRequest createReferralRequest(LdapURL url) {
        CompareRequest request = (CompareRequest)((CompareRequest.Builder)CompareRequest.builder().controls(((CompareRequest)this.getRequest()).getControls())).dn(!url.getUrl().isDefaultBaseDn() ? url.getUrl().getBaseDn() : ((CompareRequest)this.getRequest()).getDn()).name(((CompareRequest)this.getRequest()).getName()).value(((CompareRequest)this.getRequest()).getValue()).build();
        if (((CompareRequest)this.getRequest()).getResponseTimeout() != null) {
            request.setResponseTimeout(request.getResponseTimeout());
        }
        return request;
    }

    protected CompareOperation createReferralOperation(ConnectionFactory factory) {
        DefaultCompareOperationHandle handle = (DefaultCompareOperationHandle)this.getHandle();
        CompareOperation op = new CompareOperation(factory);
        op.setResultHandlers(handle.getOnResult());
        op.setControlHandlers(handle.getOnControl());
        op.setReferralHandlers(handle.getOnReferral());
        op.setIntermediateResponseHandlers(handle.getOnIntermediate());
        op.setExceptionHandler(handle.getOnException());
        op.setUnsolicitedNotificationHandlers(handle.getOnUnsolicitedNotification());
        op.setCompareValueHandlers(handle.getOnCompare());
        op.setReferralResultHandler(new FollowCompareReferralHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory(), this.getThrowOnFailure()));
        return op;
    }

    @Override
    protected Set<ResultCode> getSuccessResultCodes() {
        return Set.of(ResultCode.COMPARE_FALSE, ResultCode.COMPARE_TRUE);
    }

    public FollowCompareReferralHandler newInstance() {
        return new FollowCompareReferralHandler(this.getReferralLimit(), this.getReferralDepth(), this.getReferralConnectionFactory(), this.getThrowOnFailure());
    }
}

