/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.linked.object;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.linked.object.LinkedObject;
import com.okta.sdk.resource.linked.object.LinkedObjectDetails;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultLinkedObject
extends AbstractInstanceResource<LinkedObject>
implements LinkedObject {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final ResourceReference<LinkedObjectDetails> associatedProperty = new ResourceReference<LinkedObjectDetails>("associated", LinkedObjectDetails.class, false);
    private static final ResourceReference<LinkedObjectDetails> primaryProperty = new ResourceReference<LinkedObjectDetails>("primary", LinkedObjectDetails.class, false);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultLinkedObject.createPropertyDescriptorMap(linksProperty, associatedProperty, primaryProperty);

    public DefaultLinkedObject(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultLinkedObject(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return LinkedObject.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public LinkedObjectDetails getAssociated() {
        return this.getResourceProperty(associatedProperty);
    }

    public LinkedObject setAssociated(LinkedObjectDetails associated) {
        this.setProperty(associatedProperty, (Object)associated);
        return this;
    }

    public LinkedObjectDetails getPrimary() {
        return this.getResourceProperty(primaryProperty);
    }

    public LinkedObject setPrimary(LinkedObjectDetails primary) {
        this.setProperty(primaryProperty, (Object)primary);
        return this;
    }

    @Override
    public void delete() {
        String linkedObjectName = this.getPrimary().getName();
        Assert.hasText((String)linkedObjectName, (String)"'linkedObjectName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/meta/schemas/user/linkedObjects/" + linkedObjectName + "", this, queryArgs, (Map<String, List<String>>)headers);
    }
}

