/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto.algo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.fulcrum.jce.crypto.StreamUtil;
import org.apache.fulcrum.jce.crypto.extended.CryptoParametersJ8;
import org.apache.fulcrum.jce.crypto.extended.CryptoStreamFactoryJ8Template;

public final class CryptoStreamPBEImpl
extends CryptoStreamFactoryJ8Template {
    protected static final int IV_SIZE = 16;
    protected static final int KEY_SIZE = 256;
    protected static final int COUNT_J8 = 10000;

    public CryptoStreamPBEImpl() throws GeneralSecurityException {
        this(CryptoStreamPBEImpl.generateSalt(), 10000);
    }

    public CryptoStreamPBEImpl(byte[] salt) {
        this(salt, 10000);
    }

    public CryptoStreamPBEImpl(byte[] salt, int count) {
        this.setSalt(salt);
        this.count = count;
        this.providerName = PROVIDERNAME;
        this.setType(CryptoParametersJ8.TYPES.PBE);
        this.algorithm = CryptoParametersJ8.TYPES_IMPL.ALGORITHM_J8_PBE.getAlgorithm();
    }

    @Override
    protected Key createKey(char[] password, byte[] salt) throws GeneralSecurityException {
        String algorithm = this.getAlgorithm();
        PBEKeySpec keySpec = new PBEKeySpec(password, salt == null ? this.getSalt() : (byte[])salt.clone(), this.getCount(), 256);
        byte[] encodedTmp = null;
        try {
            SecretKeyFactory keyFactory = this.getProviderName() == null ? SecretKeyFactory.getInstance(algorithm) : SecretKeyFactory.getInstance(algorithm, this.getProviderName());
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            return secretKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityException(e);
        }
        finally {
            if (encodedTmp != null) {
                Arrays.fill(encodedTmp, (byte)0);
            }
            if (keySpec != null) {
                keySpec.clearPassword();
            }
        }
    }

    @Override
    protected byte[] createCipher(InputStream is, int mode, char[] password) throws GeneralSecurityException, IOException {
        PBEParameterSpec paramSpec = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        StreamUtil.copy(is, bos);
        byte[] input = bos.toByteArray();
        byte[] ciphertext = null;
        byte[] salt = null;
        byte[] iv = null;
        if (mode == 2) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(input);
            salt = new byte[16];
            byteBuffer.get(salt);
            iv = new byte[16];
            byteBuffer.get(iv);
            ciphertext = new byte[byteBuffer.remaining()];
            byteBuffer.get(ciphertext);
        }
        Key key = this.createKey(password, salt);
        Cipher cipher = this.getProviderName() == null ? Cipher.getInstance(this.getAlgorithm()) : Cipher.getInstance(this.getAlgorithm(), this.getProviderName());
        if (mode == 2) {
            paramSpec = new PBEParameterSpec(salt, this.getCount(), new IvParameterSpec(iv));
            cipher.init(mode, key, paramSpec);
            ciphertext = cipher.doFinal(ciphertext);
        }
        if (mode == 1) {
            paramSpec = new PBEParameterSpec(this.getSalt(), this.getCount());
            salt = paramSpec.getSalt();
            cipher.init(mode, key, paramSpec);
            byte[] result = cipher.doFinal(input);
            iv = cipher.getIV();
            ByteBuffer byteBuffer = ByteBuffer.allocate(salt.length + iv.length + result.length);
            ciphertext = byteBuffer.put(salt).put(iv).put(result).array();
        }
        return ciphertext;
    }
}

