/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.check;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.check.AnnotationCheckComposite;
import org.apache.uima.ruta.check.AnnotationCheckTreeNode;
import org.apache.uima.ruta.check.CheckAnnotation;
import org.apache.uima.ruta.check.CheckDocument;
import org.apache.uima.ruta.check.CheckElement;
import org.apache.uima.ruta.check.FeatureCheckTreeNode;
import org.apache.uima.ruta.check.IAnnotationCheckTreeNode;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class AnnotationCheckLabelProvider
extends LabelProvider
implements ILabelProvider {
    private AnnotationCheckComposite composite;

    public AnnotationCheckLabelProvider(AnnotationCheckComposite composite) {
        this.composite = composite;
    }

    public Image getImage(Object element) {
        if (element instanceof FeatureCheckTreeNode) {
            return this.composite.getImage("feature");
        }
        if (element instanceof IAnnotationCheckTreeNode) {
            return this.getAnnotationCheckTreeNodeImage(element);
        }
        return null;
    }

    private Image getAnnotationCheckTreeNodeImage(Object element) {
        IAnnotationCheckTreeNode node = (IAnnotationCheckTreeNode)element;
        CheckElement e = node.getElement();
        if (!e.checked) {
            return this.composite.getImage("help");
        }
        if (e.keep) {
            return this.composite.getImage("accept");
        }
        return this.composite.getImage("delete");
    }

    public String getText(Object element) {
        if (element instanceof FeatureCheckTreeNode) {
            FeatureCheckTreeNode featureNode = (FeatureCheckTreeNode)element;
            return "[" + featureNode.getFeature().getShortName() + "]: " + featureNode.getValue();
        }
        if (element instanceof AnnotationCheckTreeNode) {
            AnnotationCheckTreeNode node = (AnnotationCheckTreeNode)element;
            CheckElement ce = node.getElement();
            if (ce instanceof CheckAnnotation) {
                CheckAnnotation ca = (CheckAnnotation)ce;
                String normalizeSpace = StringUtils.normalizeSpace((String)ca.getCoveredText());
                return "[" + ca.getShortType() + "]: " + normalizeSpace;
            }
            if (ce instanceof CheckDocument) {
                CheckDocument cd = (CheckDocument)ce;
                String name = new File(cd.source).getName();
                return name;
            }
        }
        return element.toString();
    }
}

